/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.descriptions;

import com.google.common.collect.ImmutableSet;
import gama.annotations.precompiler.GamlAnnotations;
import gama.annotations.precompiler.GamlProperties;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.ICollector;
import gama.dev.DEBUG;
import gama.gaml.compilation.GAML;
import gama.gaml.compilation.GamaGetter;
import gama.gaml.compilation.IValidator;
import gama.gaml.compilation.annotations.depends_on;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.compilation.kernel.GamaBundleLoader;
import gama.gaml.descriptions.AbstractProto;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.IVarDescriptionUser;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.descriptions.VariableDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.expressions.IVarExpression;
import gama.gaml.expressions.operators.BinaryOperator;
import gama.gaml.expressions.operators.NAryOperator;
import gama.gaml.expressions.operators.TypeFieldExpression;
import gama.gaml.expressions.operators.UnaryOperator;
import gama.gaml.expressions.types.TypeExpression;
import gama.gaml.interfaces.IGamlDescription;
import gama.gaml.types.IType;
import gama.gaml.types.Signature;
import gama.gaml.types.Types;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;

public class OperatorProto
extends AbstractProto
implements IVarDescriptionUser {
    public static final String[] EMPTY_DEPS = new String[0];
    public static OperatorProto AS;
    public static final Set<String> noMandatoryParenthesis;
    public static final Set<String> binaries;
    public final boolean isVarOrField;
    public final boolean canBeConst;
    public final boolean iterator;
    private IValidator semanticValidator;
    public final IType returnType;
    private final GamaGetter helper;
    public final Signature signature;
    public boolean[] lazy;
    public final int typeProvider;
    public final int contentTypeProvider;
    public final int keyTypeProvider;
    public final int[] expectedContentType;
    public final int contentTypeContentTypeProvider;
    private String[] depends_on;

    static {
        noMandatoryParenthesis = ImmutableSet.copyOf(Arrays.asList("-", "!"));
        binaries = ImmutableSet.copyOf(Arrays.asList("=", "+", "-", "/", "*", "^", "<", ">", "<=", ">=", "?", "!=", ":", ".", "where", "select", "collect", "first_with", "last_with", "overlapping", "at_distance", "in", "inside", "among", "contains", "contains_any", "contains_all", "min_of", "max_of", "with_max_of", "with_min_of", "of_species", "of_generic_species", "sort_by", "accumulate", "or", "and", "at", "is", "group_by", "index_of", "last_index_of", "index_by", "count", "sort", "::", "as_map"));
    }

    public IExpression create(IDescription iDescription, EObject eObject, IExpression ... iExpressionArray) {
        block13: {
            if (this.getValidator().validate(iDescription, eObject, iExpressionArray)) break block13;
            return null;
        }
        try {
            switch (this.signature.size()) {
                case 1: {
                    if (this.isVarOrField) {
                        return new TypeFieldExpression(this, iDescription, iExpressionArray[0]);
                    }
                    return UnaryOperator.create(this, iDescription, iExpressionArray[0]);
                }
                case 2: {
                    if (this.isVarOrField) {
                        BinaryOperator binaryOperator;
                        IExpression iExpression = iExpressionArray[1];
                        if (iExpression instanceof BinaryOperator && "as".equals((binaryOperator = (BinaryOperator)iExpression).getName())) {
                            TypeExpression typeExpression = (TypeExpression)binaryOperator.arg(1);
                            IVarExpression iVarExpression = (IVarExpression)binaryOperator.arg(0);
                            return BinaryOperator.create(AS, iDescription, new BinaryOperator.BinaryVarOperator(this, iDescription, iExpressionArray[0], iVarExpression), typeExpression);
                        }
                        return new BinaryOperator.BinaryVarOperator(this, iDescription, iExpressionArray[0], (IVarExpression)iExpressionArray[1]);
                    }
                    return BinaryOperator.create(this, iDescription, iExpressionArray);
                }
            }
            return NAryOperator.create(this, iExpressionArray);
        }
        catch (GamaRuntimeException gamaRuntimeException) {
            if (iDescription != null) {
                iDescription.error("This code is not functional: " + gamaRuntimeException.getMessage(), "gaml.general.issue", eObject, new String[0]);
            }
            return null;
        }
        catch (Exception exception) {
            if (iDescription != null) {
                iDescription.error("The compiler encountered an internal error: " + exception.getMessage(), "gaml.general.issue", eObject, new String[0]);
            }
            return null;
        }
    }

    public OperatorProto(String string, AnnotatedElement annotatedElement, String string2, GamaGetter gamaGetter, boolean bl, boolean bl2, IType iType, Signature signature, int n, int n2, int n3, int n4, int[] nArray, String string3) {
        super(string, annotatedElement, string3);
        this.iterator = GAML.ITERATORS.contains(string);
        if (string2 != null) {
            this.documentation = new IGamlDescription.ConstantDoc(string2);
        }
        if ("as".equals(string)) {
            AS = this;
        }
        this.returnType = iType;
        this.canBeConst = bl;
        this.isVarOrField = bl2;
        this.helper = gamaGetter;
        this.signature = signature;
        this.typeProvider = n;
        this.contentTypeProvider = n2;
        this.keyTypeProvider = n3;
        this.expectedContentType = nArray;
        this.contentTypeContentTypeProvider = n4;
    }

    public boolean[] getLazyness() {
        if (this.lazy == null) {
            this.lazy = new boolean[this.signature.size()];
            if (this.lazy.length == 0) {
                return this.lazy;
            }
            AnnotatedElement annotatedElement = this.support;
            if (annotatedElement instanceof Method) {
                Method method = (Method)annotatedElement;
                Class<?>[] classArray = method.getParameterTypes();
                if (classArray.length == 0) {
                    return this.lazy;
                }
                int n = 0;
                if (classArray[0] == IScope.class) {
                    n = 1;
                }
                int n2 = n;
                while (n2 < classArray.length) {
                    if (IExpression.class.isAssignableFrom(classArray[n2])) {
                        this.lazy[n2 - n] = true;
                    }
                    ++n2;
                }
            }
        }
        return this.lazy;
    }

    public OperatorProto(String string, AnnotatedElement annotatedElement, GamaGetter gamaGetter, boolean bl, boolean bl2, int n, Class clazz, int n2, int n3, int n4, int[] nArray) {
        this(string, annotatedElement == null ? clazz : annotatedElement, null, gamaGetter, bl, bl2, Types.get(n), new Signature(clazz), n2, n3, n4, -13, nArray, GamaBundleLoader.CURRENT_PLUGIN_NAME);
    }

    private OperatorProto(OperatorProto operatorProto, IType iType) {
        this(operatorProto.name, operatorProto.support, null, operatorProto.getHelper(), operatorProto.canBeConst, operatorProto.isVarOrField, operatorProto.returnType, new Signature(iType), operatorProto.typeProvider, operatorProto.contentTypeProvider, operatorProto.keyTypeProvider, operatorProto.contentTypeContentTypeProvider, operatorProto.expectedContentType, operatorProto.plugin);
    }

    @Override
    public String getTitle() {
        if (this.isVarOrField) {
            return "field " + this.getName() + " of type " + String.valueOf(this.returnType) + ", for values of type " + this.signature.asPattern(false);
        }
        return "operator " + this.getName() + "(" + this.signature.asPattern(false) + "), returns " + String.valueOf(this.returnType);
    }

    @Override
    public IGamlDescription.Doc getDocumentation() {
        if (!this.isVarOrField) {
            return super.getDocumentation();
        }
        GamlAnnotations.vars vars2 = this.getJavaBase().getAnnotation(GamlAnnotations.vars.class);
        if (vars2 != null) {
            GamlAnnotations.variable[] variableArray;
            GamlAnnotations.variable[] variableArray2 = variableArray = vars2.value();
            int n = variableArray.length;
            int n2 = 0;
            while (n2 < n) {
                GamlAnnotations.variable variable2 = variableArray2[n2];
                if (variable2.name().equals(this.getName())) {
                    if (variable2.doc().length <= 0) break;
                    return new IGamlDescription.ConstantDoc(variable2.doc()[0].value());
                }
                ++n2;
            }
        }
        return new IGamlDescription.ConstantDoc(this.getTitle());
    }

    public void verifyExpectedTypes(IDescription iDescription, IType<?> iType) {
        if (this.expectedContentType == null || this.expectedContentType.length == 0 || iDescription == null) {
            return;
        }
        if (this.expectedContentType.length == 1 && this.iterator) {
            IType iType2 = Types.get(this.expectedContentType[0]);
            if (!iType.isTranslatableInto(iType2)) {
                iDescription.warning("Operator " + this.getName() + " expects an argument of type " + String.valueOf(iType2), "gaml.casting.issue");
            }
        } else if (this.signature.isUnary()) {
            int[] nArray = this.expectedContentType;
            int n = this.expectedContentType.length;
            int n2 = 0;
            while (n2 < n) {
                int n3 = nArray[n2];
                if (iType.isTranslatableInto(Types.get(n3))) {
                    return;
                }
                ++n2;
            }
            iDescription.error("Operator " + this.getName() + " expects arguments of type " + String.valueOf(iType), "gaml.wrong.type.issue");
        }
    }

    @Override
    public String serializeToGaml(boolean bl) {
        return this.getName() + "(" + this.signature.toString() + ")";
    }

    public String getCategory() {
        if (this.support == null) {
            return "Other";
        }
        GamlAnnotations.operator operator2 = this.support.getAnnotation(GamlAnnotations.operator.class);
        if (operator2 == null) {
            return "Other";
        }
        String[] stringArray = operator2.category();
        if (stringArray.length > 0) {
            return operator2.category()[0];
        }
        return "Other";
    }

    @Override
    public int getKind() {
        return 15;
    }

    public String getPattern(boolean bl) {
        int n = this.signature.size();
        String string = this.getName();
        if (n == 1 || n > 2) {
            if (noMandatoryParenthesis.contains(string)) {
                return string + this.signature.asPattern(bl);
            }
            return string + "(" + this.signature.asPattern(bl) + ")";
        }
        if (binaries.contains(string)) {
            return this.signature.get(0).asPattern() + " " + string + " " + this.signature.get(1).asPattern();
        }
        return string + "(" + this.signature.asPattern(bl) + ")";
    }

    @Override
    public void collectMetaInformation(GamlProperties gamlProperties) {
        super.collectMetaInformation(gamlProperties);
        gamlProperties.put("operators", this.name);
    }

    public OperatorProto copyWithSignature(IType iType) {
        return new OperatorProto(this, iType);
    }

    @Override
    public void collectUsedVarsOf(SpeciesDescription speciesDescription, ICollector<IVarDescriptionUser> iCollector, ICollector<VariableDescription> iCollector2) {
        if (iCollector.contains(this)) {
            return;
        }
        iCollector.add(this);
        String[] stringArray = this.getDependencies();
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                if (speciesDescription.hasAttribute(string)) {
                    iCollector2.add(speciesDescription.getAttribute(string));
                }
                ++n2;
            }
        }
    }

    @Override
    public GamlAnnotations.doc getDocAnnotation() {
        GamlAnnotations.operator operator2;
        GamlAnnotations.doc[] docArray;
        GamlAnnotations.doc doc2 = super.getDocAnnotation();
        if (doc2 != null) {
            return doc2;
        }
        if (this.support != null && this.support.isAnnotationPresent(GamlAnnotations.operator.class) && (docArray = (operator2 = this.support.getAnnotation(GamlAnnotations.operator.class)).doc()) != null && docArray.length > 0) {
            doc2 = docArray[0];
        }
        return doc2;
    }

    public GamaGetter getHelper() {
        return this.helper;
    }

    public IValidator getValidator() {
        if (this.semanticValidator == null) {
            if (this.support != null) {
                validator validator2 = this.support.getAnnotation(validator.class);
                try {
                    this.semanticValidator = validator2 == null ? IValidator.NULL : validator2.value().getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                    DEBUG.ERR((Object)("Error in creating the validator for operator " + this.name + " on method " + String.valueOf(this.support)));
                }
            } else {
                this.semanticValidator = IValidator.NULL;
            }
        }
        return this.semanticValidator;
    }

    public String[] getDependencies() {
        if (this.depends_on == null) {
            depends_on depends_on2;
            this.depends_on = this.support != null ? ((depends_on2 = this.support.getAnnotation(depends_on.class)) == null ? EMPTY_DEPS : depends_on2.value()) : EMPTY_DEPS;
        }
        return this.depends_on;
    }
}

