/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.ExecutionResult;
import gama.core.runtime.IScope;
import gama.core.runtime.concurrent.GamaExecutorService;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.IContainer;
import gama.gaml.compilation.ISymbol;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.statements.AbstractStatementSequence;
import gama.gaml.statements.IExecutable;
import gama.gaml.statements.IStatement;
import gama.gaml.statements.RemoteSequence;
import gama.gaml.types.Types;

@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="parallel", type={3, 1}, optional=true, doc={@GamlAnnotations.doc(value="(experimental) setting this facet to 'true' will allow 'ask' to use concurrency when traversing the targets; setting it to an integer will set the threshold under which they will be run sequentially (the default is initially 20, but can be fixed in the preferences). This facet is false by default.")}), @GamlAnnotations.facet(name="target", type={16, 11}, of=11, optional=false, doc={@GamlAnnotations.doc(value="an expression that evaluates to an agent or a list of agents")}), @GamlAnnotations.facet(name="as", type={14}, optional=true, doc={@GamlAnnotations.doc(value="an expression that evaluates to a species")})}, omissible="target")
@GamlAnnotations.inside(kinds={3, 11, 6, 5}, symbols={"chart"})
@GamlAnnotations.doc(value="Allows an agent, the sender agent (that can be the [Sections161#global world agent]), to ask another (or other) agent(s) to perform a set of statements. If the value of the target facet is nil or empty, the statement is ignored.", usages={@GamlAnnotations.usage(name="Ask agents", value="Ask  a set of receiver agents, stored in a container, to perform a block of statements. The block is evaluated in the context of the agents' species", examples={@GamlAnnotations.example(value="ask ${receiver_agents} {", isExecutable=false, isPattern=true), @GamlAnnotations.example(value="     ${cursor}", isExecutable=false, isPattern=true), @GamlAnnotations.example(value="}", isExecutable=false, isPattern=true)}), @GamlAnnotations.usage(name="Ask one agent", menu="Custom", path={"Special"}, value="Ask  one agent to perform a block of statements. The block is evaluated in the context of the agent's species", examples={@GamlAnnotations.example(value="ask ${one_agent} {", isExecutable=false, isPattern=true), @GamlAnnotations.example(value="     ${cursor}", isExecutable=false, isPattern=true), @GamlAnnotations.example(value="}", isExecutable=false, isPattern=true)}), @GamlAnnotations.usage(name="Ask agents and force their species", value="If the species of the receiver agent(s) cannot be determined, it is possible to force it using the `as` facet. An error is thrown if an agent is not a direct or undirect instance of this species", examples={@GamlAnnotations.example(value="ask ${receiver_agent(s)} as: ${a_species_expression} {", isExecutable=false, isPattern=true), @GamlAnnotations.example(value="     ${cursor}", isExecutable=false, isPattern=true), @GamlAnnotations.example(value="}", isExecutable=false, isPattern=true)}), @GamlAnnotations.usage(name="Ask one agent casted to a species", value="If the species of the receiver agent cannot be determined, it is possible to force it by casting the agent. Nothing happens if the agent cannot be casted to this species", pattern="ask ${species_name}(${receiver_agent}) {\n\t ${cursor}\n}"), @GamlAnnotations.usage(name="Ask agents belonging to a species", value="To ask a set of agents to do something only if they belong to a given species, the `of_species` operator can be used. If none of the agents belong to the species, nothing happens", examples={@GamlAnnotations.example(value="ask ${receiver_agents} of_species ${species_name} {", isExecutable=false, isPattern=true), @GamlAnnotations.example(value="     ${cursor}", isExecutable=false, isPattern=true), @GamlAnnotations.example(value="}", isExecutable=false, isPattern=true)}), @GamlAnnotations.usage(value="Any statement can be declared in the block statements. All the statements will be evaluated in the context of the receiver agent(s), as if they were defined in their species, which means that an expression like `self` will represent the receiver agent and not the sender. If the sender needs to refer to itself, some of its own attributes (or temporary variables) within the block statements, it has to use the keyword `myself`.", examples={@GamlAnnotations.example(value="species animal {", isExecutable=false), @GamlAnnotations.example(value="    float energy <- rnd (1000) min: 0.0;", isExecutable=false), @GamlAnnotations.example(value="    reflex when: energy > 500 { // executed when the energy is above the given threshold", isExecutable=false), @GamlAnnotations.example(value="         list<animal> others <- (animal at_distance 5); // find all the neighboring animals in a radius of 5 meters", isExecutable=false), @GamlAnnotations.example(value="         float shared_energy  <- (energy - 500) / length (others); // compute the amount of energy to share with each of them", isExecutable=false), @GamlAnnotations.example(value="         ask others { // no need to cast, since others has already been filtered to only include animals", isExecutable=false), @GamlAnnotations.example(value="              if (energy < 500) { // refers to the energy of each animal in others", isExecutable=false), @GamlAnnotations.example(value="                   energy <- energy + myself.shared_energy; // increases the energy of each animal", isExecutable=false), @GamlAnnotations.example(value="                   myself.energy <- myself.energy - myself.shared_energy; // decreases the energy of the sender", isExecutable=false), @GamlAnnotations.example(value="              }", isExecutable=false), @GamlAnnotations.example(value="         }", isExecutable=false), @GamlAnnotations.example(value="    }", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)})})
public class AskStatement
extends AbstractStatementSequence
implements IStatement.Breakable {
    private RemoteSequence sequence = null;
    private final IExpression target = this.getFacet("target");
    private final IExpression parallel = this.getFacet("parallel");

    public AskStatement(IDescription iDescription) {
        super(iDescription);
        if (this.target != null) {
            this.setName("ask " + this.target.serializeToGaml(false));
        }
    }

    @Override
    public void setChildren(Iterable<? extends ISymbol> iterable) {
        this.sequence = new RemoteSequence(this.description);
        this.sequence.setName("commands of " + this.getName());
        this.sequence.setChildren(iterable);
    }

    @Override
    public Object privateExecuteIn(IScope iScope) {
        IAgent iAgent;
        Object object = this.target.value(iScope);
        if (object instanceof IContainer) {
            IContainer iContainer = (IContainer)object;
            GamaExecutorService.execute(iScope, (IExecutable)this.sequence, iContainer.listValue(iScope, Types.AGENT, false), this.parallel);
            return this;
        }
        if (object instanceof IAgent) {
            iAgent = (IAgent)object;
        } else {
            iAgent = Cast.asAgent(iScope, object);
            if (iAgent == null) {
                throw GamaRuntimeException.error("Can not execute ask on a nil agent", iScope);
            }
        }
        ExecutionResult executionResult = iScope.execute(this.sequence, iAgent, null);
        return executionResult.getValue();
    }

    @Override
    public void dispose() {
        this.sequence.dispose();
        super.dispose();
    }
}

