/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements.save;

import gama.core.metamodel.topology.grid.GridPopulation;
import gama.core.metamodel.topology.projection.IProjection;
import gama.core.metamodel.topology.projection.ProjectionFactory;
import gama.core.runtime.IScope;
import gama.core.util.matrix.GamaField;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.species.ISpecies;
import gama.gaml.statements.save.AbstractSaver;
import gama.gaml.statements.save.SaveOptions;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.gce.geotiff.GeoTiffFormat;
import org.geotools.geometry.Envelope2D;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridCoverageWriter;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GeoTiffSaver
extends AbstractSaver {
    private static final String GEOTIFF = "geotiff";

    @Override
    public void save(IScope iScope, IExpression iExpression, File file2, SaveOptions saveOptions) throws IOException {
        if (file2 == null) {
            return;
        }
        File file3 = file2;
        if (file3.exists() && !file3.delete()) {
            return;
        }
        try {
            Object object = iExpression.value(iScope);
            if (object instanceof GamaField) {
                GamaField gamaField = (GamaField)object;
                this.saveField(iScope, gamaField, file3);
            } else {
                ISpecies iSpecies = Cast.asSpecies(iScope, object);
                if (iSpecies == null || !iSpecies.isGrid()) {
                    return;
                }
                this.saveGrid(iScope, iSpecies, file3);
            }
        }
        finally {
            ProjectionFactory.saveTargetCRSAsPRJFile(iScope, file3.getAbsolutePath());
        }
    }

    private void saveGrid(IScope iScope, ISpecies iSpecies, File file2) throws IllegalArgumentException, IOException {
        GridPopulation gridPopulation = (GridPopulation)iSpecies.getPopulation(iScope);
        int n = gridPopulation.getNbCols();
        int n2 = gridPopulation.getNbRows();
        IProjection iProjection = iScope.getSimulation().getProjectionFactory().getWorld();
        CoordinateReferenceSystem coordinateReferenceSystem = ProjectionFactory.getTargetCRSOrDefault(iScope);
        double d = iProjection == null ? 0.0 : iProjection.getProjectedEnvelope().getMinX();
        double d2 = iProjection == null ? 0.0 : iProjection.getProjectedEnvelope().getMinY();
        float[][] fArray = new float[n2][n];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n) {
                fArray[n3][n4] = gridPopulation.getGridValue(n4, n3).floatValue();
                ++n4;
            }
            ++n3;
        }
        double d3 = iScope.getSimulation().getEnvelope().getWidth();
        double d4 = iScope.getSimulation().getEnvelope().getHeight();
        Envelope2D envelope2D = new Envelope2D(coordinateReferenceSystem, d, d2, d3, d4);
        GridCoverage2D gridCoverage2D = new GridCoverageFactory().create((CharSequence)"data", fArray, (Envelope)envelope2D);
        GeoTiffFormat geoTiffFormat = new GeoTiffFormat();
        GridCoverageWriter gridCoverageWriter = geoTiffFormat.getWriter((Object)file2);
        gridCoverageWriter.write((GridCoverage)gridCoverage2D, null);
    }

    private void saveField(IScope iScope, GamaField gamaField, File file2) throws IllegalArgumentException, IOException {
        if (gamaField.isEmpty(iScope)) {
            return;
        }
        int n = gamaField.numCols;
        int n2 = gamaField.numRows;
        IProjection iProjection = iScope.getSimulation().getProjectionFactory().getWorld();
        double d = iProjection == null ? 0.0 : iProjection.getProjectedEnvelope().getMinX();
        double d2 = iProjection == null ? 0.0 : iProjection.getProjectedEnvelope().getMinY();
        CoordinateReferenceSystem coordinateReferenceSystem = ProjectionFactory.getTargetCRSOrDefault(iScope);
        float[][] fArray = new float[n2][n];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n) {
                fArray[n3][n4] = gamaField.get(iScope, n4, n3).floatValue();
                ++n4;
            }
            ++n3;
        }
        double d3 = iScope.getSimulation().getEnvelope().getWidth();
        double d4 = iScope.getSimulation().getEnvelope().getHeight();
        Envelope2D envelope2D = new Envelope2D(coordinateReferenceSystem, d, d2, d3, d4);
        GridCoverage2D gridCoverage2D = new GridCoverageFactory().create((CharSequence)"data", fArray, (Envelope)envelope2D);
        GeoTiffFormat geoTiffFormat = new GeoTiffFormat();
        GridCoverageWriter gridCoverageWriter = geoTiffFormat.getWriter((Object)file2);
        gridCoverageWriter.write((GridCoverage)gridCoverage2D, null);
    }

    @Override
    public Set<String> computeFileTypes() {
        return Set.of(GEOTIFF);
    }
}

