/*
 * Decompiled with CFR 0.152.
 */
package gama.core.kernel.batch.exploration.sobol;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.util.FileUtils;
import gama.core.kernel.batch.exploration.AExplorationAlgorithm;
import gama.core.kernel.batch.exploration.sobol.Sobol;
import gama.core.kernel.experiment.BatchAgent;
import gama.core.kernel.experiment.IParameter;
import gama.core.kernel.experiment.ParameterAdapter;
import gama.core.kernel.experiment.ParametersSet;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.gaml.compilation.ISymbol;
import gama.gaml.descriptions.IDescription;
import gama.gaml.operators.Cast;
import gama.gaml.types.GamaDateType;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@GamlAnnotations.inside(kinds={13})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="name", type={-201}, optional=false, internal=true, doc={@GamlAnnotations.doc(value="The name of the method. For internal use only")}), @GamlAnnotations.facet(name="sample", type={-201}, optional=false, doc={@GamlAnnotations.doc(value="The size of the sample for the sobol sequence")}), @GamlAnnotations.facet(name="outputs", type={5}, of=4, optional=false, doc={@GamlAnnotations.doc(value="The list of output variables to analyse through sobol indexes")}), @GamlAnnotations.facet(name="results", type={4}, optional=true, doc={@GamlAnnotations.doc(value="The path to the file where the automatic batch report will be written")}), @GamlAnnotations.facet(name="report", type={4}, optional=false, doc={@GamlAnnotations.doc(value="The path to the file where the Sobol report will be written")}), @GamlAnnotations.facet(name="path", type={4}, optional=true, doc={@GamlAnnotations.doc(value="The path to the saltelli sample csv file. If the file doesn't exist automatic Saltelli sampling will be performed and saved in the corresponding location")})}, omissible="name")
@GamlAnnotations.doc(value="This algorithm runs a Sobol exploration - it has been built upon the moea framework at https://github.com/MOEAFramework/MOEAFramework - disabled the repeat facet of the experiment", usages={@GamlAnnotations.usage(value="For example: ", examples={@GamlAnnotations.example(value="method sobol sample_size:100 outputs:['my_var'] report:'../path/to/report/file.txt'; ", isExecutable=false)})})
public class SobolExploration
extends AExplorationAlgorithm {
    protected static final String SAMPLE_SIZE = "sample";
    private Sobol sobol_analysis;
    private List<IParameter.Batch> parameters;
    private IList<String> outputs;
    private List<ParametersSet> solutions;
    protected IMap<ParametersSet, Map<String, List<Object>>> res_outputs;
    private int _sample;

    public SobolExploration(IDescription iDescription) {
        super(iDescription);
    }

    @Override
    public void setChildren(Iterable<? extends ISymbol> iterable) {
    }

    @Override
    public void explore(IScope iScope) {
        String string;
        File file2;
        File file3;
        List<ParametersSet> list;
        List<ParametersSet> list2 = list = this.solutions == null ? this.buildParameterSets(iScope, new ArrayList<ParametersSet>(), 0) : this.solutions;
        if (list.size() != this._sample) {
            throw GamaRuntimeException.error("Saltelli sample should be " + this._sample + " but is " + list.size(), iScope);
        }
        this.currentExperiment.setSeeds(new Double[1]);
        this.currentExperiment.setKeepSimulations(false);
        this.res_outputs = this.currentExperiment.runSimulationsAndReturnResults(list);
        Map<String, List<Object>> map = this.rebuildOutput(this.res_outputs);
        this.sobol_analysis.setOutputs(map);
        this.sobol_analysis.evaluate();
        if (this.hasFacet("results")) {
            this.saveRawResults(iScope, this.res_outputs);
        }
        if (!(file3 = (file2 = new File(FileUtils.constructAbsoluteFilePath(iScope, string = Cast.asString(iScope, this.getFacet("report").value(iScope)), false))).getParentFile()).exists()) {
            file3.mkdirs();
        }
        if (file2.exists()) {
            file2.delete();
        }
        this.sobol_analysis.saveResult(file2);
    }

    @Override
    public List<ParametersSet> buildParameterSets(IScope iScope, List<ParametersSet> list, int n) {
        Serializable serializable;
        int n2 = Cast.asInt(iScope, this.getFacet(SAMPLE_SIZE).value(iScope));
        ArrayList<IParameter.Batch> arrayList = new ArrayList<IParameter.Batch>(this.currentExperiment.getParametersToExplore());
        this.parameters = this.parameters == null ? arrayList : this.parameters;
        this._sample = n2 * (2 * this.parameters.size() + 2);
        LinkedHashMap<String, List<Object>> linkedHashMap = new LinkedHashMap<String, List<Object>>();
        int n3 = 0;
        while (n3 < this.parameters.size()) {
            serializable = new ArrayList<Object>();
            switch (this.parameters.get(n3).getType().id()) {
                case 1: 
                case 2: {
                    serializable.add(this.parameters.get(n3).getMinValue(iScope));
                    serializable.add(this.parameters.get(n3).getMaxValue(iScope));
                    break;
                }
                case 3: {
                    serializable.add(false);
                    serializable.add(true);
                    break;
                }
                case 23: {
                    serializable.add(GamaDateType.staticCast(iScope, this.parameters.get(n3).getMinValue(iScope), null, false));
                    serializable.add(GamaDateType.staticCast(iScope, this.parameters.get(n3).getMaxValue(iScope), null, false));
                    break;
                }
                case 7: {
                    serializable.add(Cast.asPoint(iScope, this.parameters.get(n3).getMinValue(iScope)));
                    serializable.add(Cast.asPoint(iScope, this.parameters.get(n3).getMaxValue(iScope)));
                    break;
                }
                case 4: {
                    if (this.parameters.get(n3).getAmongValue(iScope).isEmpty()) {
                        throw GamaRuntimeException.error("Trying to force a string variable in sampling without among facets", iScope);
                    }
                    serializable.addAll(this.parameters.get(n3).getAmongValue(iScope));
                    break;
                }
                default: {
                    throw GamaRuntimeException.error("Trying to add a variable of unknown type " + this.parameters.get(n3).getType().id() + " to a parameter set", iScope);
                }
            }
            linkedHashMap.put(this.parameters.get(n3).getName(), (List<Object>)((Object)serializable));
            ++n3;
        }
        this.outputs = Cast.asList(iScope, this.getFacet("outputs").value(iScope));
        this.sobol_analysis = new Sobol(linkedHashMap, this.outputs, n2, iScope);
        if (this.hasFacet("path")) {
            String string = Cast.asString(iScope, this.getFacet("path").value(iScope));
            serializable = new File(FileUtils.constructAbsoluteFilePath(iScope, string, false));
            if (((File)serializable).exists()) {
                this.sobol_analysis.setSaltelliSamplingFromCsv((File)serializable);
            } else {
                this.sobol_analysis.setRandomSaltelliSampling();
                this.sobol_analysis.saveSaltelliSample((File)serializable);
            }
        } else {
            this.sobol_analysis.setRandomSaltelliSampling();
        }
        Map<String, List<Object>> map = this.sobol_analysis.getParametersValues();
        int n4 = 0;
        while (n4 < this._sample) {
            ParametersSet parametersSet = new ParametersSet();
            for (IParameter.Batch batch : this.parameters) {
                parametersSet.put(batch.getName(), map.get(batch.getName()).get(n4));
            }
            list.add(parametersSet);
            ++n4;
        }
        this.solutions = list;
        return list;
    }

    @Override
    public void addParametersTo(List<IParameter.Batch> list, BatchAgent batchAgent) {
        super.addParametersTo(list, batchAgent);
        list.add(new ParameterAdapter("Saltelli sample", "sobol", 4){

            @Override
            public Object value() {
                return SobolExploration.this._sample;
            }
        });
    }

    private Map<String, List<Object>> rebuildOutput(IMap<ParametersSet, Map<String, List<Object>>> iMap) {
        HashMap<String, List<Object>> hashMap = new HashMap<String, List<Object>>();
        for (String object : this.outputs) {
            hashMap.put(object, new ArrayList());
        }
        for (ParametersSet parametersSet : this.solutions) {
            for (String string : this.outputs) {
                try {
                    ((List)hashMap.get(string)).add(((List)((Map)iMap.get(parametersSet)).get(string)).get(0));
                }
                catch (NullPointerException nullPointerException) {
                    return hashMap;
                }
            }
        }
        return hashMap;
    }
}

