/*
 * Decompiled with CFR 0.152.
 */
package gama.core.kernel.experiment;

import com.google.common.collect.Iterables;
import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.interfaces.IGui;
import gama.core.common.preferences.GamaPreferences;
import gama.core.common.util.RandomUtils;
import gama.core.kernel.experiment.ActionExecuter;
import gama.core.kernel.experiment.ExperimentClock;
import gama.core.kernel.experiment.ExperimentParameter;
import gama.core.kernel.experiment.ExperimentPlan;
import gama.core.kernel.experiment.IExperimentAgent;
import gama.core.kernel.experiment.IExperimentPlan;
import gama.core.kernel.experiment.IParameter;
import gama.core.kernel.experiment.ISimulationRecorder;
import gama.core.kernel.experiment.ParametersSet;
import gama.core.kernel.experiment.SimulationRecorderFactory;
import gama.core.kernel.model.IModel;
import gama.core.kernel.simulation.SimulationAgent;
import gama.core.kernel.simulation.SimulationClock;
import gama.core.kernel.simulation.SimulationPopulation;
import gama.core.metamodel.agent.GamlAgent;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.population.DefaultPopulationFactory;
import gama.core.metamodel.population.IPopulation;
import gama.core.metamodel.population.IPopulationFactory;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.outputs.ExperimentOutputManager;
import gama.core.outputs.IOutputManager;
import gama.core.runtime.ExecutionScope;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.runtime.server.GamaServerExperimentConfiguration;
import gama.core.util.GamaColor;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMap;
import gama.core.util.GamaMapFactory;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.dev.DEBUG;
import gama.gaml.compilation.Symbol;
import gama.gaml.descriptions.ModelDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.expressions.IExpressionFactory;
import gama.gaml.operators.Cast;
import gama.gaml.species.ISpecies;
import gama.gaml.statements.IExecutable;
import gama.gaml.types.GamaGeometryType;
import gama.gaml.types.Types;
import gama.gaml.variables.IVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@GamlAnnotations.species(name="experiment", doc={@GamlAnnotations.doc(value="The species of agents that represent experiments")})
@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="simulations", type=5, of=-27, doc={@GamlAnnotations.doc(value="Contains the list of currently running simulations")}), @GamlAnnotations.variable(name="simulation", type=-27, doc={@GamlAnnotations.doc(value="Contains a reference to the current simulation being run by this experiment", comment="will be nil if no simulation have been created. In case several simulations are launched, contains a reference to the latest one")}), @GamlAnnotations.variable(name="model_path", type=4, constant=true, doc={@GamlAnnotations.doc(value="Contains the absolute path to the folder in which the current model is located", comment="Always terminated with a trailing separator")}), @GamlAnnotations.variable(name="seed", type=2, doc={@GamlAnnotations.doc(value="The seed of the random number generator. Each time it is set, the random number generator is reinitialized. WARNING: Setting it to zero actually means that you let GAMA choose a random seed")}), @GamlAnnotations.variable(name="rng", type=4, doc={@GamlAnnotations.doc(value="The random number generator to use. Four different ones are at the disposal of the modeler: 'mersenne' represents the default generator, based on the Mersenne-Twister algorithm. Very reliable, fast and deterministic (that is, using the same seed and the same sequence of calls, it will return the same stream of pseudo-random numbers). This algorithm is however not safe to use in simulations where agents can behave in parallel; 'threaded' is a very fast generator, based on the DotMix algorithm, that can be safely used in parallel simulations as it creates one instance per thread. However, determinism cannot be guaranteed and this algorithm does not accept a seed as each instance will compute its own;'parallel' is a version of the Mersenne-Twister algorithm that can be safely used in parallel simulations by preventing a concurrent access to its internal state. Determinism is guaranteed (in terms of generation, but not in terms of execution, as the sequence in which the threads will access it cannot be determined) and it performs a bit slower than its base version.'java' invokes the standard generator provided by the JDK, deterministic and thread-safe, albeit slower than all the other ones")}), @GamlAnnotations.variable(name="cycle", type=1, doc={@GamlAnnotations.doc(value="Returns the current cycle of the simulation")}), @GamlAnnotations.variable(name="rng_usage", type=1, doc={@GamlAnnotations.doc(value="Returns the number of times the random number generator of the experiment has been drawn")}), @GamlAnnotations.variable(name="maximum_cycle_duration", type=2, doc={@GamlAnnotations.doc(value="The maximum duration (in seconds) a simulation cycle should last. Default is 1. Units can be used to pass values greater than a second (for instance '10 #sec')", comment="Useful to set the range, from 0 to this value, in which the user can choose a value for the delay")}), @GamlAnnotations.variable(name="minimum_cycle_duration", type=2, doc={@GamlAnnotations.doc(value="The minimum duration (in seconds) a simulation cycle should last. Default is 0. Units can be used to pass values smaller than a second (for instance '10 #msec')", comment="Useful to introduce slow_downs to fast simulations or to synchronize the simulation on some other process")}), @GamlAnnotations.variable(name="parameters", type=10, doc={@GamlAnnotations.doc(value="A parameters set of this experiment agent")}), @GamlAnnotations.variable(name="project_path", type=4, constant=true, doc={@GamlAnnotations.doc(value="Contains the absolute path to the project in which the current model is located", comment="Always terminated with a trailing separator")})})
@GamlAnnotations.experiment(value="gui")
@GamlAnnotations.doc(value="GUI experiments are experiments used to visualise and interact with simulations through the regular user interface of GAMA. They can declare, parameters, used to populate the Parameters view, outputs like displays or monitors")
public class ExperimentAgent
extends GamlAgent
implements IExperimentAgent {
    public static final String MODEL_PATH = "model_path";
    public static final String PROJECT_PATH = "project_path";
    public static final String MINIMUM_CYCLE_DURATION = "minimum_cycle_duration";
    private static final String MAXIMUM_CYCLE_DURATION = "maximum_cycle_duration";
    final IExpression stopCondition;
    private final IScope ownScope;
    protected final ActionExecuter executer;
    protected ISimulationRecorder recorder;
    final IMap<String, Object> extraParametersMap = GamaMapFactory.createOrdered();
    protected RandomUtils random;
    protected Double currentMinimumDuration = 0.0;
    protected Double currentMaximumDuration = 1.0;
    protected final ExperimentClock ownClock;
    protected String ownModelPath;
    private Boolean scheduled = false;
    private volatile boolean isOnUserHold = false;
    private IPopulationFactory populationFactory;

    static {
        DEBUG.OFF();
    }

    public ExperimentAgent(IPopulation<? extends IAgent> iPopulation, int n) throws GamaRuntimeException {
        super(iPopulation, n);
        super.setGeometry(GamaGeometryType.createPoint(new GamaPoint(-1.0, -1.0)));
        this.ownScope = new ExperimentAgentScope();
        this.ownClock = new ExperimentClock(this.ownScope);
        this.executer = new ActionExecuter(this.ownScope);
        this.populationFactory = this.initializePopulationFactory();
        if (this.getSpecies().isMemorize()) {
            this.recorder = SimulationRecorderFactory.create();
        }
        if (iPopulation.getSpecies().getDescription().belongsToAMicroModel()) {
            this.initialize();
        } else {
            this.reset();
        }
        IExpression iExpression = this.getSpecies().getStopCondition();
        this.stopCondition = iExpression == null ? this.defaultStopCondition() : iExpression;
    }

    protected IExpression defaultStopCondition() {
        return IExpressionFactory.FALSE_EXPR;
    }

    private void initialize() {
        this.createSimulationPopulation();
        this.random = this.random == null ? new RandomUtils() : new RandomUtils(this.getDefinedSeed(), this.getDefinedRng());
    }

    @Override
    public final IPopulationFactory getPopulationFactory() {
        return this.populationFactory;
    }

    protected IPopulationFactory initializePopulationFactory() {
        return new DefaultPopulationFactory();
    }

    public final void setPopulationFactory(IPopulationFactory iPopulationFactory) {
        this.populationFactory = iPopulationFactory;
    }

    @Override
    public SimulationClock getClock() {
        return this.ownClock;
    }

    public void reset() {
        this.ownClock.reset();
        this.closeSimulations(false);
        this.initialize();
    }

    public String getDefinedRng() {
        if (GamaPreferences.Runtime.CORE_RND_EDITABLE.getValue().booleanValue()) {
            return (String)((ExperimentPlan)this.getSpecies()).parameters.get("rng").value(this.ownScope);
        }
        return GamaPreferences.External.CORE_RNG.getValue();
    }

    public Double getDefinedSeed() {
        if (GamaPreferences.Runtime.CORE_RND_EDITABLE.getValue().booleanValue()) {
            IParameter.Batch batch = (IParameter.Batch)((ExperimentPlan)this.getSpecies()).parameters.get("seed");
            return batch.isDefined() ? (Double)batch.value(this.ownScope) : null;
        }
        return GamaPreferences.External.CORE_SEED_DEFINED.getValue() != false ? GamaPreferences.External.CORE_SEED.getValue() : null;
    }

    @Override
    public void closeSimulations(boolean bl) {
        this.executer.executeDisposeActions();
        if (this.getSimulationPopulation() != null) {
            this.getSimulationPopulation().dispose();
        }
        if (!this.getSpecies().isBatch()) {
            this.ownScope.getGui().setSelectedAgent(null);
            this.ownScope.getGui().setHighlightedAgent(null);
            this.ownScope.getGui().getStatus().resumeStatus(this.ownScope);
            this.ownScope.getGui().closeDialogs(this.ownScope);
            this.ownScope.getGui().closeSimulationViews(this.ownScope, bl, true);
        }
    }

    @Override
    public Object primDie(IScope iScope) throws GamaRuntimeException {
        if (this.dying || this.dead) {
            return null;
        }
        GAMA.closeExperiment(this.getSpecies());
        GAMA.getGui().closeSimulationViews(iScope, true, false);
        return null;
    }

    @Override
    public void dispose() {
        if (this.dying || this.dead) {
            return;
        }
        this.dying = true;
        this.getSpecies().getArchitecture().abort(this.ownScope);
        this.closeSimulations(!this.getSpecies().isReloading());
        GAMA.releaseScope(this.ownScope);
        super.dispose();
    }

    @Override
    public Object _init_(IScope iScope) {
        if (iScope.interrupted()) {
            return null;
        }
        if (this.automaticallyCreateFirstSimulation()) {
            this.createSimulation(ParametersSet.EMPTY, this.scheduled);
        }
        super._init_(iScope);
        this.tryToRecordSimulations();
        return this;
    }

    @Override
    protected boolean preStep(IScope iScope) {
        this.ownClock.beginCycle();
        this.executer.executeBeginActions();
        return super.preStep(iScope);
    }

    @Override
    protected void postStep(IScope iScope) {
        this.executer.executeEndActions();
        this.executer.executeOneShotActions();
        this.tryToRecordSimulations();
        IOutputManager iOutputManager = this.getOutputManager();
        if (iOutputManager != null) {
            iOutputManager.step(iScope);
        }
        this.ownClock.step();
        this.informStatus();
        GAMA.updateExperimentState(this.getSpecies());
    }

    private void tryToRecordSimulations() {
        if (this.isRecord()) {
            SimulationPopulation simulationPopulation = this.getSimulationPopulation();
            IExpression iExpression = this.getSpecies().shouldRecord();
            if (simulationPopulation != null && iExpression != null) {
                ArrayList<SimulationAgent> arrayList = new ArrayList<SimulationAgent>(simulationPopulation);
                for (SimulationAgent simulationAgent : arrayList) {
                    IScope iScope = simulationAgent.getScope();
                    if (iScope.interrupted() || !Cast.asBool(iScope, iExpression.value(iScope)).booleanValue()) continue;
                    this.recorder.record(simulationAgent);
                }
            }
        }
    }

    protected boolean automaticallyCreateFirstSimulation() {
        return true;
    }

    @Override
    public boolean init(IScope iScope) {
        this.showParameters(iScope);
        GAMA.changeCurrentTopLevelAgent(this, true);
        iScope.getGui().clearErrors(iScope);
        super.init(iScope);
        IOutputManager iOutputManager = this.getOutputManager();
        if (iOutputManager != null) {
            iOutputManager.init(iScope);
        }
        GAMA.updateExperimentState(this.getSpecies());
        return true;
    }

    private void showParameters(IScope iScope) {
        ExperimentOutputManager experimentOutputManager = (ExperimentOutputManager)this.getOutputManager();
        Symbol symbol2 = experimentOutputManager.getLayout() == null ? experimentOutputManager : experimentOutputManager.getLayout();
        Boolean bl = symbol2.getFacetValue(iScope, "parameters", null);
        if (bl != null && !bl.booleanValue()) {
            iScope.getGui().hideParameters();
        } else {
            iScope.getGui().updateParameters();
        }
    }

    public SimulationAgent createSimulation(ParametersSet parametersSet, boolean bl) {
        SimulationPopulation simulationPopulation = this.getSimulationPopulation();
        if (simulationPopulation == null) {
            return null;
        }
        ParametersSet parametersSet2 = this.getParameterValues();
        if (parametersSet != null) {
            parametersSet2.putAll(parametersSet);
        }
        IList iList = GamaListFactory.create(Types.MAP);
        iList.add(parametersSet2);
        IList iList2 = simulationPopulation.createAgents(this.ownScope, 1, iList, false, bl);
        return (SimulationAgent)iList2.get(0);
    }

    public ParametersSet getParameterValues() {
        Map<String, IParameter> map = this.getSpecies().getParameters();
        ParametersSet parametersSet = new ParametersSet(this.ownScope, map, false);
        parametersSet.putAll(this.extraParametersMap);
        return parametersSet;
    }

    @Override
    public RandomUtils getRandomGenerator() {
        return this.random;
    }

    @Override
    public void schedule(IScope iScope) {
        this.scheduled = true;
        this.getSpecies().getController().schedule(this);
    }

    protected void createSimulationPopulation() {
        IModel iModel = this.getModel();
        SimulationPopulation simulationPopulation = (SimulationPopulation)this.getMicroPopulation(iModel);
        if (simulationPopulation == null) {
            simulationPopulation = new SimulationPopulation(this, (ISpecies)iModel);
            this.setAttribute(iModel.getName(), simulationPopulation);
            simulationPopulation.initializeFor(this.ownScope);
        }
        this.microPopulations = new IPopulation[]{simulationPopulation};
    }

    @Override
    public IScope getScope() {
        return this.ownScope;
    }

    @Override
    public IModel getModel() {
        return this.getSpecies().getModel();
    }

    @Override
    public IExperimentAgent getExperiment() {
        return this;
    }

    @Override
    public IExperimentPlan getSpecies() {
        return (IExperimentPlan)super.getSpecies();
    }

    @Override
    public GamaPoint setLocation(GamaPoint gamaPoint) {
        return gamaPoint;
    }

    @Override
    public void setGeometry(IShape iShape) {
    }

    public List<? extends IParameter.Batch> getDefaultParameters() {
        if (!this.getSpecies().isHeadless() && !GamaPreferences.Runtime.CORE_RND_EDITABLE.getValue().booleanValue()) {
            return new ArrayList();
        }
        ArrayList<ExperimentParameter> arrayList = new ArrayList<ExperimentParameter>();
        String string = this.getExperimentParametersCategory();
        ExperimentParameter experimentParameter = new ExperimentParameter(this.getScope(), this.getSpecies().getVar("rng"), "Random number generator", string, RandomUtils.Generators.names(), false);
        arrayList.add(experimentParameter);
        experimentParameter = new ExperimentParameter(this.getScope(), this.getSpecies().getVar("seed"), "Default random seed", string, "(current seed)", null, true){

            @Override
            Object getValue(IScope iScope) {
                return ExperimentAgent.this.getSeed();
            }
        };
        experimentParameter.setDefined(GamaPreferences.External.CORE_SEED_DEFINED.getValue());
        arrayList.add(experimentParameter);
        return arrayList;
    }

    protected String getExperimentParametersCategory() {
        return "Random number generation";
    }

    @Override
    @GamlAnnotations.getter(value="minimum_cycle_duration", initializer=true)
    public Double getMinimumDuration() {
        return this.currentMinimumDuration;
    }

    @Override
    @GamlAnnotations.getter(value="maximum_cycle_duration", initializer=true)
    public Double getMaximumDuration() {
        return this.currentMaximumDuration;
    }

    @Override
    @GamlAnnotations.setter(value="minimum_cycle_duration")
    public void setMinimumDuration(Double d) {
        if (d > this.currentMaximumDuration) {
            this.currentMaximumDuration = d;
        }
        this.setMinimumDurationExternal(d);
        this.ownScope.getGui().updateSpeedDisplay(this.ownScope, this.currentMinimumDuration * 1000.0, this.currentMaximumDuration * 1000.0, false);
    }

    @Override
    @GamlAnnotations.setter(value="maximum_cycle_duration")
    public void setMaximumDuration(Double d) {
        if (d <= 0.0) {
            d = 1.0;
        }
        if (d < this.currentMinimumDuration) {
            d = this.currentMinimumDuration;
        }
        this.currentMaximumDuration = d;
        this.ownScope.getGui().updateSpeedDisplay(this.ownScope, this.currentMinimumDuration * 1000.0, this.currentMaximumDuration * 1000.0, false);
    }

    public void setMinimumDurationExternal(Double d) {
        this.currentMinimumDuration = d;
    }

    @Override
    @GamlAnnotations.getter(value="model_path", initializer=true)
    public String getWorkingPath() {
        if (this.ownModelPath == null) {
            this.ownModelPath = this.getModel().getWorkingPath() + "/";
        }
        return this.ownModelPath;
    }

    @Override
    public List<String> getWorkingPaths() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getWorkingPath());
        arrayList.addAll(this.getModel().getImportedPaths());
        return arrayList;
    }

    @GamlAnnotations.setter(value="model_path")
    public void setWorkingPath(String string) {
        this.ownModelPath = string.endsWith("/") ? string : string + "/";
    }

    @GamlAnnotations.getter(value="parameters")
    @GamlAnnotations.doc(value="retuns the map of parameters defined in this experiment")
    public GamaMap<String, Object> getParameters(IScope iScope) {
        return this.getParameterValues();
    }

    @GamlAnnotations.getter(value="project_path")
    public String getProjectPath() {
        return this.getModel().getProjectPath() + "/";
    }

    @GamlAnnotations.getter(value="cycle")
    public Integer getCycle(IScope iScope) {
        if (this.ownClock != null) {
            return this.ownClock.getCycle();
        }
        return 0;
    }

    @GamlAnnotations.action(name="update_outputs", doc={@GamlAnnotations.doc(value="Forces all outputs to refresh, optionally recomputing their values")}, args={@GamlAnnotations.arg(name="recompute", type=3, doc={@GamlAnnotations.doc(value="Whether or not to force the outputs to make a computation step")})})
    public Object updateDisplays(IScope iScope) {
        Boolean bl = iScope.getBoolArg("recompute");
        if (bl.booleanValue()) {
            this.getSpecies().recomputeAndRefreshAllOutputs();
        } else {
            this.getSpecies().refreshAllOutputs();
        }
        return this;
    }

    @GamlAnnotations.action(name="compact_memory", doc={@GamlAnnotations.doc(value="Forces a 'garbage collect' of the unused objects in GAMA")})
    public Object compactMemory(IScope iScope) {
        System.gc();
        return this;
    }

    @GamlAnnotations.getter(value="seed", initializer=true)
    public Double getSeed() {
        Double d = this.random.getSeed();
        return d == null ? 0.0 : d;
    }

    @GamlAnnotations.setter(value="seed")
    public void setSeed(Double d) {
        Double d2 = d == null || d == 0.0 ? null : d;
        this.getRandomGenerator().setSeed(d2, true);
    }

    @GamlAnnotations.getter(value="rng_usage", initializer=false)
    public Integer getUsage() {
        Integer n = this.random.getUsage();
        return n == null ? 0 : n;
    }

    @GamlAnnotations.setter(value="rng_usage")
    public void setUsage(Integer n) {
        Integer n2 = n;
        if (n == null) {
            n2 = 0;
        }
        this.getRandomGenerator().setUsage(n2);
    }

    @GamlAnnotations.getter(value="rng", initializer=true)
    public String getRng() {
        return this.getRandomGenerator().getRngName();
    }

    @GamlAnnotations.setter(value="rng")
    public void setRng(String string) {
        this.getRandomGenerator().setGenerator(string, true);
    }

    @Override
    public SimulationPopulation getSimulationPopulation() {
        return (SimulationPopulation)this.getMicroPopulation(this.getModel());
    }

    @GamlAnnotations.getter(value="simulations")
    public IList<? extends IAgent> getSimulations() {
        return this.getSimulationPopulation().copy(this.ownScope);
    }

    @GamlAnnotations.setter(value="simulations")
    public void setSimulations(IList<IAgent> iList) {
    }

    @Override
    @GamlAnnotations.getter(value="simulation")
    public SimulationAgent getSimulation() {
        if (this.getSimulationPopulation() != null) {
            return this.getSimulationPopulation().getCurrentSimulation();
        }
        return null;
    }

    @GamlAnnotations.setter(value="simulation")
    public void setSimulation(SimulationAgent simulationAgent) {
        this.getSimulationPopulation().setCurrentSimulation(simulationAgent);
    }

    @Override
    public boolean isOnUserHold() {
        return this.isOnUserHold;
    }

    @Override
    public void setOnUserHold(boolean bl) {
        this.isOnUserHold = bl;
    }

    @Override
    public IPopulation<? extends IAgent> getPopulationFor(ISpecies iSpecies) {
        if (iSpecies == this.getModel()) {
            return this.getSimulationPopulation();
        }
        SimulationAgent simulationAgent = this.getSimulation();
        if (simulationAgent == null) {
            return IPopulation.createEmpty(iSpecies);
        }
        ModelDescription modelDescription = iSpecies.getDescription().getModelDescription();
        ModelDescription modelDescription2 = this.getModel().getDescription();
        if (modelDescription2.getMicroModel(modelDescription.getAlias()) == null) {
            return simulationAgent.getPopulationFor(iSpecies.getName());
        }
        return simulationAgent.getPopulationFor(iSpecies);
    }

    private void informStatus() {
        if (this.isHeadless() || this.isBatch()) {
            return;
        }
        this.ownScope.getGui().getStatus().informStatus(this.ownScope, null, "overlays/status.clock");
    }

    public boolean backward(IScope iScope) {
        try {
            GAMA.runAndUpdateAll(() -> {
                for (SimulationAgent simulationAgent : this.getSimulationPopulation()) {
                    if (!this.recorder.canStepBack(simulationAgent)) continue;
                    this.recorder.restore(simulationAgent);
                    if (((ExperimentPlan)this.getSpecies()).keepsSeed()) continue;
                    simulationAgent.setRandomGenerator(new RandomUtils(this.random.next(), simulationAgent.getRandomGenerator().getRngName()));
                }
            });
        }
        finally {
            this.informStatus();
            GAMA.updateExperimentState(this.getSpecies());
        }
        return true;
    }

    public Iterable<IOutputManager> getAllSimulationOutputs() {
        SimulationPopulation simulationPopulation = this.getSimulationPopulation();
        if (simulationPopulation != null) {
            return Iterables.filter((Iterable)Iterables.concat((Iterable)Iterables.transform((Iterable)simulationPopulation, SimulationAgent::getOutputManager), Collections.singletonList(this.getOutputManager())), iOutputManager -> iOutputManager != null);
        }
        return Collections.emptyList();
    }

    public boolean isScheduled() {
        return this.scheduled;
    }

    @Override
    public void closeSimulation(SimulationAgent simulationAgent) {
        simulationAgent.dispose();
    }

    @Override
    public GamaColor getColor() {
        return GamaColor.get(30, 30, 30, 255);
    }

    @Override
    public IOutputManager getOutputManager() {
        return this.getSpecies().getExperimentOutputs();
    }

    @Override
    public void postEndAction(IExecutable iExecutable) {
        this.executer.insertEndAction(iExecutable);
    }

    @Override
    public void postDisposeAction(IExecutable iExecutable) {
        this.executer.insertDisposeAction(iExecutable);
    }

    @Override
    public void postOneShotAction(IExecutable iExecutable) {
        this.executer.insertOneShotAction(iExecutable);
    }

    @Override
    public void executeAction(IExecutable iExecutable) {
        this.executer.executeOneAction(iExecutable);
    }

    @Override
    public boolean canStepBack() {
        if (!this.isRecord()) {
            return false;
        }
        SimulationAgent simulationAgent = this.getSimulation();
        if (simulationAgent == null) {
            return false;
        }
        return simulationAgent.getClock().getCycle() > 0;
    }

    @Override
    public boolean isHeadless() {
        return this.getSpecies().isHeadless();
    }

    public boolean isBatch() {
        return this.getSpecies().isBatch();
    }

    @Override
    public boolean isRecord() {
        return this.recorder != null;
    }

    @Override
    public String getFamilyName() {
        return "experiment";
    }

    @Override
    public boolean isExperiment() {
        return true;
    }

    @Override
    public IExpression getStopCondition() {
        return this.stopCondition;
    }

    public class ExperimentAgentScope
    extends ExecutionScope {
        GamaServerExperimentConfiguration serverConfig;

        @Override
        public GamaServerExperimentConfiguration getServerConfiguration() {
            return this.serverConfig;
        }

        @Override
        public void setServerConfiguration(GamaServerExperimentConfiguration gamaServerExperimentConfiguration) {
            this.serverConfig = gamaServerExperimentConfiguration;
        }

        @Override
        public RandomUtils getRandom() {
            return ExperimentAgent.this.random;
        }

        public ExperimentAgentScope() {
            super(ExperimentAgent.this);
            this.serverConfig = GamaServerExperimentConfiguration.NULL;
        }

        public ExperimentAgentScope(String string) {
            super(ExperimentAgent.this, string);
            this.serverConfig = GamaServerExperimentConfiguration.NULL;
        }

        @Override
        public IScope copy(String string) {
            ExperimentAgentScope experimentAgentScope = new ExperimentAgentScope(string);
            experimentAgentScope.push(this.getCurrentSymbol());
            return experimentAgentScope;
        }

        @Override
        public IExperimentAgent getExperiment() {
            return ExperimentAgent.this;
        }

        @Override
        public Object getGlobalVarValue(String string) {
            if (ExperimentAgent.this.hasAttribute(string) || ExperimentAgent.this.getSpecies().hasVar(string)) {
                return super.getGlobalVarValue(string);
            }
            SimulationAgent simulationAgent = this.getSimulation();
            if (simulationAgent != null && !simulationAgent.dead()) {
                return simulationAgent.getScope().getGlobalVarValue(string);
            }
            if (this.getModel().getSpecies().hasVar(string)) {
                IVariable iVariable = this.getModel().getSpecies().getVar(string);
                boolean bl = !iVariable.isNotModifiable();
                boolean bl2 = !this.getExperiment().getSpecies().keepsSimulations();
                boolean bl3 = this.getCurrentSymbol() instanceof ExperimentParameter;
                if (bl && bl2 && !bl3) {
                    throw GamaRuntimeException.error("This experiment does not keep its simulations. " + string + " cannot be retrieved in this context", this);
                }
                return iVariable.getInitialValue(this);
            }
            if (ExperimentAgent.this.getSpecies().hasParameter(string)) {
                return ExperimentAgent.this.getSpecies().getExperimentScope().getGlobalVarValue(string);
            }
            return ExperimentAgent.this.extraParametersMap.get(string);
        }

        @Override
        public boolean hasAccessToGlobalVar(String string) {
            if (ExperimentAgent.this.hasAttribute(string) || ExperimentAgent.this.getSpecies().hasVar(string) || this.getModel().getSpecies().hasVar(string) || ExperimentAgent.this.getSpecies().hasParameter(string)) {
                return true;
            }
            return ExperimentAgent.this.extraParametersMap.containsKey(string);
        }

        @Override
        public void setGlobalVarValue(String string, Object object) {
            if (ExperimentAgent.this.getSpecies().hasVar(string)) {
                super.setGlobalVarValue(string, object);
                return;
            }
            SimulationAgent simulationAgent = this.getSimulation();
            if (simulationAgent != null && !simulationAgent.dead() && simulationAgent.getSpecies().hasVar(string)) {
                simulationAgent.getScope().setGlobalVarValue(string, object);
            } else {
                ExperimentAgent.this.extraParametersMap.put(string, object);
            }
        }

        @Override
        public void setAgentVarValue(IAgent iAgent, String string, Object object) {
            if (iAgent == ExperimentAgent.this) {
                this.setGlobalVarValue(string, object);
            } else {
                super.setAgentVarValue(iAgent, string, object);
            }
        }

        @Override
        public Object getAgentVarValue(IAgent iAgent, String string) {
            if (iAgent == ExperimentAgent.this) {
                return this.getGlobalVarValue(string);
            }
            return super.getAgentVarValue(iAgent, string);
        }

        @Override
        public IGui getGui() {
            if (ExperimentAgent.this.getSpecies().isHeadless()) {
                return GAMA.getHeadlessGui();
            }
            return GAMA.getRegularGui();
        }
    }
}

