/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs.display;

import gama.core.common.interfaces.IDisplaySurface;
import gama.core.common.interfaces.IGraphics;
import gama.core.common.interfaces.ILayer;
import gama.core.common.interfaces.ILayerManager;
import gama.core.metamodel.shape.IShape;
import gama.core.outputs.LayeredDisplayOutput;
import gama.core.outputs.layers.AbstractLayerStatement;
import gama.core.outputs.layers.AgentLayer;
import gama.core.outputs.layers.EventLayer;
import gama.core.outputs.layers.EventLayerStatement;
import gama.core.outputs.layers.GisLayer;
import gama.core.outputs.layers.GraphicLayer;
import gama.core.outputs.layers.GridAgentLayer;
import gama.core.outputs.layers.GridLayer;
import gama.core.outputs.layers.ILayerStatement;
import gama.core.outputs.layers.ImageLayer;
import gama.core.outputs.layers.MeshLayer;
import gama.core.outputs.layers.OverlayLayer;
import gama.core.outputs.layers.SpeciesLayer;
import gama.core.outputs.layers.charts.ChartLayer;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LayerManager
implements ILayerManager {
    private final ILayer[] layers;
    private final Map<String, EventLayerStatement> eventLayers = new HashMap<String, EventLayerStatement>();
    final IDisplaySurface surface;
    private int count = 0;

    public static ILayer createLayer(LayeredDisplayOutput layeredDisplayOutput, ILayerStatement iLayerStatement) {
        return switch (iLayerStatement.getType(layeredDisplayOutput)) {
            case ILayerStatement.LayerType.GRID -> new GridLayer(iLayerStatement);
            case ILayerStatement.LayerType.AGENTS -> new AgentLayer(iLayerStatement);
            case ILayerStatement.LayerType.GRID_AGENTS -> new GridAgentLayer(iLayerStatement);
            case ILayerStatement.LayerType.SPECIES -> new SpeciesLayer(iLayerStatement);
            case ILayerStatement.LayerType.IMAGE -> new ImageLayer(layeredDisplayOutput.getScope(), iLayerStatement);
            case ILayerStatement.LayerType.GIS -> new GisLayer(iLayerStatement);
            case ILayerStatement.LayerType.CHART -> new ChartLayer(iLayerStatement);
            case ILayerStatement.LayerType.EVENT -> new EventLayer(iLayerStatement);
            case ILayerStatement.LayerType.GRAPHICS -> new GraphicLayer(iLayerStatement);
            case ILayerStatement.LayerType.OVERLAY -> new OverlayLayer(iLayerStatement);
            case ILayerStatement.LayerType.MESH -> new MeshLayer(iLayerStatement);
            default -> null;
        };
    }

    public LayerManager(IDisplaySurface iDisplaySurface, LayeredDisplayOutput layeredDisplayOutput) {
        this.surface = iDisplaySurface;
        OverlayLayer overlayLayer = null;
        ArrayList<ILayer> arrayList = new ArrayList<ILayer>();
        for (AbstractLayerStatement abstractLayerStatement : layeredDisplayOutput.getLayers()) {
            if (abstractLayerStatement instanceof EventLayerStatement) {
                EventLayerStatement eventLayerStatement = (EventLayerStatement)abstractLayerStatement;
                this.eventLayers.put(eventLayerStatement.getName(), eventLayerStatement);
            }
            if (!abstractLayerStatement.isToCreate()) continue;
            ILayer iLayer = LayerManager.createLayer(layeredDisplayOutput, abstractLayerStatement);
            if (iLayer instanceof OverlayLayer) {
                overlayLayer = (OverlayLayer)iLayer;
                continue;
            }
            if (iLayer == null) continue;
            arrayList.add(iLayer);
            this.addItem(iLayer);
        }
        if (overlayLayer != null) {
            arrayList.add(overlayLayer);
        }
        this.layers = arrayList.toArray(new ILayer[arrayList.size()]);
    }

    @Override
    public void dispose() {
        ILayer[] iLayerArray = this.layers;
        int n = this.layers.length;
        int n2 = 0;
        while (n2 < n) {
            ILayer iLayer = iLayerArray[n2];
            iLayer.dispose();
            ++n2;
        }
    }

    @Override
    public List<ILayer> getLayersIntersecting(int n, int n2) {
        ArrayList<ILayer> arrayList = new ArrayList<ILayer>();
        ILayer[] iLayerArray = this.layers;
        int n3 = this.layers.length;
        int n4 = 0;
        while (n4 < n3) {
            ILayer iLayer = iLayerArray[n4];
            if (iLayer.containsScreenPoint(n, n2)) {
                arrayList.add(iLayer);
            }
            ++n4;
        }
        return arrayList;
    }

    @Override
    public Rectangle2D focusOn(IShape iShape, IDisplaySurface iDisplaySurface) {
        if (iShape == null) {
            return null;
        }
        Rectangle2D rectangle2D = null;
        ILayer[] iLayerArray = this.layers;
        int n = this.layers.length;
        int n2 = 0;
        while (n2 < n) {
            ILayer iLayer = iLayerArray[n2];
            Rectangle2D rectangle2D2 = iLayer.focusOn(iShape, iDisplaySurface);
            if (rectangle2D2 != null) {
                if (rectangle2D == null) {
                    rectangle2D = new Rectangle2D.Double(rectangle2D2.getX(), rectangle2D2.getY(), rectangle2D2.getWidth(), rectangle2D2.getHeight());
                } else {
                    rectangle2D.add(rectangle2D2);
                }
            }
            ++n2;
        }
        return rectangle2D;
    }

    @Override
    public void drawLayersOn(IGraphics iGraphics) {
        if (iGraphics == null) {
            return;
        }
        IScope.IGraphicsScope iGraphicsScope = this.surface.getScope();
        if (iGraphicsScope == null || iGraphicsScope.interrupted()) {
            return;
        }
        iGraphicsScope.setGraphics(iGraphics);
        if (iGraphics.beginDrawingLayers()) {
            try {
                ILayer[] iLayerArray = this.layers;
                int n = this.layers.length;
                int n2 = 0;
                while (n2 < n) {
                    ILayer iLayer = iLayerArray[n2];
                    if (iGraphicsScope.interrupted()) {
                        return;
                    }
                    try {
                        iLayer.draw(iGraphicsScope, iGraphics);
                        ++n2;
                        continue;
                    }
                    catch (Exception exception) {
                        GAMA.reportAndThrowIfNeeded(iGraphicsScope, GamaRuntimeException.create(exception, iGraphicsScope), false);
                    }
                    break;
                }
            }
            finally {
                iGraphics.endDrawingLayers();
            }
        }
    }

    @Override
    public List<ILayer> getItems() {
        return Arrays.asList(this.layers);
    }

    @Override
    public String getItemDisplayName(ILayer iLayer, String string) {
        return iLayer.getMenuName();
    }

    @Override
    public boolean addItem(ILayer iLayer) {
        iLayer.getDefinition().setOrder(this.count++);
        iLayer.firstLaunchOn(this.surface);
        return true;
    }

    @Override
    public void outputChanged() {
        ILayer[] iLayerArray = this.layers;
        int n = this.layers.length;
        int n2 = 0;
        while (n2 < n) {
            ILayer iLayer = iLayerArray[n2];
            iLayer.reloadOn(this.surface);
            ++n2;
        }
    }

    @Override
    public boolean stayProportional() {
        ILayer[] iLayerArray = this.layers;
        int n = this.layers.length;
        int n2 = 0;
        while (n2 < n) {
            ILayer iLayer = iLayerArray[n2];
            if (iLayer.stayProportional()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void makeItemSelectable(ILayer iLayer, boolean bl) {
        iLayer.getData().setSelectable(bl);
    }

    @Override
    public void makeItemVisible(ILayer iLayer, boolean bl) {
        this.surface.runAndUpdate(() -> {
            if (bl) {
                iLayer.enableOn(this.surface);
            } else {
                iLayer.disableOn(this.surface);
            }
            this.forceRedrawingLayers();
        });
    }

    @Override
    public void forceRedrawingLayers() {
        ILayer[] iLayerArray = this.layers;
        int n = this.layers.length;
        int n2 = 0;
        while (n2 < n) {
            ILayer iLayer = iLayerArray[n2];
            iLayer.forceRedrawingOnce();
            ++n2;
        }
        this.surface.layersChanged();
    }

    @Override
    public boolean isProvidingCoordinates() {
        ILayer[] iLayerArray = this.layers;
        int n = this.layers.length;
        int n2 = 0;
        while (n2 < n) {
            ILayer iLayer = iLayerArray[n2];
            if (iLayer.getData().isVisible().booleanValue() && iLayer.isProvidingCoordinates()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean isProvidingWorldCoordinates() {
        ILayer[] iLayerArray = this.layers;
        int n = this.layers.length;
        int n2 = 0;
        while (n2 < n) {
            ILayer iLayer = iLayerArray[n2];
            if (iLayer.getData().isVisible().booleanValue() && iLayer.isProvidingWorldCoordinates()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean hasMouseMenuEventLayer() {
        return this.eventLayers.containsKey("mouse_menu");
    }

    @Override
    public boolean hasEscEventLayer() {
        return this.eventLayers.containsKey("escape");
    }

    @Override
    public boolean hasArrowEventLayer() {
        return this.eventLayers.containsKey("arrow_down") || this.eventLayers.containsKey("arrow_up") || this.eventLayers.containsKey("arrow_right") || this.eventLayers.containsKey("arrow_left");
    }

    @Override
    public boolean isItemVisible(ILayer iLayer) {
        return iLayer.getData().isVisible();
    }

    @Override
    public boolean hasStructurallyChanged() {
        ILayer[] iLayerArray = this.layers;
        int n = this.layers.length;
        int n2 = 0;
        while (n2 < n) {
            ILayer iLayer = iLayerArray[n2];
            if (iLayer.getData().hasStructurallyChanged()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public ChartLayer getOnlyChart() {
        ChartLayer chartLayer = null;
        ILayer[] iLayerArray = this.layers;
        int n = this.layers.length;
        int n2 = 0;
        while (n2 < n) {
            ILayer iLayer = iLayerArray[n2];
            if (iLayer instanceof ChartLayer) {
                ChartLayer chartLayer2 = (ChartLayer)iLayer;
                if (chartLayer != null) {
                    return null;
                }
                chartLayer = chartLayer2;
            } else if (!(iLayer instanceof EventLayer)) {
                return null;
            }
            ++n2;
        }
        return chartLayer;
    }
}

