/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs.layers;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.interfaces.IEventLayerDelegate;
import gama.core.outputs.layers.EventLayerStatement;
import gama.core.runtime.IScope;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class KeyboardEventLayerDelegate
implements IEventLayerDelegate {
    @GamlAnnotations.constant(value="shift", category={"User control operators"}, doc={@GamlAnnotations.doc(value="Represents the shift key modifier")})
    public static final String SHIFT_MODIFIER = "shift";
    @GamlAnnotations.constant(value="ctrl", category={"User control operators"}, doc={@GamlAnnotations.doc(value="Represents the control key modifier")})
    public static final String CONTROL_MODIFIER = "ctrl";
    @GamlAnnotations.constant(value="alt", category={"User control operators"}, doc={@GamlAnnotations.doc(value="Represents the alt key modifier")})
    public static final String ALT_MODIFIER = "alt";
    @GamlAnnotations.constant(value="cmd", category={"User control operators"}, doc={@GamlAnnotations.doc(value="Represents the command key modifier")})
    public static final String CMD_MODIFIER = "cmd";
    @GamlAnnotations.constant(value="arrow_down", category={"User control operators"}, doc={@GamlAnnotations.doc(value="Represents an event emitted when the user presses the arrow down key. Defining an event layer with this event will deactivate the default navigation using arrow keys in the display. Use shift+arrow to override")})
    public static final String ARROW_DOWN = "arrow_down";
    @GamlAnnotations.constant(value="arrow_up", category={"User control operators"}, doc={@GamlAnnotations.doc(value="Represents an event emitted when the user presses the arrow up key. Defining an event layer with this event will deactivate the default navigation using arrow keys in the display. Use shift+arrow to override")})
    public static final String ARROW_UP = "arrow_up";
    @GamlAnnotations.constant(value="arrow_left", category={"User control operators"}, doc={@GamlAnnotations.doc(value="Represents an event emitted when the user presses the arrow left key. Defining an event layer with this event will deactivate the default navigation using arrow keys in the display. Use shift+arrow to override")})
    public static final String ARROW_LEFT = "arrow_left";
    @GamlAnnotations.constant(value="arrow_right", category={"User control operators"}, doc={@GamlAnnotations.doc(value="Represents an event emitted when the user presses the arrow right key.Defining an event layer with this event will deactivate the default navigation using arrow keys in the display. Use shift+arrow to override")})
    public static final String ARROW_RIGHT = "arrow_right";
    @GamlAnnotations.constant(value="escape", category={"User control operators"}, doc={@GamlAnnotations.doc(value="Represents an event emitted when the user presses the ESC key. Defining an event layer with this event will deactivate the fullscreen shortcut in the display. Use the toolbar/menu command to go fullscreen")})
    public static final String KEY_ESC = "escape";
    @GamlAnnotations.constant(value="page_down", category={"User control operators"}, doc={@GamlAnnotations.doc(value="Represents an event emitted when the user presses the page down key")})
    public static final String KEY_PAGE_DOWN = "page_down";
    @GamlAnnotations.constant(value="page_up", category={"User control operators"}, doc={@GamlAnnotations.doc(value="Represents an event emitted when the user presses the page up key")})
    public static final String KEY_PAGE_UP = "page_up";
    @GamlAnnotations.constant(value="enter", category={"User control operators"}, doc={@GamlAnnotations.doc(value="Represents an event emitted when the user presses the enter/return key")})
    public static final String KEY_ENTER = "enter";
    @GamlAnnotations.constant(value="tab", category={"User control operators"}, doc={@GamlAnnotations.doc(value="Represents an event emitted when the user presses the tab key")})
    public static final String KEY_TAB = "tab";
    public static final Set<String> EVENTS = new HashSet<String>(Arrays.asList("enter", "escape", "page_down", "page_up", "tab", "arrow_down", "arrow_left", "arrow_right", "arrow_up", "alt", "ctrl", "cmd", "shift"));

    @Override
    public boolean acceptSource(IScope iScope, Object object) {
        return Objects.equals(object, "default");
    }

    @Override
    public boolean createFrom(IScope iScope, Object object, EventLayerStatement eventLayerStatement) {
        return true;
    }

    @Override
    public Set<String> getEvents() {
        return EVENTS;
    }
}

