/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs.layers.charts;

import gama.core.common.interfaces.IDisplaySurface;
import gama.core.outputs.layers.charts.ChartDataSet;
import gama.core.outputs.layers.charts.ChartDataSource;
import gama.core.runtime.IScope;
import gama.core.util.GamaColor;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import java.awt.Color;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.util.LinkedHashMap;
import org.jfree.chart.JFreeChart;

public abstract class ChartOutput {
    static final int SERIES_CHART = 0;
    static final int HISTOGRAM_CHART = 1;
    static final int PIE_CHART = 2;
    static final int XY_CHART = 3;
    static final int BOX_WHISKER_CHART = 4;
    static final int SCATTER_CHART = 5;
    static final int RADAR_CHART = 6;
    static final int HEATMAP_CHART = 7;
    public int lastUpdateCycle = -1;
    public boolean ismyfirststep = true;
    String chname = "";
    String xlabel = null;
    String ylabel = null;
    String y2label = null;
    ChartDataSet chartdataset;
    int type = 0;
    boolean reverse_axes = false;
    boolean x_logscale = false;
    boolean y_logscale = false;
    boolean y2_logscale = false;
    boolean use_second_y_axis = false;
    boolean title_visible = true;
    boolean x_tick_value_visible = true;
    boolean y_tick_value_visible = true;
    boolean x_tick_line_visible = true;
    boolean y_tick_line_visible = true;
    Color backgroundColor = GamaColor.WHITE;
    Color axesColor = null;
    Color labelBackgroundColor = null;
    Color labelTextColor = null;
    Color textColor = null;
    Color tickColor = null;
    String tickFontFace = "SansSerif";
    int tickFontSize = 10;
    int tickFontStyle = 0;
    String labelFontFace = "SansSerif";
    int labelFontSize = 12;
    int labelFontStyle = 1;
    String legendFontFace = "SansSerif";
    int legendFontSize = 10;
    int legendFontStyle = 2;
    String titleFontFace = "Serif";
    int titleFontSize = 14;
    int titleFontStyle = 1;
    String series_label_position = "default";
    String style = "default";
    double gap = -1.0;
    double xrangeinterval;
    double xrangemin;
    double xrangemax;
    boolean usexrangeinterval = false;
    boolean usexrangeminmax = false;
    double yrangeinterval;
    double yrangemin;
    double yrangemax;
    boolean useyrangeinterval = false;
    boolean useyrangeminmax = false;
    double y2rangeinterval;
    double y2rangemin;
    double y2rangemax;
    boolean usey2rangeinterval = false;
    boolean usey2rangeminmax = false;
    double xtickunit = -1.0;
    double ytickunit = -1.0;
    double y2tickunit = -1.0;

    public abstract BufferedImage getImage(int var1, int var2, boolean var3);

    public ChartOutput(IScope iScope, String string, IExpression iExpression) {
        String string2;
        String string3 = string2 = iExpression == null ? "series" : Cast.asString(iScope, iExpression.value(iScope));
        this.type = "series".equals(string2) ? 0 : ("histogram".equals(string2) ? 1 : ("radar".equals(string2) ? 6 : ("pie".equals(string2) ? 2 : ("box_whisker".equals(string2) ? 4 : ("scatter".equals(string2) ? 5 : 3)))));
        this.axesColor = GamaColor.get(Color.black);
    }

    public int getChartCycle(IScope iScope) {
        if (this.ismyfirststep) {
            this.ismyfirststep = false;
            return 0;
        }
        return iScope.getClock().getCycle() + 1;
    }

    public void step(IScope iScope) {
        this.chartdataset.updatedataset(iScope, this.getChartCycle(iScope));
        this.updateOutput(iScope);
    }

    public void initdataset() {
    }

    public void updateOutput(IScope iScope) {
        if (this.chartdataset.doResetAll(iScope, this.lastUpdateCycle)) {
            this.clearDataSet(iScope);
            for (String string : this.chartdataset.getDataSeriesIds(iScope)) {
                this.createNewSerie(iScope, string);
            }
            this.preResetSeries(iScope);
            for (String string : this.chartdataset.getDataSeriesIds(iScope)) {
                this.resetSerie(iScope, string);
            }
        } else {
            LinkedHashMap<String, Integer> linkedHashMap = this.chartdataset.getSerieRemovalDate();
            for (String string : linkedHashMap.keySet()) {
                if (linkedHashMap.get(string) < this.lastUpdateCycle) continue;
                this.removeSerie(iScope, string);
                linkedHashMap.put(string, linkedHashMap.get(string) - 1);
            }
            LinkedHashMap<String, Integer> linkedHashMap2 = this.chartdataset.getSerieCreationDate();
            for (String string : linkedHashMap2.keySet()) {
                if (linkedHashMap2.get(string) < this.lastUpdateCycle) continue;
                this.createNewSerie(iScope, string);
                linkedHashMap2.put(string, linkedHashMap2.get(string) - 1);
            }
            this.preResetSeries(iScope);
            for (String string : this.chartdataset.getDataSeriesIds(iScope)) {
                this.resetSerie(iScope, string);
            }
        }
        this.resetAxes(iScope);
        this.lastUpdateCycle = iScope.getClock().getCycle();
    }

    public void preResetSeries(IScope iScope) {
    }

    public void resetAxes(IScope iScope) {
    }

    public void removeSerie(IScope iScope, String string) {
    }

    protected void resetSerie(IScope iScope, String string) {
    }

    protected void clearDataSet(IScope iScope) {
    }

    protected void createNewSerie(IScope iScope, String string) {
    }

    public void setUseXSource(IScope iScope, IExpression iExpression) {
    }

    public void setUseXLabels(IScope iScope, IExpression iExpression) {
    }

    public void setUseYLabels(IScope iScope, IExpression iExpression) {
    }

    public void initChart(IScope iScope, String string) {
        this.chname = string;
    }

    public void createChart(IScope iScope) {
    }

    public ChartDataSet getChartdataset() {
        return this.chartdataset;
    }

    public void setChartdataset(ChartDataSet chartDataSet) {
        this.chartdataset = chartDataSet;
        chartDataSet.setOutput(this);
    }

    public String getName() {
        return this.chname;
    }

    public String getStyle() {
        return this.style;
    }

    public void setAxesColorValue(IScope iScope, GamaColor gamaColor) {
        this.axesColor = gamaColor;
    }

    public void setTickColorValue(IScope iScope, GamaColor gamaColor) {
        this.tickColor = gamaColor;
    }

    public void setBackgroundColorValue(IScope iScope, GamaColor gamaColor) {
        this.backgroundColor = gamaColor;
    }

    public void setLabelTextColorValue(IScope iScope, GamaColor gamaColor) {
        this.labelTextColor = gamaColor;
    }

    public void setLabelBackgroundColorValue(IScope iScope, GamaColor gamaColor) {
        this.labelBackgroundColor = gamaColor;
    }

    public void setColorValue(IScope iScope, GamaColor gamaColor) {
        this.textColor = gamaColor;
    }

    public void setTickFontFace(IScope iScope, String string) {
        if (string != null) {
            this.tickFontFace = string;
        }
    }

    public void setLabelFontFace(IScope iScope, String string) {
        if (string != null) {
            this.labelFontFace = string;
        }
    }

    public void setLegendFontFace(IScope iScope, String string) {
        if (string != null) {
            this.legendFontFace = string;
        }
    }

    public void setTitleFontFace(IScope iScope, String string) {
        if (string != null) {
            this.titleFontFace = string;
        }
    }

    public void setTickFontSize(IScope iScope, int n) {
        this.tickFontSize = n;
    }

    public void setLabelFontSize(IScope iScope, int n) {
        this.labelFontSize = n;
    }

    public void setLegendFontSize(IScope iScope, int n) {
        this.legendFontSize = n;
    }

    public void setTitleFontSize(IScope iScope, int n) {
        this.titleFontSize = n;
    }

    public void setTickFontStyle(IScope iScope, int n) {
        this.tickFontStyle = n;
    }

    public void setLabelFontStyle(IScope iScope, int n) {
        this.labelFontStyle = n;
    }

    public void setLegendFontStyle(IScope iScope, int n) {
        this.legendFontStyle = n;
    }

    public void setTitleFontStyle(IScope iScope, int n) {
        this.titleFontStyle = n;
    }

    public void setXLabel(IScope iScope, String string) {
        this.xlabel = string;
    }

    public String getXLabel(IScope iScope) {
        return this.xlabel;
    }

    public void setYLabel(IScope iScope, String string) {
        this.ylabel = string;
    }

    public String getYLabel(IScope iScope) {
        return this.ylabel;
    }

    public void setY2Label(IScope iScope, String string) {
        this.y2label = string;
    }

    public String getY2Label(IScope iScope) {
        return this.y2label;
    }

    public boolean getUseXRangeInterval(IScope iScope) {
        return this.usexrangeinterval;
    }

    public boolean getUseXRangeMinMax(IScope iScope) {
        return this.usexrangeminmax;
    }

    public boolean getUseYRangeInterval(IScope iScope) {
        return this.useyrangeinterval;
    }

    public boolean getUseYRangeMinMax(IScope iScope) {
        return this.useyrangeminmax;
    }

    public boolean getUseY2RangeInterval(IScope iScope) {
        return this.usey2rangeinterval;
    }

    public boolean getUseY2RangeMinMax(IScope iScope) {
        return this.usey2rangeminmax;
    }

    public void setXRangeInterval(IScope iScope, double d) {
        this.usexrangeinterval = true;
        this.xrangeinterval = d;
    }

    public double getXRangeInterval(IScope iScope) {
        return this.xrangeinterval;
    }

    public void setXRangeMinMax(IScope iScope, double d, double d2) {
        this.usexrangeminmax = true;
        this.xrangemin = d;
        this.xrangemax = d2;
    }

    public double getXRangeMin(IScope iScope) {
        return this.xrangemin;
    }

    public double getXRangeMax(IScope iScope) {
        return this.xrangemax;
    }

    public double getYRangeInterval(IScope iScope) {
        return this.yrangeinterval;
    }

    public void setYRangeInterval(IScope iScope, double d) {
        this.useyrangeinterval = true;
        this.yrangeinterval = d;
    }

    public void setYRangeMinMax(IScope iScope, double d, double d2) {
        this.useyrangeminmax = true;
        this.yrangemin = d;
        this.yrangemax = d2;
    }

    public double getYRangeMin(IScope iScope) {
        return this.yrangemin;
    }

    public double getYRangeMax(IScope iScope) {
        return this.yrangemax;
    }

    public double getY2RangeInterval(IScope iScope) {
        return this.y2rangeinterval;
    }

    public void setY2RangeInterval(IScope iScope, double d) {
        this.usey2rangeinterval = true;
        this.y2rangeinterval = d;
    }

    public void setY2RangeMinMax(IScope iScope, double d, double d2) {
        this.usey2rangeminmax = true;
        this.y2rangemin = d;
        this.y2rangemax = d2;
    }

    public double getY2RangeMin(IScope iScope) {
        return this.y2rangemin;
    }

    public double getY2RangeMax(IScope iScope) {
        return this.y2rangemax;
    }

    public void setXTickUnit(IScope iScope, double d) {
        this.xtickunit = d;
    }

    public double getXTickUnit(IScope iScope) {
        return this.xtickunit;
    }

    public void setYTickUnit(IScope iScope, double d) {
        this.ytickunit = d;
    }

    public double getYTickUnit(IScope iScope) {
        return this.ytickunit;
    }

    public void setY2TickUnit(IScope iScope, double d) {
        this.y2tickunit = d;
    }

    public double getY2TickUnit(IScope iScope) {
        return this.y2tickunit;
    }

    public void setGap(IScope iScope, double d) {
        this.gap = d;
    }

    public JFreeChart getJFChart() {
        return null;
    }

    public void setSerieMarkerShape(IScope iScope, String string, String string2) {
    }

    public void setDefaultPropertiesFromType(IScope iScope, ChartDataSource chartDataSource, int n) {
    }

    public void setUseSize(IScope iScope, String string, boolean bl) {
    }

    public void setSeriesLabelPosition(IScope iScope, String string) {
        this.series_label_position = string;
    }

    public void setStyle(IScope iScope, String string) {
        this.style = string;
    }

    public void initChart_post_data_init(IScope iScope) {
    }

    public void getModelCoordinatesInfo(int n, int n2, IDisplaySurface iDisplaySurface, Point point, StringBuilder stringBuilder) {
    }

    public void setReverseAxis(IScope iScope, Boolean bl) {
        this.reverse_axes = bl;
    }

    public void setX_LogScale(IScope iScope, Boolean bl) {
        this.x_logscale = bl;
    }

    public void setY_LogScale(IScope iScope, Boolean bl) {
        this.y_logscale = bl;
    }

    public boolean getX_LogScale(IScope iScope) {
        return this.x_logscale;
    }

    public boolean getY_LogScale(IScope iScope) {
        return this.y_logscale;
    }

    public void setY2_LogScale(IScope iScope, Boolean bl) {
        this.y2_logscale = bl;
    }

    public boolean getY2_LogScale(IScope iScope) {
        return this.y2_logscale;
    }

    public void setUseSecondYAxis(IScope iScope, Boolean bl) {
        this.use_second_y_axis = bl;
    }

    public boolean getUseSecondYAxis(IScope iScope) {
        return this.use_second_y_axis;
    }

    public void setXTickValueVisible(IScope iScope, Boolean bl) {
        this.x_tick_value_visible = bl;
    }

    public boolean getXTickValueVisible(IScope iScope) {
        return this.x_tick_value_visible;
    }

    public void setYTickValueVisible(IScope iScope, Boolean bl) {
        this.y_tick_value_visible = bl;
    }

    public boolean getYTickValueVisible(IScope iScope) {
        return this.y_tick_value_visible;
    }

    public void setTitleVisible(IScope iScope, Boolean bl) {
        this.title_visible = bl;
    }

    public boolean getTitleVisible(IScope iScope) {
        return this.title_visible;
    }

    public void setXTickLineVisible(IScope iScope, Boolean bl) {
        this.x_tick_line_visible = bl;
    }

    public boolean getXTickLineVisible(IScope iScope) {
        return this.x_tick_line_visible;
    }

    public void setYTickLineVisible(IScope iScope, Boolean bl) {
        this.y_tick_line_visible = bl;
    }

    public boolean getYTickLineVisible(IScope iScope) {
        return this.y_tick_line_visible;
    }

    public void dispose(IScope iScope) {
    }
}

