/*
 * Decompiled with CFR 0.152.
 */
package gama.core.runtime.exceptions;

import gama.core.kernel.experiment.ITopLevelAgent;
import gama.core.kernel.simulation.SimulationClock;
import gama.core.runtime.IScope;
import gama.gaml.compilation.ISymbol;
import gama.gaml.operators.Strings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;

public class GamaRuntimeException
extends RuntimeException {
    private final long cycle;
    protected final List<String> agentsNames = new ArrayList<String>();
    private boolean isWarning;
    protected final List<String> context = new ArrayList<String>();
    protected EObject editorContext;
    protected int occurrences = 0;
    protected boolean reported = false;
    protected final IScope scope;

    public static GamaRuntimeException create(Throwable throwable, IScope iScope) {
        if (throwable instanceof GamaRuntimeException) {
            return (GamaRuntimeException)throwable;
        }
        if (throwable instanceof IOException || throwable instanceof FileNotFoundException) {
            return new GamaRuntimeFileException(iScope, throwable);
        }
        return new GamaRuntimeException(iScope, throwable);
    }

    public static GamaRuntimeException error(String string, IScope iScope) {
        return new GamaRuntimeException(iScope, string, false);
    }

    public static GamaRuntimeException warning(String string, IScope iScope) {
        return new GamaRuntimeException(iScope, string, true);
    }

    protected static String getExceptionName(Throwable throwable) {
        String string = throwable.getClass().getName();
        if (string.contains("geotools") || string.contains("opengis")) {
            return "exception in GeoTools library";
        }
        if (string.contains("jts")) {
            return "exception in JTS library";
        }
        if (string.contains("rcaller")) {
            return "exception in RCaller library";
        }
        if (string.contains("jogamp")) {
            return "exception in JOGL library";
        }
        if (string.contains("weka")) {
            return "exception in Weka library";
        }
        if (string.contains("math3")) {
            return "exception in Math library";
        }
        if (throwable instanceof NullPointerException) {
            return "nil value detected";
        }
        if (throwable instanceof IndexOutOfBoundsException) {
            return "index out of bounds";
        }
        if (throwable instanceof IOException) {
            return "I/O error";
        }
        if (throwable instanceof CoreException) {
            return "exception in Eclipse";
        }
        if (throwable instanceof ClassCastException) {
            return "wrong casting";
        }
        if (throwable instanceof IllegalArgumentException) {
            return "illegal argument";
        }
        return throwable.getClass().getSimpleName();
    }

    protected GamaRuntimeException(IScope iScope, Throwable throwable) {
        super((String)(throwable == null ? "Error" : "Java error: " + GamaRuntimeException.getExceptionName(throwable)), throwable);
        ISymbol iSymbol;
        this.scope = iScope;
        if (iScope != null && (iSymbol = iScope.getCurrentSymbol()) != null) {
            this.addContext(iSymbol);
        }
        if (throwable != null) {
            throwable.printStackTrace();
            this.addContext(throwable.getClass().getSimpleName() + ": " + throwable.getMessage());
            int n = 0;
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            int n2 = stackTraceElementArray.length;
            int n3 = 0;
            while (n3 < n2) {
                StackTraceElement stackTraceElement = stackTraceElementArray[n3];
                this.addContext(stackTraceElement.toString());
                if (n++ > 5) break;
                ++n3;
            }
        }
        this.cycle = this.computeCycle(iScope);
    }

    protected GamaRuntimeException(IScope iScope, String string, boolean bl) {
        super(string);
        ISymbol iSymbol;
        this.scope = iScope;
        if (iScope != null && (iSymbol = iScope.getCurrentSymbol()) != null) {
            this.addContext(iSymbol);
        }
        this.cycle = this.computeCycle(iScope);
        this.isWarning = bl;
    }

    public void addContext(String string) {
        this.context.add(string);
    }

    public void addContext(ISymbol iSymbol) {
        EObject eObject;
        String string = iSymbol.serializeToGaml(false);
        if (string != null && !string.isBlank()) {
            this.addContext("in " + string);
        }
        if ((eObject = iSymbol.getDescription().getUnderlyingElement()) != null && this.editorContext == null) {
            this.editorContext = eObject;
        }
    }

    public EObject getEditorContext() {
        return this.editorContext;
    }

    public void addAgent(String string) {
        ++this.occurrences;
        if (this.agentsNames.contains(string)) {
            return;
        }
        this.agentsNames.add(string);
    }

    public void addAgents(List<String> list) {
        for (String string : list) {
            this.addAgent(string);
        }
    }

    public long getCycle() {
        return this.cycle;
    }

    public String getAgentSummary() {
        String string;
        int n = this.agentsNames.size();
        String string2 = n == 0 ? "" : (string = n == 1 ? this.agentsNames.get(0) : String.valueOf(n) + " agents");
        String string3 = this.occurrences == 0 ? "" : (this.occurrences == 1 ? "1 occurence in " : String.valueOf(this.occurrences) + " occurrences in ");
        return string3 + string;
    }

    public boolean isWarning() {
        return this.isWarning;
    }

    public long computeCycle(IScope iScope) {
        SimulationClock simulationClock = iScope == null ? null : iScope.getClock();
        return simulationClock == null ? 0L : (long)simulationClock.getCycle();
    }

    public List<String> getContextAsList() {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.scope != null && this.scope.getRoot() != null) {
            arrayList.add("in " + this.scope.getRoot().getName());
        }
        if ((n = this.agentsNames.size()) == 0) {
            return arrayList;
        }
        if (n == 1) {
            arrayList.add("in agent " + this.agentsNames.get(0));
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("in agents ").append(this.agentsNames.get(0));
            int n2 = 1;
            while (n2 < this.agentsNames.size()) {
                stringBuilder.append(", ").append(this.agentsNames.get(n2));
                if (stringBuilder.length() > 100) {
                    stringBuilder.append("...");
                    break;
                }
                ++n2;
            }
            arrayList.add(stringBuilder.toString());
        }
        arrayList.addAll(this.context);
        return arrayList;
    }

    @Override
    public String toString() {
        String string = this.getClass().getName();
        String string2 = this.getLocalizedMessage();
        return string2 != null ? string2 : string;
    }

    public boolean equivalentTo(GamaRuntimeException gamaRuntimeException) {
        return this == gamaRuntimeException || this.editorContext == gamaRuntimeException.editorContext && this.getMessage().equals(gamaRuntimeException.getMessage()) && this.scope != null && gamaRuntimeException.scope != null && this.scope.getRoot() == gamaRuntimeException.scope.getRoot() && this.getCycle() == gamaRuntimeException.getCycle();
    }

    public void setReported() {
        this.reported = true;
    }

    public boolean isReported() {
        return this.reported;
    }

    public List<String> getAgentsNames() {
        return this.agentsNames;
    }

    public String getAllText() {
        StringBuilder stringBuilder = new StringBuilder(300);
        String string = this.getAgentSummary();
        stringBuilder.append(string).append(" at ");
        stringBuilder.append("cycle ").append(this.getCycle()).append(": ").append(this.getMessage());
        List<String> list = this.getContextAsList();
        for (String string2 : list) {
            stringBuilder.append(Strings.LN).append(string2);
        }
        return stringBuilder.toString();
    }

    public boolean isInvalid() {
        return this.scope == null || this.scope.isClosed();
    }

    public ITopLevelAgent getTopLevelAgent() {
        return this.scope == null ? null : this.scope.getRoot();
    }

    public static class GamaRuntimeFileException
    extends GamaRuntimeException {
        public GamaRuntimeFileException(IScope iScope, Throwable throwable) {
            super(iScope, throwable);
        }

        public GamaRuntimeFileException(IScope iScope, String string) {
            super(iScope, string, false);
        }
    }
}

