/*
 * Decompiled with CFR 0.152.
 */
package gama.core.runtime.server;

import gama.core.common.interfaces.IStatusDisplayer;
import gama.core.kernel.experiment.IExperimentAgent;
import gama.core.runtime.IScope;
import gama.core.runtime.server.GamaServerMessage;
import gama.core.runtime.server.GamaServerMessager;
import gama.core.util.GamaColor;

public final class GamaServerStatusDisplayer
extends GamaServerMessager
implements IStatusDisplayer {
    @Override
    public boolean canSendMessage(IExperimentAgent iExperimentAgent) {
        if (iExperimentAgent == null) {
            return false;
        }
        IScope iScope = iExperimentAgent.getScope();
        return iScope != null && iScope.getServerConfiguration().status();
    }

    @Override
    public void informStatus(IScope iScope, String string) {
        if (!this.canSendMessage(iScope.getExperiment())) {
            return;
        }
        this.sendMessage(iScope.getExperiment(), "{\"message\": \"" + string + "\"}", GamaServerMessage.Type.SimulationStatusInform);
    }

    @Override
    public void errorStatus(IScope iScope, Exception exception) {
        if (!this.canSendMessage(iScope.getExperiment())) {
            return;
        }
        this.sendMessage(iScope.getExperiment(), "{\"message\": \"" + exception.getMessage() + "\"}", GamaServerMessage.Type.SimulationStatusError);
    }

    @Override
    public void setStatus(IScope iScope, String string, GamaColor gamaColor) {
        if (!this.canSendMessage(iScope.getExperiment())) {
            return;
        }
        this.sendMessage(iScope.getExperiment(), this.json.object("message", string, "color", gamaColor).toString(), GamaServerMessage.Type.SimulationStatus);
    }

    @Override
    public void informStatus(IScope iScope, String string, String string2) {
        if (!this.canSendMessage(iScope.getExperiment())) {
            return;
        }
        this.sendMessage(iScope.getExperiment(), this.json.object("message", string, "icon", string2).toString(), GamaServerMessage.Type.SimulationStatusInform);
    }

    @Override
    public void setStatus(IScope iScope, String string, String string2) {
        if (!this.canSendMessage(iScope.getExperiment())) {
            return;
        }
        this.sendMessage(iScope.getExperiment(), this.json.object("message", string, "icon", string2).toString(), GamaServerMessage.Type.SimulationStatus);
    }

    @Override
    public void neutralStatus(IScope iScope, String string) {
        if (!this.canSendMessage(iScope.getExperiment())) {
            return;
        }
        this.sendMessage(iScope.getExperiment(), this.json.object("message", string).toString(), GamaServerMessage.Type.SimulationStatusNeutral);
    }
}

