/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.file.json;

import gama.core.runtime.IScope;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.core.util.file.json.IJsonConstants;
import gama.core.util.file.json.Json;
import gama.core.util.file.json.JsonValue;
import gama.core.util.file.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class JsonArray
extends JsonValue
implements Iterable<JsonValue>,
IJsonConstants {
    private final List<JsonValue> values;
    private final Json json;

    JsonArray(Json json) {
        this.json = json;
        this.values = new ArrayList<JsonValue>();
    }

    public JsonArray add(int n) {
        this.values.add(this.json.valueOf(n));
        return this;
    }

    public JsonArray add(long l) {
        this.values.add(this.json.valueOf(l));
        return this;
    }

    public JsonArray add(float f) {
        this.values.add(this.json.valueOf(f));
        return this;
    }

    public JsonArray add(double d) {
        this.values.add(this.json.valueOf(d));
        return this;
    }

    public JsonArray add(boolean bl) {
        this.values.add(this.json.valueOf(bl));
        return this;
    }

    public JsonArray add(String string) {
        this.values.add(this.json.valueOf(string));
        return this;
    }

    public JsonArray add(JsonValue jsonValue) {
        if (jsonValue == null) {
            throw new NullPointerException("value is null");
        }
        this.values.add(jsonValue);
        return this;
    }

    public JsonArray add(Object object) {
        this.values.add(this.json.valueOf(object));
        return this;
    }

    public JsonArray set(int n, int n2) {
        this.values.set(n, this.json.valueOf(n2));
        return this;
    }

    public JsonArray set(int n, long l) {
        this.values.set(n, this.json.valueOf(l));
        return this;
    }

    public JsonArray set(int n, float f) {
        this.values.set(n, this.json.valueOf(f));
        return this;
    }

    public JsonArray set(int n, double d) {
        this.values.set(n, this.json.valueOf(d));
        return this;
    }

    public JsonArray set(int n, boolean bl) {
        this.values.set(n, this.json.valueOf(bl));
        return this;
    }

    public JsonArray set(int n, String string) {
        this.values.set(n, this.json.valueOf(string));
        return this;
    }

    public JsonArray set(int n, JsonValue jsonValue) {
        if (jsonValue == null) {
            throw new NullPointerException("value is null");
        }
        this.values.set(n, jsonValue);
        return this;
    }

    public JsonArray remove(int n) {
        this.values.remove(n);
        return this;
    }

    public int size() {
        return this.values.size();
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public JsonValue get(int n) {
        return this.values.get(n);
    }

    public List<JsonValue> values() {
        return Collections.unmodifiableList(this.values);
    }

    @Override
    public Iterator<JsonValue> iterator() {
        final Iterator<JsonValue> iterator = this.values.iterator();
        return new Iterator<JsonValue>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public JsonValue next() {
                return (JsonValue)iterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    void write(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeArrayOpen();
        Iterator<JsonValue> iterator = this.iterator();
        if (iterator.hasNext()) {
            iterator.next().write(jsonWriter);
            while (iterator.hasNext()) {
                jsonWriter.writeArraySeparator();
                iterator.next().write(jsonWriter);
            }
        }
        jsonWriter.writeArrayClose();
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public JsonArray asArray() {
        return this;
    }

    @Override
    public int hashCode() {
        return this.values.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        JsonArray jsonArray = (JsonArray)object;
        return this.values.equals(jsonArray.values);
    }

    @Override
    public IList toGamlValue(IScope iScope) {
        IList iList = GamaListFactory.create();
        for (JsonValue jsonValue : this.values) {
            iList.add(jsonValue.toGamlValue(iScope));
        }
        return iList;
    }
}

