/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.factories;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import gama.core.common.preferences.GamaPreferences;
import gama.dev.DEBUG;
import gama.gaml.compilation.GamlCompilationError;
import gama.gaml.compilation.IAgentConstructor;
import gama.gaml.compilation.ast.ISyntacticElement;
import gama.gaml.compilation.ast.SyntacticFactory;
import gama.gaml.compilation.ast.SyntacticModelElement;
import gama.gaml.compilation.ast.SyntacticSpeciesElement;
import gama.gaml.compilation.kernel.GamaMetaModel;
import gama.gaml.descriptions.ConstantExpressionDescription;
import gama.gaml.descriptions.ExperimentDescription;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.ModelDescription;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.descriptions.SymbolDescription;
import gama.gaml.descriptions.SymbolProto;
import gama.gaml.descriptions.ValidationContext;
import gama.gaml.factories.DescriptionFactory;
import gama.gaml.factories.SymbolFactory;
import gama.gaml.statements.Facets;
import gama.gaml.types.Types;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.jgrapht.graph.DirectedAcyclicGraph;

public class ModelFactory
extends SymbolFactory {
    static {
        DEBUG.ON();
    }

    public static ModelDescription createRootModel(String string, Class clazz, SpeciesDescription speciesDescription, SpeciesDescription speciesDescription2, IAgentConstructor iAgentConstructor, Set<String> set, String string2) {
        if ("model".equals(string)) {
            ModelDescription.ROOT = new ModelDescription(string, clazz, "", "", null, speciesDescription, speciesDescription2, null, null, ValidationContext.NULL, Collections.EMPTY_SET, iAgentConstructor);
            return ModelDescription.ROOT;
        }
        ModelDescription modelDescription = new ModelDescription(string, clazz, "", "", null, null, ModelDescription.ROOT, null, null, ValidationContext.NULL, Collections.EMPTY_SET, iAgentConstructor, set);
        ModelDescription.BUILT_IN_MODELS.put(string, modelDescription);
        return modelDescription;
    }

    @Override
    protected IDescription buildDescription(String string, Facets facets2, EObject eObject, Iterable<IDescription> iterable, IDescription iDescription, SymbolProto symbolProto) {
        return null;
    }

    public ModelDescription createModelDescription(String string2, String string3, Iterable<ISyntacticElement> iterable, ValidationContext validationContext, Map<String, ModelDescription> map) {
        LinkedHashMap<String, ISyntacticElement> linkedHashMap = new LinkedHashMap<String, ISyntacticElement>();
        LinkedHashMap<String, ISyntacticElement> linkedHashMap2 = new LinkedHashMap<String, ISyntacticElement>();
        LinkedHashMap<String, SpeciesDescription> linkedHashMap3 = new LinkedHashMap<String, SpeciesDescription>();
        ISyntacticElement iSyntacticElement = (ISyntacticElement)Iterables.get(iterable, (int)0);
        if (!this.applyPragmas(validationContext, iSyntacticElement)) {
            return null;
        }
        Facets facets2 = null;
        ISyntacticElement iSyntacticElement2 = SyntacticFactory.create("global", null, true, new Object[0]);
        int n = Iterables.size(iterable);
        while (n-- > 0) {
            facets2 = this.extractAndAssembleElementsOf(validationContext, facets2, (ISyntacticElement)Iterables.get(iterable, (int)n), iSyntacticElement2, linkedHashMap, linkedHashMap2);
        }
        String string4 = this.buildModelName(iSyntacticElement.getName());
        Set<String> set = this.buildWorkingPaths(map, iterable);
        ModelDescription modelDescription = this.buildPrimaryModel(string2, string3, validationContext, iterable, iSyntacticElement, facets2, string4, set);
        if (map != null) {
            modelDescription.addChildren(map.values());
        }
        this.addSpeciesAndExperiments(modelDescription, linkedHashMap, linkedHashMap2, linkedHashMap3);
        this.parentSpeciesAndExperiments(modelDescription, linkedHashMap, linkedHashMap2, linkedHashMap3);
        modelDescription.buildTypes();
        if (map != null) {
            map.forEach((string, modelDescription2) -> modelDescription.getTypesManager().alias(modelDescription2.getName(), (String)string));
        }
        this.complementSpecies(modelDescription, iSyntacticElement2);
        this.complementSpeciesAndExperiments(modelDescription, linkedHashMap, linkedHashMap2);
        modelDescription.inheritFromParent();
        for (SpeciesDescription speciesDescription : this.getSpeciesInHierarchicalOrder(modelDescription)) {
            speciesDescription.inheritFromParent();
            if (!speciesDescription.isExperiment() || speciesDescription.finalizeDescription()) continue;
            return null;
        }
        if (modelDescription.hasFacet("schedules") || modelDescription.hasFacet("frequency")) {
            this.createSchedulerSpecies(modelDescription);
        }
        if (!modelDescription.finalizeDescription()) {
            return null;
        }
        return modelDescription;
    }

    private void complementSpeciesAndExperiments(ModelDescription modelDescription, Map<String, ISyntacticElement> map, Map<String, ISyntacticElement> map2) {
        map.forEach((string, iSyntacticElement) -> this.complementSpecies(modelDescription.getMicroSpecies(iSyntacticElement.getName()), (ISyntacticElement)iSyntacticElement));
        map2.forEach((string, iSyntacticElement) -> this.complementSpecies(modelDescription.getExperiment(iSyntacticElement.getName()), (ISyntacticElement)iSyntacticElement));
    }

    private void addSpeciesAndExperiments(ModelDescription modelDescription, Map<String, ISyntacticElement> map, Map<String, ISyntacticElement> map2, Map<String, SpeciesDescription> map3) {
        map.forEach((string, iSyntacticElement) -> this.addMicroSpecies(modelDescription, (ISyntacticElement)iSyntacticElement, map3));
        map2.forEach((string, iSyntacticElement) -> this.addExperiment((String)string, modelDescription, (ISyntacticElement)iSyntacticElement, map3));
    }

    private void parentSpeciesAndExperiments(ModelDescription modelDescription, Map<String, ISyntacticElement> map, Map<String, ISyntacticElement> map2, Map<String, SpeciesDescription> map3) {
        map.forEach((string, iSyntacticElement) -> this.parentSpecies(modelDescription, (ISyntacticElement)iSyntacticElement, modelDescription, map3));
        map2.forEach((string, iSyntacticElement) -> this.parentExperiment(modelDescription, (ISyntacticElement)iSyntacticElement));
    }

    private ModelDescription buildPrimaryModel(String string, String string2, ValidationContext validationContext, Iterable<ISyntacticElement> iterable, ISyntacticElement iSyntacticElement2, Facets facets2, String string3, Set<String> set) {
        Object object;
        ModelDescription modelDescription;
        ModelDescription modelDescription2 = ModelDescription.ROOT;
        if (facets2 != null && facets2.containsKey("parent") && (modelDescription = ModelDescription.BUILT_IN_MODELS.get(object = facets2.getLabel("parent"))) != null) {
            modelDescription2 = modelDescription;
        }
        object = new ModelDescription(string3, null, string, string2, iSyntacticElement2.getElement(), null, modelDescription2, null, facets2, validationContext, set, modelDescription2.getAgentConstructor());
        modelDescription = Iterables.size(iterable) == 1 ? null : ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)Iterables.skip(iterable, (int)1), iSyntacticElement -> this.buildModelName(iSyntacticElement.getName())));
        ((ModelDescription)object).setImportedModelNames((Collection<String>)((Object)modelDescription));
        return object;
    }

    private Set<String> buildWorkingPaths(Map<String, ModelDescription> map, Iterable<ISyntacticElement> iterable) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        int n = Iterables.size(iterable);
        while (n-- > 0) {
            linkedHashSet.add(((SyntacticModelElement)Iterables.get(iterable, (int)n)).getPath());
        }
        if (map != null) {
            for (ModelDescription modelDescription : map.values()) {
                linkedHashSet.addAll(modelDescription.getAlternatePaths());
            }
        }
        return linkedHashSet;
    }

    private Facets extractAndAssembleElementsOf(ValidationContext validationContext, Facets facets2, ISyntacticElement iSyntacticElement3, ISyntacticElement iSyntacticElement4, Map<String, ISyntacticElement> map, Map<String, ISyntacticElement> map2) {
        SyntacticModelElement syntacticModelElement = (SyntacticModelElement)iSyntacticElement3;
        if (syntacticModelElement != null) {
            if (syntacticModelElement.hasFacets()) {
                if (facets2 == null) {
                    facets2 = syntacticModelElement.copyFacets(null);
                } else {
                    facets2.putAll(syntacticModelElement.copyFacets(null));
                }
            }
            syntacticModelElement.visitChildren(iSyntacticElement2 -> {
                iSyntacticElement2.setFacet("**origin**", ConstantExpressionDescription.create(syntacticModelElement.getName()));
                iSyntacticElement4.addChild(iSyntacticElement2);
            });
            ISyntacticElement.SyntacticVisitor syntacticVisitor = iSyntacticElement -> this.addSpeciesNode(iSyntacticElement, validationContext, map);
            syntacticModelElement.visitSpecies(syntacticVisitor);
            syntacticModelElement.visitGrids(syntacticVisitor);
            syntacticVisitor = iSyntacticElement -> this.addExperimentNode(iSyntacticElement, syntacticModelElement.getName(), validationContext, map2);
            syntacticModelElement.visitExperiments(syntacticVisitor);
        }
        return facets2;
    }

    private boolean applyPragmas(ValidationContext validationContext, ISyntacticElement iSyntacticElement) {
        Map<String, List<String>> map = iSyntacticElement.getPragmas();
        validationContext.resetInfoAndWarning();
        if (map == null) {
            return true;
        }
        List<String> list = map.get("requires");
        if (map.containsKey("no_info")) {
            validationContext.setNoInfo();
        }
        if (map.containsKey("no_warning")) {
            validationContext.setNoWarning();
        }
        if (map.containsKey("no_experiment")) {
            validationContext.setNoExperiment();
        }
        return GamaPreferences.Experimental.REQUIRED_PLUGINS.getValue() == false || list == null || validationContext.verifyPlugins(list);
    }

    private Iterable<SpeciesDescription> getSpeciesInHierarchicalOrder(ModelDescription modelDescription) {
        DirectedAcyclicGraph directedAcyclicGraph = new DirectedAcyclicGraph(Object.class);
        IDescription.DescriptionVisitor descriptionVisitor = speciesDescription -> {
            if (speciesDescription instanceof ModelDescription) {
                return true;
            }
            SpeciesDescription speciesDescription2 = speciesDescription.getParent();
            if (speciesDescription2 == null || speciesDescription2 == speciesDescription) {
                return false;
            }
            directedAcyclicGraph.addVertex(speciesDescription);
            if (!speciesDescription2.isBuiltIn()) {
                directedAcyclicGraph.addVertex((Object)speciesDescription2);
                try {
                    directedAcyclicGraph.addEdge((Object)speciesDescription2, speciesDescription);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    speciesDescription.error("The hierarchy of " + speciesDescription.getName() + " is inconsistent.", "gaml.wrong.parent.issue");
                    return false;
                }
            }
            return true;
        };
        modelDescription.visitAllSpecies(descriptionVisitor);
        return () -> directedAcyclicGraph.iterator();
    }

    private void createSchedulerSpecies(ModelDescription modelDescription) {
        SpeciesDescription speciesDescription = (SpeciesDescription)DescriptionFactory.create("species", (IDescription)modelDescription, "name", "_internal_global_scheduler");
        speciesDescription.finalizeDescription();
        if (modelDescription.hasFacet("schedules")) {
            speciesDescription.setFacetExprDescription("schedules", modelDescription.getFacet("schedules"));
            modelDescription.removeFacets("schedules");
        }
        if (modelDescription.hasFacet("frequency")) {
            speciesDescription.setFacetExprDescription("frequency", modelDescription.getFacet("frequency"));
            modelDescription.removeFacets("frequency");
        }
        modelDescription.addChild(speciesDescription);
    }

    void addExperiment(String string, ModelDescription modelDescription, ISyntacticElement iSyntacticElement, Map<String, SpeciesDescription> map) {
        IDescription iDescription = DescriptionFactory.create(iSyntacticElement, (IDescription)modelDescription, (Iterable<IDescription>)Collections.EMPTY_LIST);
        ExperimentDescription experimentDescription = (ExperimentDescription)iDescription;
        map.put(experimentDescription.getName(), experimentDescription);
        ((SymbolDescription)iDescription).resetOriginName();
        iDescription.setOriginName(this.buildModelName(string));
        modelDescription.addChild(iDescription);
    }

    void addExperimentNode(ISyntacticElement iSyntacticElement, String string, ValidationContext validationContext, Map<String, ISyntacticElement> map) {
        EObject eObject;
        String string2 = iSyntacticElement.getName();
        ISyntacticElement iSyntacticElement2 = map.get(string2);
        if (iSyntacticElement2 != null && (eObject = iSyntacticElement2.getElement()) != null && eObject.eResource() != null) {
            URI uRI;
            URI uRI2 = eObject.eResource().getURI();
            if (uRI2.equals(uRI = validationContext.getURI())) {
                validationContext.add(new GamlCompilationError("Experiment " + iSyntacticElement.getName() + " is declared twice", "gaml.duplicate.definition.issue", iSyntacticElement.getElement(), GamlCompilationError.GamlCompilationErrorType.Error, new String[0]));
            } else {
                validationContext.add(new GamlCompilationError("Experiment " + string2 + " supersedes the one declared in " + uRI2.lastSegment(), "gaml.duplicate.definition.issue", iSyntacticElement.getElement(), GamlCompilationError.GamlCompilationErrorType.Info, new String[0]));
            }
        }
        map.put(string2, iSyntacticElement);
    }

    void addMicroSpecies(SpeciesDescription speciesDescription, ISyntacticElement iSyntacticElement2, Map<String, SpeciesDescription> map) {
        SpeciesDescription speciesDescription2 = (SpeciesDescription)DescriptionFactory.create(iSyntacticElement2, (IDescription)speciesDescription, (Iterable<IDescription>)Collections.EMPTY_LIST);
        map.put(speciesDescription2.getName(), speciesDescription2);
        speciesDescription.addChild(speciesDescription2);
        ISyntacticElement.SyntacticVisitor syntacticVisitor = iSyntacticElement -> this.addMicroSpecies(speciesDescription2, iSyntacticElement, map);
        iSyntacticElement2.visitSpecies(syntacticVisitor);
        iSyntacticElement2.visitExperiments(syntacticVisitor);
    }

    void addSpeciesNode(ISyntacticElement iSyntacticElement, ValidationContext validationContext, Map<String, ISyntacticElement> map) {
        if (!(iSyntacticElement instanceof SyntacticSpeciesElement)) {
            return;
        }
        SyntacticSpeciesElement syntacticSpeciesElement = (SyntacticSpeciesElement)iSyntacticElement;
        String string = syntacticSpeciesElement.getName();
        ISyntacticElement iSyntacticElement2 = map.get(string);
        if (iSyntacticElement2 != null) {
            validationContext.add(new GamlCompilationError("Species " + string + " is declared twice", "gaml.duplicate.definition.issue", syntacticSpeciesElement.getElement(), GamlCompilationError.GamlCompilationErrorType.Error, new String[0]));
            validationContext.add(new GamlCompilationError("Species " + string + " is declared twice", "gaml.duplicate.definition.issue", iSyntacticElement2.getElement(), GamlCompilationError.GamlCompilationErrorType.Error, new String[0]));
        }
        map.put(string, syntacticSpeciesElement);
    }

    void complementSpecies(SpeciesDescription speciesDescription, ISyntacticElement iSyntacticElement2) {
        if (speciesDescription == null) {
            return;
        }
        speciesDescription.copyJavaAdditions();
        iSyntacticElement2.visitChildren(iSyntacticElement -> {
            IDescription iDescription = DescriptionFactory.create(iSyntacticElement, (IDescription)speciesDescription, null);
            if (iDescription != null) {
                speciesDescription.addChild(iDescription);
            }
        });
        iSyntacticElement2.visitSpecies(iSyntacticElement -> {
            SpeciesDescription speciesDescription2 = speciesDescription.getMicroSpecies(iSyntacticElement.getName());
            if (speciesDescription2 != null) {
                this.complementSpecies(speciesDescription2, iSyntacticElement);
            }
        });
    }

    void parentExperiment(ModelDescription modelDescription, ISyntacticElement iSyntacticElement) {
        ExperimentDescription experimentDescription = modelDescription.getExperiment(iSyntacticElement.getName());
        if (experimentDescription == null) {
            return;
        }
        String string = experimentDescription.getLitteral("parent");
        SpeciesDescription speciesDescription = modelDescription.getExperiment(string);
        if (speciesDescription == null) {
            speciesDescription = GamaMetaModel.getExperimentDescription();
        }
        experimentDescription.setParent(speciesDescription);
    }

    void parentSpecies(SpeciesDescription speciesDescription, ISyntacticElement iSyntacticElement2, ModelDescription modelDescription, Map<String, SpeciesDescription> map) {
        SpeciesDescription speciesDescription2;
        SpeciesDescription speciesDescription3 = map.get(iSyntacticElement2.getName());
        if (speciesDescription3 == null || speciesDescription3.isExperiment()) {
            return;
        }
        String string = speciesDescription3.getLitteral("parent");
        if (string == null) {
            string = "agent";
        }
        if ((speciesDescription2 = this.lookupSpecies(string, map)) == null) {
            speciesDescription2 = modelDescription.getSpeciesDescription(string);
        }
        speciesDescription3.setParent(speciesDescription2);
        iSyntacticElement2.visitSpecies(iSyntacticElement -> this.parentSpecies(speciesDescription3, iSyntacticElement, modelDescription, map));
    }

    SpeciesDescription lookupSpecies(String string, Map<String, SpeciesDescription> map) {
        SpeciesDescription speciesDescription = map.get(string);
        if (speciesDescription == null) {
            speciesDescription = Types.getBuiltInSpecies().get(string);
        }
        return speciesDescription;
    }

    protected String buildModelName(String string) {
        return string.replace(' ', '_') + "_model";
    }
}

