/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.compilation.IDescriptionValidator;
import gama.gaml.compilation.annotations.serializer;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.StatementDescription;
import gama.gaml.descriptions.StatementWithChildrenDescription;
import gama.gaml.descriptions.SymbolDescription;
import gama.gaml.descriptions.SymbolProto;
import gama.gaml.descriptions.SymbolSerializer;
import gama.gaml.statements.AbstractStatement;

@GamlAnnotations.inside(kinds={11})
@GamlAnnotations.doc(value="`break` allows to interrupt the current sequence of statements.")
@validator(value=BreakValidator.class)
@serializer(value=BreakSerializer.class)
public class BreakStatement
extends AbstractStatement {
    public BreakStatement(IDescription iDescription) {
        super(iDescription);
    }

    @Override
    protected Object privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        iScope.setBreakStatus();
        return null;
    }

    public static class BreakSerializer
    extends SymbolSerializer<StatementDescription> {
        @Override
        protected void serialize(SymbolDescription symbolDescription, StringBuilder stringBuilder, boolean bl) {
            stringBuilder.append("break").append(";");
        }
    }

    public static class BreakValidator
    implements IDescriptionValidator<StatementDescription> {
        @Override
        public void validate(StatementDescription statementDescription) {
            IDescription iDescription = statementDescription.getEnclosingDescription();
            while (iDescription instanceof StatementWithChildrenDescription) {
                if (((StatementWithChildrenDescription)iDescription).isBreakable()) {
                    return;
                }
                iDescription = iDescription.getEnclosingDescription();
            }
            statementDescription.error("'break' must be used in the context of " + String.valueOf(SymbolProto.BREAKABLE_STATEMENTS), "gaml.wrong.context.issue");
        }
    }
}

