/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.compilation.IDescriptionValidator;
import gama.gaml.compilation.annotations.serializer;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.StatementDescription;
import gama.gaml.descriptions.StatementWithChildrenDescription;
import gama.gaml.descriptions.SymbolDescription;
import gama.gaml.descriptions.SymbolProto;
import gama.gaml.descriptions.SymbolSerializer;
import gama.gaml.statements.AbstractStatement;

@GamlAnnotations.inside(kinds={11})
@GamlAnnotations.doc(value="`continue` allows to skip the remaining statements inside a loop and an ask and directly move to the next element. Inside a switch, it has the same effect as break.")
@validator(value=ContinueValidator.class)
@serializer(value=ContinueSerializer.class)
public class ContinueStatement
extends AbstractStatement {
    public ContinueStatement(IDescription iDescription) {
        super(iDescription);
    }

    @Override
    protected Object privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        iScope.setContinueStatus();
        return null;
    }

    public static class ContinueSerializer
    extends SymbolSerializer<StatementDescription> {
        @Override
        protected void serialize(SymbolDescription symbolDescription, StringBuilder stringBuilder, boolean bl) {
            stringBuilder.append("continue").append(";");
        }
    }

    public static class ContinueValidator
    implements IDescriptionValidator<StatementDescription> {
        @Override
        public void validate(StatementDescription statementDescription) {
            IDescription iDescription = statementDescription.getEnclosingDescription();
            while (iDescription instanceof StatementWithChildrenDescription) {
                if (((StatementWithChildrenDescription)iDescription).isContinuable()) {
                    return;
                }
                iDescription = iDescription.getEnclosingDescription();
            }
            statementDescription.error("'continue' must be used in the context of " + String.valueOf(SymbolProto.CONTINUABLE_STATEMENTS), "gaml.wrong.context.issue");
        }
    }
}

