/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.types;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.IContainer;
import gama.core.util.file.GamaFile;
import gama.gaml.types.GamaType;
import java.io.File;

@GamlAnnotations.type(name="bool", id=3, wraps={Boolean.class, boolean.class}, kind=104, doc={@GamlAnnotations.doc(value="Represents boolean values, either true or false")}, concept={"type", "logical", "condition"})
public class GamaBoolType
extends GamaType<Boolean> {
    @Override
    @GamlAnnotations.doc(value="Casts parameter into a bool. false if the parameter is nil, equal to zero, empty or dead, depending on its type")
    public Boolean cast(IScope iScope, Object object, Object object2, boolean bl) throws GamaRuntimeException {
        return GamaBoolType.staticCast(iScope, object, object2, bl);
    }

    public static Boolean staticCast(IScope iScope, Object object, Object object2, boolean bl) {
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof IAgent) {
            return !((IAgent)object).dead();
        }
        if (object instanceof GamaFile) {
            return ((GamaFile)object).exists(iScope);
        }
        if (object instanceof IContainer) {
            return !((IContainer)object).isEmpty(iScope);
        }
        if (object instanceof File) {
            return ((File)object).exists();
        }
        if (object instanceof Integer) {
            if ((Integer)object != 0) {
                return true;
            }
            return false;
        }
        if (object instanceof Double) {
            if ((Double)object != 0.0) {
                return true;
            }
            return false;
        }
        if (object instanceof String) {
            return "true".equals(object);
        }
        return false;
    }

    @Override
    public Boolean getDefault() {
        return false;
    }

    @Override
    public boolean canCastToConst() {
        return true;
    }
}

