/*
 * Decompiled with CFR 0.152.
 */
package gama.core.common.interfaces;

import com.google.common.primitives.Ints;
import gama.core.common.geometry.Envelope3D;
import gama.core.common.interfaces.IDisplaySurface;
import gama.core.common.interfaces.IGraphics;
import gama.core.common.interfaces.ItemList;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.outputs.layers.GridLayerData;
import gama.core.outputs.layers.ILayerData;
import gama.core.outputs.layers.ILayerStatement;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.gaml.interfaces.INamed;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.Set;

public interface ILayer
extends INamed,
Comparable<ILayer> {
    public ILayerStatement getDefinition();

    public ILayerData getData();

    default public String getMenuName() {
        return this.getType() + String.valueOf(ItemList.SEPARATION_CODE) + this.getName();
    }

    public void draw(IScope.IGraphicsScope var1, IGraphics var2) throws GamaRuntimeException;

    default public void dispose() {
    }

    default public boolean stayProportional() {
        return true;
    }

    default public void reloadOn(IDisplaySurface iDisplaySurface) {
        this.forceRedrawingOnce();
    }

    default public void firstLaunchOn(IDisplaySurface iDisplaySurface) {
    }

    default public void enableOn(IDisplaySurface iDisplaySurface) {
        this.getData().setVisible(true);
    }

    default public void disableOn(IDisplaySurface iDisplaySurface) {
        this.getData().setVisible(false);
    }

    public String getType();

    default public Rectangle2D focusOn(IShape iShape, IDisplaySurface iDisplaySurface) {
        Envelope3D envelope3D = iShape.getEnvelope();
        Point point = this.getScreenCoordinatesFrom(envelope3D.getMinX(), envelope3D.getMinY(), iDisplaySurface);
        Point point2 = this.getScreenCoordinatesFrom(envelope3D.getMaxX(), envelope3D.getMaxY(), iDisplaySurface);
        return new Rectangle2D.Double(point.x, point.y, (double)point2.x - (double)point.x, (double)point2.y - (double)point.y);
    }

    default public IList<? extends IAgent> getAgentsForMenu(IScope iScope) {
        return GamaListFactory.EMPTY_LIST;
    }

    default public boolean isProvidingCoordinates() {
        return true;
    }

    default public boolean isProvidingWorldCoordinates() {
        return true;
    }

    default public boolean containsScreenPoint(int n, int n2) {
        if (!this.getData().isVisible().booleanValue()) {
            return false;
        }
        Point point = this.getData().getPositionInPixels();
        Point point2 = this.getData().getSizeInPixels();
        return n >= point.x && n2 >= point.y && n <= point.x + point2.x && n2 <= point.y + point2.y;
    }

    default public GamaPoint getModelCoordinatesFrom(int n, int n2, IDisplaySurface iDisplaySurface) {
        return iDisplaySurface.getModelCoordinatesFrom(n, n2, this.getData().getSizeInPixels(), this.getData().getPositionInPixels());
    }

    default public Point getScreenCoordinatesFrom(double d, double d2, IDisplaySurface iDisplaySurface) {
        double d3 = d / iDisplaySurface.getEnvWidth();
        double d4 = d2 / iDisplaySurface.getEnvHeight();
        Point point = this.getData().getSizeInPixels();
        int n = (int)(d3 * (double)point.x);
        int n2 = (int)(d4 * (double)point.y);
        return new Point(n, n2);
    }

    default public void getModelCoordinatesInfo(int n, int n2, IDisplaySurface iDisplaySurface, StringBuilder stringBuilder) {
        GamaPoint gamaPoint = this.getModelCoordinatesFrom(n, n2, iDisplaySurface);
        String string = gamaPoint == null ? "N/A" : String.format("%5.2f", gamaPoint.getX());
        String string2 = gamaPoint == null ? "N/A" : String.format("%5.2f", gamaPoint.getY());
        stringBuilder.append(String.format("X%8s | Y%8s", string, string2));
    }

    default public Set<IAgent> collectAgentsAt(int n, int n2, IDisplaySurface iDisplaySurface) {
        return Collections.EMPTY_SET;
    }

    public void forceRedrawingOnce();

    default public boolean isOverlay() {
        return false;
    }

    @Override
    default public String serializeToGaml(boolean bl) {
        return this.getDefinition().serializeToGaml(bl);
    }

    @Override
    default public int compareTo(ILayer iLayer) {
        return Ints.compare((int)this.getDefinition().getOrder(), (int)iLayer.getDefinition().getOrder());
    }

    default public Boolean isControllable() {
        return true;
    }

    public static interface IGridLayer
    extends ILayer {
        @Override
        public GridLayerData getData();
    }
}

