/*
 * Decompiled with CFR 0.152.
 */
package gama.core.common.preferences;

import gama.core.common.preferences.GamaPreferences;
import gama.core.common.preferences.IPreferenceChangeListener;
import gama.core.common.util.StringUtils;
import gama.core.kernel.experiment.IParameter;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaColor;
import gama.core.util.GamaMapFactory;
import gama.core.util.IMap;
import gama.dev.COUNTER;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Pref<T>
implements IParameter {
    private final int order = COUNTER.COUNT();
    private final boolean inGaml;
    String key;
    String title;
    String tab;
    String group;
    String comment;
    boolean disabled = false;
    boolean hidden = false;
    boolean restartRequired = false;
    boolean isWorkspace = false;
    ValueProvider<T> initialProvider;
    T value;
    T initial;
    final int type;
    ValueProvider<List<T>> valuesProvider;
    Comparable min;
    Comparable max;
    Comparable step;
    boolean slider = true;
    String[] enables = EMPTY_STRINGS;
    String[] disables = EMPTY_STRINGS;
    String[] refreshes = EMPTY_STRINGS;
    String[] fileExtensions = EMPTY_STRINGS;
    Set<IPreferenceChangeListener<T>> listeners = new HashSet<IPreferenceChangeListener<T>>();

    Pref(String string, int n, boolean bl) {
        this.type = n;
        this.key = string;
        this.inGaml = bl;
    }

    public Pref<T> disabled() {
        this.disabled = true;
        return this;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public Pref<T> onChange(IPreferenceChangeListener.IPreferenceAfterChangeListener<T> iPreferenceAfterChangeListener) {
        this.addChangeListener(iPreferenceAfterChangeListener);
        return this;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public Pref<T> among(T ... TArray) {
        return this.among(Arrays.asList(TArray));
    }

    public Pref<T> among(List<T> list) {
        this.valuesProvider = () -> list;
        return this;
    }

    public Pref<T> among(ValueProvider<List<T>> valueProvider) {
        this.valuesProvider = valueProvider;
        return this;
    }

    public Pref<T> between(Comparable comparable, Comparable comparable2) {
        this.min = comparable;
        this.max = comparable2;
        return this;
    }

    public Pref<T> step(Comparable comparable) {
        this.step = comparable;
        return this;
    }

    public Pref<T> in(String string, String string2) {
        this.tab = string;
        this.group = string2;
        return this;
    }

    public Pref<T> withComment(String string) {
        this.setUnitLabel(string);
        return this;
    }

    public Pref<T> named(String string) {
        this.title = string;
        return this;
    }

    public Pref<T> init(T t) {
        this.initial = t;
        this.value = t;
        return this;
    }

    public Pref<T> init(ValueProvider<T> valueProvider) {
        this.initialProvider = valueProvider;
        return this;
    }

    public Pref<T> set(T t) {
        if (this.isValueChanged(t) && this.acceptChange(t)) {
            this.value = t;
            this.afterChange(t);
        }
        return this;
    }

    private boolean isValueChanged(T t) {
        return this.value == null ? t != null : !this.value.equals(t);
    }

    public Pref<T> activates(String ... stringArray) {
        this.enables = stringArray;
        return this;
    }

    public Pref<T> deactivates(String ... stringArray) {
        this.disables = stringArray;
        return this;
    }

    public Pref<T> refreshes(String ... stringArray) {
        this.refreshes = stringArray;
        return this;
    }

    public T getValue() {
        if (this.initialProvider != null) {
            this.init(this.initialProvider.get());
            this.initialProvider = null;
        }
        return this.value;
    }

    @Override
    public IType<?> getType() {
        return Types.get(this.type);
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public String getKey() {
        return this.key;
    }

    public List<T> getValues() {
        return this.valuesProvider == null ? null : this.valuesProvider.get();
    }

    @Override
    public String getName() {
        return this.key;
    }

    @Override
    public String getCategory() {
        return this.group;
    }

    @Override
    public String getUnitLabel(IScope iScope) {
        return this.comment;
    }

    @Override
    public void setUnitLabel(String string) {
        this.comment = string;
    }

    @Override
    public void setValue(IScope iScope, Object object) {
        this.set(object);
    }

    public Pref<T> addChangeListener(IPreferenceChangeListener<T> iPreferenceChangeListener) {
        this.listeners.add(iPreferenceChangeListener);
        return this;
    }

    public void removeChangeListener(IPreferenceChangeListener<T> iPreferenceChangeListener) {
        this.listeners.remove(iPreferenceChangeListener);
    }

    public void removeChangeListeners() {
        this.listeners.clear();
    }

    public T value(IScope iScope) throws GamaRuntimeException {
        return this.getValue();
    }

    @Override
    public String serializeToGaml(boolean bl) {
        return StringUtils.toGaml(this.value, bl);
    }

    @Override
    public Object getInitialValue(IScope iScope) {
        if (this.initialProvider != null) {
            this.init(this.initialProvider.get());
            this.initialProvider = null;
        }
        return this.initial;
    }

    @Override
    public Comparable getMinValue(IScope iScope) {
        return this.min;
    }

    @Override
    public Comparable getMaxValue(IScope iScope) {
        return this.max;
    }

    @Override
    public List getAmongValue(IScope iScope) {
        return this.valuesProvider == null ? null : this.valuesProvider.get();
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public boolean isDefined() {
        return true;
    }

    @Override
    public void setDefined(boolean bl) {
    }

    @Override
    public Comparable getStepValue(IScope iScope) {
        return this.step;
    }

    public boolean acceptChange(T t) {
        for (IPreferenceChangeListener<T> iPreferenceChangeListener : this.listeners) {
            if (iPreferenceChangeListener.beforeValueChange(t)) continue;
            return false;
        }
        return true;
    }

    protected void afterChange(T t) {
        this.initialProvider = null;
        for (IPreferenceChangeListener<T> iPreferenceChangeListener : this.listeners) {
            iPreferenceChangeListener.afterValueChange(t);
        }
    }

    @Override
    public String[] getEnablement() {
        return this.enables;
    }

    @Override
    public String[] getDisablement() {
        return this.disables;
    }

    @Override
    public String[] getRefreshment() {
        return this.refreshes;
    }

    @Override
    public String[] getFileExtensions() {
        return this.fileExtensions;
    }

    public void save() {
        IMap iMap = GamaMapFactory.createUnordered();
        iMap.put(this.getName(), this.getValue());
        GamaPreferences.setNewPreferences(iMap);
    }

    @Override
    public boolean acceptsSlider(IScope iScope) {
        return this.slider;
    }

    public Pref<T> hidden() {
        this.hidden = true;
        return this;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public Pref<T> restartRequired() {
        this.restartRequired = true;
        return this;
    }

    public boolean isRestartRequired() {
        return this.restartRequired;
    }

    public boolean inGaml() {
        return this.inGaml;
    }

    @Override
    public List<GamaColor> getColors(IScope iScope) {
        return null;
    }

    @Override
    public GamaColor getColor(IScope iScope) {
        return null;
    }

    @Override
    public boolean isDefinedInExperiment() {
        return false;
    }

    @Override
    public boolean isWorkspace() {
        return this.isWorkspace;
    }

    public Pref<T> restrictToWorkspace() {
        this.isWorkspace = true;
        return this;
    }

    public Pref<T> withExtensions(String ... stringArray) {
        this.fileExtensions = stringArray;
        return this;
    }

    @Override
    public void setValueNoCheckNoNotification(Object object) {
        this.value = object;
    }

    @FunctionalInterface
    public static interface ValueProvider<T> {
        public T get();
    }
}

