/*
 * Decompiled with CFR 0.152.
 */
package gama.core.kernel.batch.exploration.betadistribution;

import gama.core.kernel.experiment.IParameter;
import gama.core.kernel.experiment.ParametersSet;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.IMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;

public final class Betadistribution {
    public static final int DEFAULT_BOOTSTRAP = 4;
    double objMin = Double.MAX_VALUE;
    double objMax = Double.MIN_VALUE;
    double[] empiricalCDFGranularity;
    List<IParameter.Batch> parameters;
    Map<ParametersSet, List<Double>> sample = new HashMap<ParametersSet, List<Double>>();
    final EmpiricalDistribution Y;

    public Betadistribution(IMap<ParametersSet, List<Object>> iMap, List<IParameter.Batch> list) {
        this(iMap, list, 100);
    }

    public Betadistribution(IMap<ParametersSet, List<Object>> iMap, List<IParameter.Batch> list, int n) {
        for (Map.Entry entry : iMap.entrySet()) {
            this.sample.put((ParametersSet)entry.getKey(), ((List)entry.getValue()).stream().mapToDouble(object -> Double.parseDouble(object.toString())).boxed().toList());
            double d = (Double)Collections.min((Collection)this.sample.get(entry.getKey()));
            double d2 = (Double)Collections.max((Collection)this.sample.get(entry.getKey()));
            if (d < this.objMin) {
                this.objMin = d;
            }
            if (!(d2 > this.objMax)) continue;
            this.objMax = d2;
        }
        this.parameters = list;
        this.empiricalCDFGranularity = this.granularity(n, this.objMin, this.objMax);
        this.Y = this.get_empirical_distribution(this.sample.values().stream().flatMap(Collection::stream).toList());
    }

    public Map<IParameter.Batch, Double> evaluate() {
        HashMap<IParameter.Batch, Double> hashMap = new HashMap<IParameter.Batch, Double>();
        for (IParameter.Batch batch : this.parameters) {
            HashMap hashMap2 = new HashMap();
            for (ParametersSet parametersSet : this.sample.keySet()) {
                Iterator iterator = parametersSet.get(batch.getName());
                if (!hashMap2.containsKey(iterator)) {
                    hashMap2.put(iterator, new ArrayList());
                }
                ((List)hashMap2.get(iterator)).addAll((Collection)this.sample.get(parametersSet));
            }
            ArrayList<Double> cloneable2 = new ArrayList<Double>();
            for (Object object : hashMap2.values()) {
                EmpiricalDistribution empiricalDistribution = this.get_empirical_distribution((List<Double>)object);
                List<Double> list = IntStream.range(0, this.Y.length()).mapToDouble(n -> empiricalDistribution.cdf(n) - this.Y.cdf(n)).boxed().toList();
                cloneable2.add(Collections.max(list) + Math.abs(Collections.min(list)));
            }
            hashMap.put(batch, cloneable2.stream().mapToDouble(Double::doubleValue).average().getAsDouble());
        }
        return hashMap;
    }

    EmpiricalDistribution get_empirical_distribution(List<Double> list) {
        double[] dArray = new double[this.empiricalCDFGranularity.length + 1];
        int n = 0;
        while (n < dArray.length) {
            int n2 = n;
            dArray[n] = n == 0 ? (double)list.stream().filter(d -> d < this.empiricalCDFGranularity[n2]).count() * 1.0 / (double)list.size() : (n == dArray.length - 1 ? (double)list.stream().filter(d -> d >= this.empiricalCDFGranularity[n2 - 1]).count() * 1.0 / (double)list.size() : (double)list.stream().filter(d -> d >= this.empiricalCDFGranularity[n2 - 1] && d < this.empiricalCDFGranularity[n2]).count() * 1.0 / (double)list.size());
            ++n;
        }
        return new EmpiricalDistribution(dArray);
    }

    private double[] granularity(int n, double d, double d2) {
        double[] dArray = new double[n - 1];
        double d3 = (d2 - d) / (double)n;
        dArray[0] = d + d3;
        int n2 = 1;
        while (n2 < n - 1) {
            dArray[n2] = dArray[n2 - 1] + d3;
            ++n2;
        }
        if (Math.ulp(dArray[n - 2] + d3) > Math.ulp(d2)) {
            throw GamaRuntimeException.error("The bins does not fit max val: " + (dArray[n - 2] + d3) + " is not the maximum expected value " + d2 + " (diff = " + Math.abs(dArray[n - 2] + d3 - d2) + ")", null);
        }
        return dArray;
    }

    public class EmpiricalDistribution {
        double[] p;
        private final double[] cdf;

        public EmpiricalDistribution(double[] dArray) {
            this.p = new double[dArray.length];
            this.cdf = new double[dArray.length];
            this.cdf[0] = dArray[0];
            int n = 0;
            while (n < dArray.length) {
                if (dArray[n] < 0.0 || dArray[n] > 1.0) {
                    throw new IllegalArgumentException("Invalid probability " + this.p[n]);
                }
                this.p[n] = dArray[n];
                if (n > 0) {
                    this.cdf[n] = this.cdf[n - 1] + this.p[n];
                }
                ++n;
            }
            if (Math.abs(this.cdf[this.cdf.length - 1] - 1.0) > (double)(dArray.length - 1) * 0.5 * (double)Math.ulp(0.5f)) {
                throw new IllegalArgumentException("The sum of probabilities is not exactly 1: " + this.cdf[this.cdf.length - 1]);
            }
        }

        public int length() {
            return this.p.length;
        }

        public double cdf(int n) {
            return this.cdf[n];
        }
    }
}

