/*
 * Decompiled with CFR 0.152.
 */
package gama.core.metamodel.shape;

import gama.core.common.geometry.AxisAngle;
import gama.core.common.geometry.Envelope3D;
import gama.core.common.geometry.GeometryUtils;
import gama.core.common.geometry.ICoordinates;
import gama.core.common.geometry.Scaling3D;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.GamaShapeFactory;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.IScope;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMapFactory;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.gaml.operators.Maths;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;

public class GamaShape
implements IShape {
    protected Geometry geometry;
    private IAgent agent;
    protected IMap<String, Object> attributes;

    @Deprecated
    public GamaShape(Geometry geometry) {
        this.setInnerGeometry(geometry);
    }

    @Deprecated
    public GamaShape(Envelope3D envelope3D) {
        this((Geometry)(envelope3D == null ? null : envelope3D.toGeometry()));
    }

    @Deprecated
    public GamaShape(IShape iShape) {
        this(iShape, null);
    }

    @Deprecated
    public GamaShape(IShape iShape, Geometry geometry) {
        this(geometry == null ? iShape.getInnerGeometry().copy() : geometry);
        this.withAttributesOf(iShape);
    }

    public GamaShape withAttributesOf(IShape iShape) {
        if (iShape == null) {
            return this;
        }
        this.copyShapeAttributesFrom(iShape);
        iShape.forEachAttribute((string, object) -> {
            if (object != iShape) {
                this.setAttribute((String)string, object);
            }
            return true;
        });
        return this;
    }

    public GamaShape withScaling(Double d) {
        if (d != null && !this.isPoint()) {
            GamaPoint gamaPoint = this.getLocation();
            this.geometry.apply((CoordinateFilter)Scaling3D.of(d));
            this.setLocation(gamaPoint);
            if (this.is3D()) {
                this.setDepth(this.getDepth() * d);
            }
        }
        return this;
    }

    public GamaShape withScaling(Scaling3D scaling3D, boolean bl) {
        if (scaling3D != null && !this.isPoint()) {
            Envelope3D envelope3D = this.getEnvelope();
            GamaPoint gamaPoint = this.getLocation();
            if (bl) {
                this.geometry.apply((CoordinateFilter)scaling3D.asBoundingBoxIn(envelope3D));
            } else {
                this.geometry.apply((CoordinateFilter)scaling3D);
            }
            this.setLocation(gamaPoint);
            if (this.is3D()) {
                this.setDepth(bl ? scaling3D.getZ() : this.getDepth() * scaling3D.getZ());
            }
        }
        return this;
    }

    public GamaShape withLocation(GamaPoint gamaPoint) {
        if (gamaPoint != null) {
            this.setLocation(gamaPoint);
        }
        return this;
    }

    public GamaShape withRotation(AxisAngle axisAngle) {
        if (!this.isPoint() && axisAngle != null) {
            Double d = null;
            if (this.is3D()) {
                d = GeometryUtils.getContourCoordinates((Geometry)this.geometry).getNormal((boolean)true).z;
            }
            GeometryUtils.rotate(this.geometry, this.getLocation(), axisAngle);
            if (d != null) {
                Double d2 = GeometryUtils.getContourCoordinates((Geometry)this.geometry).getNormal((boolean)true).z;
                if (d > 0.0 && d2 < 0.0) {
                    this.setDepth(-this.getDepth().doubleValue());
                }
            }
        }
        return this;
    }

    @Override
    public boolean isMultiple() {
        return this.getInnerGeometry() instanceof GeometryCollection;
    }

    public boolean is3D() {
        return this.getDepth() != null;
    }

    public IList<GamaShape> getGeometries() {
        IList<GamaShape> iList = GamaListFactory.create(Types.GEOMETRY);
        if (this.isMultiple()) {
            int n = 0;
            int n2 = this.getInnerGeometry().getNumGeometries();
            while (n < n2) {
                iList.add(GamaShapeFactory.createFrom(this.getInnerGeometry().getGeometryN(n)));
                ++n;
            }
        } else {
            iList.add(this);
        }
        return iList;
    }

    @Override
    public boolean isPoint() {
        if (this.geometry == null) {
            return false;
        }
        return this.geometry.getNumPoints() == 1;
    }

    @Override
    public boolean isLine() {
        return this.getInnerGeometry() instanceof LineString || this.getInnerGeometry() instanceof MultiLineString;
    }

    @Override
    public String stringValue(IScope iScope) {
        if (this.geometry == null) {
            return "";
        }
        return SHAPE_WRITER.write(this.geometry);
    }

    @Override
    public String serializeToGaml(boolean bl) {
        if (this.isPoint()) {
            return this.getLocation().serializeToGaml(bl) + " as geometry";
        }
        if (this.isMultiple()) {
            return this.getGeometries().serializeToGaml(bl) + " as geometry";
        }
        IList<GamaShape> iList = this.getHoles();
        StringBuilder stringBuilder = new StringBuilder();
        if (this.getInnerGeometry() instanceof LineString) {
            stringBuilder.append("polyline (");
        } else {
            stringBuilder.append("polygon (");
        }
        stringBuilder.append(this.getPoints().serializeToGaml(bl));
        stringBuilder.append(")");
        if (iList.isEmpty()) {
            return stringBuilder.toString();
        }
        for (GamaShape gamaShape : iList) {
            stringBuilder.insert(0, "(");
            stringBuilder.append(") - (");
            stringBuilder.append(gamaShape.serializeToGaml(bl));
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.getInnerGeometry().toText() + " at " + String.valueOf(this.getLocation());
    }

    @Override
    public GamaPoint getLocation() {
        if (this.isPoint()) {
            return (GamaPoint)this.geometry.getCoordinate();
        }
        return GeometryUtils.getContourCoordinates(this.geometry).getCenter();
    }

    @Override
    public GamaPoint setLocation(GamaPoint gamaPoint) {
        if (this.isPoint()) {
            this.geometry = GeometryUtils.GEOMETRY_FACTORY.createPoint(gamaPoint);
        } else {
            GeometryUtils.translate(this.geometry, this.getLocation(), gamaPoint);
        }
        return gamaPoint;
    }

    public GamaShape translatedTo(IScope iScope, GamaPoint gamaPoint) {
        GamaShape gamaShape = this.copy(iScope);
        gamaShape.setLocation(gamaPoint);
        return gamaShape;
    }

    @Override
    public GamaShape getGeometry() {
        return this;
    }

    @Override
    public Double getArea() {
        return this.getInnerGeometry().getArea();
    }

    @Override
    public Double getVolume() {
        Double d = this.getDepth();
        if (d == 0.0) {
            return 0.0;
        }
        IShape.Type type2 = this.getGeometricalType();
        return switch (type2) {
            case IShape.Type.SPHERE -> 4.1887902047863905 * Maths.pow((Double)(this.getWidth() / 2.0), (Integer)3);
            case IShape.Type.CONE -> 1.0471975511965976 * Maths.pow((Double)(this.getWidth() / 2.0), (Integer)2) * d;
            case IShape.Type.PYRAMID -> Maths.pow(this.getWidth(), (Integer)2) * d / 3.0;
            case IShape.Type.NULL, IShape.Type.THREED_FILE -> {
                Envelope3D var3_3 = this.getEnvelope();
                yield var3_3 == null ? Envelope3D.of(this.getGeometry().getInnerGeometry()).getVolume() : var3_3.getVolume();
            }
            default -> this.getArea() * d;
        };
    }

    @Override
    public double getPerimeter() {
        if (this.geometry instanceof GeometryCollection) {
            int[] nArray = new int[1];
            GeometryUtils.applyToInnerGeometries((GeometryCollection)this.geometry, geometry -> {
                int n = (int)((double)nArray[0] + GeometryUtils.getContourCoordinates(geometry).getLength());
            });
            return nArray[0];
        }
        ICoordinates iCoordinates = GeometryUtils.getContourCoordinates(this.geometry);
        return iCoordinates.getLength();
    }

    @Override
    public IList<GamaShape> getHoles() {
        IList<GamaShape> iList = GamaListFactory.create(Types.GEOMETRY);
        if (this.getInnerGeometry() instanceof Polygon) {
            Polygon polygon = (Polygon)this.getInnerGeometry();
            int n = polygon.getNumInteriorRing();
            int n2 = 0;
            while (n2 < n) {
                iList.add(GamaShapeFactory.createFrom((Geometry)GeometryUtils.GEOMETRY_FACTORY.createPolygon(polygon.getInteriorRingN(n2).getCoordinates())));
                ++n2;
            }
        }
        return iList;
    }

    @Override
    public GamaPoint getCentroid() {
        if (this.geometry == null) {
            return null;
        }
        if (this.isPoint()) {
            return this.getLocation();
        }
        Coordinate coordinate = this.geometry.getCentroid().getCoordinate();
        coordinate.z = this.computeAverageZOrdinate();
        return (GamaPoint)coordinate;
    }

    @Override
    public GamaShape getExteriorRing(IScope iScope) {
        Geometry geometry = this.getInnerGeometry();
        if (geometry instanceof Polygon) {
            geometry = ((Polygon)geometry).getExteriorRing();
        } else if (geometry instanceof MultiPolygon) {
            MultiPolygon multiPolygon = (MultiPolygon)geometry;
            LineString[] lineStringArray = new LineString[multiPolygon.getNumGeometries()];
            int n = 0;
            while (n < multiPolygon.getNumGeometries()) {
                lineStringArray[n] = ((Polygon)multiPolygon.getGeometryN(n)).getExteriorRing();
                ++n;
            }
            geometry = GeometryUtils.GEOMETRY_FACTORY.createMultiLineString(lineStringArray);
        }
        return GamaShapeFactory.createFrom(geometry);
    }

    private ShapeData getData(boolean bl) {
        Geometry geometry = this.getInnerGeometry();
        if (geometry == null) {
            return null;
        }
        Object object = geometry.getUserData();
        if (object == null) {
            if (!bl) {
                return null;
            }
            object = new ShapeData();
            geometry.setUserData(object);
        }
        return (ShapeData)object;
    }

    @Override
    public Double getDepth() {
        ShapeData shapeData = this.getData(false);
        return shapeData == null ? null : shapeData.depth;
    }

    @Override
    public void setDepth(double d) {
        ShapeData shapeData = this.getData(true);
        if (shapeData != null) {
            shapeData.depth = d;
        }
    }

    @Override
    public IList<GamaPoint> getPoints() {
        if (this.getInnerGeometry() == null) {
            return GamaListFactory.create(Types.POINT);
        }
        return GamaListFactory.wrap((IType)Types.POINT, GeometryUtils.getPointsOf(this.getInnerGeometry()));
    }

    @Override
    public Envelope3D getEnvelope() {
        if (this.geometry == null) {
            return null;
        }
        return Envelope3D.of(this);
    }

    @Override
    public IAgent getAgent() {
        return this.agent;
    }

    @Override
    public void setAgent(IAgent iAgent) {
        this.agent = iAgent;
    }

    @Override
    public void setInnerGeometry(Geometry geometry) {
        if (geometry == null) {
            this.geometry = null;
            return;
        }
        if (geometry.isEmpty()) {
            return;
        }
        this.geometry = geometry instanceof GeometryCollection && geometry.getNumGeometries() == 1 ? geometry.getGeometryN(0) : geometry;
    }

    @Override
    public void setGeometry(IShape iShape) {
        if (iShape == null || iShape == this) {
            return;
        }
        this.setInnerGeometry(iShape.getInnerGeometry());
        this.withAttributesOf(iShape);
    }

    private double computeAverageZOrdinate() {
        Coordinate[] coordinateArray;
        double d = 0.0;
        Coordinate[] coordinateArray2 = coordinateArray = this.geometry.getCoordinates();
        int n = coordinateArray.length;
        int n2 = 0;
        while (n2 < n) {
            Coordinate coordinate = coordinateArray2[n2];
            if (!Double.isNaN(coordinate.z)) {
                d += coordinate.z;
            }
            ++n2;
        }
        return d / (double)coordinateArray.length;
    }

    @Override
    public void dispose() {
        this.agent = null;
        if (this.attributes != null) {
            this.attributes.clear();
            this.attributes = null;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof GamaShape) {
            GamaShape gamaShape = (GamaShape)object;
            Geometry geometry = gamaShape.geometry;
            if (geometry == null) {
                return this.geometry == null;
            }
            if (this.geometry == null) {
                return false;
            }
            return this.geometry.equalsExact(geometry);
        }
        return false;
    }

    public int hashCode() {
        if (this.geometry == null) {
            return 0;
        }
        return this.geometry.hashCode();
    }

    @Override
    public Geometry getInnerGeometry() {
        return this.geometry;
    }

    @Override
    public GamaShape copy(IScope iScope) {
        return GamaShapeFactory.createFrom(this.geometry.copy());
    }

    @Override
    public boolean covers(IShape iShape) {
        return GeometryUtils.robustCovers(this, iShape);
    }

    @Override
    public double euclidianDistanceTo(IShape iShape) {
        if (this.isPoint() && iShape.isPoint()) {
            return iShape.getLocation().euclidianDistanceTo(this.getLocation());
        }
        return this.getInnerGeometry().distance(iShape.getInnerGeometry());
    }

    @Override
    public double euclidianDistanceTo(GamaPoint gamaPoint) {
        if (this.isPoint()) {
            return gamaPoint.euclidianDistanceTo(this.getLocation());
        }
        return this.getInnerGeometry().distance(gamaPoint.getInnerGeometry());
    }

    @Override
    public boolean intersects(IShape iShape) {
        return GeometryUtils.robustIntersects(this, iShape);
    }

    @Override
    public boolean crosses(IShape iShape) {
        return GeometryUtils.robustCrosses(this, iShape);
    }

    @Override
    public boolean partiallyOverlaps(IShape iShape) {
        return GeometryUtils.robustPartiallyOverlaps(this, iShape);
    }

    @Override
    public boolean touches(IShape iShape) {
        return GeometryUtils.robustTouches(this, iShape);
    }

    public IMap<String, Object> getAttributes(boolean bl) {
        if (this.attributes == null && bl) {
            this.attributes = GamaMapFactory.create(Types.STRING, Types.NO_TYPE);
        }
        return this.attributes;
    }

    @Override
    public IShape.Type getGeometricalType() {
        ShapeData shapeData = this.getData(false);
        if (shapeData != null && shapeData.type != null) {
            return shapeData.type;
        }
        String string = this.getInnerGeometry().getGeometryType();
        IShape.Type type2 = (IShape.Type)((Object)JTS_TYPES.get(string));
        if (type2 == null) {
            type2 = IShape.Type.NULL;
        }
        if (shapeData != null) {
            shapeData.type = type2;
        }
        return type2;
    }

    public void losePredefinedProperty() {
        if (THREED_TYPES.contains((Object)this.getGeometricalType())) {
            this.setGeometricalType(IShape.Type.POLYHEDRON);
        }
    }

    @Override
    public void setGeometricalType(IShape.Type type2) {
        ShapeData shapeData = this.getData(true);
        if (shapeData != null) {
            shapeData.type = type2;
        }
    }

    public IType getGamlType() {
        return Types.GEOMETRY;
    }

    public static class ShapeData {
        private Double depth;
        private IShape.Type type;
    }
}

