/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.interfaces.IGamaView;
import gama.core.kernel.experiment.ExperimentAgent;
import gama.core.outputs.IOutput;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.compilation.ISymbol;
import gama.gaml.compilation.Symbol;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.ModelDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.expressions.IExpressionFactory;
import gama.gaml.operators.Cast;
import java.util.Collections;
import java.util.List;

@GamlAnnotations.inside(symbols={"output"})
public abstract class AbstractOutput
extends Symbol
implements IOutput {
    private IScope outputScope;
    volatile boolean paused;
    volatile boolean open;
    volatile boolean permanent;
    volatile boolean disposed = false;
    private boolean isUserCreated = true;
    final IExpression refresh;
    final String originalName;
    final boolean virtual;
    protected IGamaView view;
    final Runnable opener = () -> {
        this.view = this.getScope().getGui().showView(this.getScope(), this.getViewId(), this.isUnique() ? null : this.getName(), 1);
        if (this.view == null) {
            return;
        }
        this.view.addOutput(this);
    };

    public AbstractOutput(IDescription iDescription) {
        super(iDescription);
        this.virtual = "true".equals(this.getLiteral("virtual", null));
        this.refresh = this.hasFacet("refresh") ? this.getFacet("refresh") : IExpressionFactory.TRUE_EXPR;
        if (iDescription != null) {
            this.name = iDescription.getName();
        }
        this.originalName = this.name;
        if (this.name != null) {
            this.name = this.name.replace(':', '_').replace('/', '_').replace('\\', '_');
            if (this.name.length() == 0) {
                this.name = "output";
            }
        }
    }

    @Override
    public String getOriginalName() {
        return this.originalName;
    }

    final boolean isUserCreated() {
        return this.isUserCreated;
    }

    @Override
    public final void setUserCreated(boolean bl) {
        this.isUserCreated = bl;
    }

    @Override
    public boolean init(IScope iScope) {
        this.setScope(this.buildScopeFrom(iScope));
        return true;
    }

    @Override
    public void update() throws GamaRuntimeException {
        if (this.view != null) {
            this.view.update(this);
        }
    }

    protected IScope buildScopeFrom(IScope iScope) {
        String string = this.description == null ? " " : this.description.getKeyword() + " ";
        return iScope.copy("of " + string + this.getName());
    }

    @Override
    public void close() {
        this.setPaused(true);
        this.setOpen(false);
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public void open() {
        this.setOpen(true);
        if (this.shouldOpenView()) {
            GAMA.getGui().run("Opening " + this.getName(), this.opener, false);
        }
    }

    @Override
    public boolean isRefreshable() {
        if (!this.isOpen() || this.isPaused()) {
            return false;
        }
        IScope iScope = this.getScope();
        if (iScope == null || iScope.interrupted()) {
            return false;
        }
        return Cast.asBool(iScope, this.refresh.value(iScope));
    }

    @Override
    public abstract boolean step(IScope var1);

    void setOpen(boolean bl) {
        this.open = bl;
    }

    @Override
    public void setPaused(boolean bl) {
        this.paused = bl;
        if (this.view != null) {
            this.view.updateToolbarState();
        }
    }

    @Override
    public void setChildren(Iterable<? extends ISymbol> iterable) {
    }

    public List<? extends ISymbol> getChildren() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public String getId() {
        String string;
        IDescription iDescription = this.getDescription();
        String string2 = string = iDescription == null ? null : iDescription.getModelDescription().getAlias();
        if (string != null && !"".equals(string) && !this.getName().contains("#")) {
            return this.isUnique() ? this.getViewId() : this.getViewId() + this.getName() + "#" + string;
        }
        return this.isUnique() ? this.getViewId() : this.getViewId() + this.getName();
    }

    public void setScope(IScope iScope) {
        if (this.outputScope != null) {
            GAMA.releaseScope(this.outputScope);
        }
        if (iScope.getModel() != null) {
            boolean bl;
            ModelDescription modelDescription = this.getDescription().getModelDescription();
            ModelDescription modelDescription2 = iScope.getModel().getDescription();
            boolean bl2 = bl = modelDescription2.getMicroModel(modelDescription.getAlias()) != null;
            if (bl) {
                ExperimentAgent experimentAgent = (ExperimentAgent)iScope.getRoot().getExternMicroPopulationFor(modelDescription.getAlias() + "." + this.getDescription().getOriginName()).getAgent(0);
                this.outputScope = experimentAgent.getSimulation().getScope();
            } else {
                this.outputScope = iScope;
            }
        } else {
            this.outputScope = iScope;
        }
    }

    @Override
    public IScope getScope() {
        return this.outputScope;
    }

    void setPermanent() {
        this.permanent = true;
    }

    public boolean isPermanent() {
        return this.permanent;
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public boolean isVirtual() {
        return this.virtual;
    }

    protected boolean shouldOpenView() {
        return true;
    }

    @Override
    public IGamaView getView() {
        return this.view;
    }

    @Override
    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        if (this.view != null) {
            this.view.removeOutput(this);
            this.view = null;
        }
        if (this.getScope() != null) {
            GAMA.releaseScope(this.getScope());
        }
    }
}

