/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs;

import com.google.common.base.Objects;
import gama.core.common.geometry.Envelope3D;
import gama.core.common.geometry.ICoordinates;
import gama.core.common.interfaces.ITyped;
import gama.core.common.preferences.GamaPreferences;
import gama.core.common.preferences.IPreferenceChangeListener;
import gama.core.kernel.experiment.ExperimentAgent;
import gama.core.kernel.simulation.SimulationAgent;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.outputs.layers.properties.GenericCameraDefinition;
import gama.core.outputs.layers.properties.GenericLightDefinition;
import gama.core.outputs.layers.properties.ICameraDefinition;
import gama.core.outputs.layers.properties.ILightDefinition;
import gama.core.outputs.layers.properties.LightDefinition;
import gama.core.outputs.layers.properties.RotationDefinition;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaColor;
import gama.core.util.GamaListFactory;
import gama.dev.DEBUG;
import gama.gaml.compilation.GAML;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.ModelDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.statements.Facets;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class LayeredDisplayData {
    public static final String OPENGL2 = "opengl2";
    public static final String WEB = "web";
    public static final Double INITIAL_ZOOM;
    public final Set<DisplayDataListener> listeners = new CopyOnWriteArraySet<DisplayDataListener>();
    private GamaColor backgroundColor = GamaPreferences.Displays.CORE_BACKGROUND.getValue();
    private GamaColor highlightColor = GamaPreferences.Displays.CORE_HIGHLIGHT.getValue();
    private GamaColor toolbarColor = null;
    private boolean isAutosaving = false;
    private String autosavingPath = "";
    private boolean isToolbarVisible = GamaPreferences.Displays.CORE_DISPLAY_TOOLBAR.getValue();
    private String displayType = "2d".equalsIgnoreCase(GamaPreferences.Displays.CORE_DISPLAY.getValue()) ? "2d" : "3d";
    private double envWidth = 0.0;
    private double envHeight = 0.0;
    private boolean isAntialiasing = GamaPreferences.Displays.CORE_ANTIALIAS.getValue();
    private volatile GamaPoint imageDimension;
    private Double zoomLevel = INITIAL_ZOOM;
    public static final ICoordinates KEYSTONE_IDENTITY;
    private final ICoordinates keystone = (ICoordinates)KEYSTONE_IDENTITY.copy();
    private boolean is3D;
    private boolean isWireframe = false;
    private boolean ortho = false;
    private boolean isShowingFPS = false;
    private boolean isDrawingEnvironment = GamaPreferences.Displays.CORE_DRAW_ENV.getValue();
    private boolean constantBackground = true;
    private double zNear = -1.0;
    private double zFar = -1.0;
    private int fullScreen = -1;
    IPreferenceChangeListener.IPreferenceAfterChangeListener<GamaColor> highlightListener = this::setHighlightColor;
    private final Map<String, ICameraDefinition> cameraDefinitions = new LinkedHashMap<String, ICameraDefinition>();
    private ICameraDefinition camera;
    private IExpression cameraNameExpression;
    RotationDefinition rotation;
    private boolean isLightOn = true;
    private int lightIndex = 1;
    private final Map<String, ILightDefinition> lights = new LinkedHashMap<String, ILightDefinition>(){
        {
            this.put("Ambient light", new GenericLightDefinition("Ambient light", -1, GamaPreferences.Displays.OPENGL_DEFAULT_LIGHT_INTENSITY.getValue()));
            this.put("default", new GenericLightDefinition("default", 0, GamaPreferences.Displays.OPENGL_DEFAULT_LIGHT_INTENSITY.getValue()));
        }
    };

    static {
        DEBUG.OFF();
        INITIAL_ZOOM = 1.0;
        KEYSTONE_IDENTITY = ICoordinates.ofLength(4).setTo(0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 0.0, 0.0);
    }

    public void addListener(DisplayDataListener displayDataListener) {
        this.listeners.add(displayDataListener);
    }

    public void removeListener(DisplayDataListener displayDataListener) {
        this.listeners.remove(displayDataListener);
    }

    public void notifyListeners(Changes changes, Object object) {
        for (DisplayDataListener displayDataListener : this.listeners) {
            displayDataListener.changed(changes, object);
        }
    }

    public LayeredDisplayData() {
        GamaPreferences.Displays.CORE_HIGHLIGHT.addChangeListener(this.highlightListener);
    }

    public void dispose() {
        GamaPreferences.Displays.CORE_HIGHLIGHT.removeChangeListener(this.highlightListener);
        this.listeners.clear();
    }

    public GamaColor getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(GamaColor gamaColor) {
        this.backgroundColor = gamaColor;
        this.notifyListeners(Changes.BACKGROUND, gamaColor);
    }

    public boolean isAutosave() {
        return this.isAutosaving;
    }

    public void setAutosave(boolean bl) {
        this.isAutosaving = bl;
    }

    public void setAutosavePath(String string) {
        this.autosavingPath = string;
    }

    public String getAutosavePath() {
        return this.autosavingPath;
    }

    public boolean isWireframe() {
        return this.isWireframe;
    }

    public void setWireframe(boolean bl) {
        this.isWireframe = bl;
    }

    public boolean isOrtho() {
        return this.ortho;
    }

    public void setOrtho(boolean bl) {
        this.ortho = bl;
    }

    public boolean isShowfps() {
        return this.isShowingFPS;
    }

    public void setShowfps(boolean bl) {
        this.isShowingFPS = bl;
    }

    public double getzNear() {
        return this.zNear;
    }

    public double getzFar() {
        return this.zFar;
    }

    public boolean isDrawEnv() {
        return this.isDrawingEnvironment;
    }

    public void setDrawEnv(boolean bl) {
        this.isDrawingEnvironment = bl;
    }

    public String getDisplayType() {
        return this.displayType;
    }

    public void setDisplayType(String string) {
        this.displayType = string;
        this.is3D = "opengl".equals(string) || "3d".equals(string) || OPENGL2.equals(string);
    }

    public GamaPoint getImageDimension() {
        return this.imageDimension;
    }

    public void setImageDimension(GamaPoint gamaPoint) {
        this.imageDimension = gamaPoint;
    }

    public double getEnvWidth() {
        return this.envWidth;
    }

    public void setEnvWidth(double d) {
        this.envWidth = d;
    }

    public double getEnvHeight() {
        return this.envHeight;
    }

    public void setEnvHeight(double d) {
        this.envHeight = d;
    }

    public double getMaxEnvDim() {
        return this.envWidth > this.envHeight ? this.envWidth : this.envHeight;
    }

    public GamaColor getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(GamaColor gamaColor) {
        this.highlightColor = gamaColor;
    }

    public boolean isAntialias() {
        return this.isAntialiasing;
    }

    public void setAntialias(boolean bl) {
        this.isAntialiasing = bl;
    }

    public Double getZoomLevel() {
        return this.zoomLevel;
    }

    public void setZoomLevel(Double d, boolean bl) {
        if (this.zoomLevel != null && this.zoomLevel.equals(d)) {
            return;
        }
        this.zoomLevel = d;
        if (bl) {
            this.notifyListeners(Changes.ZOOM, this.zoomLevel);
        }
    }

    public int fullScreen() {
        return this.fullScreen;
    }

    public void setFullScreen(int n) {
        this.fullScreen = n;
    }

    public void setKeystone(List<GamaPoint> list) {
        if (list == null) {
            return;
        }
        this.keystone.setTo(list.toArray(new GamaPoint[4]));
    }

    public void setKeystone(ICoordinates iCoordinates) {
        if (iCoordinates == null) {
            return;
        }
        this.keystone.setTo(iCoordinates.toCoordinateArray());
    }

    public ICoordinates getKeystone() {
        return this.keystone;
    }

    public boolean isKeystoneDefined() {
        return !this.keystone.equals(KEYSTONE_IDENTITY);
    }

    public boolean isToolbarVisible() {
        return this.isToolbarVisible;
    }

    public GamaColor getToolbarColor() {
        return this.toolbarColor == null ? this.getBackgroundColor() : this.toolbarColor;
    }

    public void setToolbarVisible(boolean bl) {
        this.isToolbarVisible = bl;
    }

    public void initWith(IScope iScope, IDescription iDescription) {
        IExpression iExpression;
        ITyped iTyped;
        IExpression iExpression2;
        IExpression iExpression3;
        ITyped iTyped2;
        IExpression iExpression4;
        IExpression iExpression5;
        IExpression iExpression6;
        IExpression iExpression7;
        IExpression iExpression8;
        IExpression iExpression9;
        Object object;
        boolean bl;
        Facets facets2 = iDescription.getFacets();
        SimulationAgent simulationAgent = iScope.getSimulation();
        ModelDescription modelDescription = iDescription.getModelDescription();
        ModelDescription modelDescription2 = iScope.getModel().getDescription();
        boolean bl2 = bl = modelDescription2.getMicroModel(modelDescription.getAlias()) != null;
        if (bl) {
            object = (ExperimentAgent)iScope.getRoot().getExternMicroPopulationFor(modelDescription.getAlias() + "." + iDescription.getOriginName()).getAgent(0);
            simulationAgent = ((ExperimentAgent)object).getSimulation();
        }
        object = null;
        object = simulationAgent != null ? simulationAgent.getEnvelope() : Envelope3D.of(0.0, 100.0, 0.0, 100.0, 0.0, 0.0);
        this.setEnvWidth(object.getWidth());
        this.setEnvHeight(object.getHeight());
        ((Envelope3D)object).dispose();
        this.updateAutoSave(iScope, facets2.getExpr("autosave"));
        IExpression iExpression10 = facets2.getExpr("toolbar");
        if (iExpression10 != null) {
            if (iExpression10.getGamlType() == Types.BOOL) {
                this.setToolbarVisible(Cast.asBool(iScope, iExpression10.value(iScope)));
            } else {
                this.setToolbarVisible(true);
                this.toolbarColor = Cast.asColor(iScope, iExpression10.value(iScope));
            }
        }
        if ((iExpression9 = facets2.getExpr("show_fps")) != null) {
            this.setShowfps(Cast.asBool(iScope, iExpression9.value(iScope)));
        }
        if ((iExpression8 = facets2.getExpr("z_near")) != null) {
            this.setZNear(Cast.asFloat(iScope, iExpression8.value(iScope)));
        }
        if ((iExpression7 = facets2.getExpr("z_far")) != null) {
            this.setZFar(Cast.asFloat(iScope, iExpression7.value(iScope)));
        }
        if ((iExpression6 = facets2.getExpr("draw_env", "axes")) != null) {
            this.setDrawEnv(Cast.asBool(iScope, iExpression6.value(iScope)));
        }
        if ((iExpression5 = facets2.getExpr("orthographic_projection")) != null) {
            this.setOrtho(Cast.asBool(iScope, iExpression5.value(iScope)));
        }
        if ((iExpression4 = facets2.getExpr("keystone")) != null && (iTyped2 = GamaListFactory.create(iScope, (IType)Types.POINT, Cast.asList(iScope, iExpression4.value(iScope)))).size() >= 4) {
            this.setKeystone((List<GamaPoint>)((Object)iTyped2));
        }
        this.initRotationFacets(iScope, facets2);
        iTyped2 = facets2.getExpr("light");
        if (iTyped2 != null) {
            this.setLightOn(Cast.asBool(iScope, iTyped2.value(iScope)));
        }
        this.initializePresetCameraDefinitions();
        this.cameraNameExpression = facets2.getExpr("camera");
        this.setCameraNameFromGaml(this.cameraNameExpression != null ? Cast.asString(iScope, this.cameraNameExpression.value(iScope)) : "default");
        IExpression iExpression11 = facets2.getExpr("fullscreen");
        if (iExpression11 != null) {
            int n = iExpression11.getGamlType() == Types.BOOL ? (Cast.asBool(iScope, iExpression11.value(iScope)) != false ? 0 : -1) : Cast.asInt(iScope, iExpression11.value(iScope));
            this.setFullScreen(n);
        }
        if ((iExpression3 = facets2.getExpr("background")) != null) {
            this.setBackgroundColor(Cast.asColor(iScope, iExpression3.value(iScope)));
            this.constantBackground = iExpression3.isConst();
        }
        if ((iExpression2 = facets2.getExpr("ambient_light")) != null) {
            if (iExpression2.getGamlType().equals(Types.COLOR)) {
                iTyped = Cast.asColor(iScope, iExpression2.value(iScope));
            } else {
                int n = Cast.asInt(iScope, iExpression2.value(iScope));
                iTyped = GamaColor.get(n, n, n, 255);
            }
            this.lights.put("Ambient light", new GenericLightDefinition("Ambient light", -1, (GamaColor)iTyped));
        }
        if ((iTyped = facets2.getExpr("antialias")) != null) {
            this.setAntialias(Cast.asBool(iScope, iTyped.value(iScope)));
        }
        if ((iExpression = facets2.getExpr("locked")) != null) {
            this.setCameraLocked(Cast.asBool(iScope, iExpression.value(iScope)));
        }
        if (this.camera != null) {
            this.camera.refresh(iScope);
        }
        if (this.rotation != null) {
            this.rotation.refresh(iScope);
        }
        this.lights.forEach((string, iLightDefinition) -> iLightDefinition.refresh(iScope));
    }

    private void updateAutoSave(IScope iScope, IExpression iExpression) throws GamaRuntimeException {
        if (iExpression == null) {
            return;
        }
        if (iExpression.getGamlType().equals(Types.POINT)) {
            GamaPoint gamaPoint = Cast.asPoint(iScope, iExpression.value(iScope));
            this.setAutosave(gamaPoint != null);
            this.setImageDimension(gamaPoint);
        } else if (iExpression.getGamlType().equals(Types.STRING)) {
            String string = Cast.asString(iScope, iExpression.value(iScope));
            this.setAutosave(string != null && !string.isBlank());
            this.setAutosavePath(string);
        } else {
            this.setAutosave(Cast.asBool(iScope, iExpression.value(iScope)));
        }
    }

    public void setZFar(Double d) {
        this.zFar = d;
    }

    public void setZNear(Double d) {
        this.zNear = d;
    }

    public void update(IScope iScope, Facets facets2) {
        IExpression iExpression;
        if (this.cameraNameExpression != null) {
            boolean bl = this.camera == null ? false : this.camera.isLocked();
            this.setCameraNameFromGaml(Cast.asString(iScope, this.cameraNameExpression.value(iScope)));
            if (this.camera != null) {
                this.camera.setLocked(bl);
            }
        }
        if (this.camera != null) {
            this.camera.refresh(iScope);
        }
        if (this.rotation != null) {
            this.rotation.refresh(iScope);
        }
        this.lights.forEach((string, iLightDefinition) -> iLightDefinition.refresh(iScope));
        this.updateAutoSave(iScope, facets2.getExpr("autosave"));
        if (!this.constantBackground && (iExpression = facets2.getExpr("background")) != null) {
            this.setBackgroundColor(Cast.asColor(iScope, iExpression.value(iScope)));
        }
    }

    public boolean isOpenGL2() {
        return OPENGL2.equals(this.displayType);
    }

    public boolean isWeb() {
        return WEB.equals(this.displayType);
    }

    public boolean is3D() {
        return this.is3D;
    }

    public void addCameraDefinition(ICameraDefinition iCameraDefinition) {
        this.cameraDefinitions.putIfAbsent(iCameraDefinition.getName(), iCameraDefinition);
    }

    public double getCameraDistanceCoefficient() {
        return this.isDrawEnv() ? 1.4 : 1.2;
    }

    public void resetCamera() {
        if (this.camera != null) {
            this.camera.reset();
        }
    }

    public double getCameraDistance() {
        return this.camera.getDistance();
    }

    public void setCameraDistance(double d) {
        this.camera.setDistance(d);
    }

    private void initializePresetCameraDefinitions() {
        double d = this.getEnvWidth();
        double d2 = this.getEnvHeight();
        double d3 = Math.max(d, d2) * this.getCameraDistanceCoefficient();
        GamaPoint gamaPoint = new GamaPoint(d / 2.0, -d2 / 2.0, 0.0);
        String[] stringArray = ICameraDefinition.PRESETS;
        int n = ICameraDefinition.PRESETS.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            this.addCameraDefinition(new GenericCameraDefinition(string, gamaPoint, this.getEnvWidth(), this.getEnvHeight(), d3));
            ++n2;
        }
        this.cameraDefinitions.putIfAbsent("default", this.cameraDefinitions.get(GamaPreferences.Displays.OPENGL_DEFAULT_CAM.getValue()));
    }

    public void setCameraNameFromGaml(String string) {
        if (this.camera != null && Objects.equal((Object)string, (Object)this.camera.getName())) {
            return;
        }
        this.resetCamera();
        this.camera = this.cameraDefinitions.get(string);
        if (this.camera == null) {
            this.camera = this.cameraDefinitions.get("default");
        }
    }

    public void setCameraNameFromUser(String string) {
        if (this.camera != null && Objects.equal((Object)string, (Object)this.camera.getName())) {
            return;
        }
        this.cameraNameExpression = GAML.getExpressionFactory().createConst(string, Types.STRING);
        this.camera = this.cameraDefinitions.get(string);
        if (this.camera == null) {
            this.camera = this.cameraDefinitions.get("default");
        }
    }

    public GamaPoint getCameraPos() {
        return this.camera.getLocation();
    }

    public void setCameraPos(GamaPoint gamaPoint) {
        this.camera.setLocation(gamaPoint);
    }

    public GamaPoint getCameraTarget() {
        return this.camera.getTarget();
    }

    public void setCameraTarget(GamaPoint gamaPoint) {
        this.camera.setTarget(gamaPoint);
    }

    public int getCameraLens() {
        return this.camera.getLens();
    }

    public String getCameraName() {
        return this.camera.getName();
    }

    public Collection<String> getCameraNames() {
        return this.cameraDefinitions.keySet();
    }

    public void setCameraLocked(boolean bl) {
        this.camera.setLocked(bl);
    }

    public boolean isCameraLocked() {
        return this.camera.isLocked();
    }

    public boolean isCameraDynamic() {
        return this.camera.isDynamic();
    }

    private void initRotationFacets(IScope iScope, Facets facets2) {
        IExpression iExpression = facets2.getExpr("rotate");
        if (iExpression != null) {
            double d = Cast.asFloat(iScope, iExpression.value(iScope));
            this.setRotationAngle(d);
        }
    }

    public void setRotation(RotationDefinition rotationDefinition) {
        this.rotation = rotationDefinition;
    }

    public boolean isContinuousRotationOn() {
        return this.rotation != null && this.rotation.isDynamic() != false;
    }

    public void setContinuousRotation(boolean bl) {
        if (this.rotation != null) {
            this.rotation.setDynamic(bl);
        }
    }

    public double getRotationAngle() {
        return this.rotation == null ? 0.0 : this.rotation.getCurrentAngle();
    }

    public boolean hasRotation() {
        return this.rotation != null && this.rotation.getAngleDelta() != 0.0 && !this.rotation.getAxis().isNull();
    }

    public void setRotationAngle(double d) {
        if (this.rotation != null) {
            this.rotation.setAngle(d);
        }
    }

    public GamaPoint getRotationCenter() {
        return this.rotation != null ? this.rotation.getCenter().yNegated() : null;
    }

    public GamaPoint getRotationAxis() {
        return this.rotation != null ? this.rotation.getAxis().yNegated() : null;
    }

    public void resetRotation() {
        if (this.rotation != null) {
            this.rotation.reset();
        }
    }

    public boolean isLightOn() {
        return this.isLightOn;
    }

    public void setLightOn(boolean bl) {
        this.isLightOn = bl;
    }

    public Map<String, ILightDefinition> getLights() {
        return this.lights;
    }

    public void addLightDefinition(LightDefinition lightDefinition) {
        int n;
        String string = lightDefinition.getName();
        if (this.lights.containsKey(string)) {
            n = this.lights.get(string).getId();
        } else {
            int n2 = this.lightIndex;
            n = n2;
            this.lightIndex = n2 + 1;
        }
        int n3 = n;
        lightDefinition.setId(n3);
        this.lights.put(string, lightDefinition);
    }

    public static enum Changes {
        BACKGROUND,
        ZOOM;

    }

    public static interface DisplayDataListener {
        public void changed(Changes var1, Object var2);
    }
}

