/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs.layers;

import gama.core.common.interfaces.IDisplaySurface;
import gama.core.common.interfaces.IGraphics;
import gama.core.common.interfaces.IImageProvider;
import gama.core.common.interfaces.ILayer;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.IShape;
import gama.core.outputs.layers.AbstractLayer;
import gama.core.outputs.layers.GridLayerData;
import gama.core.outputs.layers.ILayerStatement;
import gama.core.runtime.IScope;
import gama.core.util.Collector;
import gama.core.util.GamaColor;
import gama.core.util.IList;
import gama.core.util.matrix.GamaField;
import gama.dev.DEBUG;
import gama.gaml.statements.draw.MeshDrawingAttributes;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.Collections;
import java.util.Set;

public class GridLayer
extends AbstractLayer
implements ILayer.IGridLayer {
    static {
        DEBUG.OFF();
    }

    public GridLayer(ILayerStatement iLayerStatement) {
        super(iLayerStatement);
    }

    @Override
    public GridLayerData createData() {
        return new GridLayerData(this.definition);
    }

    @Override
    public GridLayerData getData() {
        return (GridLayerData)super.getData();
    }

    @Override
    public Rectangle2D focusOn(IShape iShape, IDisplaySurface iDisplaySurface) {
        IAgent iAgent = iShape.getAgent();
        if (iAgent == null || iAgent.getSpecies() != this.getData().getGrid().getCellSpecies()) {
            return null;
        }
        return super.focusOn(iAgent, iDisplaySurface);
    }

    @Override
    public void reloadOn(IDisplaySurface iDisplaySurface) {
        super.reloadOn(iDisplaySurface);
        this.getData().reset();
    }

    @Override
    public void privateDraw(IScope.IGraphicsScope iGraphicsScope, IGraphics iGraphics) {
        GamaColor gamaColor = null;
        GridLayerData gridLayerData = this.getData();
        if (gridLayerData.drawLines()) {
            gamaColor = gridLayerData.getLineColor();
        }
        double[] dArray = gridLayerData.getElevationMatrix(iGraphicsScope);
        IImageProvider iImageProvider = gridLayerData.textureFile();
        MeshDrawingAttributes meshDrawingAttributes = new MeshDrawingAttributes(this.getName(), dArray == null);
        meshDrawingAttributes.setGrayscaled(gridLayerData.isGrayScaled());
        meshDrawingAttributes.setEmpty(gridLayerData.isWireframe());
        BufferedImage bufferedImage = gridLayerData.getImage();
        if (iImageProvider != null) {
            meshDrawingAttributes.setTextures(Collections.singletonList(iImageProvider));
        } else if (bufferedImage != null) {
            int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
            System.arraycopy(gridLayerData.getGrid().getDisplayData(), 0, nArray, 0, nArray.length);
            meshDrawingAttributes.setTextures(Collections.singletonList(bufferedImage));
        }
        meshDrawingAttributes.setTriangulated(gridLayerData.isTriangulated());
        meshDrawingAttributes.setWithText(gridLayerData.isShowText());
        meshDrawingAttributes.setBorder(gamaColor);
        meshDrawingAttributes.setXYDimension(gridLayerData.getDimensions());
        meshDrawingAttributes.setSmooth(gridLayerData.isSmooth() != false ? 1 : 0);
        if (dArray == null) {
            iGraphics.drawImage(bufferedImage, meshDrawingAttributes);
        } else {
            iGraphics.drawField(new GamaField(iGraphicsScope, (int)gridLayerData.getDimensions().x, (int)gridLayerData.getDimensions().y, dArray, Double.MAX_VALUE), meshDrawingAttributes);
        }
    }

    @Override
    public Set<IAgent> collectAgentsAt(int n, int n2, IDisplaySurface iDisplaySurface) {
        Throwable throwable = null;
        Object var5_6 = null;
        try (Collector.AsOrderedSet asOrderedSet = Collector.getOrderedSet();){
            asOrderedSet.add(this.getData().getGrid().getAgentAt(this.getModelCoordinatesFrom(n, n2, iDisplaySurface)));
            return asOrderedSet.items();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public String getType() {
        return "Grid layer";
    }

    public IList<IAgent> getAgentsForMenu(IScope iScope) {
        return this.getData().getGrid().getAgents();
    }
}

