/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs.layers.charts;

import gama.core.common.interfaces.IDisplaySurface;
import gama.core.outputs.layers.charts.ChartDataSeries;
import gama.core.outputs.layers.charts.ChartDataSource;
import gama.core.outputs.layers.charts.ChartJFreeChartOutput;
import gama.core.runtime.IScope;
import gama.gaml.expressions.IExpression;
import java.awt.Paint;
import java.awt.Point;
import java.util.ArrayList;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.SpiderWebPlot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.Dataset;

public class ChartJFreeChartOutputRadar
extends ChartJFreeChartOutput {
    public ChartJFreeChartOutputRadar(IScope iScope, String string, IExpression iExpression) {
        super(iScope, string, iExpression);
    }

    @Override
    public void createChart(IScope iScope) {
        super.createChart(iScope);
        SpiderWebPlot spiderWebPlot = new SpiderWebPlot((CategoryDataset)this.createDataset(iScope));
        this.chart = new JFreeChart(this.getName(), null, (Plot)spiderWebPlot, true);
    }

    @Override
    public void initdataset() {
        super.initdataset();
        this.chartdataset.setCommonXSeries(true);
        this.chartdataset.setByCategory(true);
    }

    @Override
    public void setDefaultPropertiesFromType(IScope iScope, ChartDataSource chartDataSource, int n) {
        switch (n) {
            default: 
        }
        chartDataSource.setCumulative(iScope, false);
        chartDataSource.setUseSize(iScope, false);
    }

    Dataset createDataset(IScope iScope) {
        return new DefaultCategoryDataset();
    }

    @Override
    protected AbstractRenderer createRenderer(IScope iScope, String string) {
        return null;
    }

    protected void resetRenderer(IScope iScope, String string) {
        SpiderWebPlot spiderWebPlot = (SpiderWebPlot)this.chart.getPlot();
        if (spiderWebPlot.getMaxValue() <= 0.0) {
            spiderWebPlot.setMaxValue(1.0);
        }
        ChartDataSeries chartDataSeries = this.getChartdataset().getDataSeries(iScope, string);
        if (this.idPosition.containsKey(string)) {
            int n = (Integer)this.idPosition.get(string);
            if (chartDataSeries.getMycolor() != null) {
                spiderWebPlot.setSeriesPaint(n, (Paint)chartDataSeries.getMycolor());
            }
            "onchart".equals(this.series_label_position);
        }
    }

    @Override
    protected void clearDataSet(IScope iScope) {
        super.clearDataSet(iScope);
        SpiderWebPlot spiderWebPlot = (SpiderWebPlot)this.chart.getPlot();
        int n = spiderWebPlot.getDataset().getRowCount() - 1;
        while (n >= 1) {
            --n;
        }
        if (this.jfreedataset.size() > 0) {
            ((DefaultCategoryDataset)this.jfreedataset.get(0)).clear();
        }
        this.jfreedataset.clear();
        this.jfreedataset.add(0, new DefaultCategoryDataset());
        spiderWebPlot.setDataset((CategoryDataset)((DefaultCategoryDataset)this.jfreedataset.get(0)));
        this.idPosition.clear();
        this.nbseries = 0;
    }

    @Override
    protected void createNewSerie(IScope iScope, String string) {
        if (!this.idPosition.containsKey(string)) {
            SpiderWebPlot spiderWebPlot = (SpiderWebPlot)this.chart.getPlot();
            DefaultCategoryDataset defaultCategoryDataset = (DefaultCategoryDataset)spiderWebPlot.getDataset();
            if (this.nbseries == 0) {
                spiderWebPlot.setDataset((CategoryDataset)defaultCategoryDataset);
            }
            ++this.nbseries;
            this.idPosition.put(string, this.nbseries - 1);
        }
    }

    @Override
    public void removeSerie(IScope iScope, String string) {
        super.removeSerie(iScope, string);
        this.clearDataSet(iScope);
    }

    @Override
    protected void resetSerie(IScope iScope, String string) {
        this.chart.getPlot();
        ChartDataSeries chartDataSeries = this.chartdataset.getDataSeries(iScope, string);
        DefaultCategoryDataset defaultCategoryDataset = (DefaultCategoryDataset)this.jfreedataset.get(0);
        if (defaultCategoryDataset.getRowKeys().contains(string)) {
            defaultCategoryDataset.removeRow((Comparable)((Object)string));
        }
        ArrayList<String> arrayList = chartDataSeries.getCValues(iScope);
        ArrayList<Double> arrayList2 = chartDataSeries.getYValues(iScope);
        ArrayList<Double> arrayList3 = chartDataSeries.getSValues(iScope);
        if (arrayList.size() > 0) {
            int n = 0;
            if (this.usexrangeinterval && (double)arrayList.size() > this.xrangeinterval) {
                n = arrayList.size() - (int)this.xrangeinterval;
            }
            int n2 = n;
            while (n2 < arrayList.size()) {
                defaultCategoryDataset.addValue((Number)arrayList2.get(n2), (Comparable)((Object)string), (Comparable)((Object)arrayList.get(n2 - n)));
                ++n2;
            }
        }
        arrayList3.size();
        this.resetRenderer(iScope, string);
    }

    @Override
    public void resetAxes(IScope iScope) {
        if ("none".equals(this.series_label_position)) {
            this.chart.getLegend().setVisible(false);
        }
    }

    private void resetDomainAxis(IScope iScope) {
        this.chart.getPlot();
    }

    @Override
    public void initChart(IScope iScope, String string) {
        super.initChart(iScope, string);
        this.chart.getPlot();
    }

    @Override
    public void initChart_post_data_init(IScope iScope) {
        super.initChart_post_data_init(iScope);
        SpiderWebPlot spiderWebPlot = (SpiderWebPlot)this.chart.getPlot();
        if ("default".equals(this.series_label_position)) {
            this.series_label_position = "legend";
        }
        "xaxis".equals(this.series_label_position);
        if (!"legend".equals(this.series_label_position)) {
            this.chart.getLegend().setVisible(false);
        }
        this.resetDomainAxis(iScope);
        spiderWebPlot.setAxisLinePaint((Paint)this.axesColor);
        spiderWebPlot.setLabelFont(this.getLabelFont());
        if (this.textColor != null) {
            spiderWebPlot.setLabelPaint((Paint)this.textColor);
        }
        if ("yaxis".equals(this.series_label_position)) {
            this.chart.getLegend().setVisible(false);
        }
        this.chart.getLegend().setVisible(true);
        if (this.xlabel != null) {
            "".equals(this.xlabel);
        }
        if ("none".equals(this.series_label_position)) {
            spiderWebPlot.setLabelPaint((Paint)this.backgroundColor);
        }
        if (this.useyrangeinterval) {
            ((SpiderWebPlot)this.chart.getPlot()).setMaxValue(this.yrangeinterval);
        } else if (this.useyrangeminmax) {
            ((SpiderWebPlot)this.chart.getPlot()).setMaxValue(this.yrangemax);
        }
    }

    @Override
    protected void initRenderer(IScope iScope) {
    }

    @Override
    public void getModelCoordinatesInfo(int n, int n2, IDisplaySurface iDisplaySurface, Point point, StringBuilder stringBuilder) {
        Comparable comparable;
        int n3 = n - point.x;
        int n4 = n2 - point.y;
        ChartEntity chartEntity = this.info.getEntityCollection().getEntity((double)n3, (double)n4);
        Comparable comparable2 = ((CategoryItemEntity)chartEntity).getColumnKey();
        String string = comparable2.toString();
        CategoryDataset categoryDataset = ((CategoryItemEntity)chartEntity).getDataset();
        double d = categoryDataset.getValue(comparable = ((CategoryItemEntity)chartEntity).getRowKey(), comparable2).doubleValue();
        boolean bl = d % 1.0 == 0.0;
        stringBuilder.append(string).append(" ").append(bl ? Integer.valueOf((int)d) : String.format("%.2f", d));
    }
}

