/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs.layers.properties;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.runtime.IScope;
import gama.core.util.GamaColor;
import gama.gaml.interfaces.INamed;
import java.util.List;

public interface ILightDefinition
extends INamed {
    @GamlAnnotations.constant(value="point", category={"3D"}, doc={@GamlAnnotations.doc(value="Represent the 'point' type of light")})
    public static final String point = "Point light";
    @GamlAnnotations.constant(value="spot", category={"3D"}, doc={@GamlAnnotations.doc(value="Represent the 'spot' type of light")})
    public static final String spot = "Spot light";
    @GamlAnnotations.constant(value="ambient", category={"3D"}, doc={@GamlAnnotations.doc(value="Represent the 'ambient' type of light")})
    public static final String ambient = "Ambient light";
    @GamlAnnotations.constant(value="direction", category={"3D"}, doc={@GamlAnnotations.doc(value="Represent the 'direction' type of light")})
    public static final String direction = "Directional light";
    public static final String[] LIGHT_PRESETS = List.of("Point light", "Directional light", "Spot light").toArray(new String[4]);
    public static final GamaPoint DEFAULT_DIRECTION = new GamaPoint(0.5, 0.5, -1.0);
    public static final GamaPoint DEFAULT_LOCATION = new GamaPoint(0.0, 0.0, 1.0);
    public static final Double DEFAULT_ANGLE = 45.0;

    default public Boolean isDynamic() {
        return true;
    }

    default public Boolean isActive() {
        return !this.getIntensity().isZero();
    }

    default public Boolean isDrawing() {
        return false;
    }

    default public GamaPoint getDirection() {
        return DEFAULT_DIRECTION;
    }

    public GamaColor getIntensity();

    default public String getType() {
        return direction;
    }

    default public double getAngle() {
        return DEFAULT_ANGLE;
    }

    default public GamaPoint getLocation() {
        return DEFAULT_LOCATION;
    }

    @Override
    public String getName();

    public int getId();

    default public double getLinearAttenuation() {
        return 0.0;
    }

    default public double getQuadraticAttenuation() {
        return 0.0;
    }

    default public double getConstantAttenuation() {
        return 1.0;
    }

    default public void refresh(IScope iScope) {
    }
}

