/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.file.json;

public class DeserializationException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final int position;
    private final Problems problemType;
    private final Object unexpectedObject;

    public DeserializationException(int n, Problems problems, Object object) {
        this.position = n;
        this.problemType = problems;
        this.unexpectedObject = object;
        if ((Problems.IOEXCEPTION.equals((Object)problems) || Problems.UNEXPECTED_EXCEPTION.equals((Object)problems)) && object instanceof Throwable) {
            this.initCause((Throwable)object);
        }
    }

    @Override
    public String getMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        switch (this.problemType) {
            case DISALLOWED_TOKEN: {
                stringBuilder.append("The disallowed token (").append(this.unexpectedObject).append(") was found at position ").append(this.position).append(". If this is in error, try again with a parse that allows the token instead. Otherwise, fix the parsable string and try again.");
                break;
            }
            case IOEXCEPTION: {
                stringBuilder.append("An IOException was encountered, ensure the reader is properly instantiated, isn't closed, or that it is ready before trying again.\n").append(this.unexpectedObject);
                break;
            }
            case UNEXPECTED_CHARACTER: {
                stringBuilder.append("The unexpected character (").append(this.unexpectedObject).append(") was found at position ").append(this.position).append(". Fix the parsable string and try again.");
                break;
            }
            case UNEXPECTED_TOKEN: {
                stringBuilder.append("The unexpected token ").append(this.unexpectedObject).append(" was found at position ").append(this.position).append(". Fix the parsable string and try again.");
                break;
            }
            case UNEXPECTED_EXCEPTION: {
                stringBuilder.append("Please report this to the library's maintainer. The unexpected exception that should be addressed before trying again occurred at position ").append(this.position).append(":\n").append(this.unexpectedObject);
                break;
            }
            default: {
                stringBuilder.append("Please report this to the library's maintainer. An error at position ").append(this.position).append(" occurred. There are no recovery recommendations available.");
            }
        }
        return stringBuilder.toString();
    }

    public int getPosition() {
        return this.position;
    }

    public Problems getProblemType() {
        return this.problemType;
    }

    public Object getUnexpectedObject() {
        return this.unexpectedObject;
    }

    public static enum Problems {
        DISALLOWED_TOKEN,
        IOEXCEPTION,
        UNEXPECTED_CHARACTER,
        UNEXPECTED_EXCEPTION,
        UNEXPECTED_TOKEN;

    }
}

