/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.matrix;

import com.google.common.collect.Iterables;
import com.google.common.primitives.Doubles;
import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.geometry.Envelope3D;
import gama.core.common.geometry.GeometryUtils;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.core.util.file.IFieldMatrixProvider;
import gama.core.util.matrix.GamaFloatMatrix;
import gama.core.util.matrix.GamaIntMatrix;
import gama.core.util.matrix.IField;
import gama.core.util.matrix.IMatrix;
import gama.gaml.operators.Cast;
import gama.gaml.operators.Colors;
import gama.gaml.statements.draw.IMeshColorProvider;
import gama.gaml.statements.draw.MeshDrawingAttributes;
import gama.gaml.types.GamaFieldType;
import gama.gaml.types.GamaGeometryType;
import gama.gaml.types.IContainerType;
import gama.gaml.types.Types;
import java.util.Arrays;
import one.util.streamex.DoubleStreamEx;
import one.util.streamex.StreamEx;
import org.locationtech.jts.geom.Coordinate;

public class GamaField
extends GamaFloatMatrix
implements IField {
    GamaPoint worldDimensions = null;
    GamaPoint cellDimensions = null;
    double epsilon;
    double noDataValue;
    IList<GamaField> bands = GamaListFactory.create(Types.FIELD);

    public GamaField(IScope iScope, IFieldMatrixProvider iFieldMatrixProvider) {
        this(iScope, iFieldMatrixProvider.getCols(iScope), iFieldMatrixProvider.getRows(iScope), iFieldMatrixProvider.getFieldData(iScope), iFieldMatrixProvider.getNoData(iScope));
        int n = iFieldMatrixProvider.getBandsNumber(iScope);
        int n2 = 1;
        while (n2 < n) {
            this.bands.add(new GamaField(iScope, this, iFieldMatrixProvider.getBand(iScope, n2)));
            ++n2;
        }
    }

    private GamaField(IScope iScope, GamaField gamaField, double[] dArray) {
        this(iScope, gamaField.numCols, gamaField.numRows, dArray, gamaField.noDataValue);
        this.worldDimensions = gamaField.worldDimensions;
        this.cellDimensions = gamaField.cellDimensions;
        this.epsilon = gamaField.epsilon;
    }

    public GamaField(IScope iScope, int n, int n2, double[] dArray, double d) {
        super(dArray);
        this.noDataValue = d;
        this.numCols = n;
        this.numRows = n2;
        this.bands.add(this);
    }

    private void computeDimensions(IScope iScope) {
        if (this.worldDimensions != null) {
            return;
        }
        IShape iShape = iScope.getSimulation().getGeometry();
        this.worldDimensions = new GamaPoint(iShape.getWidth(), iShape.getHeight());
        this.cellDimensions = new GamaPoint(iShape.getWidth() / (double)this.numCols, iShape.getHeight() / (double)this.numRows);
        this.epsilon = this.cellDimensions.x / 1000.0;
    }

    @Override
    public Double getFromIndicesList(IScope iScope, IList iList) throws GamaRuntimeException {
        if (iList == null || iList.isEmpty()) {
            return null;
        }
        int n = iList.size();
        if (n == 1) {
            Object e = iList.get(0);
            if (e instanceof GamaPoint) {
                return this.get(iScope, (GamaPoint)e);
            }
            return this.matrix[Cast.asInt(iScope, e)];
        }
        return this.get(iScope, Cast.asInt(iScope, iList.get(0)), Cast.asInt(iScope, iList.get(1)));
    }

    @Override
    public Double get(IScope iScope, GamaPoint gamaPoint) {
        int n;
        this.computeDimensions(iScope);
        GamaPoint gamaPoint2 = new GamaPoint(gamaPoint);
        int n2 = gamaPoint2.x < 0.0 ? 0 : (n = gamaPoint2.x >= this.worldDimensions.x ? this.numCols - 1 : (int)(gamaPoint2.x / this.cellDimensions.x));
        int n3 = gamaPoint2.y < 0.0 ? 0 : (gamaPoint2.y >= this.worldDimensions.y ? this.numRows - 1 : (int)(gamaPoint2.y / this.cellDimensions.y));
        return this.matrix[n3 * this.numCols + n];
    }

    @Override
    public void setValueAtIndex(IScope iScope, Object object, Double d) {
        this.computeDimensions(iScope);
        int n = -1;
        if (object instanceof Integer) {
            n = (Integer)object;
        } else if (object instanceof IList) {
            IList iList = (IList)object;
            n = (Integer)iList.get(1) * this.numCols + (Integer)iList.get(0);
        } else if (object instanceof GamaPoint) {
            int n2;
            GamaPoint gamaPoint = (GamaPoint)object;
            int n3 = gamaPoint.x < 0.0 ? 0 : (n2 = gamaPoint.x >= this.worldDimensions.x ? this.numCols - 1 : (int)(gamaPoint.x / this.cellDimensions.x));
            int n4 = gamaPoint.y < 0.0 ? 0 : (gamaPoint.y >= this.worldDimensions.y ? this.numRows - 1 : (int)(gamaPoint.y / this.cellDimensions.y));
            n = n4 * this.numCols + n2;
        }
        if (n > -1 && n < this.matrix.length) {
            this.matrix[n] = d;
        }
    }

    @Override
    public GamaPoint getCellSize(IScope iScope) {
        this.computeDimensions(iScope);
        return this.cellDimensions;
    }

    @Override
    public double getNoData(IScope iScope) {
        return this.noDataValue;
    }

    @Override
    public void setNoData(IScope iScope, double d) {
        if (d != this.noDataValue) {
            this.noDataValue = d;
        }
        if (this.bands.size() > 1) {
            int n = 1;
            while (n < this.bands.size()) {
                ((GamaField)this.bands.get(n)).setNoData(iScope, d);
                ++n;
            }
        }
    }

    @Override
    public IList<? extends IField> getBands(IScope iScope) {
        return this.bands;
    }

    @Override
    public double[] getMinMax(double[] dArray) {
        double[] dArray2;
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        double[] dArray3 = dArray2 = this.getMatrix();
        int n = dArray2.length;
        int n2 = 0;
        while (n2 < n) {
            double d3 = dArray3[n2];
            if (d3 != this.noDataValue) {
                if (d3 > d2) {
                    d2 = d3;
                }
                if (d3 < d) {
                    d = d3;
                }
            }
            ++n2;
        }
        if (dArray == null) {
            return new double[]{d, d2};
        }
        dArray[0] = d;
        dArray[1] = d2;
        return dArray;
    }

    @Override
    public int getNbNeighbours() {
        return 8;
    }

    @Override
    public double getValueAtIndex(IScope iScope, int n, String string) {
        return this.matrix[n];
    }

    @Override
    public void setValueAtIndex(IScope iScope, int n, String string, double d) {
        this.matrix[n] = d;
    }

    @Override
    public void getValuesInto(IScope iScope, String string, double d, double[] dArray) {
        System.arraycopy(this.matrix, 0, dArray, 0, dArray.length);
        int n = 0;
        while (n < dArray.length) {
            if (dArray[n] < d) {
                dArray[n] = 0.0;
            }
            ++n;
        }
    }

    @Override
    public StreamEx<Double> stream(IScope iScope) {
        return DoubleStreamEx.of((double[])this.getMatrix()).filter(d -> d != this.noDataValue).boxed();
    }

    @Override
    public Iterable<Double> iterable(IScope iScope) {
        return Iterables.filter((Iterable)Doubles.asList((double[])this.getMatrix()), d -> d != this.noDataValue);
    }

    @Override
    public IShape getCellShapeAt(IScope iScope, GamaPoint gamaPoint) {
        int n;
        this.computeDimensions(iScope);
        int n2 = gamaPoint.x < 0.0 ? 0 : (n = gamaPoint.x >= this.worldDimensions.x ? this.numCols - 1 : (int)(gamaPoint.x / this.cellDimensions.x));
        int n3 = gamaPoint.y < 0.0 ? 0 : (gamaPoint.y >= this.worldDimensions.y ? this.numRows - 1 : (int)(gamaPoint.y / this.cellDimensions.y));
        return this.getCellShapeAt(iScope, n, n3);
    }

    @Override
    public IShape getCellShapeAt(IScope iScope, int n, int n2) {
        this.computeDimensions(iScope);
        return GamaGeometryType.buildRectangle(this.cellDimensions.x, this.cellDimensions.y, new GamaPoint((double)n * this.cellDimensions.x + this.cellDimensions.x / 2.0, (double)n2 * this.cellDimensions.y + this.cellDimensions.y / 2.0, this.get(iScope, n, n2)));
    }

    @Override
    public IList<Double> getValuesIntersecting(IScope iScope, IShape iShape) {
        this.computeDimensions(iScope);
        Envelope3D envelope3D = Envelope3D.of(iShape);
        IList<Double> iList = GamaListFactory.create(Types.FLOAT);
        GamaPoint gamaPoint = new GamaPoint();
        double d = envelope3D.getMinX();
        while (d < envelope3D.getMaxX()) {
            double d2 = envelope3D.getMinY();
            while (d2 < envelope3D.getMaxY()) {
                Double d3;
                gamaPoint.setLocation(d, d2, 0.0);
                if (GeometryUtils.POINT_LOCATOR.intersects((Coordinate)gamaPoint, iShape.getInnerGeometry()) && (d3 = this.get(iScope, gamaPoint)) != null) {
                    iList.add(d3);
                }
                d2 += this.cellDimensions.y;
            }
            d += this.cellDimensions.x;
        }
        return iList;
    }

    @Override
    public IList<IShape> getCellsIntersecting(IScope iScope, IShape iShape) {
        this.computeDimensions(iScope);
        Envelope3D envelope3D = Envelope3D.of(iShape);
        IList<IShape> iList = GamaListFactory.create(Types.GEOMETRY);
        GamaPoint gamaPoint = new GamaPoint();
        double d = envelope3D.getMinX();
        while (d < envelope3D.getMaxX()) {
            double d2 = envelope3D.getMinY();
            while (d2 < envelope3D.getMaxY()) {
                IShape iShape2;
                gamaPoint.setLocation(d, d2, 0.0);
                if (GeometryUtils.POINT_LOCATOR.intersects((Coordinate)gamaPoint, iShape.getInnerGeometry()) && (iShape2 = this.getCellShapeAt(iScope, gamaPoint)) != null) {
                    iList.add(iShape2);
                }
                d2 += this.cellDimensions.y;
            }
            d += this.cellDimensions.x;
        }
        return iList;
    }

    @Override
    public IList<IShape> getCellsOverlapping(IScope iScope, IShape iShape) {
        this.computeDimensions(iScope);
        Envelope3D envelope3D = Envelope3D.of(iShape);
        IList<IShape> iList = GamaListFactory.create(Types.GEOMETRY);
        GamaPoint gamaPoint = new GamaPoint();
        double d = envelope3D.getMinX();
        while (d < envelope3D.getMaxX()) {
            double d2 = envelope3D.getMinY();
            while (d2 < envelope3D.getMaxY()) {
                gamaPoint.setLocation(d, d2, 0.0);
                IShape iShape2 = this.getCellShapeAt(iScope, gamaPoint);
                if (iShape2 != null && iShape2.intersects(iShape)) {
                    iList.add(iShape2);
                }
                d2 += this.cellDimensions.y;
            }
            d += this.cellDimensions.x;
        }
        return iList;
    }

    @Override
    public IList<GamaPoint> getLocationsIntersecting(IScope iScope, IShape iShape) {
        this.computeDimensions(iScope);
        Envelope3D envelope3D = Envelope3D.of(iShape);
        IList<GamaPoint> iList = GamaListFactory.create(Types.POINT);
        GamaPoint gamaPoint = new GamaPoint();
        double d = envelope3D.getMinX();
        while (d < envelope3D.getMaxX()) {
            double d2 = envelope3D.getMinY();
            while (d2 < envelope3D.getMaxY()) {
                gamaPoint.setLocation(d, d2, 0.0);
                if (GeometryUtils.POINT_LOCATOR.intersects((Coordinate)gamaPoint, iShape.getInnerGeometry())) {
                    iList.add(gamaPoint.copy(iScope));
                }
                d2 += this.cellDimensions.y;
            }
            d += this.cellDimensions.x;
        }
        return iList;
    }

    @Override
    public IList<GamaPoint> getNeighborsOf(IScope iScope, GamaPoint gamaPoint) {
        this.computeDimensions(iScope);
        IList<GamaPoint> iList = GamaListFactory.create(Types.POINT);
        int n = (int)(gamaPoint.x / this.cellDimensions.x);
        int n2 = (int)(gamaPoint.y / this.cellDimensions.y);
        int n3 = -1;
        while (n3 <= 1) {
            int n4 = -1;
            while (n4 <= 1) {
                int n5 = n + n3;
                int n6 = n2 + n4;
                if (n5 >= 0 && n5 <= this.numCols - 1 && n6 >= 0 && n6 <= this.numRows - 1 && (n3 != 0 || n4 != 0)) {
                    iList.add(new GamaPoint((double)n5 * this.cellDimensions.x, (double)n6 * this.cellDimensions.y, this.get(iScope, n5, n6)));
                }
                ++n4;
            }
            ++n3;
        }
        return iList;
    }

    @Override
    public double[] getBand(IScope iScope, int n) {
        double[] dArray = super.getBand(iScope, n);
        if (dArray == null && n < this.bands.size()) {
            dArray = ((GamaField)this.bands.get(n)).getBand(iScope, 0);
        }
        return dArray;
    }

    @Override
    public int getBandsNumber(IScope iScope) {
        return this.bands.size();
    }

    @Override
    public GamaField copy(IScope iScope, GamaPoint gamaPoint, boolean bl) {
        if (gamaPoint == null) {
            if (!bl) {
                return this;
            }
            GamaField gamaField = new GamaField(iScope, this.numCols, this.numRows, Arrays.copyOf(this.getMatrix(), this.getMatrix().length), this.noDataValue);
            if (this.bands.size() > 1) {
                for (GamaField gamaField2 : this.bands) {
                    gamaField.bands.add(new GamaField(iScope, this.numCols, this.numRows, Arrays.copyOf(gamaField2.getMatrix(), gamaField2.getMatrix().length), this.noDataValue));
                }
            }
            return gamaField;
        }
        GamaField gamaField = new GamaField(iScope, (int)gamaPoint.getX(), (int)gamaPoint.getY(), Arrays.copyOf(this.getMatrix(), this.getMatrix().length), this.noDataValue);
        if (this.bands.size() > 1) {
            for (GamaField gamaField3 : this.bands) {
                gamaField.bands.add(new GamaField(iScope, (int)gamaPoint.getX(), (int)gamaPoint.getY(), Arrays.copyOf(gamaField3.getMatrix(), gamaField3.getMatrix().length), this.noDataValue));
            }
        }
        return gamaField;
    }

    @Override
    @GamlAnnotations.operator(value={"+"}, can_be_const=true, content_type=2, category={"Matrix-related operators"}, concept={"matrix"}, doc={@GamlAnnotations.doc(side_effects="Modifies the left field. Use an explicit copy operation to prevent this", value="Adds a matrix or a field to the left field")})
    public GamaField plus(IScope iScope, IMatrix iMatrix) throws GamaRuntimeException {
        block7: {
            block8: {
                block6: {
                    if (!(iMatrix instanceof GamaField)) break block6;
                    GamaField gamaField = (GamaField)iMatrix;
                    double d = gamaField.noDataValue;
                    int n = 0;
                    while (n < this.matrix.length) {
                        if (this.matrix[n] != this.noDataValue && gamaField.matrix[n] != d) {
                            int n2 = n;
                            this.matrix[n2] = this.matrix[n2] + gamaField.matrix[n];
                        }
                        ++n;
                    }
                    break block7;
                }
                if (!(iMatrix instanceof GamaFloatMatrix)) break block8;
                GamaFloatMatrix gamaFloatMatrix = (GamaFloatMatrix)iMatrix;
                int n = 0;
                while (n < this.matrix.length) {
                    if (this.matrix[n] != this.noDataValue) {
                        int n3 = n;
                        this.matrix[n3] = this.matrix[n3] + gamaFloatMatrix.matrix[n];
                    }
                    ++n;
                }
                break block7;
            }
            if (!(iMatrix instanceof GamaIntMatrix)) break block7;
            GamaIntMatrix gamaIntMatrix = (GamaIntMatrix)iMatrix;
            int n = 0;
            while (n < this.matrix.length) {
                if (this.matrix[n] != this.noDataValue) {
                    int n4 = n;
                    this.matrix[n4] = this.matrix[n4] + (double)gamaIntMatrix.matrix[n];
                }
                ++n;
            }
        }
        return this;
    }

    @Override
    @GamlAnnotations.operator(value={"-"}, can_be_const=true, content_type=2, category={"Matrix-related operators"}, concept={"matrix"}, doc={@GamlAnnotations.doc(side_effects="Modifies the left field. Use an explicit copy operation to prevent this", value="Subtracts a matrix or a field from the left field")})
    public GamaField minus(IScope iScope, IMatrix iMatrix) throws GamaRuntimeException {
        block7: {
            block8: {
                block6: {
                    if (!(iMatrix instanceof GamaField)) break block6;
                    GamaField gamaField = (GamaField)iMatrix;
                    double d = gamaField.noDataValue;
                    int n = 0;
                    while (n < this.matrix.length) {
                        if (this.matrix[n] != this.noDataValue && gamaField.matrix[n] != d) {
                            int n2 = n;
                            this.matrix[n2] = this.matrix[n2] - gamaField.matrix[n];
                        }
                        ++n;
                    }
                    break block7;
                }
                if (!(iMatrix instanceof GamaFloatMatrix)) break block8;
                GamaFloatMatrix gamaFloatMatrix = (GamaFloatMatrix)iMatrix;
                int n = 0;
                while (n < this.matrix.length) {
                    if (this.matrix[n] != this.noDataValue) {
                        int n3 = n;
                        this.matrix[n3] = this.matrix[n3] - gamaFloatMatrix.matrix[n];
                    }
                    ++n;
                }
                break block7;
            }
            if (!(iMatrix instanceof GamaIntMatrix)) break block7;
            GamaIntMatrix gamaIntMatrix = (GamaIntMatrix)iMatrix;
            int n = 0;
            while (n < this.matrix.length) {
                if (this.matrix[n] != this.noDataValue) {
                    int n4 = n;
                    this.matrix[n4] = this.matrix[n4] - (double)gamaIntMatrix.matrix[n];
                }
                ++n;
            }
        }
        return this;
    }

    @Override
    @GamlAnnotations.operator(value={"*"}, can_be_const=true, content_type=2, category={"Matrix-related operators"}, concept={}, doc={@GamlAnnotations.doc(side_effects="Modifies the field. Use an explicit copy operation to prevent this", value="Scales the values in the field by the float parameter")})
    public GamaField times(Double d) throws GamaRuntimeException {
        int n = 0;
        while (n < this.matrix.length) {
            if (this.matrix[n] != this.noDataValue) {
                int n2 = n;
                this.matrix[n2] = this.matrix[n2] * d;
            }
            ++n;
        }
        return this;
    }

    @Override
    @GamlAnnotations.operator(value={"*"}, can_be_const=true, content_type=2, category={"Matrix-related operators"}, concept={}, doc={@GamlAnnotations.doc(side_effects="Modifies the field. Use an explicit copy operation to prevent this", value="Scales the values in the field by the int parameter")})
    public GamaField times(Integer n) throws GamaRuntimeException {
        int n2 = 0;
        while (n2 < this.matrix.length) {
            if (this.matrix[n2] != this.noDataValue) {
                int n3 = n2;
                this.matrix[n3] = this.matrix[n3] * (double)n.intValue();
            }
            ++n2;
        }
        return this;
    }

    @Override
    @GamlAnnotations.operator(value={"/"}, can_be_const=true, content_type=2, category={"Matrix-related operators"}, concept={}, doc={@GamlAnnotations.doc(side_effects="Modifies the field. Use an explicit copy operation to prevent this", value="Scales the values in the field by 1 on the float parameter")})
    public GamaField divides(Double d) throws GamaRuntimeException {
        int n = 0;
        while (n < this.matrix.length) {
            if (this.matrix[n] != this.noDataValue) {
                int n2 = n;
                this.matrix[n2] = this.matrix[n2] / d;
            }
            ++n;
        }
        return this;
    }

    @Override
    @GamlAnnotations.operator(value={"/"}, can_be_const=true, content_type=2, category={"Matrix-related operators"}, concept={}, doc={@GamlAnnotations.doc(side_effects="Modifies the field. Use an explicit copy operation to prevent this", value="Scales the values in the field by 1 on the int parameter")})
    public GamaField divides(Integer n) throws GamaRuntimeException {
        int n2 = 0;
        while (n2 < this.matrix.length) {
            if (this.matrix[n2] != this.noDataValue) {
                int n3 = n2;
                this.matrix[n3] = this.matrix[n3] / (double)n.intValue();
            }
            ++n2;
        }
        return this;
    }

    @Override
    @GamlAnnotations.operator(value={"+"}, can_be_const=true, content_type=2, category={"Matrix-related operators"}, concept={}, doc={@GamlAnnotations.doc(side_effects="Modifies the field. Use an explicit copy operation to prevent this", value="Adds a float value to all the values in the field")})
    public GamaField plus(Double d) throws GamaRuntimeException {
        int n = 0;
        while (n < this.matrix.length) {
            if (this.matrix[n] != this.noDataValue) {
                int n2 = n;
                this.matrix[n2] = this.matrix[n2] + d;
            }
            ++n;
        }
        return this;
    }

    @Override
    @GamlAnnotations.operator(value={"+"}, can_be_const=true, content_type=2, category={"Matrix-related operators"}, concept={}, doc={@GamlAnnotations.doc(side_effects="Modifies the field. Use an explicit copy operation to prevent this", value="Adds an int value to all the values in the field")})
    public GamaField plus(Integer n) throws GamaRuntimeException {
        int n2 = 0;
        while (n2 < this.matrix.length) {
            if (this.matrix[n2] != this.noDataValue) {
                int n3 = n2;
                this.matrix[n3] = this.matrix[n3] + (double)n.intValue();
            }
            ++n2;
        }
        return this;
    }

    @Override
    @GamlAnnotations.operator(value={"-"}, can_be_const=true, content_type=2, category={"Matrix-related operators"}, concept={}, doc={@GamlAnnotations.doc(side_effects="Modifies the field. Use an explicit copy operation to prevent this", value="Subtracts a float value from all the values in the field")})
    public GamaField minus(Double d) throws GamaRuntimeException {
        int n = 0;
        while (n < this.matrix.length) {
            if (this.matrix[n] != this.noDataValue) {
                int n2 = n;
                this.matrix[n2] = this.matrix[n2] - d;
            }
            ++n;
        }
        return this;
    }

    @Override
    @GamlAnnotations.operator(value={"-"}, can_be_const=true, content_type=2, category={"Matrix-related operators"}, concept={}, doc={@GamlAnnotations.doc(side_effects="Modifies the field. Use an explicit copy operation to prevent this", value="Subtracts an int value from all the values in the field")})
    public GamaField minus(Integer n) throws GamaRuntimeException {
        int n2 = 0;
        while (n2 < this.matrix.length) {
            if (this.matrix[n2] != this.noDataValue) {
                int n3 = n2;
                this.matrix[n3] = this.matrix[n3] - (double)n.intValue();
            }
            ++n2;
        }
        return this;
    }

    @GamlAnnotations.operator(value={"flatten"}, can_be_const=true, content_type=2, category={"Matrix-related operators"}, concept={}, doc={@GamlAnnotations.doc(side_effects="Does not modify the field but can return the same one. Use an explicit copy operation to prevent this", value="Flattens this field into a grayscale 1-band field. The bands if they exist are supposed to represent RGB components")})
    public GamaField flatten(IScope iScope) throws GamaRuntimeException {
        return this.flatten(iScope, null);
    }

    @GamlAnnotations.operator(value={"flatten"}, can_be_const=true, content_type=2, category={"Matrix-related operators"}, concept={}, doc={@GamlAnnotations.doc(side_effects="Does not modify the field", value="Flattens this field into a 1-band field using the color computer passed in parameter (the same argument as the one used in mesh layers): a palette, a scale, a color. If this computer cannot be interpreted, defaults to flattening interpreting the bands as RGB components")})
    public GamaField flatten(IScope iScope, Object object) throws GamaRuntimeException {
        IMeshColorProvider iMeshColorProvider;
        IMeshColorProvider iMeshColorProvider2 = object instanceof IMeshColorProvider ? (iMeshColorProvider = (IMeshColorProvider)object) : MeshDrawingAttributes.computeColors(object, true);
        GamaField gamaField = (GamaField)GamaFieldType.buildField(iScope, this.numCols, this.numRows);
        double[] dArray = this.getMinMax();
        double[] dArray2 = new double[4];
        int n = 0;
        while (n < this.numCols) {
            int n2 = 0;
            while (n2 < this.numRows) {
                int n3 = n2 * this.numCols + n;
                double[] dArray3 = iMeshColorProvider2.getColor(n3, this.matrix[n3], dArray[0], dArray[1], dArray2);
                gamaField.matrix[n3] = Colors.rgb((int)(dArray3[0] * 255.0), (int)(dArray3[1] * 255.0), (int)(dArray3[2] * 255.0), dArray3[3] * 255.0).getRGB();
                ++n2;
            }
            ++n;
        }
        return gamaField;
    }

    @Override
    public IContainerType getGamlType() {
        return Types.FIELD;
    }
}

