/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.path;

import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.IShape;
import gama.core.metamodel.topology.ITopology;
import gama.core.metamodel.topology.graph.GamaSpatialGraph;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.core.util.file.json.Json;
import gama.core.util.file.json.JsonValue;
import gama.core.util.graph.IGraph;
import gama.core.util.path.IPath;
import gama.gaml.operators.Cast;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;

public class GamaPath<V, E, G extends IGraph<V, E>>
implements Comparable,
GraphPath<V, E>,
IPath<V, E, G> {
    V source;
    V target;
    IList<E> edges;
    double weight = 0.0;
    G graph;
    int graphVersion;

    @Override
    public JsonValue serializeToJson(Json json) {
        return json.typedObject(this.getGamlType(), "source", this.source, "target", this.target, "edges", json.array(this.edges), "weight", this.weight).add("graph", this.graph).add("graphVersion", this.graphVersion);
    }

    public GamaPath() {
    }

    public IType getGamlType() {
        return Types.PATH;
    }

    public GamaPath(G g, V v, V v2, IList<? extends E> iList) {
        this.init(g, v, v2, iList, true);
        this.graph = g;
    }

    public GamaPath(G g, V v, V v2, IList<? extends E> iList, boolean bl) {
        this.init(g, v, v2, iList, bl);
        this.graph = g;
    }

    public GamaPath(IList<? extends V> iList) {
        IList iList2 = GamaListFactory.create();
        int n = 0;
        while (n < iList.size() - 1) {
            E e = this.createEdge(iList.get(n), iList.get(n + 1));
            if (e != null) {
                iList2.add(e);
            }
            ++n;
        }
        this.init(null, iList.get(0), iList.get(iList.size() - 1), iList2, false);
        this.graph = null;
    }

    protected E createEdge(V v, V v2) {
        return null;
    }

    public void init(G g, V v, V v2, IList<? extends E> iList, boolean bl) {
        this.source = v;
        this.target = v2;
        this.edges = GamaListFactory.create();
        this.graphVersion = 0;
        if (iList != null && iList.size() > 0) {
            this.edges.addAll(iList);
        }
    }

    public GamaPath(G g, IList<? extends V> iList) {
        if (!(g instanceof GamaSpatialGraph) && iList.isEmpty()) {
            throw new ClassCastException("We cannot create an empty path in a non-spatial graph");
        }
        if (iList.isEmpty()) {
            this.source = null;
            this.target = null;
        } else {
            this.source = iList.get(0);
            this.target = iList.get(iList.size() - 1);
        }
        this.edges = GamaListFactory.create();
        int n = 0;
        int n2 = iList.size();
        while (n < n2 - 1) {
            this.edges.add(g.getEdge(iList.get(n), iList.get(n + 1)));
            ++n;
        }
        this.graph = g;
    }

    @Override
    public G getGraph() {
        return this.graph;
    }

    @Override
    public V getStartVertex() {
        return this.source;
    }

    @Override
    public V getEndVertex() {
        return this.target;
    }

    @Override
    public IList<E> getEdgeList() {
        return this.edges;
    }

    public void setWeight(double d) {
        this.weight = d;
    }

    @Override
    public double getWeight() {
        Graph graph = this.getGraph();
        if (graph == null) {
            return this.weight;
        }
        return graph.computeWeight(this);
    }

    @Override
    public String stringValue(IScope iScope) {
        return this.serializeToGaml(false);
    }

    @Override
    public GamaPath copy(IScope iScope) {
        return new GamaPath<V, E, G>(this.graph, this.source, this.target, this.edges);
    }

    @Override
    public IList<V> getVertexList() {
        if (this.graph == null) {
            return GamaListFactory.EMPTY_LIST;
        }
        return GamaListFactory.wrap(this.getGamlType().getKeyType(), super.getVertexList());
    }

    @Override
    public double getWeight(IShape iShape) throws GamaRuntimeException {
        return iShape.getGeometry().getPerimeter();
    }

    public String toString() {
        return "path between " + this.getStartVertex().toString() + " and " + this.getEndVertex().toString();
    }

    @Override
    public void acceptVisitor(IAgent iAgent) {
        iAgent.setAttribute("current_path", this);
    }

    @Override
    public void forgetVisitor(IAgent iAgent) {
        iAgent.setAttribute("current_path", null);
    }

    @Override
    public int indexOf(IAgent iAgent) {
        return Cast.asInt(null, iAgent.getAttribute("index_on_path"));
    }

    @Override
    public int indexSegmentOf(IAgent iAgent) {
        return Cast.asInt(null, iAgent.getAttribute("index_on_path_segment"));
    }

    @Override
    public boolean isVisitor(IAgent iAgent) {
        return iAgent.getAttribute("current_path") == this;
    }

    @Override
    public void setIndexOf(IAgent iAgent, int n) {
        iAgent.setAttribute("index_on_path", n);
    }

    @Override
    public void setIndexSegementOf(IAgent iAgent, int n) {
        iAgent.setAttribute("index_on_path_segment", n);
    }

    @Override
    public String serializeToGaml(boolean bl) {
        return "(" + this.getEdgeList().serializeToGaml(bl) + ") as path";
    }

    @Override
    public int getLength() {
        return this.edges.size();
    }

    @Override
    public double getDistance(IScope iScope) {
        if (this.getEdgeList() == null || this.getEdgeList().isEmpty()) {
            return 0.0;
        }
        return this.getWeight();
    }

    @Override
    public ITopology getTopology(IScope iScope) {
        return this.graph instanceof GamaSpatialGraph ? ((GamaSpatialGraph)this.graph).getTopology(iScope) : null;
    }

    @Override
    public void setRealObjects(IMap<IShape, IShape> iMap) {
    }

    @Override
    public IShape getRealObject(Object object) {
        return null;
    }

    @Override
    public void setSource(V v) {
        this.source = v;
    }

    @Override
    public void setTarget(V v) {
        this.target = v;
    }

    @Override
    public int getGraphVersion() {
        return this.graphVersion;
    }

    @Override
    public IList<IShape> getEdgeGeometry() {
        return null;
    }

    @Override
    public IShape getGeometry() {
        return null;
    }

    @Override
    public void setGraph(G g) {
        this.graph = g;
        this.graphVersion = g.getPathComputer().getVersion();
    }

    public int compareTo(Object object) {
        return (int)(this.getWeight() - ((GamaPath)object).getWeight());
    }
}

