/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.architecture.rule_based;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.statements.AbstractStatementSequence;

@GamlAnnotations.inside(symbols={"rules"}, kinds={0, 13, 1})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="when", type={3}, optional=false, doc={@GamlAnnotations.doc(value="The condition to fulfill in order to execute the statements embedded in the rule. when: true makes the rule always activable")}), @GamlAnnotations.facet(name="priority", type={2}, optional=true, doc={@GamlAnnotations.doc(value="An optional priority for the rule, which is used to sort activable rules and run them in that order ")}), @GamlAnnotations.facet(name="name", type={-201}, optional=false, doc={@GamlAnnotations.doc(value="the identifier of the rule")})}, omissible="name")
@GamlAnnotations.doc(value="A simple definition of a rule (set of statements which execution depend on a condition and a priority).")
public class RuleStatement
extends AbstractStatementSequence {
    protected static final String PRIORITY = "priority";
    protected static final String RULE = "do_rule";
    protected final IExpression priority;
    protected final IExpression condition;

    public RuleStatement(IDescription iDescription) {
        super(iDescription);
        this.setName(iDescription.getName());
        this.priority = this.getFacet(PRIORITY);
        this.condition = this.getFacet("when");
    }

    public Double computePriority(IScope iScope) throws GamaRuntimeException {
        return this.priority == null ? 0.0 : Cast.asFloat(iScope, this.priority.value(iScope));
    }

    public Boolean computeCondition(IScope iScope) throws GamaRuntimeException {
        return this.condition == null ? true : Cast.asBool(iScope, this.condition.value(iScope));
    }
}

