/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.descriptions;

import gama.core.common.util.StringUtils;
import gama.dev.DEBUG;
import gama.gaml.compilation.GAML;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.IExpressionDescription;
import gama.gaml.descriptions.LabelExpressionDescription;
import gama.gaml.descriptions.ModelDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.expressions.types.TypeExpression;
import gama.gaml.types.IType;
import gama.gaml.types.ITypesManager;
import gama.gaml.types.Types;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EObject;

public class BasicExpressionDescription
implements IExpressionDescription {
    protected IExpression expression;
    protected EObject target;

    static {
        DEBUG.OFF();
    }

    public BasicExpressionDescription(IExpression iExpression) {
        this.expression = iExpression;
    }

    public BasicExpressionDescription(EObject eObject) {
        this.target = eObject;
    }

    public String toString() {
        return this.serializeToGaml(false);
    }

    public String toOwnString() {
        return this.target.toString();
    }

    @Override
    public String serializeToGaml(boolean bl) {
        return this.expression == null ? this.toOwnString() : this.expression.serializeToGaml(bl);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof IExpressionDescription) {
            return ((IExpressionDescription)object).equalsString(this.toString());
        }
        return false;
    }

    @Override
    public IExpression getExpression() {
        return this.expression;
    }

    @Override
    public void dispose() {
        this.expression = null;
        this.target = null;
    }

    @Override
    public void setExpression(IExpression iExpression) {
        this.expression = iExpression;
    }

    @Override
    public IExpression compile(IDescription iDescription) {
        if (this.expression == null) {
            this.expression = GAML.getExpressionFactory().createExpr(this, iDescription);
        }
        return this.expression;
    }

    @Override
    public IExpressionDescription compileAsLabel() {
        IExpressionDescription iExpressionDescription = LabelExpressionDescription.create(StringUtils.toJavaString(this.toString()));
        iExpressionDescription.setTarget(this.getTarget());
        return iExpressionDescription;
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equalsString(String string) {
        return string == null ? false : string.equals(this.toString());
    }

    @Override
    public EObject getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(EObject eObject) {
        if (this.target == null) {
            this.target = eObject;
        }
    }

    @Override
    public boolean isConst() {
        return false;
    }

    @Override
    public Collection<String> getStrings(IDescription iDescription, boolean bl) {
        return Collections.EMPTY_SET;
    }

    @Override
    public IExpressionDescription cleanCopy() {
        BasicExpressionDescription basicExpressionDescription = new BasicExpressionDescription(this.target);
        basicExpressionDescription.expression = this.expression;
        return basicExpressionDescription;
    }

    @Override
    public IType<?> getDenotedType(IDescription iDescription) {
        this.compile(iDescription);
        if (this.expression == null) {
            return Types.NO_TYPE;
        }
        if (this.expression instanceof TypeExpression) {
            return ((TypeExpression)this.expression).getDenotedType();
        }
        IType<?> iType = this.expression.getGamlType();
        ModelDescription modelDescription = iDescription.getModelDescription();
        if (modelDescription != null) {
            ITypesManager iTypesManager = modelDescription.getTypesManager();
            String string = this.expression.literalValue();
            return iTypesManager.get(string, iType);
        }
        return iType;
    }
}

