/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements.save;

import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.graph.IGraph;
import gama.core.util.graph.writer.GraphExporters;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.statements.save.AbstractSaver;
import gama.gaml.statements.save.SaveOptions;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.io.File;
import java.util.Collections;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.nio.GraphExporter;

public class GraphSaver
extends AbstractSaver {
    @Override
    public void save(IScope iScope, IExpression iExpression, File file2, SaveOptions saveOptions) {
        GraphExporter graphExporter = GraphExporters.getGraphWriter(saveOptions.type);
        IGraph iGraph = Cast.asGraph(iScope, iExpression);
        if (iGraph != null) {
            if (graphExporter == null) {
                throw GamaRuntimeException.error("Format is not recognized ('" + saveOptions.type + "')", iScope);
            }
            graphExporter.exportGraph((Graph)iGraph, file2.getAbsoluteFile());
        }
    }

    @Override
    public Set<String> getFileTypes() {
        return GraphExporters.getAvailableWriters();
    }

    @Override
    public IType getDataType() {
        return Types.GRAPH;
    }

    @Override
    protected Set<String> computeFileTypes() {
        return Collections.EMPTY_SET;
    }
}

