/*
 * Decompiled with CFR 0.152.
 */
package gama.core.common.geometry;

import gama.core.common.geometry.Rotation3D;
import gama.core.metamodel.shape.GamaPoint;
import java.io.Serializable;

public class AxisAngle
implements Serializable,
Cloneable {
    public final GamaPoint axis = new GamaPoint(Rotation3D.PLUS_K);
    public double angle;

    public AxisAngle(GamaPoint gamaPoint, double d) {
        if (gamaPoint != null) {
            this.axis.setLocation(gamaPoint);
        } else {
            this.axis.setLocation(Rotation3D.PLUS_K);
        }
        this.angle = d;
    }

    public AxisAngle(Double d) {
        this.angle = d == null ? 0.0 : d;
    }

    public AxisAngle() {
        this.axis.setLocation(0.0, 0.0, 0.0);
        this.angle = 0.0;
    }

    public String toString() {
        return "(" + this.axis.x + ", " + this.axis.y + ", " + this.axis.z + ", " + this.angle + ")";
    }

    public boolean equals(AxisAngle axisAngle) {
        if (axisAngle == null) {
            return false;
        }
        return this.axis.equals(axisAngle.axis) && this.angle == axisAngle.angle;
    }

    public boolean equals(Object object) {
        if (object instanceof AxisAngle) {
            return this.equals((AxisAngle)object);
        }
        return false;
    }

    public int hashCode() {
        long l = 1L;
        l = 31L * l + Double.doubleToLongBits(this.axis.x);
        l = 31L * l + Double.doubleToLongBits(this.axis.y);
        l = 31L * l + Double.doubleToLongBits(this.axis.z);
        l = 31L * l + Double.doubleToLongBits(this.angle);
        return (int)(l ^ l >> 32);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public final double getAngle() {
        return this.angle;
    }

    public final void setAngle(double d) {
        this.angle = d;
    }

    public double getX() {
        return this.axis.x;
    }

    public final void setX(double d) {
        this.axis.x = d;
    }

    public final double getY() {
        return this.axis.y;
    }

    public final void setY(double d) {
        this.axis.y = d;
    }

    public double getZ() {
        return this.axis.z;
    }

    public final void setZ(double d) {
        this.axis.z = d;
    }

    public GamaPoint getAxis() {
        return this.axis;
    }
}

