/*
 * Decompiled with CFR 0.152.
 */
package gama.core.kernel.batch.exploration.stochanalysis;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.util.FileUtils;
import gama.core.kernel.batch.exploration.AExplorationAlgorithm;
import gama.core.kernel.batch.exploration.stochanalysis.Stochanalysis;
import gama.core.kernel.experiment.BatchAgent;
import gama.core.kernel.experiment.IParameter;
import gama.core.kernel.experiment.ParameterAdapter;
import gama.core.kernel.experiment.ParametersSet;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaMapFactory;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.gaml.compilation.ISymbol;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@GamlAnnotations.inside(kinds={13})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="name", type={-201}, optional=false, internal=true, doc={@GamlAnnotations.doc(value="The name of the method. For internal use only")}), @GamlAnnotations.facet(name="sampling", type={-201}, optional=true, doc={@GamlAnnotations.doc(value="The sampling method to build parameters sets. Available methods are: latinhypercube, orthogonal, factorial, uniform, saltelli, morris")}), @GamlAnnotations.facet(name="outputs", type={5}, optional=false, doc={@GamlAnnotations.doc(value="The list of output variables to analyse")}), @GamlAnnotations.facet(name="sample", type={1}, optional=true, doc={@GamlAnnotations.doc(value="The number of sample required , 10 by default")}), @GamlAnnotations.facet(name="report", type={4}, optional=false, doc={@GamlAnnotations.doc(value="The path to the file where the Sobol report will be written")}), @GamlAnnotations.facet(name="results", type={4}, optional=true, doc={@GamlAnnotations.doc(value="The path to the file where the automatic batch report will be written")}), @GamlAnnotations.facet(name="iterations", type={1}, optional=true, doc={@GamlAnnotations.doc(value="The number of iteration for orthogonal sampling, 5 by default")})}, omissible="name")
@GamlAnnotations.doc(value="This algorithm runs an exploration with a given sampling to compute a Stochasticity Analysis", usages={@GamlAnnotations.usage(value="For example: ", examples={@GamlAnnotations.example(value="method stochanalyse sampling:'latinhypercube' outputs:['my_var'] replicat:10 report:'../path/to/report/file.txt'; ", isExecutable=false)})})
public class StochanalysisExploration
extends AExplorationAlgorithm {
    private List<IParameter.Batch> parameters;
    private IList<Object> outputs;
    protected IMap<ParametersSet, Map<String, List<Object>>> res_outputs;

    public StochanalysisExploration(IDescription iDescription) {
        super(iDescription);
    }

    @Override
    public void setChildren(Iterable<? extends ISymbol> iterable) {
    }

    @Override
    public void explore(IScope iScope) throws GamaRuntimeException {
        Object object;
        Object object222;
        List<IParameter.Batch> list = this.parameters = this.parameters == null ? new ArrayList<IParameter.Batch>(this.currentExperiment.getParametersToExplore()) : this.parameters;
        if (this.hasFacet("sample")) {
            this.sample_size = Cast.asInt(iScope, this.getFacet("sample").value(iScope));
        }
        List<ParametersSet> list2 = this.getExperimentPlan(this.parameters, iScope);
        this.res_outputs = this.currentExperiment.runSimulationsAndReturnResults(list2);
        IExpression iExpression = this.getFacet("outputs");
        this.outputs = Cast.asList(iScope, iScope.evaluate(iExpression, this.currentExperiment).getValue());
        LinkedHashMap<String, Map<ParametersSet, Map<String, List<Double>>>> linkedHashMap = new LinkedHashMap<String, Map<ParametersSet, Map<String, List<Double>>>>();
        for (Object object222 : this.outputs) {
            IMap iMap22;
            object = GamaMapFactory.create();
            for (IMap iMap22 : this.res_outputs.keySet()) {
                object.put(iMap22, (List)((Map)this.res_outputs.get(iMap22)).get(object222.toString()));
            }
            iMap22 = GamaMapFactory.create();
            for (String string2 : Stochanalysis.SA) {
                IMap<ParametersSet, List<Double>> iMap = Stochanalysis.stochasticityAnalysis((IMap<ParametersSet, List<Object>>)object, string2, iScope);
                for (ParametersSet parametersSet : object.keySet()) {
                    if (!iMap22.containsKey(parametersSet)) {
                        iMap22.put(parametersSet, Stochanalysis.SA.stream().collect(Collectors.toMap(Function.identity(), string -> new ArrayList())));
                    }
                    ((Map)iMap22.get(parametersSet)).put(string2, (List)iMap.get(parametersSet));
                }
            }
            linkedHashMap.put(object222.toString(), iMap22);
        }
        object222 = Cast.asString(iScope, this.getFacet("report").value(iScope));
        File file2 = new File(FileUtils.constructAbsoluteFilePath(iScope, object222, false));
        object = file2.getParentFile();
        if (!((File)object).exists()) {
            ((File)object).mkdirs();
        }
        if (file2.exists()) {
            file2.delete();
        }
        Stochanalysis.writeAndTellReport(file2, linkedHashMap, this.sample_size, this.currentExperiment.getSeeds().length, iScope);
        if (this.hasFacet("outputs") && this.hasFacet("results")) {
            this.saveRawResults(iScope, this.res_outputs);
        }
        if (this.hasFacet("outputs") && this.hasFacet("results")) {
            GAMA.reportAndThrowIfNeeded(iScope, GamaRuntimeException.warning("Facet " + (this.hasFacet("outputs") ? "results" : "outputs") + " is missing - raw results won't be saved", iScope), false);
        }
    }

    @Override
    public void addParametersTo(List<IParameter.Batch> list, final BatchAgent batchAgent) {
        super.addParametersTo(list, batchAgent);
        list.add(new ParameterAdapter("Sampling method", "stochanalyse", 4){

            @Override
            public Object value() {
                return StochanalysisExploration.this.hasFacet("sampling") ? Cast.asString(batchAgent.getScope(), StochanalysisExploration.this.getFacet("sampling").value(batchAgent.getScope())) : "Exhaustive";
            }
        });
        list.add(new ParameterAdapter("Sample size", "stochanalyse", 4){

            @Override
            public Object value() {
                return StochanalysisExploration.this.sample_size;
            }
        });
    }
}

