/*
 * Decompiled with CFR 0.152.
 */
package gama.core.kernel.batch.optimization.genetic;

import gama.core.kernel.batch.optimization.genetic.Chromosome;
import gama.core.kernel.batch.optimization.genetic.GeneticAlgorithm;
import gama.core.kernel.batch.optimization.genetic.Initialization;
import gama.core.kernel.experiment.IParameter;
import gama.core.runtime.IScope;
import gama.core.runtime.concurrent.GamaExecutorService;
import gama.core.runtime.exceptions.GamaRuntimeException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class InitializationUniform
implements Initialization {
    @Override
    public List<Chromosome> initializePop(IScope iScope, List<IParameter.Batch> list, GeneticAlgorithm geneticAlgorithm) throws GamaRuntimeException {
        ArrayList<Chromosome> arrayList = new ArrayList<Chromosome>();
        int n = geneticAlgorithm.getNbPrelimGenerations();
        int n2 = geneticAlgorithm.getPopulationDim();
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                arrayList.add(new Chromosome(iScope, list, true));
                ++n4;
            }
            ++n3;
        }
        if (GamaExecutorService.shouldRunAllSimulationsInParallel(iScope.getExperiment())) {
            geneticAlgorithm.computePopFitnessAll(iScope, arrayList);
        } else {
            geneticAlgorithm.computePopFitness(iScope, arrayList);
        }
        ArrayList<Chromosome> arrayList2 = new ArrayList<Chromosome>(arrayList);
        Collections.sort(arrayList2);
        if (geneticAlgorithm.isMaximize()) {
            Collections.reverse(arrayList2);
        }
        return arrayList2.subList(0, n2 - 1);
    }
}

