/*
 * Decompiled with CFR 0.152.
 */
package gama.core.metamodel.agent;

import gama.core.common.util.RandomUtils;
import gama.core.kernel.simulation.SimulationAgent;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.agent.IMacroAgent;
import gama.core.metamodel.agent.ISerialisedAgent;
import gama.core.metamodel.population.IPopulation;
import gama.core.metamodel.population.ISerialisedPopulation;
import gama.core.metamodel.population.SerialisedGrid;
import gama.core.metamodel.population.SerialisedPopulation;
import gama.core.metamodel.topology.grid.GridPopulation;
import gama.core.metamodel.topology.grid.IGridAgent;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.IList;
import gama.core.util.file.json.Json;
import gama.core.util.file.json.JsonGamlAgent;
import gama.core.util.file.json.JsonValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public record SerialisedAgent(int index, String species, Map<String, Object> attributes, Map<String, ISerialisedPopulation> innerPopulations) implements ISerialisedAgent
{
    public static final Set<String> NON_SERIALISABLE = Set.of("members", "agents", "location", "host", "peers", "experiment", "world", "time", "machine_time", "duration", "average_duration", "total_duration", "index");
    public static final Set<String> GRID_NON_SERIALISABLE = Set.of("grid_x", "grid_y", "neighbors");
    public static final String HISTORY_KEY = "**history**";
    public static final String SERIALISE_HISTORY = "**serialise_history**";

    public static SerialisedAgent of(IAgent iAgent, boolean bl) {
        SimulationAgent simulationAgent;
        int n = iAgent.getIndex();
        String string = iAgent.getSpeciesName();
        Map<String, Object> map = SerialisedAgent.filterAttributes(iAgent, iAgent instanceof IGridAgent, iAgent.getAttributes(true), bl);
        Map<String, ISerialisedPopulation> map2 = SerialisedAgent.filterPopulations(iAgent, iAgent instanceof IGridAgent, iAgent.getAttributes(true), bl);
        SerialisedAgent serialisedAgent = new SerialisedAgent(n, string, map, map2);
        if (iAgent instanceof SimulationAgent && !SerialisedAgent.shouldSerializeHistory(simulationAgent = (SimulationAgent)iAgent)) {
            serialisedAgent.attributes().remove(HISTORY_KEY);
        }
        return serialisedAgent;
    }

    public static SerialisedAgent of(int n, String string, Map<String, Object> map) {
        return new SerialisedAgent(n, string, map, Collections.EMPTY_MAP);
    }

    private static Map<String, ISerialisedPopulation> filterPopulations(IAgent iAgent, boolean bl, Map<String, Object> map, boolean bl2) {
        if (!bl2) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, ISerialisedPopulation> hashMap = new HashMap<String, ISerialisedPopulation>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            IPopulation iPopulation;
            Object object = entry.getValue();
            if (!(object instanceof IPopulation)) continue;
            hashMap.put(entry.getKey(), (ISerialisedPopulation)((Object)((iPopulation = (IPopulation)object).isGrid() ? new SerialisedGrid((GridPopulation)iPopulation) : new SerialisedPopulation(iPopulation))));
        }
        return hashMap;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public static Map<String, Object> filterAttributes(IAgent iAgent, boolean bl, Map<String, Object> map, boolean bl2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String string = entry.getKey();
            Object object = entry.getValue();
            if (NON_SERIALISABLE.contains(string) || bl && GRID_NON_SERIALISABLE.contains(string) || bl2 && object instanceof IPopulation) continue;
            hashMap.put(string, object);
        }
        boolean bl3 = iAgent instanceof SimulationAgent;
        if (bl3) {
            SimulationAgent simulationAgent = (SimulationAgent)iAgent;
            hashMap.put("seed", simulationAgent.getSeed());
            hashMap.put("rng", simulationAgent.getRng());
            hashMap.put("rng_usage", simulationAgent.getUsage());
            hashMap.put("cycle", simulationAgent.getClock().getCycle());
        }
        if (!bl) {
            hashMap.put("shape", iAgent.getGeometry());
        }
        hashMap.put("name", iAgent.getName());
        return hashMap;
    }

    @Override
    public Object getAttributeValue(String string) {
        return this.attributes.get(string);
    }

    @Override
    public void setAttributeValue(String string, Object object) {
        this.attributes.put(string, object);
    }

    @Override
    public IAgent restoreInto(IScope iScope, IPopulation<? extends IAgent> iPopulation) throws GamaRuntimeException {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        arrayList.add(this.attributes);
        IList<? extends IAgent> iList = iPopulation.createAgents(iScope, 1, arrayList, true, true);
        IAgent iAgent = (IAgent)iList.get(0);
        this.restoreAs(iScope, iAgent);
        return iAgent;
    }

    @Override
    public void restoreAs(IScope iScope, IAgent iAgent) {
        this.attributes().forEach((string, object) -> iAgent.setDirectVarValue(iScope, (String)string, object));
        if (iAgent instanceof IMacroAgent) {
            IMacroAgent iMacroAgent = (IMacroAgent)iAgent;
            if (this.innerPopulations != null) {
                this.innerPopulations.forEach((string, iSerialisedPopulation) -> {
                    IPopulation<? extends IAgent> iPopulation = iMacroAgent.getMicroPopulation((String)string);
                    if (iPopulation != null) {
                        if (iSerialisedPopulation instanceof SerialisedGrid) {
                            SerialisedGrid serialisedGrid = (SerialisedGrid)iSerialisedPopulation;
                            serialisedGrid.restoreAs(iScope, iPopulation);
                        } else if (iSerialisedPopulation instanceof SerialisedPopulation) {
                            SerialisedPopulation serialisedPopulation = (SerialisedPopulation)iSerialisedPopulation;
                            serialisedPopulation.restoreAs(iScope, iPopulation);
                        }
                    }
                });
                if (iAgent instanceof SimulationAgent) {
                    SimulationAgent simulationAgent = (SimulationAgent)iAgent;
                    Map<String, Object> map = this.attributes();
                    Double d = (Double)map.remove("seed");
                    String string2 = (String)map.remove("rng");
                    Integer n = (Integer)map.remove("rng_usage");
                    simulationAgent.setRandomGenerator(new RandomUtils(d, string2));
                    simulationAgent.setUsage(n);
                    Integer n2 = (Integer)simulationAgent.getAttribute("cycle");
                    simulationAgent.getClock().setCycleNoCheck(n2);
                }
            }
        }
    }

    @Override
    public JsonValue serializeToJson(Json json) {
        JsonGamlAgent jsonGamlAgent = (JsonGamlAgent)json.agent(this.species, this.index).add("attributes", this.attributes);
        if (this.innerPopulations != null && !this.innerPopulations.isEmpty()) {
            jsonGamlAgent.add("populations", this.innerPopulations);
        }
        return jsonGamlAgent;
    }

    public IAgent recreateIn(IScope iScope) {
        IPopulation<? extends IAgent> iPopulation = iScope.getSimulation().getPopulationFor(this.species);
        if (iPopulation == null) {
            throw GamaRuntimeException.error("No population named" + this.species + " exist in this simulation", iScope);
        }
        IAgent iAgent = iPopulation.getOrCreateAgent(iScope, this.index);
        this.restoreAs(iScope, iAgent);
        return iAgent;
    }

    static boolean shouldSerializeHistory(SimulationAgent simulationAgent) {
        return simulationAgent.hasAttribute(SERIALISE_HISTORY) && (Boolean)simulationAgent.getAttribute(SERIALISE_HISTORY) != false;
    }
}

