/*
 * Decompiled with CFR 0.152.
 */
package gama.core.metamodel.population;

import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.population.IPopulation;
import gama.core.runtime.IScope;
import java.util.Collection;
import java.util.LinkedList;

public class PopulationNotifier
implements IPopulation.Listener {
    private LinkedList<IPopulation.Listener> listeners;

    private boolean hasListeners() {
        return this.listeners != null && !this.listeners.isEmpty();
    }

    public void addListener(IPopulation.Listener listener) {
        if (this.listeners == null) {
            this.listeners = new LinkedList();
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(IPopulation.Listener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    @Override
    public void notifyAgentRemoved(IScope iScope, IPopulation<? extends IAgent> iPopulation, IAgent iAgent) {
        if (!this.hasListeners()) {
            return;
        }
        try {
            for (IPopulation.Listener listener : this.listeners) {
                listener.notifyAgentRemoved(iScope, iPopulation, iAgent);
            }
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
    }

    @Override
    public void notifyAgentAdded(IScope iScope, IPopulation<? extends IAgent> iPopulation, IAgent iAgent) {
        if (!this.hasListeners()) {
            return;
        }
        try {
            for (IPopulation.Listener listener : this.listeners) {
                listener.notifyAgentAdded(iScope, iPopulation, iAgent);
            }
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
    }

    @Override
    public void notifyAgentsAdded(IScope iScope, IPopulation<? extends IAgent> iPopulation, Collection<? extends IAgent> collection) {
        if (!this.hasListeners()) {
            return;
        }
        LinkedList<? extends IAgent> linkedList = new LinkedList<IAgent>(collection);
        try {
            for (IPopulation.Listener listener : this.listeners) {
                listener.notifyAgentsAdded(iScope, iPopulation, linkedList);
            }
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
    }

    @Override
    public void notifyAgentsRemoved(IScope iScope, IPopulation<? extends IAgent> iPopulation, Collection<? extends IAgent> collection) {
        if (!this.hasListeners()) {
            return;
        }
        try {
            for (IPopulation.Listener listener : this.listeners) {
                listener.notifyAgentsRemoved(iScope, iPopulation, collection);
            }
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
    }

    @Override
    public void notifyPopulationCleared(IScope iScope, IPopulation<? extends IAgent> iPopulation) {
        if (!this.hasListeners()) {
            return;
        }
        try {
            for (IPopulation.Listener listener : this.listeners) {
                listener.notifyPopulationCleared(iScope, iPopulation);
            }
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
    }

    public void clear() {
        this.listeners = null;
    }
}

