/*
 * Decompiled with CFR 0.152.
 */
package gama.core.metamodel.shape;

import gama.core.metamodel.shape.IShape;
import java.util.Objects;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceComparator;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.GeometryFilter;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;

public class DynamicLineString
extends LineString
implements Cloneable {
    final IShape source;
    final IShape target;

    public DynamicLineString(GeometryFactory geometryFactory, IShape iShape, IShape iShape2) {
        super(null, geometryFactory);
        this.source = iShape;
        this.target = iShape2;
    }

    public String getGeometryType() {
        return "LineString";
    }

    public Coordinate getCoordinate() {
        return this.source.getLocation();
    }

    public Coordinate[] getCoordinates() {
        return new Coordinate[]{this.source.getLocation(), this.target.getLocation()};
    }

    public CoordinateSequence getCoordinateSequence() {
        return this.getFactory().getCoordinateSequenceFactory().create(this.getCoordinates());
    }

    public int getNumPoints() {
        return 2;
    }

    public boolean isEmpty() {
        return false;
    }

    public int getDimension() {
        return 1;
    }

    public Geometry getBoundary() {
        return this.getFactory().createMultiPoint(new Point[]{this.getStartPoint(), this.getEndPoint()});
    }

    public Point getStartPoint() {
        return this.getFactory().createPoint(this.getCoordinate());
    }

    public Point getEndPoint() {
        return this.getFactory().createPoint((Coordinate)this.target.getLocation());
    }

    public int getBoundaryDimension() {
        return 0;
    }

    public LineString reverse() {
        return new DynamicLineString(this.getFactory(), this.target, this.source);
    }

    public boolean equalsExact(Geometry geometry, double d) {
        if (!(geometry instanceof DynamicLineString)) {
            return false;
        }
        DynamicLineString dynamicLineString = (DynamicLineString)geometry;
        return Objects.equals(dynamicLineString.source, this.source) && Objects.equals(dynamicLineString.target, this.target);
    }

    public int hashCode() {
        int n = this.source == null ? 0 : this.source.hashCode();
        return 31 * n + (this.target == null ? 0 : this.target.hashCode());
    }

    public void apply(CoordinateFilter coordinateFilter) {
        coordinateFilter.filter(this.getCoordinate());
        coordinateFilter.filter((Coordinate)this.target.getLocation());
    }

    public void apply(CoordinateSequenceFilter coordinateSequenceFilter) {
        CoordinateSequence coordinateSequence = this.getCoordinateSequence();
        coordinateSequenceFilter.filter(coordinateSequence, 0);
        if (coordinateSequenceFilter.isDone()) {
            return;
        }
        coordinateSequenceFilter.filter(coordinateSequence, 1);
        if (coordinateSequenceFilter.isGeometryChanged()) {
            this.geometryChanged();
        }
    }

    public void apply(GeometryFilter geometryFilter) {
        geometryFilter.filter((Geometry)this);
    }

    public void apply(GeometryComponentFilter geometryComponentFilter) {
        geometryComponentFilter.filter((Geometry)this);
    }

    public boolean isSimple() {
        return true;
    }

    public boolean isValid() {
        return true;
    }

    public void normalize() {
    }

    public final Object clone() {
        DynamicLineString dynamicLineString = new DynamicLineString(this.getFactory(), this.source, this.target);
        dynamicLineString.setUserData(this.getUserData());
        return dynamicLineString;
    }

    protected Envelope computeEnvelopeInternal() {
        CoordinateSequence coordinateSequence = this.getFactory().getCoordinateSequenceFactory().create(this.getCoordinates());
        return coordinateSequence.expandEnvelope(new Envelope());
    }

    protected int compareToSameClass(Object object) {
        DynamicLineString dynamicLineString = (DynamicLineString)object;
        int n = this.source.getLocation().compareTo(dynamicLineString.source.getLocation());
        if (n != 0) {
            return n;
        }
        return this.target.getLocation().compareTo(dynamicLineString.target.getLocation());
    }

    protected int compareToSameClass(Object object, CoordinateSequenceComparator coordinateSequenceComparator) {
        DynamicLineString dynamicLineString = (DynamicLineString)object;
        return coordinateSequenceComparator.compare((Object)this.getCoordinateSequence(), (Object)dynamicLineString.getCoordinateSequence());
    }

    protected boolean isEquivalentClass(Geometry geometry) {
        return geometry instanceof DynamicLineString;
    }

    public boolean isRing() {
        return false;
    }

    public boolean isClosed() {
        return false;
    }

    public Point getPointN(int n) {
        if (n == 0) {
            return this.getFactory().createPoint(this.getCoordinate());
        }
        if (n == 1) {
            return this.getFactory().createPoint((Coordinate)this.target.getLocation());
        }
        return null;
    }

    public Coordinate getCoordinateN(int n) {
        if (n == 0) {
            return this.getCoordinate();
        }
        if (n == 1) {
            return this.target.getLocation();
        }
        return null;
    }

    public IShape getSource() {
        return this.source;
    }

    public IShape getTarget() {
        return this.target;
    }
}

