/*
 * Decompiled with CFR 0.152.
 */
package gama.core.runtime.concurrent;

import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.IShape;
import java.util.List;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;

public class AgentSpliterator
implements Spliterator<IAgent> {
    int begin;
    final int end;
    final int threshold;
    final IShape[] agents;

    public static Spliterator<IAgent> of(IShape[] iShapeArray, int n) {
        if (iShapeArray == null || iShapeArray.length == 0) {
            return Spliterators.emptySpliterator();
        }
        return new AgentSpliterator(iShapeArray, 0, iShapeArray.length, n);
    }

    public static Spliterator<IAgent> of(List<? extends IShape> list, int n) {
        int n2 = list.size();
        return new AgentSpliterator(list.toArray(new IAgent[n2]), 0, n2, n);
    }

    private AgentSpliterator(IShape[] iShapeArray, int n, int n2, int n3) {
        this.begin = n;
        this.end = n2;
        this.threshold = n3;
        this.agents = iShapeArray;
    }

    @Override
    public void forEachRemaining(Consumer<? super IAgent> consumer) {
        int n = this.begin;
        while (n < this.end) {
            consumer.accept((IAgent)this.agents[n]);
            ++n;
        }
    }

    @Override
    public boolean tryAdvance(Consumer<? super IAgent> consumer) {
        return true;
    }

    public AgentSpliterator trySplit() {
        int n = this.end - this.begin;
        if (n <= this.threshold) {
            return null;
        }
        int n2 = this.begin + n / 2;
        AgentSpliterator agentSpliterator = new AgentSpliterator(this.agents, this.begin, n2, this.threshold);
        this.begin = n2;
        return agentSpliterator;
    }

    @Override
    public long estimateSize() {
        return (long)this.end - (long)this.begin;
    }

    @Override
    public int characteristics() {
        return 5200;
    }
}

