/*
 * Decompiled with CFR 0.152.
 */
package gama.core.runtime.concurrent;

import gama.core.common.preferences.GamaPreferences;
import gama.core.common.preferences.Pref;
import gama.core.kernel.experiment.IExperimentAgent;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.ExecutionResult;
import gama.core.runtime.FlowStatus;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.benchmark.StopWatch;
import gama.core.runtime.concurrent.ParallelAgentRunner;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.IList;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.species.ISpecies;
import gama.gaml.statements.IExecutable;
import gama.gaml.types.GamaType;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;

public abstract class GamaExecutorService {
    public static final Thread.UncaughtExceptionHandler EXCEPTION_HANDLER = new GamaMemoryExceptionHandler();
    public static volatile ForkJoinPool AGENT_PARALLEL_EXECUTOR;
    public static final Pref<Boolean> CONCURRENCY_SIMULATIONS;
    public static final Pref<Boolean> CONCURRENCY_SIMULATIONS_ALL;
    public static final Pref<Boolean> CONCURRENCY_GRID;
    public static final Pref<Boolean> CONCURRENCY_SPECIES;
    public static final Pref<Integer> CONCURRENCY_THRESHOLD;
    public static final Pref<Integer> THREADS_NUMBER;

    static {
        CONCURRENCY_SIMULATIONS = GamaPreferences.create("pref_parallel_simulations", "Make experiments run simulations in parallel", true, 3, true).in("Execution", "Parallelism");
        CONCURRENCY_SIMULATIONS_ALL = GamaPreferences.create("pref_parallel_simulations_all", "In batch, allows to run simulations with all available processors[WARNING: disables reflexes and permanent displays of batch experiments]", false, 3, true).in("Execution", "Parallelism");
        CONCURRENCY_GRID = GamaPreferences.create("pref_parallel_grids", "Make grids schedule their agents in parallel (beware that setting this to true no longer allows GAMA to ensure the reproducibility of simulations)", false, 3, true).in("Execution", "Parallelism");
        CONCURRENCY_SPECIES = GamaPreferences.create("pref_parallel_species", "Make species schedule their agents in parallel (beware that setting this to true no longer allows GAMA to ensure the reproducibility of simulations)", false, 3, true).in("Execution", "Parallelism");
        CONCURRENCY_THRESHOLD = GamaPreferences.create("pref_parallel_threshold", "Number under which agents are executed sequentially", 20, 1, true).between(Integer.valueOf(1), null).in("Execution", "Parallelism");
        THREADS_NUMBER = GamaPreferences.create("pref_parallel_threads", "Max. number of threads to use (available processors: " + Runtime.getRuntime().availableProcessors() + ")", 4, 1, true).between(Integer.valueOf(1), null).in("Execution", "Parallelism").onChange(n -> {
            GamaExecutorService.reset();
            System.setProperty("java.util.concurrent.ForkJoinPool.common.parallelism", String.valueOf(n));
        });
    }

    public static void reset() {
        GamaExecutorService.setConcurrencyLevel(THREADS_NUMBER.getValue());
    }

    public static void setConcurrencyLevel(int n) {
        if (AGENT_PARALLEL_EXECUTOR != null) {
            AGENT_PARALLEL_EXECUTOR.shutdown();
        }
        AGENT_PARALLEL_EXECUTOR = new ForkJoinPool(n){

            @Override
            public Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
                return EXCEPTION_HANDLER;
            }
        };
    }

    public static int getParallelism(IScope iScope, IExpression iExpression, Caller caller) {
        switch (GamaType.of(iExpression).id()) {
            case 3: {
                Boolean bl = (Boolean)iExpression.value(iScope);
                if (Boolean.FALSE.equals(bl)) {
                    return 0;
                }
                if (caller == Caller.SIMULATION) {
                    return THREADS_NUMBER.getValue();
                }
                return CONCURRENCY_THRESHOLD.getValue();
            }
            case 1: {
                return Math.abs((Integer)iExpression.value(iScope));
            }
        }
        return switch (caller) {
            case Caller.SIMULATION -> {
                if (CONCURRENCY_SIMULATIONS.getValue().booleanValue()) {
                    yield THREADS_NUMBER.getValue();
                }
                yield 0;
            }
            case Caller.SPECIES -> {
                if (CONCURRENCY_SPECIES.getValue().booleanValue()) {
                    yield CONCURRENCY_THRESHOLD.getValue();
                }
                yield 0;
            }
            case Caller.GRID -> {
                if (CONCURRENCY_GRID.getValue().booleanValue()) {
                    yield CONCURRENCY_THRESHOLD.getValue();
                }
                yield 0;
            }
            default -> 0;
        };
    }

    public static void executeThreaded(Runnable runnable) {
        AGENT_PARALLEL_EXECUTOR.invoke(ForkJoinTask.adapt(runnable));
    }

    public static <A extends IAgent> Boolean step(IScope iScope, IList<A> iList, ISpecies iSpecies) throws GamaRuntimeException {
        IExpression iExpression = iSpecies.getSchedule();
        IList iList2 = iExpression == null ? iList : Cast.asList(iScope, iExpression.value(iScope));
        int n = GamaExecutorService.getParallelism(iScope, iSpecies.getConcurrency(), iSpecies.isGrid() ? Caller.GRID : Caller.SPECIES);
        return GamaExecutorService.doStep((IScope)iScope, (IShape[])iList2.toArray(new IAgent[iList2.size()]), (int)n, (ISpecies)iSpecies);
    }

    public static <A extends IShape> Boolean step(IScope iScope, A[] AArray, ISpecies iSpecies) throws GamaRuntimeException {
        Object[] objectArray;
        IExpression iExpression = iSpecies.getSchedule();
        if (iExpression == null) {
            objectArray = AArray;
        } else {
            IList iList = Cast.asList(iScope, iExpression.value(iScope));
            objectArray = iList.toArray(new IAgent[iList.size()]);
        }
        int n = GamaExecutorService.getParallelism(iScope, iSpecies.getConcurrency(), iSpecies.isGrid() ? Caller.GRID : Caller.SPECIES);
        return GamaExecutorService.doStep((IScope)iScope, objectArray, (int)n, (ISpecies)iSpecies);
    }

    private static <A extends IShape> Boolean doStep(IScope iScope, A[] AArray, int n, ISpecies iSpecies) {
        Throwable throwable = null;
        Object var5_6 = null;
        try (StopWatch stopWatch = GAMA.benchmark(iScope, iSpecies);){
            int n2 = n;
            if (AArray.length <= n) {
                n2 = 0;
            }
            switch (n2) {
                case 0: {
                    A[] AArray2 = AArray;
                    int n3 = AArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        A a = AArray2[n4];
                        IAgent iAgent = (IAgent)a;
                        if (!iAgent.dead() && !iScope.step(iAgent).passed()) {
                            return false;
                        }
                        ++n4;
                    }
                    break;
                }
                case 1: {
                    A[] AArray3 = AArray;
                    int n5 = AArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        Object a = AArray3[n6];
                        GamaExecutorService.executeThreaded(() -> {
                            ExecutionResult executionResult = iScope.step((IAgent)a);
                        });
                        ++n6;
                    }
                    break;
                }
                default: {
                    ParallelAgentRunner.step((IScope)iScope, AArray, (int)n);
                    break;
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return true;
    }

    public static <A extends IShape> void execute(IScope iScope, IExecutable iExecutable, A[] AArray, IExpression iExpression) throws GamaRuntimeException {
        int n = GamaExecutorService.getParallelism(iScope, iExpression, Caller.NONE);
        if (AArray.length <= n) {
            n = 0;
        }
        switch (n) {
            case 0: {
                A[] AArray2 = AArray;
                int n2 = AArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    A a = AArray2[n3];
                    iScope.execute(iExecutable, (IAgent)a, null);
                    if (iScope.getAndClearBreakStatus() == FlowStatus.BREAK) break;
                    ++n3;
                }
                return;
            }
            case 1: {
                A[] AArray3 = AArray;
                int n4 = AArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    Object a = AArray3[n5];
                    GamaExecutorService.executeThreaded(() -> {
                        ExecutionResult executionResult = iScope.execute(iExecutable, (IAgent)a, null);
                    });
                    ++n5;
                }
                return;
            }
        }
        ParallelAgentRunner.execute((IScope)iScope, (IExecutable)iExecutable, AArray, (int)n);
    }

    public static void execute(IScope iScope, IExecutable iExecutable, List<? extends IAgent> list, IExpression iExpression) throws GamaRuntimeException {
        GamaExecutorService.execute((IScope)iScope, (IExecutable)iExecutable, (IShape[])list.toArray(new IAgent[list.size()]), (IExpression)iExpression);
    }

    public static boolean shouldRunAllSimulationsInParallel(IExperimentAgent iExperimentAgent) {
        boolean bl = CONCURRENCY_SIMULATIONS_ALL.getValue();
        return iExperimentAgent == null ? bl : bl || iExperimentAgent.isHeadless() && iExperimentAgent.getSpecies().isBatch();
    }

    public static enum Caller {
        SPECIES,
        GRID,
        NONE,
        SIMULATION;

    }

    static class GamaMemoryExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        long lastWarningTimeStamp = 0L;

        GamaMemoryExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            if (throwable instanceof OutOfMemoryError) {
                long l = System.currentTimeMillis();
                if (l - this.lastWarningTimeStamp > 60000L) {
                    this.lastWarningTimeStamp = l;
                    String string = throwable.getMessage();
                    String string2 = string = string == null ? "" : string.toLowerCase();
                    if (GamaPreferences.Runtime.CORE_MEMORY_ACTION.getValue().booleanValue() && GAMA.getExperiment() != null && string.contains("heap")) {
                        GAMA.getGui().openMessageDialog(GAMA.getRuntimeScope(), "GAMA is out of memory. Experiment will be closed now. Please consult: https://gama-platform.org/wiki/Troubleshooting#memory-problems");
                        GAMA.closeAllExperiments(true, true);
                    } else {
                        if (GAMA.getExperiment() != null && !string.contains("heap")) {
                            GAMA.getGui().openMessageDialog(GAMA.getRuntimeScope(), "GAMA cannot allocate more memory for displaying this experiment. The platform will exit now. Please try to quit other applications and relaunch it");
                        } else {
                            GAMA.getGui().openMessageDialog(GAMA.getRuntimeScope(), "Your system is running out of memory. GAMA will exit now. Please try to quit other applications and relaunch it");
                        }
                        System.exit(0);
                    }
                }
            } else {
                throwable.printStackTrace();
            }
        }
    }
}

