/*
 * Decompiled with CFR 0.152.
 */
package gama.core.runtime.concurrent;

import gama.core.kernel.experiment.IExperimentPlan;
import gama.core.kernel.simulation.SimulationAgent;
import gama.core.kernel.simulation.SimulationPopulation;
import gama.core.runtime.concurrent.GamaExecutorService;
import gama.core.runtime.concurrent.ISimulationRunner;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class SimulationRunnerOld
implements ISimulationRunner {
    public volatile ExecutorService executor;
    final Map<SimulationAgent, Callable<Boolean>> runnables;
    final int concurrency;
    volatile int activeThreads;

    public static ISimulationRunner of(SimulationPopulation simulationPopulation) {
        int n = 0;
        IExperimentPlan iExperimentPlan = simulationPopulation.getHost().getSpecies();
        n = iExperimentPlan.isHeadless() && !iExperimentPlan.isBatch() ? 1 : GamaExecutorService.getParallelism(simulationPopulation.getHost().getScope(), iExperimentPlan.getConcurrency(), GamaExecutorService.Caller.SIMULATION);
        return new SimulationRunnerOld(n < 0 ? 1 : n);
    }

    private SimulationRunnerOld(int n) {
        this.concurrency = n;
        this.runnables = new LinkedHashMap<SimulationAgent, Callable<Boolean>>();
    }

    @Override
    public void remove(SimulationAgent simulationAgent) {
        this.runnables.remove(simulationAgent);
    }

    @Override
    public void add(SimulationAgent simulationAgent) {
        this.add(simulationAgent, () -> {
            this.activeThreads = this.computeNumberOfThreads();
            return simulationAgent.step();
        });
    }

    private void add(SimulationAgent simulationAgent, Callable<Boolean> callable) {
        this.runnables.put(simulationAgent, callable);
    }

    @Override
    public void step() {
        try {
            this.getExecutor().invokeAll(this.runnables.values());
        }
        catch (InterruptedException interruptedException) {}
    }

    private int computeNumberOfThreads() {
        int n;
        ExecutorService executorService = this.getExecutor();
        if (executorService instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)executorService;
            n = Math.min(this.concurrency, threadPoolExecutor.getActiveCount());
        } else {
            n = 1;
        }
        return n;
    }

    protected ExecutorService getExecutor() {
        return this.executor == null ? (this.executor = this.concurrency == 0 ? Executors.newSingleThreadExecutor() : new Executor(GamaExecutorService.THREADS_NUMBER.getValue())) : this.executor;
    }

    @Override
    public void dispose() {
        this.runnables.clear();
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    @Override
    public Set<SimulationAgent> getStepable() {
        return this.runnables.keySet();
    }

    @Override
    public int getActiveThreads() {
        return this.activeThreads;
    }

    @Override
    public boolean hasSimulations() {
        return this.runnables.size() > 0;
    }

    static class Executor
    extends ThreadPoolExecutor {
        Executor(int n) {
            super(n, n, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        }

        @Override
        protected void afterExecute(Runnable runnable, Throwable throwable) {
            Throwable throwable2 = throwable;
            super.afterExecute(runnable, throwable2);
            if (throwable2 == null && runnable instanceof Future) {
                try {
                    Future future = (Future)((Object)runnable);
                    if (future.isDone()) {
                        future.get();
                    }
                }
                catch (CancellationException cancellationException) {
                    throwable2 = cancellationException;
                }
                catch (ExecutionException executionException) {
                    throwable2 = executionException.getCause();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            if (throwable2 != null) {
                GamaExecutorService.EXCEPTION_HANDLER.uncaughtException(Thread.currentThread(), throwable2);
            }
        }
    }
}

