/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.file;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.geometry.Envelope3D;
import gama.core.common.interfaces.IValue;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.GamaShape;
import gama.core.metamodel.shape.GamaShapeFactory;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMapFactory;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.core.util.file.GamaFileMetaData;
import gama.core.util.file.GamaGisFile;
import gama.dependencies.osmosis.Bound;
import gama.dependencies.osmosis.Entity;
import gama.dependencies.osmosis.EntityContainer;
import gama.dependencies.osmosis.Node;
import gama.dependencies.osmosis.OsmHandler;
import gama.dependencies.osmosis.OsmosisReader;
import gama.dependencies.osmosis.Relation;
import gama.dependencies.osmosis.RelationMember;
import gama.dependencies.osmosis.Sink;
import gama.dependencies.osmosis.Tag;
import gama.dependencies.osmosis.Way;
import gama.dependencies.osmosis.WayNode;
import gama.dev.DEBUG;
import gama.gaml.operators.Strings;
import gama.gaml.operators.spatial.SpatialOperators;
import gama.gaml.operators.spatial.SpatialTransformations;
import gama.gaml.types.GamaGeometryType;
import gama.gaml.types.Types;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.lang3.StringUtils;
import org.geotools.data.DataUtilities;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.xml.sax.helpers.DefaultHandler;

@GamlAnnotations.file(name="osm", extensions={"osm", "pbf", "bz2", "gz"}, buffer_type=5, buffer_content=13, buffer_index=1, concept={"osm", "file"}, doc={@GamlAnnotations.doc(value="Represents files that contain OSM GIS information. The internal representation is a list of geometries. See https://en.wikipedia.org/wiki/OpenStreetMap for more information")})
public class GamaOsmFile
extends GamaGisFile {
    final ReferencedEnvelope env = new ReferencedEnvelope();
    IMap<String, IList> filteringOptions;
    Map<String, String> attributes = new HashMap<String, String>();
    final IMap<String, List<IShape>> layers = GamaMapFactory.create(Types.STRING, Types.LIST);
    static final List<String> featureTypes = Arrays.asList("aerialway", "aeroway", "amenity", "barrier", "boundary", "building", "craft", "emergency", "geological", "highway", "historic", "landuse", "leisure", "man_made", "military", "natural", "office", "place", "power", "public_transport", "railway", "route", "shop", "sport", "tourism", "waterway", "water");
    int nbObjects;

    @GamlAnnotations.doc(value="This file constructor allows to read a osm (.osm, .pbf, .bz2, .gz) file (using WGS84 coordinate system for the data)", examples={@GamlAnnotations.example(value="file f <- osm_file(\"file\");", isExecutable=false)})
    public GamaOsmFile(IScope iScope, String string) {
        super(iScope, string, (Integer)null);
    }

    @GamlAnnotations.doc(value="This file constructor allows to read an osm (.osm, .pbf, .bz2, .gz) file (using WGS84 coordinate system for the data)The map is used to filter the objects in the file according their attributes: for each key (string) of the map, only the objects that have a value for the  attribute contained in the value set are kept. For an exhaustive list of the attibute of OSM data, see: http://wiki.openstreetmap.org/wiki/Map_Features", examples={@GamlAnnotations.example(value="file f <- osm_file(\"file\", map([\"highway\"::[\"primary\", \"secondary\"], \"building\"::[\"yes\"], \"amenity\"::[]]));", equals="f will contain all the objects of file that have the attibute 'highway' with the value 'primary' or 'secondary', and the objects that have the attribute 'building' with the value 'yes', and all the objects that have the attribute 'aminity' (whatever the value).", isExecutable=false)})
    public GamaOsmFile(IScope iScope, String string, IMap<String, IList> iMap) {
        super(iScope, string, (Integer)null);
        this.filteringOptions = iMap;
    }

    @Override
    protected String fetchFromURL(IScope iScope) {
        String string = super.fetchFromURL(iScope);
        if (string.endsWith(".osm.xml")) {
            string = string.replace(".xml", "");
        }
        return string;
    }

    public void getFeatureIterator(final IScope iScope, final boolean bl) {
        final HashMap<Long, GamaShape> hashMap = new HashMap<Long, GamaShape>();
        final HashMap<Long, Node> hashMap2 = new HashMap<Long, Node>();
        final LinkedHashSet<Node> linkedHashSet = new LinkedHashSet<Node>();
        final ArrayList<Way> arrayList = new ArrayList<Way>();
        final ArrayList<Relation> arrayList2 = new ArrayList<Relation>();
        final LinkedHashSet<Long> linkedHashSet2 = new LinkedHashSet<Long>();
        final LinkedHashSet linkedHashSet3 = new LinkedHashSet();
        Sink sink = new Sink(){

            public void process(EntityContainer entityContainer) {
                boolean bl5;
                Entity entity = entityContainer.getEntity();
                boolean bl2 = bl5 = GamaOsmFile.this.filteringOptions != null && !GamaOsmFile.this.filteringOptions.isEmpty();
                if (entity instanceof Bound) {
                    Bound bound = (Bound)entity;
                    Envelope3D envelope3D = Envelope3D.of(bound.getLeft(), bound.getRight(), bound.getBottom(), bound.getTop(), 0.0, 0.0);
                    GamaOsmFile.this.computeProjection(iScope, envelope3D);
                } else if (bl) {
                    if (entity instanceof Node) {
                        Node node = (Node)entity;
                        Geometry geometry = GamaOsmFile.this.gis == null ? new GamaPoint(node.getLongitude(), node.getLatitude()).getInnerGeometry() : GamaOsmFile.this.gis.transform(new GamaPoint(node.getLongitude(), node.getLatitude()).getInnerGeometry());
                        hashMap.put(node.getId(), GamaShapeFactory.createFrom(geometry));
                        hashMap2.put(node.getId(), node);
                        boolean bl3 = GamaOsmFile.this.keepEntity(bl5, entity);
                        if (!bl3) {
                            return;
                        }
                        linkedHashSet.add(node);
                    } else if (entity instanceof Way) {
                        GamaOsmFile.this.registerHighway((Way)entity, linkedHashSet3, linkedHashSet2);
                        arrayList.add((Way)entity);
                    } else if (entity instanceof Relation) {
                        boolean bl4 = GamaOsmFile.this.keepEntity(bl5, entity);
                        if (!bl4) {
                            return;
                        }
                        arrayList2.add((Relation)entity);
                    }
                }
            }

            public void complete() {
            }

            public void initialize(Map<String, Object> map) {
            }
        };
        this.readFile(iScope, sink, this.getFile(iScope));
        if (bl) {
            this.setBuffer(this.buildGeometries(iScope, linkedHashSet, arrayList, arrayList2, linkedHashSet2, hashMap, hashMap2));
        }
    }

    boolean keepEntity(boolean bl, Entity entity) {
        if (bl) {
            boolean bl2 = false;
            block0: for (String string : this.filteringOptions.getKeys()) {
                IList iList = (IList)this.filteringOptions.get(string);
                for (Tag tag : entity.getTags()) {
                    if (!string.equals(tag.getKey()) || iList != null && !iList.isEmpty() && !iList.contains(tag.getValue())) continue;
                    bl2 = true;
                    continue block0;
                }
            }
            if (!bl2) {
                return false;
            }
        }
        return true;
    }

    private void addAttribute(Map<String, String> map, String string, Object object) {
        String string2 = map.get(string);
        if ("string".equals(string2)) {
            return;
        }
        String string3 = "int";
        try {
            Integer.parseInt(object.toString());
        }
        catch (Exception exception) {
            try {
                Double.parseDouble(object.toString());
            }
            catch (Exception exception2) {
                string3 = "string";
            }
        }
        if (string2 == null || "string".equals(string3)) {
            map.put(string, string3);
        }
    }

    @Override
    protected void fillBuffer(IScope iScope) throws GamaRuntimeException {
        if (this.getBuffer() != null) {
            return;
        }
        this.setBuffer(GamaListFactory.create(Types.GEOMETRY));
        this.getFeatureIterator(iScope, true);
    }

    public IList<IShape> buildGeometries(IScope iScope, Set<Node> set, List<Way> list, List<Relation> list2, Set<Long> set2, Map<Long, GamaShape> map, Map<Long, Node> map2) {
        List<Object> list3;
        Object object;
        Object object22;
        Object object32;
        IValue iValue;
        Way way2;
        boolean bl = this.filteringOptions != null && !this.filteringOptions.isEmpty();
        for (Way way2 : list) {
            for (WayNode wayNode : way2.getWayNodes()) {
                set.add(map2.get(wayNode.getNodeId()));
            }
        }
        way2 = GamaListFactory.create(Types.GEOMETRY);
        if (this.gis == null) {
            this.computeProjection(iScope, Envelope3D.of((Envelope)this.env));
            if (this.gis != null) {
                for (Long l : map.keySet()) {
                    GamaShape gamaShape = GamaShapeFactory.createFrom(this.gis.transform(map.get(l).getInnerGeometry()));
                    map.put(l, gamaShape);
                }
            }
        }
        HashMap<Long, Entity> hashMap = new HashMap<Long, Entity>();
        for (Node node : set) {
            iValue = map.get(node.getId());
            boolean bl2 = !node.getTags().isEmpty();
            object32 = new HashMap();
            if (iValue == null) continue;
            this.env.expandToInclude((Coordinate)((GamaShape)iValue).getLocation());
            for (Tag tag : node.getTags()) {
                object22 = tag.getKey();
                object = tag.getValue();
                if (object != null) {
                    this.addAttribute((Map<String, String>)object32, (String)object22, object);
                }
                iValue.setAttribute((String)object22, object);
                if (!"highway".equals(object22)) continue;
                set2.add(node.getId());
            }
            if (!bl2) continue;
            way2.add(iValue);
            iValue.forEachAttribute((arg_0, arg_1) -> this.lambda$0((GamaShape)iValue, (Map)object32, arg_0, arg_1));
        }
        block5: for (Way way3 : list) {
            Object object4;
            boolean bl3;
            hashMap.put(way3.getId(), (Entity)way3);
            boolean bl4 = this.keepEntity(bl, (Entity)way3);
            if (!bl4) continue;
            IMap iMap = GamaMapFactory.create();
            object32 = GamaMapFactory.createUnordered();
            for (Tag tag : way3.getTags()) {
                object22 = tag.getKey();
                object = tag.getValue();
                if (object != null) {
                    this.addAttribute((Map<String, String>)object32, (String)object22, object);
                }
                iMap.put(object22, tag.getValue());
            }
            iMap.put("osm_id", way3.getId());
            boolean bl5 = bl3 = iMap.containsKey("highway") || ((WayNode)way3.getWayNodes().get(0)).getNodeId() != ((WayNode)way3.getWayNodes().get(way3.getWayNodes().size() - 1)).getNodeId();
            if (bl3) {
                list3 = this.createSplitRoad(way3.getWayNodes(), iMap, set2, map);
                way2.addAll(list3);
                if (list3.isEmpty()) continue;
                for (Object object22 : iMap.keySet()) {
                    object4 = String.valueOf(object22) + " (line)";
                    if (!featureTypes.contains(object22)) continue;
                    IList iList = (IList)this.layers.get(object4);
                    if (iList == null) {
                        iList = GamaListFactory.create(Types.GEOMETRY);
                        this.layers.put((String)object4, iList);
                    }
                    iList.addAll(list3);
                    for (String string : object32.keySet()) {
                        String string2 = (String)object4 + ";" + string;
                        this.attributes.put(string2, (String)object32.get(string));
                    }
                    continue block5;
                }
                continue;
            }
            list3 = GamaListFactory.create(Types.GEOMETRY);
            for (Object object22 : way3.getWayNodes()) {
                object4 = map.get(object22.getNodeId());
                if (object4 == null) continue;
                list3.add(object4);
            }
            if (list3.size() < 3 || (object22 = GamaGeometryType.buildPolygon(list3)) == null || object22.getInnerGeometry() == null || object22.getInnerGeometry().isEmpty() || !(object22.getInnerGeometry().getArea() > 0.0)) continue;
            iMap.forEach((arg_0, arg_1) -> GamaOsmFile.lambda$1((IShape)object22, arg_0, arg_1));
            way2.add(object22);
            object22.forEachAttribute((arg_0, arg_1) -> this.lambda$2((IShape)object22, (Map)object32, arg_0, arg_1));
        }
        for (Relation relation : list2) {
            iValue = GamaMapFactory.createUnordered();
            IMap iMap = GamaMapFactory.create();
            for (Object object32 : relation.getTags()) {
                list3 = object32.getKey();
                iMap.put(list3, object32.getValue());
            }
            object32 = (String)iMap.get("type");
            if ("polygon".equals(object32) || "multipolygon".equals(object32)) {
                this.managePolygonRelation(iScope, relation, (IList<IShape>)way2, hashMap, iMap, map, set2, (Map<String, String>)((Object)iValue));
                continue;
            }
            this.manageNormalRelation(iScope, relation, (IList<IShape>)way2, hashMap, iMap, map, set2);
        }
        this.nbObjects = way2 == null ? 0 : way2.size();
        return way2;
    }

    private void managePolygonRelation(IScope iScope, Relation relation, IList<IShape> iList, Map<Long, Entity> map, Map<String, Object> map2, Map<Long, GamaShape> map3, Set<Long> set, Map<String, String> map4) {
        Object object22;
        IList iList2 = GamaListFactory.create(Types.GEOMETRY);
        IList<Object> iList3 = GamaListFactory.create();
        IList<IShape> iList4 = GamaListFactory.create();
        for (Object object22 : relation.getMembers()) {
            Entity entity = map.get(object22.getMemberId());
            if (!(entity instanceof Way)) continue;
            IList iList5 = GamaListFactory.create();
            Way way = (Way)entity;
            for (WayNode wayNode : way.getWayNodes()) {
                GamaShape gamaShape = map3.get(wayNode.getNodeId());
                if (gamaShape == null) continue;
                iList5.add(gamaShape);
            }
            if (object22.getMemberRole().equals("outer")) {
                iList3.add(iList5);
                continue;
            }
            iList4.add(GamaGeometryType.buildPolygon(iList5));
        }
        if (iList3.size() > 1) {
            object22 = (IList)iList3.get(0);
            iList3.remove(object22);
            for (Object object3 : iList3) {
                int n = object22.indexOf(object3.get(0));
                if (n < 0) continue;
                if (n == 0) {
                    object22.addAll(n, object3.reversed());
                    continue;
                }
                object22.addAll(n, object3);
            }
            iList2.addAll(object22);
        } else if (!iList3.isEmpty()) {
            iList2.addAll((Collection)iList3.get(0));
        }
        if (iList2.size() < 3) {
            return;
        }
        object22 = GamaGeometryType.buildPolygon(iList2);
        if (object22 != null && object22.getInnerGeometry() != null && !object22.getInnerGeometry().isEmpty() && object22.getInnerGeometry().getArea() > 0.0) {
            Object object3;
            if (iList4 != null && !iList4.isEmpty()) {
                object22 = SpatialOperators.minus(iScope, (IShape)object22, iList4);
            }
            object3 = SpatialTransformations.clean(iScope, (IShape)object22);
            map2.forEach((arg_0, arg_1) -> GamaOsmFile.lambda$3((IShape)object3, arg_0, arg_1));
            iList.add((IShape)object3);
            object3.forEachAttribute((arg_0, arg_1) -> this.lambda$4((IShape)object3, map4, arg_0, arg_1));
        }
    }

    private void manageNormalRelation(IScope iScope, Relation relation, IList<IShape> iList, Map<Long, Entity> map, Map<String, Object> map2, Map<Long, GamaShape> map3, Set<Long> set) {
        int n = 0;
        for (RelationMember relationMember : relation.getMembers()) {
            List<Object> list;
            IValue iValue;
            Object object;
            Entity entity = map.get(relationMember.getMemberId());
            if (entity instanceof Way) {
                object = ((Way)entity).getWayNodes();
                iValue = GamaMapFactory.create();
                iValue.put("entity_order", n++);
                iValue.put("gama_bus_line", map2.get("name"));
                iValue.put("osm_way_id", ((Way)entity).getId());
                if (object.size() <= 0) continue;
                list = this.createSplitRoad((List<WayNode>)object, (Map<String, Object>)((Object)iValue), set, map3);
                iList.addAll(list);
                continue;
            }
            if (!(entity instanceof Node)) continue;
            object = map3.get(((Node)entity).getId());
            iValue = ((GamaShape)object).copy(iScope);
            list = GamaListFactory.create(Types.GEOMETRY);
            list.add(iValue);
            iValue.setAttribute("gama_bus_line", map2.get("name"));
            iList.add((IShape)iValue);
        }
    }

    public List<IShape> createSplitRoad(List<WayNode> list, Map<String, Object> map, Set<Long> set, Map<Long, GamaShape> map2) {
        Object object;
        IList<Object> iList = GamaListFactory.create(Types.LIST.of(Types.GEOMETRY));
        IList iList2 = GamaListFactory.create(Types.GEOMETRY);
        IList<IShape> iList3 = GamaListFactory.create(Types.GEOMETRY);
        WayNode wayNode = list.get(list.size() - 1);
        for (WayNode wayNode2 : list) {
            Long l = wayNode2.getNodeId();
            object = map2.get(l);
            if (object == null) continue;
            iList2.add(object);
            if (!set.contains(l) && wayNode2 != wayNode) continue;
            if (iList2.size() > 1) {
                iList.add(iList2);
            }
            iList2 = GamaListFactory.create(Types.GEOMETRY);
            iList2.add(object);
        }
        int n = 0;
        for (Object object2 : iList) {
            object = new HashMap<String, Object>(map);
            object.put("way_order", n++);
            IShape iShape = this.createRoad((List<IShape>)object2, (Map<String, Object>)object);
            if (iShape == null) continue;
            iList3.add(iShape);
        }
        return iList3;
    }

    private IShape createRoad(List<IShape> list, Map<String, Object> map) {
        if (list.size() < 2) {
            return null;
        }
        IShape iShape = GamaGeometryType.buildPolyline(list);
        if (iShape != null && iShape.getInnerGeometry() != null && !iShape.getInnerGeometry().isEmpty() && iShape.getInnerGeometry().isSimple() && iShape.getPerimeter() > 0.0) {
            for (String string : map.keySet()) {
                iShape.setAttribute(string, map.get(string));
            }
            return iShape;
        }
        return null;
    }

    void registerHighway(Way way, Set<Long> set, Set<Long> set2) {
        for (Tag tag : way.getTags()) {
            String string = tag.getKey();
            if (!"highway".equals(string)) continue;
            List list = way.getWayNodes();
            for (WayNode wayNode : list) {
                long l = wayNode.getNodeId();
                if (set.contains(l)) {
                    set2.add(l);
                    continue;
                }
                set.add(l);
            }
            if (list.size() <= 2 || list.get(0) != list.get(list.size() - 1)) continue;
            set2.add(((WayNode)list.get(list.size() / 2)).getNodeId());
        }
    }

    private void readFile(IScope iScope, Sink sink, File file2) {
        String string = this.getExtension(iScope);
        OsmosisReader osmosisReader = null;
        switch (string) {
            case "pbf": {
                try {
                    Throwable throwable = null;
                    Object var8_10 = null;
                    try (InputStream inputStream = Files.newInputStream(file2.toPath(), new OpenOption[0]);){
                        osmosisReader = new OsmosisReader(inputStream);
                        osmosisReader.setSink(sink);
                        osmosisReader.run();
                        break;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {
                    throw GamaRuntimeException.create(iOException, iScope);
                }
            }
            default: {
                this.readXML(iScope, sink);
            }
        }
    }

    private void readXML(IScope iScope, Sink sink) throws GamaRuntimeException {
        try {
            String string;
            InputStream inputStream = Files.newInputStream(this.getFile(iScope).toPath(), new OpenOption[0]);
            switch (string = this.getExtension(iScope)) {
                case "gz": {
                    inputStream = new GZIPInputStream(inputStream);
                    break;
                }
                case "bz2": {
                    inputStream = new BZip2CompressorInputStream(inputStream);
                }
            }
            Throwable throwable = null;
            Object var7_9 = null;
            try (InputStream inputStream2 = inputStream;){
                SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
                sAXParser.parse(inputStream2, (DefaultHandler)new OsmHandler(sink, false));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            throw GamaRuntimeException.error("Unable to parse xml file " + this.getName(iScope) + ": " + exception.getMessage(), iScope);
        }
    }

    @Override
    public Envelope3D computeEnvelope(IScope iScope) {
        if (this.gis == null) {
            this.getFeatureIterator(iScope, false);
        }
        if (this.gis == null) {
            return Envelope3D.of((Envelope)this.env);
        }
        return this.gis.getProjectedEnvelope();
    }

    @Override
    protected CoordinateReferenceSystem getOwnCRS(IScope iScope) {
        return DefaultGeographicCRS.WGS84;
    }

    public Map<String, String> getOSMAttributes(IScope iScope) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
            this.getFeatureIterator(iScope, true);
        }
        return this.attributes;
    }

    public Map<String, List<IShape>> getLayers() {
        return this.layers;
    }

    public List<String> getFeatureTypes() {
        return featureTypes;
    }

    @Override
    protected SimpleFeatureCollection getFeatureCollection(IScope iScope) {
        return null;
    }

    private /* synthetic */ boolean lambda$0(GamaShape gamaShape, Map map, String string, Object object) {
        if (featureTypes.contains(string)) {
            String string2 = string + " (point)";
            IList iList = (IList)this.layers.get(string2);
            if (iList == null) {
                iList = GamaListFactory.create(Types.GEOMETRY);
                this.layers.put(string2, iList);
            }
            iList.add(gamaShape);
            for (String string3 : map.keySet()) {
                String string4 = string2 + ";" + string3;
                this.attributes.put(string4, (String)map.get(string3));
            }
            return false;
        }
        return true;
    }

    private static /* synthetic */ void lambda$1(IShape iShape, String string, Object object) {
        iShape.setAttribute(string, object);
    }

    private /* synthetic */ boolean lambda$2(IShape iShape, Map map, String string, Object object) {
        String string2 = string + " (polygon)";
        if (featureTypes.contains(string)) {
            IList iList = (IList)this.layers.get(string2);
            if (iList == null) {
                iList = GamaListFactory.create(Types.GEOMETRY);
                this.layers.put(string2, iList);
            }
            iList.add(iShape);
            for (String string3 : map.keySet()) {
                String string4 = string2 + ";" + string3;
                this.attributes.put(string4, (String)map.get(string3));
            }
            return false;
        }
        return true;
    }

    private static /* synthetic */ void lambda$3(IShape iShape, String string, Object object) {
        iShape.setAttribute(string, object);
    }

    private /* synthetic */ boolean lambda$4(IShape iShape, Map map, String string, Object object) {
        String string2 = string + " (polygon)";
        if (featureTypes.contains(string)) {
            IList iList = (IList)this.layers.get(string2);
            if (iList == null) {
                iList = GamaListFactory.create(Types.GEOMETRY);
                this.layers.put(string2, iList);
            }
            iList.add(iShape);
            for (String string3 : map.keySet()) {
                String string4 = string2 + ";" + string3;
                this.attributes.put(string4, (String)map.get(string3));
            }
            return false;
        }
        return true;
    }

    public static class OSMInfo
    extends GamaFileMetaData {
        int itemNumber;
        CoordinateReferenceSystem crs;
        final double width;
        final double height;
        final Map<String, String> attributes;

        public OSMInfo(URL uRL, long l) {
            block6: {
                super(l);
                this.attributes = new LinkedHashMap<String, String>();
                CoordinateReferenceSystem coordinateReferenceSystem = null;
                ReferencedEnvelope referencedEnvelope = new ReferencedEnvelope();
                int n = 0;
                try {
                    try {
                        IShape iShape2;
                        File file2 = new File(uRL.toURI());
                        GamaOsmFile gamaOsmFile = new GamaOsmFile(null, file2.getAbsolutePath());
                        this.attributes.putAll(gamaOsmFile.getOSMAttributes(GAMA.getRuntimeScope()));
                        SimpleFeatureType simpleFeatureType = DataUtilities.createType((String)"geometries", (String)"geom:LineString");
                        ArrayList<SimpleFeature> arrayList = new ArrayList<SimpleFeature>();
                        for (IShape iShape2 : gamaOsmFile.iterable(null)) {
                            arrayList.add(SimpleFeatureBuilder.build((SimpleFeatureType)simpleFeatureType, (Object[])new Object[]{iShape2.getInnerGeometry()}, null));
                        }
                        iShape2 = new ListFeatureCollection(simpleFeatureType, arrayList);
                        SimpleFeatureSource simpleFeatureSource = DataUtilities.source((FeatureCollection)iShape2);
                        referencedEnvelope = simpleFeatureSource.getBounds();
                        n = gamaOsmFile.nbObjects;
                        coordinateReferenceSystem = gamaOsmFile.getOwnCRS(null);
                    }
                    catch (Exception exception) {
                        DEBUG.ERR((Object)("Error in reading metadata of " + String.valueOf(uRL)));
                        this.hasFailed = true;
                        this.width = referencedEnvelope != null ? referencedEnvelope.getWidth() * (Math.PI / 180) * 6378137.0 : 0.0;
                        this.height = referencedEnvelope != null ? referencedEnvelope.getHeight() * (Math.PI / 180) * 6378137.0 : 0.0;
                        this.itemNumber = n;
                        this.crs = coordinateReferenceSystem;
                        break block6;
                    }
                }
                catch (Throwable throwable) {
                    this.width = referencedEnvelope != null ? referencedEnvelope.getWidth() * (Math.PI / 180) * 6378137.0 : 0.0;
                    this.height = referencedEnvelope != null ? referencedEnvelope.getHeight() * (Math.PI / 180) * 6378137.0 : 0.0;
                    this.itemNumber = n;
                    this.crs = coordinateReferenceSystem;
                    throw throwable;
                }
                this.width = referencedEnvelope != null ? referencedEnvelope.getWidth() * (Math.PI / 180) * 6378137.0 : 0.0;
                this.height = referencedEnvelope != null ? referencedEnvelope.getHeight() * (Math.PI / 180) * 6378137.0 : 0.0;
                this.itemNumber = n;
                this.crs = coordinateReferenceSystem;
            }
        }

        public CoordinateReferenceSystem getCRS() {
            return this.crs;
        }

        public OSMInfo(String string) throws NoSuchAuthorityCodeException, FactoryException {
            super(string);
            this.attributes = new LinkedHashMap<String, String>();
            if (!this.hasFailed) {
                String[] stringArray = this.split(string);
                this.itemNumber = Integer.parseInt(stringArray[1]);
                String string2 = stringArray[2];
                this.crs = "null".equals(string2) ? null : CRS.parseWKT((String)string2);
                this.width = Double.parseDouble(stringArray[3]);
                this.height = Double.parseDouble(stringArray[4]);
                if (stringArray.length > 5) {
                    String[] stringArray2 = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)stringArray[5], (String)"@%@");
                    String[] stringArray3 = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)stringArray[6], (String)"@%@");
                    int n = 0;
                    while (n < stringArray2.length) {
                        this.attributes.put(stringArray2[n], stringArray3[n]);
                        ++n;
                    }
                }
            } else {
                this.itemNumber = 0;
                this.width = 0.0;
                this.height = 0.0;
                this.crs = null;
            }
        }

        @Override
        public String getSuffix() {
            return this.hasFailed ? "error: decompress the file to a .osm file" : this.itemNumber + " objects | " + Math.round(this.width) + "m x " + Math.round(this.height) + "m";
        }

        @Override
        public void appendSuffix(StringBuilder stringBuilder) {
            if (this.hasFailed) {
                stringBuilder.append("error: decompress the file to a .osm file");
                return;
            }
            stringBuilder.append(this.itemNumber).append(" object");
            if (this.itemNumber > 1) {
                stringBuilder.append("s");
            }
            stringBuilder.append(" | ");
            stringBuilder.append(Math.round(this.width)).append("m x ");
            stringBuilder.append(Math.round(this.height)).append("m");
        }

        @Override
        public String getDocumentation() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.hasFailed) {
                stringBuilder.append("Unreadable OSM file").append(Strings.LN).append("Decompress the file to an .osm file and retry");
            } else {
                stringBuilder.append("OSM file").append(Strings.LN);
                stringBuilder.append(this.itemNumber).append(" objects").append(Strings.LN);
                stringBuilder.append("Dimensions: ").append(Math.round(this.width) + "m x " + Math.round(this.height) + "m").append(Strings.LN);
                stringBuilder.append("Coordinate Reference System: ").append(this.crs == null ? "No CRS" : this.crs.getName().getCode()).append(Strings.LN);
                if (!this.attributes.isEmpty()) {
                    stringBuilder.append("Attributes: ").append(Strings.LN);
                    this.attributes.forEach((string, string2) -> {
                        StringBuilder stringBuilder2 = stringBuilder.append("<li>").append((String)string).append(" (" + string2 + ")").append("</li>");
                    });
                }
            }
            return stringBuilder.toString();
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public String toPropertyString() {
            String string = String.join((CharSequence)"@%@", this.attributes.keySet());
            String string2 = String.join((CharSequence)"@%@", this.attributes.values());
            CharSequence[] charSequenceArray = new String[]{super.toPropertyString(), String.valueOf(this.itemNumber), this.crs == null ? "null" : this.crs.toWKT(), String.valueOf(this.width), String.valueOf(this.height), string, string2};
            return String.join((CharSequence)"_!_", charSequenceArray);
        }
    }
}

