/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.file.json;

import gama.core.runtime.IScope;
import gama.core.util.file.json.JsonArray;
import gama.core.util.file.json.JsonGamlAgent;
import gama.core.util.file.json.JsonGamlObject;
import gama.core.util.file.json.JsonObject;
import gama.core.util.file.json.JsonWriter;
import gama.core.util.file.json.WriterConfig;
import gama.core.util.file.json.WritingBuffer;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;

public abstract class JsonValue
implements Serializable {
    JsonValue() {
    }

    public boolean isGamlObject() {
        return false;
    }

    public boolean isGamlAgent() {
        return false;
    }

    public boolean isObject() {
        return false;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isNumber() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean isTrue() {
        return false;
    }

    public boolean isFalse() {
        return false;
    }

    public boolean isNull() {
        return false;
    }

    public JsonObject asObject() {
        throw new UnsupportedOperationException("Not an object: " + this.toString());
    }

    public JsonArray asArray() {
        throw new UnsupportedOperationException("Not an array: " + this.toString());
    }

    public int asInt() {
        throw new UnsupportedOperationException("Not a number: " + this.toString());
    }

    public long asLong() {
        throw new UnsupportedOperationException("Not a number: " + this.toString());
    }

    public float asFloat() {
        throw new UnsupportedOperationException("Not a number: " + this.toString());
    }

    public double asDouble() {
        throw new UnsupportedOperationException("Not a number: " + this.toString());
    }

    public String asString() {
        throw new UnsupportedOperationException("Not a string: " + this.toString());
    }

    public boolean asBoolean() {
        throw new UnsupportedOperationException("Not a boolean: " + this.toString());
    }

    public JsonGamlObject asGamlObject() {
        throw new UnsupportedOperationException("Not a GAML object: " + this.toString());
    }

    public JsonGamlAgent asGamlAgent() {
        throw new UnsupportedOperationException("Not a GAML agent: " + this.toString());
    }

    public void writeTo(Writer writer) throws IOException {
        this.writeTo(writer, WriterConfig.MINIMAL);
    }

    public void writeTo(Writer writer, WriterConfig writerConfig) throws IOException {
        if (writer == null) {
            throw new NullPointerException("writer is null");
        }
        if (writerConfig == null) {
            throw new NullPointerException("config is null");
        }
        WritingBuffer writingBuffer = new WritingBuffer(writer, 128);
        this.write(writerConfig.createWriter(writingBuffer));
        writingBuffer.flush();
    }

    public String toString() {
        return this.toString(WriterConfig.MINIMAL);
    }

    public String toString(WriterConfig writerConfig) {
        StringWriter stringWriter = new StringWriter();
        try {
            this.writeTo(stringWriter, writerConfig);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return stringWriter.toString();
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public int hashCode() {
        return super.hashCode();
    }

    abstract void write(JsonWriter var1) throws IOException;

    public abstract Object toGamlValue(IScope var1);
}

