/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.random;

import gama.core.common.util.RandomUtils;
import gama.core.util.random.GamaRNG;
import gama.dev.DEBUG;

public class MersenneTwisterRNG
extends GamaRNG {
    int BITWISE_BYTE_TO_INT = 255;
    private static final int N = 624;
    private static final int M = 397;
    private static final int[] MAG01;
    private static final int UPPER_MASK = Integer.MIN_VALUE;
    private static final int LOWER_MASK = Integer.MAX_VALUE;
    private static final int BOOTSTRAP_SEED = 19650218;
    private static final int BOOTSTRAP_FACTOR = 1812433253;
    private static final int SEED_FACTOR1 = 1664525;
    private static final int SEED_FACTOR2 = 1566083941;
    private static final int GENERATE_MASK1 = -1658038656;
    private static final int GENERATE_MASK2 = -272236544;
    private final int[] mt = new int[624];
    private int mtIndex = 0;

    static {
        DEBUG.OFF();
        int[] nArray = new int[2];
        nArray[1] = -1727483681;
        MAG01 = nArray;
    }

    public MersenneTwisterRNG(RandomUtils randomUtils) {
        this(randomUtils.generateSeed(16));
    }

    protected MersenneTwisterRNG(byte[] byArray) {
        super(byArray);
        int[] nArray = this.convertBytesToInts(byArray);
        this.mt[0] = 19650218;
        this.mtIndex = 1;
        while (this.mtIndex < 624) {
            this.mt[this.mtIndex] = 1812433253 * (this.mt[this.mtIndex - 1] ^ this.mt[this.mtIndex - 1] >>> 30) + this.mtIndex;
            ++this.mtIndex;
        }
        int n = 1;
        int n2 = 0;
        int n3 = Math.max(624, nArray.length);
        while (n3 > 0) {
            this.mt[n] = (this.mt[n] ^ (this.mt[n - 1] ^ this.mt[n - 1] >>> 30) * 1664525) + nArray[n2] + n2;
            ++n2;
            if (++n >= 624) {
                this.mt[0] = this.mt[623];
                n = 1;
            }
            if (n2 >= nArray.length) {
                n2 = 0;
            }
            --n3;
        }
        n3 = 623;
        while (n3 > 0) {
            this.mt[n] = (this.mt[n] ^ (this.mt[n - 1] ^ this.mt[n - 1] >>> 30) * 1566083941) - n;
            if (++n >= 624) {
                this.mt[0] = this.mt[623];
                n = 1;
            }
            --n3;
        }
        this.mt[0] = Integer.MIN_VALUE;
    }

    @Override
    protected int internalNext(int n) {
        int n2;
        if (this.mtIndex >= 624) {
            int n3 = 0;
            while (n3 < 227) {
                n2 = this.mt[n3] & Integer.MIN_VALUE | this.mt[n3 + 1] & Integer.MAX_VALUE;
                this.mt[n3] = this.mt[n3 + 397] ^ n2 >>> 1 ^ MAG01[n2 & 1];
                ++n3;
            }
            while (n3 < 623) {
                n2 = this.mt[n3] & Integer.MIN_VALUE | this.mt[n3 + 1] & Integer.MAX_VALUE;
                this.mt[n3] = this.mt[n3 + 397 - 624] ^ n2 >>> 1 ^ MAG01[n2 & 1];
                ++n3;
            }
            n2 = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
            this.mt[623] = this.mt[396] ^ n2 >>> 1 ^ MAG01[n2 & 1];
            this.mtIndex = 0;
        }
        n2 = this.mt[this.mtIndex++];
        n2 ^= n2 >>> 11;
        n2 ^= n2 << 7 & 0x9D2C5680;
        n2 ^= n2 << 15 & 0xEFC60000;
        n2 ^= n2 >>> 18;
        return n2 >>> 32 - n;
    }

    int[] convertBytesToInts(byte[] byArray) {
        if (byArray.length % 4 != 0) {
            throw new IllegalArgumentException("Number of input bytes must be a multiple of 4.");
        }
        int[] nArray = new int[byArray.length / 4];
        int n = 0;
        while (n < nArray.length) {
            int n2 = n * 4;
            nArray[n] = this.BITWISE_BYTE_TO_INT & byArray[n2 + 3] | (this.BITWISE_BYTE_TO_INT & byArray[n2 + 2]) << 8 | (this.BITWISE_BYTE_TO_INT & byArray[n2 + 1]) << 16 | (this.BITWISE_BYTE_TO_INT & byArray[n2]) << 24;
            ++n;
        }
        return nArray;
    }
}

