/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.descriptions;

import com.google.common.collect.Iterables;
import gama.core.kernel.experiment.IExperimentAgent;
import gama.core.metamodel.agent.IAgent;
import gama.core.util.GamaMapFactory;
import gama.core.util.IMap;
import gama.gaml.compilation.IAgentConstructor;
import gama.gaml.compilation.kernel.GamaMetaModel;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.ModelDescription;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.descriptions.StatementDescription;
import gama.gaml.descriptions.VariableDescription;
import gama.gaml.statements.Facets;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class ExperimentDescription
extends SpeciesDescription {
    private IMap<String, VariableDescription> parameters;
    private StatementDescription output;
    private StatementDescription permanent;

    public ExperimentDescription(String string, SpeciesDescription speciesDescription, Iterable<IDescription> iterable, EObject eObject, Facets facets2) {
        super(string, null, speciesDescription, null, iterable, eObject, facets2);
        String string2 = this.getLitteral("type");
        this.setIf(IDescription.Flag.isBatch, "batch".equals(string2));
        this.setIf(IDescription.Flag.isMemorize, facets2.containsKey("record"));
    }

    public ExperimentDescription(String string, Class<?> clazz, SpeciesDescription speciesDescription, SpeciesDescription speciesDescription2, IAgentConstructor<? extends IAgent> iAgentConstructor, Set<String> set, Facets facets2, String string2) {
        super(string, clazz, speciesDescription, speciesDescription2, iAgentConstructor, set, facets2, string2);
    }

    private void addParameter(VariableDescription variableDescription) {
        String string;
        VariableDescription variableDescription2;
        if (this.parameters == null) {
            this.parameters = GamaMapFactory.create();
        }
        if ((variableDescription2 = (VariableDescription)this.parameters.get(string = variableDescription.getName())) != null) {
            variableDescription2.warning("'" + string + "' is overwritten in this experiment and will not be used.", "gaml.duplicate.definition.issue", "name", new String[0]);
            variableDescription.warning("'" + string + "' overwrites a previous definition.", "gaml.duplicate.definition.issue", "name", new String[0]);
        }
        ModelDescription modelDescription = this.getModelDescription();
        modelDescription.visitAllAttributes(iDescription -> {
            VariableDescription variableDescription2 = (VariableDescription)iDescription;
            if (string.equals(variableDescription2.getParameterName())) {
                Resource resource;
                Resource resource2 = variableDescription.getUnderlyingElement() == null ? null : variableDescription.getUnderlyingElement().eResource();
                Resource resource3 = resource = variableDescription2.getUnderlyingElement() == null ? null : variableDescription2.getUnderlyingElement().eResource();
                if (Objects.equals(resource2, resource)) {
                    variableDescription.info("'" + string + "' supersedes the parameter declaration in " + variableDescription2.getOriginName(), "gaml.redefinition.info", "name", new String[0]);
                    variableDescription2.info("Parameter '" + string + "' is redefined in experiment " + variableDescription.getEnclosingDescription().getName(), "gaml.duplicate.definition.issue", "name", new String[0]);
                } else if (resource != null) {
                    variableDescription.info("This definition of '" + string + "' supersedes the one in imported file " + resource.getURI().lastSegment(), "gaml.redefinition.info", "name", new String[0]);
                }
            }
            return true;
        });
        this.parameters.put(variableDescription.getName(), variableDescription);
    }

    public boolean hasParameter(String string) {
        if (this.parameters == null) {
            return false;
        }
        return this.parameters.containsKey(string);
    }

    public VariableDescription getParameter(String string) {
        if (this.parameters == null) {
            return null;
        }
        return (VariableDescription)this.parameters.get(string);
    }

    public void inheritParametersFrom(ExperimentDescription experimentDescription) {
        if (experimentDescription.parameters != null) {
            for (VariableDescription variableDescription : experimentDescription.parameters.values()) {
                this.addInheritedParameter(variableDescription);
            }
        }
    }

    public void addInheritedParameter(VariableDescription variableDescription) {
        String string = variableDescription.getName();
        if (!this.hasParameter(string)) {
            this.addParameter(variableDescription.copy(this));
            return;
        }
        VariableDescription variableDescription2 = this.getParameter(string);
        if (this.assertAttributesAreCompatible(variableDescription, variableDescription2)) {
            if (!variableDescription2.isBuiltIn()) {
                this.markAttributeRedefinition(variableDescription, variableDescription2);
            }
            variableDescription2.copyFrom(variableDescription);
        }
    }

    @Override
    public void addInheritedAttribute(VariableDescription variableDescription) {
        if ("parameter".equals(variableDescription.getKeyword())) {
            this.addParameter(variableDescription);
        } else {
            super.addInheritedAttribute(variableDescription);
        }
    }

    @Override
    public void addOwnAttribute(VariableDescription variableDescription) {
        if (!"parameter".equals(variableDescription.getKeyword())) {
            super.addOwnAttribute(variableDescription);
        } else {
            this.addParameter(variableDescription);
        }
    }

    @Override
    public String getTitle() {
        return "experiment " + this.getName();
    }

    public String getExperimentTitleFacet() {
        return this.getLitteral("title");
    }

    @Override
    public boolean isExperiment() {
        return true;
    }

    @Override
    public boolean visitOwnChildren(IDescription.DescriptionVisitor<IDescription> descriptionVisitor) {
        if (!super.visitOwnChildren(descriptionVisitor) || this.parameters != null && !this.parameters.forEachValue(descriptionVisitor)) {
            return false;
        }
        return (this.output == null || descriptionVisitor.process(this.output)) && (this.permanent == null || descriptionVisitor.process(this.permanent));
    }

    @Override
    public boolean visitOwnChildrenRecursively(IDescription.DescriptionVisitor<IDescription> descriptionVisitor) {
        IDescription.DescriptionVisitor descriptionVisitor2 = iDescription -> {
            if (!descriptionVisitor.process((IDescription)iDescription)) {
                return false;
            }
            return iDescription.visitOwnChildrenRecursively(descriptionVisitor);
        };
        if (!super.visitOwnChildrenRecursively(descriptionVisitor) || this.parameters != null && !this.parameters.forEachValue(descriptionVisitor2)) {
            return false;
        }
        return (this.output == null || descriptionVisitor2.process(this.output)) && (this.permanent == null || descriptionVisitor2.process(this.permanent));
    }

    @Override
    public Iterable<IDescription> getOwnChildren() {
        return Iterables.concat(super.getOwnChildren(), (Iterable)(this.parameters == null ? Collections.EMPTY_LIST : this.parameters.values()), (Iterable)(this.output == null ? Collections.EMPTY_LIST : Collections.singleton(this.output)), (Iterable)(this.permanent == null ? Collections.EMPTY_LIST : Collections.singleton(this.permanent)));
    }

    @Override
    public boolean visitChildren(IDescription.DescriptionVisitor<IDescription> descriptionVisitor) {
        boolean bl = super.visitChildren(descriptionVisitor);
        if (!bl) {
            return false;
        }
        if (this.parameters != null) {
            bl &= this.parameters.forEachValue(descriptionVisitor);
        }
        if (!bl) {
            return false;
        }
        if (this.output != null) {
            bl &= descriptionVisitor.process(this.output);
        }
        if (!bl) {
            return false;
        }
        if (this.permanent != null) {
            bl &= descriptionVisitor.process(this.permanent);
        }
        return bl;
    }

    public Boolean isMemorize() {
        return this.isSet(IDescription.Flag.isMemorize);
    }

    public Boolean isBatch() {
        return this.isSet(IDescription.Flag.isBatch);
    }

    @Override
    public Class<? extends IExperimentAgent> getJavaBase() {
        String string = this.getLitteral("type");
        return GamaMetaModel.INSTANCE.getJavaBaseFor(string);
    }

    @Override
    public void inheritFromParent() {
        if (this.parent != null && this.parent != this && !this.parent.isBuiltIn()) {
            super.inheritFromParent();
            this.inheritParametersFrom((ExperimentDescription)this.parent);
            this.inheritOutputsFrom((ExperimentDescription)this.parent);
        }
    }

    private void inheritOutputsFrom(ExperimentDescription experimentDescription) {
        if (experimentDescription.output != null) {
            if (this.output == null) {
                this.output = experimentDescription.output.copy(this);
            } else {
                this.mergeOutputs(experimentDescription.output, this.output);
            }
        }
        if (experimentDescription.permanent != null) {
            if (this.permanent == null) {
                this.permanent = experimentDescription.permanent.copy(this);
            } else {
                this.mergeOutputs(experimentDescription.permanent, this.permanent);
            }
        }
    }

    private void mergeOutputs(StatementDescription statementDescription, StatementDescription statementDescription2) {
        statementDescription.visitChildren(iDescription -> {
            IDescription iDescription2 = ExperimentDescription.getSimilarChild(statementDescription2, iDescription);
            if (iDescription2 == null) {
                statementDescription2.addChild(iDescription.copy(statementDescription2));
            } else {
                iDescription2.info("This definition of " + iDescription2.getName() + " supersedes the one in " + iDescription.getSpeciesContext().getName(), "gaml.redefinition.info", "name", new String[0]);
            }
            return true;
        });
    }

    @Override
    protected void addBehavior(StatementDescription statementDescription) {
        if ("output".equals(statementDescription.getKeyword())) {
            this.output = statementDescription;
        } else if ("permanent".equals(statementDescription.getKeyword())) {
            this.permanent = statementDescription;
        } else {
            super.addBehavior(statementDescription);
        }
    }

    @Override
    protected boolean parentIsVisible() {
        if (!this.getParent().isExperiment()) {
            return false;
        }
        if (this.parent.isBuiltIn()) {
            return true;
        }
        ModelDescription modelDescription = (ModelDescription)this.getMacroSpecies();
        return modelDescription != null && modelDescription.getExperiment(this.parent.getName()) != null;
    }

    @Override
    public boolean visitMicroSpecies(IDescription.DescriptionVisitor<SpeciesDescription> descriptionVisitor) {
        return true;
    }
}

