/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.operators.spatial;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.geometry.Envelope3D;
import gama.core.common.geometry.GeometryUtils;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.GamaShapeFactory;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.gaml.compilation.annotations.depends_on;
import gama.gaml.operators.Cast;
import gama.gaml.operators.Maths;
import gama.gaml.operators.spatial.SpatialOperators;
import gama.gaml.operators.spatial.SpatialRelations;
import gama.gaml.operators.spatial.SpatialTransformations;
import gama.gaml.types.GamaGeometryType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;

public class SpatialCreation {
    @GamlAnnotations.operator(value={"circle"}, category={"Spatial operators", "Shape"}, concept={"shape", "geometry"})
    @GamlAnnotations.doc(value="A circle geometry which radius is equal to the operand.", masterDoc=true, usages={@GamlAnnotations.usage(value="returns a point if the radius operand is lower or equal to 0.")}, comment="the center of the circle is by default the location of the current agent in which has been called this operator.", examples={@GamlAnnotations.example(value="circle(10)", equals="a geometry as a circle of radius 10.", test=false)}, see={"around", "cone", "line", "link", "norm", "point", "polygon", "polyline", "rectangle", "square", "triangle"})
    public static IShape circle(IScope iScope, Double d) {
        GamaPoint gamaPoint;
        IAgent iAgent = iScope.getAgent();
        GamaPoint gamaPoint2 = gamaPoint = iAgent != null ? iAgent.getLocation() : new GamaPoint(0.0, 0.0);
        if (d <= 0.0) {
            return GamaShapeFactory.createFrom(gamaPoint);
        }
        return GamaGeometryType.buildCircle(d, gamaPoint);
    }

    @GamlAnnotations.operator(value={"circle"}, category={"Spatial operators", "Shape"}, concept={"shape", "geometry"})
    @GamlAnnotations.doc(value="A circle geometry which radius is equal to the first operand, and the center has the location equal to the second operand.", usages={@GamlAnnotations.usage(value="When circle is used with 2 operands, the second one is the center of the created circle.", examples={@GamlAnnotations.example(value="circle(10,{80,30})", equals="a geometry as a circle of radius 10, the center will be in the location {80,30}.", test=false)})}, see={"around", "cone", "line", "link", "norm", "point", "polygon", "polyline", "rectangle", "square", "triangle"})
    public static IShape circle(IScope iScope, Double d, GamaPoint gamaPoint) {
        GamaPoint gamaPoint2 = gamaPoint;
        if (d <= 0.0) {
            return GamaShapeFactory.createFrom(gamaPoint2);
        }
        return GamaGeometryType.buildCircle(d, gamaPoint2);
    }

    @GamlAnnotations.operator(value={"ellipse"}, category={"Spatial operators", "Shape"}, concept={"shape", "geometry"})
    @GamlAnnotations.doc(value="An ellipse geometry which x-radius is equal to the first operand and y-radius is equal to the second operand", usages={@GamlAnnotations.usage(value="returns a point if both operands are lower or equal to 0, a line if only one is.")}, comment="the center of the ellipse is by default the location of the current agent in which has been called this operator.", examples={@GamlAnnotations.example(value="ellipse(10, 10)", equals="a geometry as an ellipse of width 10 and height 10.", test=false)}, see={"around", "cone", "line", "link", "norm", "point", "polygon", "polyline", "rectangle", "square", "circle", "squircle", "triangle"})
    public static IShape ellipse(IScope iScope, Double d, Double d2) {
        GamaPoint gamaPoint;
        IAgent iAgent = iScope.getAgent();
        GamaPoint gamaPoint2 = gamaPoint = iAgent != null ? iAgent.getLocation() : new GamaPoint(0.0, 0.0);
        if (d <= 0.0 && d2 <= 0.0) {
            return GamaShapeFactory.createFrom(gamaPoint);
        }
        return GamaGeometryType.buildEllipse(d, d2, gamaPoint);
    }

    @GamlAnnotations.operator(value={"squircle"}, category={"Spatial operators", "Shape"}, concept={"shape", "geometry"})
    @GamlAnnotations.doc(value="A mix of square and circle geometry (see : http://en.wikipedia.org/wiki/Squircle), which side size is equal to the first operand and power is equal to the second operand", usages={@GamlAnnotations.usage(value="returns a point if the side operand is lower or equal to 0.")}, comment="the center of the ellipse is by default the location of the current agent in which has been called this operator.", examples={@GamlAnnotations.example(value="squircle(4,4)", equals="a geometry as a squircle of side 4 with a power of 4.", test=false)}, see={"around", "cone", "line", "link", "norm", "point", "polygon", "polyline", "super_ellipse", "rectangle", "square", "circle", "ellipse", "triangle"})
    public static IShape squicle(IScope iScope, Double d, Double d2) {
        GamaPoint gamaPoint;
        IAgent iAgent = iScope.getAgent();
        GamaPoint gamaPoint2 = gamaPoint = iAgent != null ? iAgent.getLocation() : new GamaPoint(0.0, 0.0);
        if (d <= 0.0) {
            return GamaShapeFactory.createFrom(gamaPoint);
        }
        return GamaGeometryType.buildSquircle(d, d2, gamaPoint);
    }

    @GamlAnnotations.operator(value={"arc"}, category={"Spatial operators", "Shape"}, concept={"shape", "geometry"})
    @GamlAnnotations.doc(value="An arc, which radius is equal to the first operand, heading to the second and amplitude the third", masterDoc=false, usages={@GamlAnnotations.usage(value="returns a point if the radius operand is lower or equal to 0.")}, comment="the center of the arc is by default the location of the current agent in which has been called this operator. This operator returns a polygon by default.", examples={@GamlAnnotations.example(value="arc(4,45,90)", equals="a geometry as an arc of radius 4, in a direction of 45\u00b0 and an amplitude of 90\u00b0", test=false)}, see={"around", "cone", "line", "link", "norm", "point", "polygon", "polyline", "super_ellipse", "rectangle", "square", "circle", "ellipse", "triangle"})
    public static IShape arc(IScope iScope, Double d, Double d2, Double d3) {
        return SpatialCreation.arc(iScope, d, d2, d3, true);
    }

    @GamlAnnotations.operator(value={"arc"}, category={"Spatial operators", "Shape"}, concept={})
    @GamlAnnotations.doc(value="An arc, which radius is equal to the first operand, heading to the second, amplitude to the third and a boolean indicating whether to return a linestring or a polygon to the fourth", masterDoc=true, usages={@GamlAnnotations.usage(value="returns a point if the radius operand is lower or equal to 0.")}, comment="the center of the arc is by default the location of the current agent in which has been called this operator.", examples={@GamlAnnotations.example(value="arc(4,45,90, false)", equals="a geometry as an arc of radius 4, in a direction of 45\u00b0 and an amplitude of 90\u00b0, which only contains the points on the arc", test=false)}, see={"around", "cone", "line", "link", "norm", "point", "polygon", "polyline", "super_ellipse", "rectangle", "square", "circle", "ellipse", "triangle"})
    public static IShape arc(IScope iScope, Double d, Double d2, Double d3, boolean bl) {
        GamaPoint gamaPoint;
        IAgent iAgent = iScope.getAgent();
        GamaPoint gamaPoint2 = gamaPoint = iAgent != null ? iAgent.getLocation() : new GamaPoint(0.0, 0.0);
        if (d <= 0.0) {
            return GamaShapeFactory.createFrom(gamaPoint);
        }
        return GamaGeometryType.buildArc(d * 2.0, d2, d3, bl, gamaPoint);
    }

    @GamlAnnotations.operator(value={"elliptical_arc"}, category={"Spatial operators", "Shape"}, concept={})
    @GamlAnnotations.doc(value="An elliptical arc from the first operand (point) to the second operand (point), which radius is equal to the third operand, and a int giving the number of points to use as a last operand", examples={@GamlAnnotations.example(value="elliptical_arc({0,0},{10,10},5.0, 20)", equals="a geometry from {0,0} to {10,10} considering a radius of 5.0 built using 20 points", test=false)}, see={"arc", "around", "cone", "line", "link", "norm", "point", "polygon", "polyline", "super_ellipse", "rectangle", "square", "circle", "ellipse", "triangle"})
    public static IShape ellipticalArc(IScope iScope, GamaPoint gamaPoint, GamaPoint gamaPoint2, double d, int n) {
        double d2 = gamaPoint.distance(gamaPoint2) / 2.0;
        double d3 = d;
        Coordinate[] coordinateArray = new Coordinate[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            double d4 = (double)n3 * (Math.PI / (double)n);
            double d5 = d2 * Math.cos(d4);
            double d6 = d3 * Math.sin(d4);
            coordinateArray[n2++] = new Coordinate(d5, d6);
            ++n3;
        }
        IShape iShape = GamaShapeFactory.createFrom((Geometry)GeometryUtils.GEOMETRY_FACTORY.createLineString(coordinateArray));
        iShape = SpatialTransformations.rotated_by(iScope, iShape, SpatialRelations.towards(iScope, gamaPoint2, gamaPoint));
        return SpatialTransformations.translated_by(iScope, iShape, gamaPoint.minus(iShape.getPoints().firstValue(iScope)));
    }

    @GamlAnnotations.operator(value={"cross"}, category={"Spatial operators", "Shape"}, concept={})
    @GamlAnnotations.doc(value="A cross, which radius is equal to the first operand (and eventually the width of the lines for the second)", masterDoc=true, examples={@GamlAnnotations.example(value="cross(10,2)", equals="a geometry as a cross of radius 10, and with a width of 2 for the lines ", test=false)}, see={"around", "cone", "line", "link", "norm", "point", "polygon", "polyline", "super_ellipse", "rectangle", "square", "circle", "ellipse", "triangle"})
    public static IShape cross(IScope iScope, Double d, Double d2) {
        GamaPoint gamaPoint;
        IAgent iAgent = iScope.getAgent();
        GamaPoint gamaPoint2 = gamaPoint = iAgent != null ? iAgent.getLocation() : new GamaPoint(0.0, 0.0);
        if (d <= 0.0) {
            return GamaShapeFactory.createFrom(gamaPoint);
        }
        return GamaGeometryType.buildCross(d, d2, gamaPoint);
    }

    @GamlAnnotations.operator(value={"cross"}, category={"Spatial operators", "Shape"}, concept={})
    @GamlAnnotations.doc(value="A cross, which radius is equal to the first operand", examples={@GamlAnnotations.example(value="cross(10)", equals="a geometry as a cross of radius 10", test=false)}, see={"around", "cone", "line", "link", "norm", "point", "polygon", "polyline", "super_ellipse", "rectangle", "square", "circle", "ellipse", "triangle"})
    public static IShape cross(IScope iScope, Double d) {
        GamaPoint gamaPoint;
        IAgent iAgent = iScope.getAgent();
        GamaPoint gamaPoint2 = gamaPoint = iAgent != null ? iAgent.getLocation() : new GamaPoint(0.0, 0.0);
        if (d <= 0.0) {
            return GamaShapeFactory.createFrom(gamaPoint);
        }
        return GamaGeometryType.buildCross(d, null, gamaPoint);
    }

    @GamlAnnotations.operator(value={"cylinder"}, category={"Spatial operators", "Shape", "3D"}, concept={"shape", "geometry"})
    @GamlAnnotations.doc(value="A cylinder geometry which radius is equal to the operand.", usages={@GamlAnnotations.usage(value="returns a point if the operand is lower or equal to 0.")}, comment="the center of the cylinder is by default the location of the current agent in which has been called this operator.", examples={@GamlAnnotations.example(value="cylinder(10,10)", equals="a geometry as a circle of radius 10.", test=false)}, see={"around", "cone", "line", "link", "norm", "point", "polygon", "polyline", "rectangle", "square", "triangle"})
    public static IShape cylinder(IScope iScope, Double d, Double d2) {
        GamaPoint gamaPoint;
        IAgent iAgent = iScope.getAgent();
        GamaPoint gamaPoint2 = gamaPoint = iAgent != null ? iAgent.getLocation() : new GamaPoint(0.0, 0.0);
        if (d <= 0.0) {
            return GamaShapeFactory.createFrom(gamaPoint);
        }
        return GamaGeometryType.buildCylinder(d, d2, gamaPoint);
    }

    @GamlAnnotations.operator(value={"sphere"}, category={"Spatial operators", "Shape", "3D"}, concept={"shape", "geometry", "3d"})
    @GamlAnnotations.doc(value="A sphere geometry which radius is equal to the operand.", usages={@GamlAnnotations.usage(value="returns a point if the operand is lower or equal to 0.")}, comment="the centre of the sphere is by default the location of the current agent in which has been called this operator.", examples={@GamlAnnotations.example(value="sphere(10)", equals="a geometry as a circle of radius 10 but displays a sphere.", test=false)}, see={"around", "cone", "line", "link", "norm", "point", "polygon", "polyline", "rectangle", "square", "triangle"})
    public static IShape sphere(IScope iScope, Double d) {
        GamaPoint gamaPoint;
        IAgent iAgent = iScope.getAgent();
        GamaPoint gamaPoint2 = gamaPoint = iAgent != null ? iAgent.getLocation() : new GamaPoint(0.0, 0.0);
        if (d <= 0.0) {
            return GamaShapeFactory.createFrom(gamaPoint);
        }
        return GamaGeometryType.buildSphere(d, gamaPoint);
    }

    @GamlAnnotations.operator(value={"teapot"}, category={"Spatial operators", "Shape", "3D"}, concept={"shape", "geometry", "3d"})
    @GamlAnnotations.doc(value="A teapot geometry which radius is equal to the operand.", special_cases={"returns a point if the operand is lower or equal to 0."}, comment="the centre of the teapot is by default the location of the current agent in which has been called this operator.", examples={@GamlAnnotations.example(value="teapot(10)", equals="a geometry as a circle of radius 10 but displays a teapot.", test=false)}, see={"around", "cone", "line", "link", "norm", "point", "polygon", "polyline", "rectangle", "square", "triangle"})
    public static IShape teapot(IScope iScope, Double d) {
        GamaPoint gamaPoint;
        IAgent iAgent = iScope.getAgent();
        GamaPoint gamaPoint2 = gamaPoint = iAgent != null ? iAgent.getLocation() : new GamaPoint(0.0, 0.0);
        if (d <= 0.0) {
            return GamaShapeFactory.createFrom(gamaPoint);
        }
        return GamaGeometryType.buildTeapot(d, gamaPoint);
    }

    @GamlAnnotations.operator(value={"cone"}, category={"Spatial operators", "Shape"}, concept={"shape", "geometry"})
    @GamlAnnotations.doc(value="A cone geometry which min and max angles are given by the operands.", masterDoc=true, special_cases={"returns nil if the operand is nil."}, comment="the center of the cone is by default the location of the current agent in which has been called this operator.", examples={@GamlAnnotations.example(value="cone(0, 45)", equals="a geometry as a cone with min angle is 0 and max angle is 45.", test=false)}, see={"around", "circle", "line", "link", "norm", "point", "polygon", "polyline", "rectangle", "square", "triangle"})
    @depends_on(value={"shape"})
    public static IShape cone(IScope iScope, Integer n, Integer n2) {
        if (n == null || n2 == null) {
            return null;
        }
        Double d = Maths.checkHeading(n);
        Double d2 = Maths.checkHeading(n2);
        IAgent iAgent = iScope.getAgent();
        GamaPoint gamaPoint = iAgent.getLocation() == null ? new GamaPoint(0.0, 0.0) : iAgent.getLocation();
        double d3 = gamaPoint.getX();
        double d4 = gamaPoint.getY();
        double d5 = iScope.getTopology().getWidth();
        double d6 = iScope.getTopology().getHeight();
        double d7 = Math.max(d5, d6);
        double d8 = d3 + Maths.cos(d) * d7;
        double d9 = d4 + Maths.sin(d) * d7;
        GamaPoint gamaPoint2 = new GamaPoint(d8, d9);
        double d10 = d3 + Maths.cos(d2) * d7;
        double d11 = d4 + Maths.sin(d2) * d7;
        GamaPoint gamaPoint3 = new GamaPoint(d10, d11);
        return SpatialCreation.polygon(iScope, GamaListFactory.wrap((IType)Types.POINT, gamaPoint, gamaPoint2, gamaPoint3));
    }

    @GamlAnnotations.operator(value={"cone"}, category={"Spatial operators", "Shape"}, concept={})
    @GamlAnnotations.doc(value="A cone geometry which min and max angles are given by the operands.", examples={@GamlAnnotations.example(value="cone({0, 45})", equals="a geometry as a cone with min angle is 0 and max angle is 45.", test=false)}, see={"around", "circle", "line", "link", "norm", "point", "polygon", "polyline", "rectangle", "square", "triangle"})
    public static IShape cone(IScope iScope, GamaPoint gamaPoint) {
        if (gamaPoint == null) {
            return null;
        }
        return SpatialCreation.cone(iScope, (int)gamaPoint.x, (int)gamaPoint.y);
    }

    @GamlAnnotations.operator(value={"cone3D"}, category={"Spatial operators", "Shape", "3D"}, concept={"shape", "geometry", "3d"})
    @GamlAnnotations.doc(value="A cone geometry which base radius size is equal to the first operand, and which the height is equal to the second operand.", special_cases={"returns a point if the operand is lower or equal to 0."}, comment="the center of the cone is by default the location of the current agent in which has been called this operator.", examples={@GamlAnnotations.example(value="cone3D(10.0,5.0)", equals="a geometry as a cone with a base circle of radius 10 and a height of 5.", test=false)}, see={"around", "cone", "line", "link", "norm", "point", "polygon", "polyline", "rectangle", "square", "triangle"})
    public static IShape cone3D(IScope iScope, Double d, Double d2) {
        GamaPoint gamaPoint;
        IAgent iAgent = iScope.getAgent();
        GamaPoint gamaPoint2 = gamaPoint = iAgent != null ? iAgent.getLocation() : new GamaPoint(0.0, 0.0);
        if (d <= 0.0) {
            return GamaShapeFactory.createFrom(gamaPoint);
        }
        return GamaGeometryType.buildCone3D(d, d2, gamaPoint);
    }

    @GamlAnnotations.operator(value={"square"}, category={"Spatial operators", "Shape"}, concept={"shape", "geometry"})
    @GamlAnnotations.doc(value="A square geometry which side size is equal to the operand.", usages={@GamlAnnotations.usage(value="returns nil if the operand is nil.")}, comment="the centre of the square is by default the location of the current agent in which has been called this operator.", examples={@GamlAnnotations.example(value="square(10)", equals="a geometry as a square of side size 10.", test=false), @GamlAnnotations.example(value="var0.area", equals="100.0", returnType="float")}, see={"around", "circle", "cone", "line", "link", "norm", "point", "polygon", "polyline", "rectangle", "triangle"})
    @GamlAnnotations.test(value="square(10).area = 100")
    public static IShape square(IScope iScope, Double d) {
        GamaPoint gamaPoint;
        IAgent iAgent = iScope.getAgent();
        GamaPoint gamaPoint2 = gamaPoint = iAgent != null ? iAgent.getLocation() : new GamaPoint(0.0, 0.0);
        if (d <= 0.0) {
            return GamaShapeFactory.createFrom(gamaPoint);
        }
        return GamaGeometryType.buildSquare(d, gamaPoint);
    }

    @GamlAnnotations.operator(value={"cube"}, category={"Spatial operators", "Shape", "3D"}, concept={"shape", "geometry", "3d"})
    @GamlAnnotations.doc(value="A cube geometry which side size is equal to the operand.", usages={@GamlAnnotations.usage(value="returns nil if the operand is nil.")}, comment="the center of the cube is by default the location of the current agent in which has been called this operator.", examples={@GamlAnnotations.example(value="cube(10)", equals="a geometry as a square of side size 10.", test=false)}, see={"around", "circle", "cone", "line", "link", "norm", "point", "polygon", "polyline", "rectangle", "triangle"})
    @GamlAnnotations.test(value="cube(10).volume = 1000")
    public static IShape cube(IScope iScope, Double d) {
        GamaPoint gamaPoint;
        IAgent iAgent = iScope.getAgent();
        GamaPoint gamaPoint2 = gamaPoint = iAgent != null ? iAgent.getLocation() : new GamaPoint(0.0, 0.0);
        if (d <= 0.0) {
            return GamaShapeFactory.createFrom(gamaPoint);
        }
        return GamaGeometryType.buildCube(d, gamaPoint);
    }

    @GamlAnnotations.operator(value={"rectangle"}, category={"Spatial operators", "Shape"}, concept={"shape", "geometry"})
    @GamlAnnotations.doc(value="A rectangle geometry which side sizes are given by the operands (as a point).", comment="the center of the rectangle is by default the location of the current agent in which has been called this operator.", examples={@GamlAnnotations.example(value="rectangle({10, 5})", equals="a geometry as a rectangle with width = 10 and height = 5.", test=false)}, see={"around", "circle", "cone", "line", "link", "norm", "point", "polygon", "polyline", "square", "triangle"})
    @GamlAnnotations.test(value="rectangle({10, 5}).area = 50.0")
    public static IShape rectangle(IScope iScope, GamaPoint gamaPoint) {
        IAgent iAgent = iScope.getAgent();
        GamaPoint gamaPoint2 = iAgent != null ? iAgent.getLocation() : new GamaPoint(0.0, 0.0);
        return GamaGeometryType.buildRectangle(gamaPoint.x, gamaPoint.y, gamaPoint2);
    }

    @GamlAnnotations.operator(value={"rectangle"}, category={"Spatial operators", "Shape"}, concept={})
    @GamlAnnotations.doc(value="A rectangle geometry, computed from the operands values (e.g. the 2 side sizes).", masterDoc=true, usages={@GamlAnnotations.usage(value="returns nil if the operand is nil.")}, comment="the center of the rectangle is by default the location of the current agent in which has been called this operator.", examples={@GamlAnnotations.example(value="rectangle(10, 5)", equals="a geometry as a rectangle with width = 10 and height = 5.", test=false)}, see={"around", "circle", "cone", "line", "link", "norm", "point", "polygon", "polyline", "square", "triangle"})
    @GamlAnnotations.test(value="rectangle(10, 5).area = 50.0")
    public static IShape rectangle(IScope iScope, double d, double d2) {
        IAgent iAgent = iScope.getAgent();
        GamaPoint gamaPoint = iAgent != null ? iAgent.getLocation() : new GamaPoint(0.0, 0.0);
        return GamaGeometryType.buildRectangle(d, d2, gamaPoint);
    }

    @GamlAnnotations.operator(value={"rectangle"}, category={"Spatial operators", "Shape"}, concept={})
    @GamlAnnotations.doc(value="A rectangle geometry which upper-left and lower-right corners are defined as points.", examples={@GamlAnnotations.example(value="rectangle({0.0,0.0}, {10.0,10.0})", equals="a geometry as a rectangle with {1.0,1.0} as the upper-left corner, {10.0,10.0} as the lower-right corner.", test=false)}, see={"around", "circle", "cone", "line", "link", "norm", "point", "polygon", "polyline", "square", "triangle"})
    @GamlAnnotations.test(value="rectangle({0.0,0.0}, {10.0,10.0}).area = 100.0")
    public static IShape rectangle(IScope iScope, GamaPoint gamaPoint, GamaPoint gamaPoint2) {
        double d = Math.abs(gamaPoint.x - gamaPoint2.x);
        double d2 = Math.abs(gamaPoint.y - gamaPoint2.y);
        GamaPoint gamaPoint3 = new GamaPoint(Math.min(gamaPoint.x, gamaPoint2.x), Math.min(gamaPoint.y, gamaPoint2.y));
        GamaPoint gamaPoint4 = new GamaPoint(gamaPoint3.x + d / 2.0, gamaPoint3.y + d2 / 2.0);
        return GamaGeometryType.buildRectangle(d, d2, gamaPoint4);
    }

    @GamlAnnotations.operator(value={"box"}, category={"Spatial operators", "Shape", "3D"}, concept={"shape", "geometry", "3d"})
    @GamlAnnotations.doc(value="A box geometry which side sizes are given by the operands.", masterDoc=true, usages={@GamlAnnotations.usage(value="returns nil if the operand is nil.")}, comment="the center of the box is by default the location of the current agent in which has been called this operator.", examples={@GamlAnnotations.example(value="box({10, 5 , 5})", equals="a geometry as a rectangle with width = 10, height = 5 depth= 5.", test=false), @GamlAnnotations.example(value=" (box({10, 10 , 5}) at_location point(50,50,0)).location.y", equals="50.0", returnType="float")}, see={"around", "circle", "sphere", "cone", "line", "link", "norm", "point", "polygon", "polyline", "square", "cube", "triangle"})
    public static IShape box(IScope iScope, GamaPoint gamaPoint) {
        IAgent iAgent = iScope.getAgent();
        GamaPoint gamaPoint2 = iAgent != null ? iAgent.getLocation() : new GamaPoint(0.0, 0.0);
        return GamaGeometryType.buildBox(gamaPoint.x, gamaPoint.y, gamaPoint.z, gamaPoint2);
    }

    @GamlAnnotations.operator(value={"box"}, category={"Spatial operators", "Shape", "3D"}, concept={})
    @GamlAnnotations.doc(value="A box geometry which side sizes are given by the operands.", usages={@GamlAnnotations.usage(value="returns nil if the operand is nil.")}, comment="the center of the box is by default the location of the current agent in which has been called this operator.", examples={@GamlAnnotations.example(value="box(10, 5 , 5)", equals="a geometry as a rectangle with width = 10, height = 5 depth= 5.", test=false)}, see={"around", "circle", "sphere", "cone", "line", "link", "norm", "point", "polygon", "polyline", "square", "cube", "triangle"})
    @GamlAnnotations.test(value="box(10,5,5).volume = 250")
    public static IShape box(IScope iScope, double d, double d2, double d3) {
        IAgent iAgent = iScope.getAgent();
        GamaPoint gamaPoint = iAgent != null ? iAgent.getLocation() : new GamaPoint(0.0, 0.0);
        return GamaGeometryType.buildBox(d, d2, d3, gamaPoint);
    }

    @GamlAnnotations.operator(value={"triangle"}, category={"Spatial operators", "Shape"}, concept={"shape", "geometry"})
    @GamlAnnotations.doc(value="A triangle geometry which side size is given by the operand.", usages={@GamlAnnotations.usage(value="returns nil if the operand is nil.")}, comment="the center of the triangle is by default the location of the current agent in which has been called this operator.", examples={@GamlAnnotations.example(value="triangle(5)", equals="a geometry as a triangle with side_size = 5.", test=false)}, see={"around", "circle", "cone", "line", "link", "norm", "point", "polygon", "polyline", "rectangle", "square"})
    public static IShape triangle(IScope iScope, Double d) {
        GamaPoint gamaPoint;
        IAgent iAgent = iScope.getAgent();
        GamaPoint gamaPoint2 = gamaPoint = iAgent != null ? iAgent.getLocation() : new GamaPoint(0.0, 0.0);
        if (d <= 0.0) {
            return GamaShapeFactory.createFrom(gamaPoint);
        }
        return GamaGeometryType.buildTriangle(d, gamaPoint);
    }

    @GamlAnnotations.operator(value={"triangle"}, category={"Spatial operators", "Shape"}, concept={"shape", "geometry"})
    @GamlAnnotations.doc(value="A triangle geometry which the base and height size are given by the operand.", usages={@GamlAnnotations.usage(value="returns nil if one of the operand is nil.")}, comment="the center of the triangle is by default the location of the current agent in which has been called this operator.", examples={@GamlAnnotations.example(value="triangle(5, 10)", equals="a geometry as a triangle with a base of 5m and a height of 10m.", test=false)}, see={"around", "circle", "cone", "line", "link", "norm", "point", "polygon", "polyline", "rectangle", "square"})
    public static IShape triangle(IScope iScope, Double d, Double d2) {
        GamaPoint gamaPoint;
        IAgent iAgent = iScope.getAgent();
        GamaPoint gamaPoint2 = gamaPoint = iAgent != null ? iAgent.getLocation() : new GamaPoint(0.0, 0.0);
        if (d <= 0.0 || d2 <= 0.0) {
            return GamaShapeFactory.createFrom(gamaPoint);
        }
        return GamaGeometryType.buildTriangle(d, d2, gamaPoint);
    }

    @GamlAnnotations.operator(value={"pyramid"}, category={"Spatial operators", "Shape", "3D"}, concept={"shape", "geometry", "3d"})
    @GamlAnnotations.doc(value="A square geometry which side size is given by the operand.", usages={@GamlAnnotations.usage(value="returns nil if the operand is nil.")}, comment="the center of the pyramid is by default the location of the current agent in which has been called this operator.", examples={@GamlAnnotations.example(value="pyramid(5)", equals="a geometry as a square with side_size = 5.", test=false)}, see={"around", "circle", "cone", "line", "link", "norm", "point", "polygon", "polyline", "rectangle", "square"})
    public static IShape pyramid(IScope iScope, Double d) {
        GamaPoint gamaPoint;
        IAgent iAgent = iScope.getAgent();
        GamaPoint gamaPoint2 = gamaPoint = iAgent != null ? iAgent.getLocation() : new GamaPoint(0.0, 0.0);
        if (d <= 0.0) {
            return GamaShapeFactory.createFrom(gamaPoint);
        }
        return GamaGeometryType.buildPyramid(d, gamaPoint);
    }

    @GamlAnnotations.operator(value={"hexagon"}, category={"Spatial operators", "Shape"}, concept={"shape", "geometry"})
    @GamlAnnotations.doc(value="A hexagon geometry which the given with and height", masterDoc=true, usages={@GamlAnnotations.usage(value="returns nil if the operand is nil.")}, comment="the center of the hexagon is by default the location of the current agent in which has been called this operator.", examples={@GamlAnnotations.example(value="hexagon(10)", equals="a geometry as a hexagon of width of 10 and height of 10.", test=false)}, see={"around", "circle", "cone", "line", "link", "norm", "point", "polygon", "polyline", "rectangle", "triangle"})
    public static IShape hexagon(IScope iScope, Double d) {
        GamaPoint gamaPoint;
        IAgent iAgent = iScope.getAgent();
        GamaPoint gamaPoint2 = gamaPoint = iAgent != null ? iAgent.getLocation() : new GamaPoint(0.0, 0.0);
        if (d <= 0.0) {
            return GamaShapeFactory.createFrom(gamaPoint);
        }
        return GamaGeometryType.buildHexagon(d, gamaPoint);
    }

    @GamlAnnotations.operator(value={"hexagon"}, category={"Spatial operators", "Shape", "3D"}, concept={"3d"})
    @GamlAnnotations.doc(value="A hexagon geometry which the given width and height", examples={@GamlAnnotations.example(value="hexagon({10,5})", equals="a geometry as a hexagon of width of 10 and height of 5.", test=false)}, see={"around", "circle", "cone", "line", "link", "norm", "point", "polygon", "polyline", "rectangle", "triangle"})
    public static IShape hexagon(IScope iScope, GamaPoint gamaPoint) {
        IAgent iAgent = iScope.getAgent();
        GamaPoint gamaPoint2 = iAgent != null ? iAgent.getLocation() : new GamaPoint(0.0, 0.0);
        Double d = gamaPoint.x;
        Double d2 = gamaPoint.y;
        if (d <= 0.0 || d2 <= 0.0) {
            return GamaShapeFactory.createFrom(gamaPoint2);
        }
        return GamaGeometryType.buildHexagon((double)d, (double)d2, gamaPoint2);
    }

    @GamlAnnotations.operator(value={"hexagon"}, category={"Spatial operators", "Shape", "3D"}, concept={"3d"})
    @GamlAnnotations.doc(value="A hexagon geometry which the given width and height", examples={@GamlAnnotations.example(value="hexagon(10,5)", equals="a geometry as a hexagon of width of 10 and height of 5.", test=false)}, see={"around", "circle", "cone", "line", "link", "norm", "point", "polygon", "polyline", "rectangle", "triangle"})
    public static IShape hexagon(IScope iScope, Double d, Double d2) {
        GamaPoint gamaPoint;
        IAgent iAgent = iScope.getAgent();
        GamaPoint gamaPoint2 = gamaPoint = iAgent != null ? iAgent.getLocation() : new GamaPoint(0.0, 0.0);
        if (d == null || d2 == null || d <= 0.0 || d2 <= 0.0) {
            return GamaShapeFactory.createFrom(gamaPoint);
        }
        return GamaGeometryType.buildHexagon((double)d, (double)d2, gamaPoint);
    }

    @GamlAnnotations.operator(value={"polygon"}, expected_content_type={7, 13, 11}, category={"Spatial operators", "Shape"}, concept={"shape", "geometry", "point"})
    @GamlAnnotations.doc(value="A polygon geometry from the given list of points.", usages={@GamlAnnotations.usage(value="if the operand is nil, returns the point geometry {0,0}"), @GamlAnnotations.usage(value="if the operand is composed of a single point, returns a point geometry"), @GamlAnnotations.usage(value="if the operand is composed of 2 points, returns a polyline geometry.")}, examples={@GamlAnnotations.example(value="polygon([{0,0}, {0,10}, {10,10}, {10,0}])", equals="a polygon geometry composed of the 4 points.", test=false), @GamlAnnotations.example(value="polygon([{0,0}, {0,10}, {10,10}, {10,0}]).area", equals="100.0", returnType="float"), @GamlAnnotations.example(value="polygon([{0,0}, {0,10}, {10,10}, {10,0}]).location", equals="point(5.0,5.0,0.0)", returnType="point")}, see={"around", "circle", "cone", "line", "link", "norm", "point", "polyline", "rectangle", "square", "triangle"})
    public static IShape polygon(IScope iScope, IContainer<?, ? extends IShape> iContainer) {
        if (iContainer == null || iContainer.isEmpty(iScope)) {
            return GamaShapeFactory.createFrom(new GamaPoint(0.0, 0.0));
        }
        IList iList = GamaListFactory.create(iScope, (IType)Types.GEOMETRY, iContainer);
        int n = iList.length(iScope);
        IShape iShape = (IShape)iList.firstValue(iScope);
        if (n == 1) {
            return GamaGeometryType.createPoint(iShape);
        }
        if (n == 2) {
            return GamaGeometryType.buildLine(iShape, (IShape)iList.lastValue(iScope));
        }
        if (!iShape.equals(iList.lastValue(iScope))) {
            iList.add(iShape);
        }
        return GamaGeometryType.buildPolygon(iList);
    }

    @GamlAnnotations.operator(value={"polyhedron"}, expected_content_type={7, 13, 11}, category={"Spatial operators", "Shape"}, concept={"shape", "geometry", "point"})
    @GamlAnnotations.doc(value="A polyhedron geometry from the given list of points.", usages={@GamlAnnotations.usage(value="if the operand is nil, returns the point geometry {0,0}"), @GamlAnnotations.usage(value="if the operand is composed of a single point, returns a point geometry"), @GamlAnnotations.usage(value="if the operand is composed of 2 points, returns a polyline geometry.")}, examples={@GamlAnnotations.example(value="polyhedron([{0,0}, {0,10}, {10,10}, {10,0}],10)", equals="a polygon geometry composed of the 4 points and of depth 10.", test=false)}, see={"around", "circle", "cone", "line", "link", "norm", "point", "polyline", "rectangle", "square", "triangle"})
    public static IShape polyhedron(IScope iScope, IContainer<?, IShape> iContainer, Double d) {
        if (iContainer == null || iContainer.isEmpty(iScope)) {
            return GamaShapeFactory.createFrom(new GamaPoint(0.0, 0.0));
        }
        IList iList = GamaListFactory.create(iScope, (IType)Types.POINT, iContainer);
        int n = iList.length(iScope);
        IShape iShape = (IShape)iList.firstValue(iScope);
        if (n == 1) {
            return GamaGeometryType.createPoint(iShape);
        }
        IShape iShape2 = (IShape)iList.lastValue(iScope);
        if (n == 2) {
            return GamaGeometryType.buildLine(iShape, iShape2);
        }
        if (!iShape.equals(iShape2)) {
            iList.add(iShape);
        }
        return GamaGeometryType.buildPolyhedron(iList, d);
    }

    @GamlAnnotations.operator(value={"curve"}, expected_content_type={7, 13, 11}, category={"Spatial operators", "Shape"}, concept={"shape", "geometry", "point"})
    @GamlAnnotations.doc(value="The operator computes a Bezier curve geometry between the given operators, with 10 or a given number of points, and from left to rigth or right to left.", masterDoc=true, usages={@GamlAnnotations.usage(value="if one  of the operand is nil, returns nil"), @GamlAnnotations.usage(value="When used with 3 points, it computes a quadratic Bezier curve geometry built from the three given points and composed of 10 points.", examples={@GamlAnnotations.example(value="curve({0,0}, {0,10}, {10,10})", equals="a quadratic Bezier curve geometry composed of 10 points from p0 to p2.", test=false)})}, see={"around", "circle", "cone", "link", "norm", "point", "polygone", "rectangle", "square", "triangle", "line"})
    public static IShape bezierCurve(IScope iScope, GamaPoint gamaPoint, GamaPoint gamaPoint2, GamaPoint gamaPoint3) {
        if (gamaPoint == null || gamaPoint2 == null || gamaPoint3 == null) {
            return null;
        }
        return GamaGeometryType.buildPolyline(SpatialCreation.quadraticBezierCurve(gamaPoint, gamaPoint2, gamaPoint3, 10));
    }

    @GamlAnnotations.operator(value={"curve"}, expected_content_type={7, 13, 11}, category={"Spatial operators", "Shape"}, concept={})
    @GamlAnnotations.doc(value="A quadratic Bezier curve geometry built from the three given points composed of a given numnber of points.", usages={@GamlAnnotations.usage(value="When used with 3 points and an integer, it  computes a quadratic Bezier curve geometry built from the three given points. If the last operand (number of points) is inferior to 2, returns nil", examples={@GamlAnnotations.example(value="curve({0,0}, {0,10}, {10,10}, 20)", equals="a quadratic Bezier curve geometry composed of 20 points from p0 to p2.", test=false)})}, see={"around", "circle", "cone", "link", "norm", "point", "polygone", "rectangle", "square", "triangle", "line"})
    public static IShape bezierCurve(IScope iScope, GamaPoint gamaPoint, GamaPoint gamaPoint2, GamaPoint gamaPoint3, int n) {
        if (gamaPoint == null || gamaPoint2 == null || gamaPoint3 == null || n < 2) {
            return null;
        }
        return GamaGeometryType.buildPolyline(SpatialCreation.quadraticBezierCurve(gamaPoint, gamaPoint2, gamaPoint3, n));
    }

    @GamlAnnotations.operator(value={"curve"}, expected_content_type={7, 13, 11}, category={"Spatial operators", "Shape"}, concept={})
    @GamlAnnotations.doc(value="A cubic Bezier curve geometry built from the four given points composed of 10 points.", usages={@GamlAnnotations.usage(value="When used with 4 points, it computes, it computes a cubic Bezier curve geometry built from the four given points and composed of 10 points. ", examples={@GamlAnnotations.example(value="curve({0,0}, {0,10}, {10,10})", equals="a cubic Bezier curve geometry composed of 10 points from p0 to p3.", test=false)})}, see={"around", "circle", "cone", "link", "norm", "point", "polygone", "rectangle", "square", "triangle", "line"})
    public static IShape bezierCurve(IScope iScope, GamaPoint gamaPoint, GamaPoint gamaPoint2, GamaPoint gamaPoint3, GamaPoint gamaPoint4) {
        if (gamaPoint == null || gamaPoint2 == null || gamaPoint3 == null || gamaPoint4 == null) {
            return null;
        }
        return GamaGeometryType.buildPolyline(SpatialCreation.cubicBezierCurve(gamaPoint, gamaPoint2, gamaPoint3, gamaPoint4, 10));
    }

    @GamlAnnotations.operator(value={"curve"}, expected_content_type={7, 13, 11}, category={"Spatial operators", "Shape"}, concept={})
    @GamlAnnotations.doc(value="A cubic Bezier curve geometry built from the two given points with the given coefficient for the radius and composed of 10 points.", usages={@GamlAnnotations.usage(value="When used with 2 points and a float coefficient, it computes a cubic Bezier curve geometry built from the two given points with the given coefficient for the radius and composed of 10 points.", examples={@GamlAnnotations.example(value="curve({0,0},{10,10}, 0.5)", equals="a cubic Bezier curve geometry composed of 10 points from p0 to p1.", test=false)})}, see={"around", "circle", "cone", "link", "norm", "point", "polygone", "rectangle", "square", "triangle", "line"})
    public static IShape bezierCurve(IScope iScope, GamaPoint gamaPoint, GamaPoint gamaPoint2, Double d) {
        return SpatialCreation.bezierCurve(iScope, gamaPoint, gamaPoint2, d, true, 10, 0.5);
    }

    @GamlAnnotations.operator(value={"curve"}, expected_content_type={7, 13, 11}, category={"Spatial operators", "Shape"}, concept={})
    @GamlAnnotations.doc(value="A cubic Bezier curve geometry built from the two given points with the given coefficient for the radius and composed of 10 points - the last boolean is used to specified if it is the right side.", usages={@GamlAnnotations.usage(value="When used with 2 points, a float coefficient and a boolean, it computes a cubic Bezier curve geometry built from the two given points with the given coefficient for the radius and composed of 10 points. The last boolean is used to specified if it is the right side.", examples={@GamlAnnotations.example(value="curve({0,0},{10,10}, 0.5, false)", equals="a cubic Bezier curve geometry composed of 10 points from p0 to p1 at the left side.", test=false)})}, see={"around", "circle", "cone", "link", "norm", "point", "polygone", "rectangle", "square", "triangle", "line"})
    public static IShape bezierCurve(IScope iScope, GamaPoint gamaPoint, GamaPoint gamaPoint2, Double d, boolean bl) {
        return SpatialCreation.bezierCurve(iScope, gamaPoint, gamaPoint2, d, bl, 10, 0.5);
    }

    @GamlAnnotations.operator(value={"curve"}, expected_content_type={7, 13, 11}, category={"Spatial operators", "Shape"}, concept={})
    @GamlAnnotations.doc(value="A cubic Bezier curve geometry built from the two given points with the given coefficient for the radius and composed of the given number of points - the boolean is used to specified if it is the right side.", usages={@GamlAnnotations.usage(value="When used with 2 points, a float coefficient, a boolean, and an integer number of points, it computes a cubic Bezier curve geometry built from the two given points with the given coefficient for the radius and composed of the given number of points - the boolean is used to specified if it is the right side.", examples={@GamlAnnotations.example(value="curve({0,0},{10,10}, 0.5, false, 100)", equals="a cubic Bezier curve geometry composed of 100 points from p0 to p1 at the right side.", test=false)})}, see={"around", "circle", "cone", "link", "norm", "point", "polygone", "rectangle", "square", "triangle", "line"})
    public static IShape bezierCurve(IScope iScope, GamaPoint gamaPoint, GamaPoint gamaPoint2, Double d, boolean bl, int n) {
        return SpatialCreation.bezierCurve(iScope, gamaPoint, gamaPoint2, d, bl, n, 0.5);
    }

    @GamlAnnotations.operator(value={"curve"}, expected_content_type={7, 13, 11}, category={"Spatial operators", "Shape"}, concept={})
    @GamlAnnotations.doc(value="A cubic Bezier curve geometry built from the two given points with the given coefficient for the radius and composed of the given number of points - the boolean is used to specified if it is the right side and the last value to indicate where is the inflection point (between 0.0 and 1.0 - default 0.5).", usages={@GamlAnnotations.usage(value="When used with 2 points, a float coefficient, a boolean, an integer number of points, and a float proportion, it computes a cubic Bezier curve geometry built from the two given points with the given coefficient for the radius and composed of the given number of points - the boolean is used to specified if it is the right side and the last value to indicate where is the inflection point (between 0.0 and 1.0 - default 0.5).", examples={@GamlAnnotations.example(value="curve({0,0},{10,10}, 0.5, false, 100, 0.8)", equals="a cubic Bezier curve geometry composed of 100 points from p0 to p1 at the right side.", test=false)})}, see={"around", "circle", "cone", "link", "norm", "point", "polygone", "rectangle", "square", "triangle", "line"})
    public static IShape bezierCurve(IScope iScope, GamaPoint gamaPoint, GamaPoint gamaPoint2, Double d, boolean bl, int n, double d2) {
        if (gamaPoint == null || gamaPoint2 == null) {
            return null;
        }
        GamaPoint gamaPoint3 = new GamaPoint(gamaPoint.x + (gamaPoint2.x - gamaPoint.x) * d2, gamaPoint.y + (gamaPoint2.y - gamaPoint.y) * d2, gamaPoint.z + (gamaPoint2.z - gamaPoint.z) * d2);
        double d3 = d * gamaPoint.euclidianDistanceTo(gamaPoint2);
        double d4 = SpatialRelations.towards(iScope, gamaPoint, gamaPoint2);
        gamaPoint3 = new GamaPoint(gamaPoint3.x + Maths.cos(d4 + 90.0 * (bl ? 1.0 : -1.0)) * d3, gamaPoint3.y + Maths.sin(d4 + 90.0 * (bl ? 1.0 : -1.0)) * d3, gamaPoint3.z);
        return SpatialCreation.bezierCurve(iScope, gamaPoint, gamaPoint3, gamaPoint2, n);
    }

    @GamlAnnotations.operator(value={"curve"}, expected_content_type={7, 13, 11}, category={"Spatial operators", "Shape"}, concept={})
    @GamlAnnotations.doc(value="A cubic Bezier curve geometry built from the two given points with the given coefficient for the radius and composed of the given number of points, considering the given inflection point (between 0.0 and 1.0 - default 0.5), and the given rotation angle (90 = along the z axis).", usages={@GamlAnnotations.usage(value="When used with 2 points, a float coefficient, a boolean, an integer number of points, a float proportion, and a float angle, it computes a cubic Bezier curve geometry built from the two given points with the given coefficient for the radius and composed of the given number of points, considering the given inflection point (between 0.0 and 1.0 - default 0.5), and the given rotation angle (90 = along the z axis).", examples={@GamlAnnotations.example(value="curve({0,0},{10,10}, 0.5, 100, 0.8, 90)", equals="a cubic Bezier curve geometry composed of 100 points from p0 to p1 at the right side.", test=false)})}, see={"around", "circle", "cone", "link", "norm", "point", "polygone", "rectangle", "square", "triangle", "line"})
    public static IShape bezierCurve(IScope iScope, GamaPoint gamaPoint, GamaPoint gamaPoint2, Double d, int n, double d2, double d3) {
        if (gamaPoint == null || gamaPoint2 == null) {
            return null;
        }
        IShape iShape = SpatialCreation.bezierCurve(iScope, gamaPoint, gamaPoint2, d, false, n, d2);
        if ((iShape = SpatialTransformations.rotated_by(iScope, iShape, d3, new GamaPoint(gamaPoint.x - gamaPoint2.x, gamaPoint.y - gamaPoint2.y, gamaPoint.z - gamaPoint2.z))) == null) {
            return null;
        }
        GamaPoint gamaPoint3 = (GamaPoint)iShape.getPoints().get(0);
        return SpatialTransformations.translated_by(iScope, iShape, new GamaPoint(gamaPoint.x - gamaPoint3.x, gamaPoint.y - gamaPoint3.y, gamaPoint.z - gamaPoint3.z));
    }

    @GamlAnnotations.operator(value={"curve"}, expected_content_type={7, 13, 11}, category={"Spatial operators", "Shape"}, concept={})
    @GamlAnnotations.doc(value="A cubic Bezier curve geometry built from the two given points with the given coefficient for the radius and composed of the given number of points, considering the given rotation angle (90 = along the z axis).", usages={@GamlAnnotations.usage(value="When used with 2 points, a float coefficient, a boolean, an integer number of points, and a float angle, it computes a cubic Bezier curve geometry built from the two given points with the given coefficient for the radius and composed of the given number of points, considering the given rotation angle (90 = along the z axis).", examples={@GamlAnnotations.example(value="curve({0,0},{10,10}, 0.5, 100, 90)", equals="a cubic Bezier curve geometry composed of 100 points from p0 to p1 at the right side.", test=false)})}, see={"around", "circle", "cone", "link", "norm", "point", "polygone", "rectangle", "square", "triangle", "line"})
    public static IShape bezierCurve(IScope iScope, GamaPoint gamaPoint, GamaPoint gamaPoint2, Double d, int n, double d2) {
        return SpatialCreation.bezierCurve(iScope, gamaPoint, gamaPoint2, d, n, 0.5, d2);
    }

    @GamlAnnotations.operator(value={"curve"}, expected_content_type={7, 13, 11}, category={"Spatial operators", "Shape"}, concept={})
    @GamlAnnotations.doc(value="A cubic Bezier curve geometry built from the two given points with the given coefficient for the radius considering the given rotation angle (90 = along the z axis).", usages={@GamlAnnotations.usage(value="When used with 2 points, a float coefficient, and a float angle, it computes a cubic Bezier curve geometry built from the two given points with the given coefficient for the radius considering the given rotation angle (90 = along the z axis).", examples={@GamlAnnotations.example(value="curve({0,0},{10,10}, 0.5, 90)", equals="a cubic Bezier curve geometry composed of 100 points from p0 to p1 at the right side.", test=false)})}, see={"around", "circle", "cone", "link", "norm", "point", "polygone", "rectangle", "square", "triangle", "line"})
    public static IShape bezierCurve(IScope iScope, GamaPoint gamaPoint, GamaPoint gamaPoint2, Double d, double d2) {
        return SpatialCreation.bezierCurve(iScope, gamaPoint, gamaPoint2, d, 10, 0.5, d2);
    }

    @GamlAnnotations.operator(value={"curve"}, expected_content_type={7, 13, 11}, category={"Spatial operators", "Shape"}, concept={})
    @GamlAnnotations.doc(value="A cubic Bezier curve geometry built from the four given points composed of a given number of points.", usages={@GamlAnnotations.usage(value="When used with 4 points and an integer number of  points, it computes a cubic Bezier curve geometry built from the four given points composed of a given number of points. If the number of points is  lower than 2, it returns nil.", examples={@GamlAnnotations.example(value="curve({0,0}, {0,10}, {10,10})", equals="a cubic Bezier curve geometry composed of 10 points from p0 to p3.", test=false)})}, see={"around", "circle", "cone", "link", "norm", "point", "polygone", "rectangle", "square", "triangle", "line"})
    public static IShape bezierCurve(IScope iScope, GamaPoint gamaPoint, GamaPoint gamaPoint2, GamaPoint gamaPoint3, GamaPoint gamaPoint4, int n) {
        if (gamaPoint == null || gamaPoint2 == null || gamaPoint3 == null || gamaPoint4 == null || n < 2) {
            return null;
        }
        return GamaGeometryType.buildPolyline(SpatialCreation.cubicBezierCurve(gamaPoint, gamaPoint2, gamaPoint3, gamaPoint4, n));
    }

    private static List<IShape> quadraticBezierCurve(GamaPoint gamaPoint, GamaPoint gamaPoint2, GamaPoint gamaPoint3, int n) {
        ArrayList<IShape> arrayList = new ArrayList<IShape>();
        int n2 = 0;
        while (n2 < n) {
            double d = SpatialCreation.quadraticBezier(gamaPoint.x, gamaPoint2.x, gamaPoint3.x, (double)n2 / (double)(n - 1));
            double d2 = SpatialCreation.quadraticBezier(gamaPoint.y, gamaPoint2.y, gamaPoint3.y, (double)n2 / (double)(n - 1));
            double d3 = SpatialCreation.quadraticBezier(gamaPoint.z, gamaPoint2.z, gamaPoint3.z, (double)n2 / (double)(n - 1));
            arrayList.add(new GamaPoint(d, d2, d3));
            ++n2;
        }
        return arrayList;
    }

    private static List<IShape> cubicBezierCurve(GamaPoint gamaPoint, GamaPoint gamaPoint2, GamaPoint gamaPoint3, GamaPoint gamaPoint4, int n) {
        ArrayList<IShape> arrayList = new ArrayList<IShape>();
        int n2 = 0;
        while (n2 < n) {
            double d = SpatialCreation.cubicBezier(gamaPoint.x, gamaPoint2.x, gamaPoint3.x, gamaPoint4.x, (double)n2 / (double)(n - 1));
            double d2 = SpatialCreation.cubicBezier(gamaPoint.y, gamaPoint2.y, gamaPoint3.y, gamaPoint4.y, (double)n2 / (double)(n - 1));
            double d3 = SpatialCreation.cubicBezier(gamaPoint.z, gamaPoint2.z, gamaPoint3.z, gamaPoint4.z, (double)n2 / (double)(n - 1));
            arrayList.add(new GamaPoint(d, d2, d3));
            ++n2;
        }
        return arrayList;
    }

    private static double quadraticBezier(double d, double d2, double d3, double d4) {
        return (1.0 - d4) * ((1.0 - d4) * d + d4 * d2) + d4 * ((1.0 - d4) * d2 + d4 * d3);
    }

    private static double cubicBezier(double d, double d2, double d3, double d4, double d5) {
        return Math.pow(1.0 - d5, 3.0) * d + 3.0 * (1.0 - d5) * (1.0 - d5) * d5 * d2 + 3.0 * (1.0 - d5) * d5 * d5 * d3 + Math.pow(d5, 3.0) * d4;
    }

    @GamlAnnotations.operator(value={"line", "polyline"}, expected_content_type={7, 13, 11}, category={"Spatial operators", "Shape"}, concept={"shape", "geometry", "point"})
    @GamlAnnotations.doc(value="A polyline geometry from the given list of points.", masterDoc=true, usages={@GamlAnnotations.usage(value="if the points list operand is nil, returns the point geometry {0,0}"), @GamlAnnotations.usage(value="if the points list operand is composed of a single point, returns a point geometry.")}, examples={@GamlAnnotations.example(value="polyline([{0,0}, {0,10}, {10,10}])", equals="a polyline geometry composed of the 3 points.", test=false), @GamlAnnotations.example(value="line([{10,10}, {10,0}])", equals="a line from 2 points.", test=false), @GamlAnnotations.example(value="string(polyline([{0,0}, {0,10}, {10,10}])+line([{10,10}, {10,0}]))", equals="\"MULTILINESTRING ((0 0, 0 10, 10 10), (10 10, 10 0))\"", returnType="string")}, see={"around", "circle", "cone", "link", "norm", "point", "polygone", "rectangle", "square", "triangle"})
    @GamlAnnotations.test(value="points_along(line({0,0},{0,10}),[0.5])[0] = point({0,5})")
    public static IShape line(IScope iScope, IContainer<?, IShape> iContainer) {
        if (iContainer == null || iContainer.isEmpty(iScope)) {
            return GamaShapeFactory.createFrom(new GamaPoint(0.0, 0.0));
        }
        IList<IShape> iList = iContainer.listValue(iScope, Types.NO_TYPE, false);
        int n = iList.length(iScope);
        IShape iShape = iList.firstValue(iScope);
        if (n == 1) {
            return GamaGeometryType.createPoint(iShape);
        }
        if (n == 2) {
            return GamaGeometryType.buildLine(iShape, iContainer.lastValue(iScope));
        }
        return GamaGeometryType.buildPolyline(iList);
    }

    @GamlAnnotations.operator(value={"geometry_collection"}, expected_content_type={7, 13, 11}, category={"Spatial operators", "Shape"})
    @GamlAnnotations.doc(value="A geometry collection (multi-geometry) composed of the given list of geometries.", usages={@GamlAnnotations.usage(value="if the operand is nil, returns the point geometry {0,0}"), @GamlAnnotations.usage(value="if the operand is composed of a single geometry, returns a copy of the geometry.")}, examples={@GamlAnnotations.example(value="geometry_collection([{0,0}, {0,10}, {10,10}, {10,0}])", equals="a geometry composed of the 4 points (multi-point).", test=false)}, see={"around", "circle", "cone", "link", "norm", "point", "polygone", "rectangle", "square", "triangle", "line"})
    public static IShape geometryCollection(IScope iScope, IContainer<?, IShape> iContainer) {
        if (iContainer == null || iContainer.isEmpty(iScope)) {
            return GamaShapeFactory.createFrom(new GamaPoint(0.0, 0.0));
        }
        IList<IShape> iList = iContainer.listValue(iScope, Types.NO_TYPE, false);
        int n = iList.length(iScope);
        IShape iShape = iList.firstValue(iScope);
        if (n == 1) {
            return iShape.copy(iScope);
        }
        return GamaGeometryType.buildMultiGeometry(iList);
    }

    @GamlAnnotations.operator(value={"line", "polyline"}, expected_content_type={7, 13, 11}, category={"Spatial operators", "Shape"})
    @GamlAnnotations.doc(value="A polyline geometry from the given list of points represented as a cylinder of radius r.", usages={@GamlAnnotations.usage(value="if a radius is added, the given list of points represented as a cylinder of radius r", examples={@GamlAnnotations.example(value="polyline([{0,0}, {0,10}, {10,10}, {10,0}],0.2)", equals="a polyline geometry composed of the 4 points.", test=false)})}, see={"around", "circle", "cone", "link", "norm", "point", "polygone", "rectangle", "square", "triangle"})
    public static IShape line(IScope iScope, IContainer<?, IShape> iContainer, double d) {
        if (iContainer == null || iContainer.isEmpty(iScope)) {
            return GamaShapeFactory.createFrom(new GamaPoint(0.0, 0.0));
        }
        IList<IShape> iList = iContainer.listValue(iScope, Types.NO_TYPE, false);
        int n = iList.length(iScope);
        IShape iShape = iList.firstValue(iScope);
        if (n == 1) {
            return GamaGeometryType.createPoint(iShape);
        }
        if (n == 2) {
            return GamaGeometryType.buildLineCylinder(iShape, iContainer.lastValue(iScope), d);
        }
        return GamaGeometryType.buildPolylineCylinder(iList, d);
    }

    @GamlAnnotations.operator(value={"plan", "polyplan"}, expected_content_type={7, 13, 11}, category={"Spatial operators", "Shape"})
    @GamlAnnotations.doc(value="A polyline geometry from the given list of points.", usages={@GamlAnnotations.usage(value="if the operand is nil, returns the point geometry {0,0}"), @GamlAnnotations.usage(value="if the operand is composed of a single point, returns a point geometry.")}, examples={@GamlAnnotations.example(value="polyplan([{0,0}, {0,10}, {10,10}, {10,0}],10)", equals="a polyline geometry composed of the 4 points with a depth of 10.", test=false)}, see={"around", "circle", "cone", "link", "norm", "point", "polygone", "rectangle", "square", "triangle"})
    public static IShape plan(IScope iScope, IContainer<?, IShape> iContainer, Double d) {
        if (iContainer == null || iContainer.isEmpty(iScope)) {
            return GamaShapeFactory.createFrom(new GamaPoint(0.0, 0.0));
        }
        IList<IShape> iList = iContainer.listValue(iScope, Types.NO_TYPE, false);
        int n = iList.length(iScope);
        IShape iShape = iList.firstValue(iScope);
        if (n == 1) {
            return GamaGeometryType.createPoint(iShape);
        }
        if (n == 2) {
            return GamaGeometryType.buildPlan(iShape, iList.lastValue(iScope), d);
        }
        return GamaGeometryType.buildPolyplan(iList, d);
    }

    @GamlAnnotations.operator(value={"link"}, category={"Spatial operators", "Shape"}, concept={"shape", "spatial_computation", "geometry"})
    @GamlAnnotations.doc(value="A dynamic line geometry between the location of the two operands", usages={@GamlAnnotations.usage(value="if one of the operands is nil, link returns a point geometry at the location of the other. If both are null, it returns a point geometry at {0,0}")}, comment="The geometry of the link is a line between the locations of the two operands, which is built and maintained dynamically ", examples={@GamlAnnotations.example(value="link (geom1,geom2)", equals="a link geometry between geom1 and geom2.", isExecutable=false)}, see={"around", "circle", "cone", "line", "norm", "point", "polygon", "polyline", "rectangle", "square", "triangle"})
    public static IShape link(IScope iScope, IShape iShape, IShape iShape2) throws GamaRuntimeException {
        if (iShape == null) {
            if (iShape2 == null) {
                return new GamaPoint(0.0, 0.0);
            }
            return GamaGeometryType.createPoint(iShape2.getLocation());
        }
        if (iShape2 == null) {
            return GamaGeometryType.createPoint(iShape.getLocation());
        }
        return GamaGeometryType.buildLink(iScope, iShape, iShape2);
    }

    @GamlAnnotations.operator(value={"around"}, category={"Spatial operators"}, concept={"geometry", "spatial_computation"})
    @GamlAnnotations.doc(value="A geometry resulting from the difference between a buffer around the right-operand casted in geometry at a distance left-operand (right-operand buffer left-operand) and the right-operand casted as geometry.", usages={@GamlAnnotations.usage(value="returns a circle geometry of radius right-operand if the left-operand is nil")}, examples={@GamlAnnotations.example(value="10 around circle(5)", equals="the ring geometry between 5 and 10.", test=false)}, see={"circle", "cone", "line", "link", "norm", "point", "polygon", "polyline", "rectangle", "square", "triangle"})
    public static IShape around(IScope iScope, Double d, Object object) throws GamaRuntimeException {
        IShape iShape = Cast.asGeometry(iScope, object, false);
        if (iShape == null) {
            return SpatialCreation.circle(iScope, d);
        }
        return SpatialOperators.minus(iScope, SpatialTransformations.enlarged_by(iScope, iShape, d), iShape);
    }

    @GamlAnnotations.operator(value={"envelope"}, category={"Spatial operators", "Shape"}, concept={"geometry", "spatial_computation"})
    @GamlAnnotations.doc(value="A 3D geometry that represents the box that surrounds the geometries or the surface described by the arguments. More general than geometry(arguments).envelope, as it allows to pass int, double, point, image files, shape files, asc files, or any list combining these arguments, in which case the envelope will be correctly expanded. If an envelope cannot be determined from the arguments, a default one of dimensions (0,100, 0, 100, 0, 100) is returned", usages={@GamlAnnotations.usage(value="This operator is often used to define the environment of simulation")}, examples={@GamlAnnotations.example(value="file road_shapefile <- file(\"../includes/roads.shp\");", isExecutable=false), @GamlAnnotations.example(value="geometry shape <- envelope(road_shapefile);", isExecutable=false), @GamlAnnotations.example(value="// shape is the system variable of  the environment", isExecutable=false), @GamlAnnotations.example(value="polygon([{0,0}, {20,0}, {10,10}, {10,0}])", equals="create a polygon to get the envolpe", test=false), @GamlAnnotations.example(value="envelope(polygon([{0,0}, {20,0}, {10,10}, {10,0}])).area", equals="200.0", returnType="float")})
    public static IShape envelope(IScope iScope, Object object) {
        Envelope3D envelope3D = Envelope3D.of(GeometryUtils.computeEnvelopeFrom(iScope, object));
        try {
            if (envelope3D.isNull()) {
                envelope3D = Envelope3D.of(0.0, 100.0, 0.0, 100.0, 0.0, 100.0);
            }
            IShape iShape = GamaGeometryType.buildBox(envelope3D.getWidth(), envelope3D.getHeight(), envelope3D.getDepth(), envelope3D.centre());
            return iShape;
        }
        finally {
            envelope3D.dispose();
        }
    }
}

