/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.skills;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.IScope;
import gama.core.runtime.concurrent.GamaExecutorService;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.skills.Skill;
import gama.gaml.species.ISpecies;
import gama.gaml.statements.IStatement;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

@GamlAnnotations.doc(value="The thread skill is intended to define the minimal set of behaviours required for agents that are able to run an action in a thread")
@GamlAnnotations.skill(name="thread", concept={"skill", "system"})
public class ThreadSkill
extends Skill {
    ScheduledExecutorService executor = Executors.newScheduledThreadPool(GamaExecutorService.THREADS_NUMBER.getValue());
    private static final String ACTION_NAME = "thread_action";
    private static final String START_THREAD = "run_thread";
    private static final String END_THREAD = "end_thread";
    private static final String EVERY = "every";
    private static final String INTERVAL = "interval";
    private static final String THREAD_MEMORY = "%%thread_memory%%";

    @GamlAnnotations.action(name="run_thread", args={@GamlAnnotations.arg(name="every", type=2, optional=true, doc={@GamlAnnotations.doc(value="Rate in machine time at which this action is run. Default unit is in seconds, use explicit units to specify another, like 10 #ms. If no rate (and no interval) is specified, the action is run once. If the action takes longer than the interval to run, it it run immediately after the previous execution")}), @GamlAnnotations.arg(name="interval", type=2, optional=true, doc={@GamlAnnotations.doc(value="Interval -- or delay -- between two executions of the action. Default unit is in seconds, use explicit units to specify another, like 10 #ms. If no interval (and no rate) is specified, the action is run once. An interval of 0 will make the action run continuously without delays")})}, doc={@GamlAnnotations.doc(examples={@GamlAnnotations.example(value="do run_thread every: 10#ms;")}, returns="true if the thread was well created and started, false otherwise", value="Start a new thread that will run the 'thread_action' either once if no facets are defined, of at a fixed rate if 'every:' is defined or with a fixed delay if 'interval:' is defined.")})
    public Boolean primStartThread(IScope iScope) throws GamaRuntimeException {
        this.primEndThread(iScope);
        double d = iScope.hasArg(INTERVAL) ? iScope.getFloatArg(INTERVAL) : -1.0;
        double d2 = iScope.hasArg(EVERY) ? iScope.getFloatArg(EVERY) : -1.0;
        ControlSubThread controlSubThread = new ControlSubThread(iScope.getAgent(), (int)(d * 1000.0), (int)(d2 * 1000.0));
        iScope.getAgent().setAttribute(THREAD_MEMORY, controlSubThread);
        controlSubThread.start();
        return true;
    }

    @GamlAnnotations.action(name="end_thread", doc={@GamlAnnotations.doc(examples={@GamlAnnotations.example(value="do end_thread;")}, returns="true if the thread was well stopped, false otherwise", value="End the current thread.")})
    public Boolean primEndThread(IScope iScope) throws GamaRuntimeException {
        ControlSubThread controlSubThread = (ControlSubThread)iScope.getAgent().getAttribute(THREAD_MEMORY);
        if (controlSubThread != null) {
            controlSubThread.stop();
            iScope.getAgent().setAttribute(THREAD_MEMORY, null);
            return true;
        }
        return false;
    }

    @GamlAnnotations.action(doc={@GamlAnnotations.doc(value="A virtual action, which contains what to execute in the thread. It needs to be redefined in the species that implement the `thread` skill")}, name="thread_action", virtual=true)
    public Object primExternalFactorOnRemainingTime(IScope iScope) throws GamaRuntimeException {
        return null;
    }

    public class ControlSubThread
    implements Runnable {
        ScheduledFuture sf;
        private final int interval;
        private final int rate;
        private final IAgent agent;

        public ControlSubThread(IAgent iAgent, int n, int n2) {
            this.interval = n;
            this.rate = n2;
            this.agent = iAgent;
        }

        public void start() {
            if (this.rate > 0) {
                this.sf = ThreadSkill.this.executor.scheduleAtFixedRate(this, 0L, this.rate, TimeUnit.MILLISECONDS);
            } else if (this.interval > 0) {
                this.sf = ThreadSkill.this.executor.scheduleWithFixedDelay(this, 0L, this.interval, TimeUnit.MILLISECONDS);
            } else if (this.interval == 0) {
                this.sf = ThreadSkill.this.executor.scheduleWithFixedDelay(this, 0L, 1L, TimeUnit.NANOSECONDS);
            } else {
                ThreadSkill.this.executor.execute(this);
            }
        }

        public void stop() {
            if (this.sf != null && !this.sf.isCancelled()) {
                this.sf.cancel(true);
            }
        }

        @Override
        public void run() {
            if (this.agent.dead()) {
                this.stop();
                return;
            }
            IScope iScope = this.agent.getScope();
            if (iScope != null && !iScope.interrupted()) {
                ISpecies iSpecies = this.agent.getSpecies();
                IStatement.WithArgs withArgs = iSpecies.getAction(ThreadSkill.ACTION_NAME);
                iScope.copy("ThreadScope").execute(withArgs, this.agent, null);
            } else {
                this.stop();
            }
        }
    }
}

