/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs.layers;

import gama.core.common.interfaces.IGraphics;
import gama.core.kernel.simulation.SimulationAgent;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.agent.IMacroAgent;
import gama.core.metamodel.population.IPopulation;
import gama.core.outputs.layers.AgentLayer;
import gama.core.outputs.layers.ILayerStatement;
import gama.core.outputs.layers.SpeciesLayerStatement;
import gama.core.runtime.ExecutionResult;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.gaml.species.ISpecies;
import gama.gaml.statements.AspectStatement;
import gama.gaml.statements.IExecutable;
import gama.gaml.types.Types;
import java.awt.geom.Rectangle2D;

public class SpeciesLayer
extends AgentLayer {
    final boolean hasMicroSpeciesLayers = this.getDefinition().getMicroSpeciesLayers() != null;

    public SpeciesLayer(ILayerStatement iLayerStatement) {
        super(iLayerStatement);
    }

    @Override
    public SpeciesLayerStatement getDefinition() {
        return (SpeciesLayerStatement)super.getDefinition();
    }

    @Override
    public IList<? extends IAgent> getAgentsForMenu(IScope iScope) {
        return GamaListFactory.createWithoutCasting(Types.AGENT, this.getDefinition().getSpecies().getPopulation(iScope));
    }

    @Override
    public String getType() {
        return "Species layer";
    }

    @Override
    public void privateDraw(IScope.IGraphicsScope iGraphicsScope, IGraphics iGraphics) throws GamaRuntimeException {
        IPopulation<? extends IAgent> iPopulation;
        this.shapes.clear();
        ISpecies iSpecies = this.getDefinition().getSpecies();
        SimulationAgent simulationAgent = iGraphicsScope.getSimulation();
        if (simulationAgent != null && !simulationAgent.dead() && (iPopulation = simulationAgent.getMicroPopulation(iSpecies)) != null) {
            IExecutable iExecutable = this.getDefinition().getAspect();
            if (iExecutable == null) {
                iExecutable = AspectStatement.DEFAULT_ASPECT;
            }
            this.drawPopulation(iGraphicsScope, iGraphics, iExecutable, iPopulation);
        }
    }

    private void drawPopulation(IScope iScope, IGraphics iGraphics, IExecutable iExecutable, IPopulation<? extends IAgent> iPopulation) throws GamaRuntimeException {
        IAgent[] iAgentArray = iPopulation.toArray();
        int n = iAgentArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAgent iAgent = iAgentArray[n2];
            if (iAgent != null && !iAgent.dead()) {
                Object object;
                ExecutionResult executionResult = null;
                if (iAgent == iScope.getGui().getHighlightedAgent()) {
                    object = iPopulation.getSpecies().getAspect("highlighted");
                    if (object == null) {
                        object = iExecutable;
                    }
                    executionResult = iScope.execute((IExecutable)object, iAgent, null);
                } else {
                    executionResult = iScope.execute(iExecutable, iAgent, null);
                }
                if (executionResult == ExecutionResult.FAILED) break;
                if (executionResult != null && executionResult.getValue() instanceof Rectangle2D) {
                    object = (Rectangle2D)executionResult.getValue();
                    this.shapes.put(iAgent, object);
                }
                if (iAgent instanceof IMacroAgent && this.hasMicroSpeciesLayers) {
                    for (SpeciesLayerStatement speciesLayerStatement : this.getDefinition().getMicroSpeciesLayers()) {
                        if (iAgent.dead() || (object = ((IMacroAgent)iAgent).getMicroPopulation(speciesLayerStatement.getSpecies())) == null || object.size() <= 0) continue;
                        IExecutable iExecutable2 = speciesLayerStatement.getAspect();
                        if (iExecutable2 == null) {
                            iExecutable2 = AspectStatement.DEFAULT_ASPECT;
                        }
                        this.drawPopulation(iScope, iGraphics, iExecutable2, (IPopulation<? extends IAgent>)object);
                    }
                }
            }
            ++n2;
        }
    }
}

