/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs.layers.properties;

import gama.core.common.preferences.GamaPreferences;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.outputs.layers.properties.AbstractDefinition;
import gama.core.outputs.layers.properties.ILightDefinition;
import gama.core.outputs.layers.properties.LightStatement;
import gama.core.runtime.IScope;
import gama.core.util.GamaColor;
import gama.dev.DEBUG;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.statements.draw.AttributeHolder;
import gama.gaml.types.Types;

public class LightDefinition
extends AbstractDefinition
implements ILightDefinition {
    final AttributeHolder.Attribute<GamaPoint> locationAttribute;
    final AttributeHolder.Attribute<String> typeAttribute = this.create("type", Types.STRING, "Directional light");
    final AttributeHolder.Attribute<GamaColor> intensityAttribute;
    final AttributeHolder.Attribute<GamaPoint> directionAttribute;
    AttributeHolder.Attribute<Double> angleAttribute;
    final AttributeHolder.Attribute<Double> attenuationAttribute;
    final AttributeHolder.Attribute<Double> linearAttribute;
    final AttributeHolder.Attribute<Double> quadraticAttribute;
    final AttributeHolder.Attribute<Boolean> activeAttribute;
    final AttributeHolder.Attribute<Boolean> drawAttribute;
    int id;

    static {
        DEBUG.OFF();
    }

    public LightDefinition(LightStatement lightStatement) {
        super(lightStatement);
        this.locationAttribute = this.create("location", Types.POINT, DEFAULT_LOCATION);
        this.directionAttribute = this.create("direction", Types.POINT, DEFAULT_DIRECTION);
        this.linearAttribute = this.create("linear_attenuation", Types.FLOAT, 0.0);
        this.attenuationAttribute = this.create("constant_attenuation", Types.FLOAT, 1.0);
        this.quadraticAttribute = this.create("quadratic_attenuation", Types.FLOAT, 0.0);
        this.angleAttribute = this.create("angle", Types.FLOAT, DEFAULT_ANGLE);
        this.drawAttribute = this.create("show", Types.BOOL, false);
        this.activeAttribute = this.create("active", Types.BOOL, true);
        Integer n = GamaPreferences.Displays.OPENGL_DEFAULT_LIGHT_INTENSITY.getValue();
        this.intensityAttribute = this.create("intensity", (IScope iScope, IExpression iExpression) -> {
            if (iExpression.getGamlType() == Types.INT) {
                int n = Cast.asInt(iScope, iExpression.value(iScope));
                return GamaColor.get(n, n, n, 255);
            }
            return Cast.asColor(iScope, iExpression.value(iScope));
        }, Types.COLOR, GamaColor.get(n, (int)n, (int)n, 255));
    }

    @Override
    public Boolean isActive() {
        if (this.activeAttribute.get().booleanValue() && ILightDefinition.super.isActive().booleanValue()) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean isDrawing() {
        return this.drawAttribute.get();
    }

    @Override
    public GamaPoint getDirection() {
        return this.directionAttribute.get();
    }

    @Override
    public String getType() {
        return this.typeAttribute.get();
    }

    @Override
    public GamaColor getIntensity() {
        return this.intensityAttribute.get();
    }

    @Override
    public double getAngle() {
        return this.angleAttribute.get();
    }

    @Override
    public String getName() {
        return this.symbol.getName();
    }

    @Override
    public int getId() {
        return "default".equals(this.getName()) ? 0 : this.id;
    }

    public void setId(int n) {
        this.id = n;
    }

    @Override
    public GamaPoint getLocation() {
        return this.locationAttribute.get();
    }

    @Override
    protected boolean getDefaultDynamicValue() {
        return true;
    }

    @Override
    protected boolean shouldRefresh() {
        return this.isDynamic();
    }

    @Override
    protected void update(IScope iScope) {
    }

    @Override
    protected void reset() {
    }

    @Override
    public double getLinearAttenuation() {
        return this.linearAttribute.get();
    }

    @Override
    public double getQuadraticAttenuation() {
        return this.quadraticAttribute.get();
    }

    @Override
    public double getConstantAttenuation() {
        return this.attenuationAttribute.get();
    }
}

