/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.file;

import gama.core.common.geometry.Envelope3D;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.file.GamaFile;
import gama.core.util.graph.GamaGraph;
import gama.core.util.graph.IGraph;
import gama.core.util.graph.loader.GraphImporters;
import gama.gaml.species.ISpecies;
import gama.gaml.types.IContainerType;
import gama.gaml.types.Types;
import org.jgrapht.Graph;
import org.jgrapht.graph.AbstractBaseGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.DirectedMultigraph;
import org.jgrapht.nio.GraphImporter;
import org.jgrapht.util.SupplierUtil;

public abstract class GamaGraphFile
extends GamaFile<IGraph<?, ?>, Object> {
    ISpecies nodeS = null;
    ISpecies edgeS = null;

    public GamaGraphFile(IScope iScope, String string) throws GamaRuntimeException {
        super(iScope, string);
    }

    public GamaGraphFile(IScope iScope, String string, ISpecies iSpecies) {
        super(iScope, string);
        this.nodeS = iSpecies;
    }

    public GamaGraphFile(IScope iScope, String string, ISpecies iSpecies, ISpecies iSpecies2) {
        super(iScope, string);
        this.nodeS = iSpecies;
        this.edgeS = iSpecies2;
    }

    @Override
    public Envelope3D computeEnvelope(IScope iScope) {
        return null;
    }

    @Override
    protected void fillBuffer(IScope iScope) throws GamaRuntimeException {
        if (this.getBuffer() != null) {
            return;
        }
        GraphImporter graphImporter = GraphImporters.getGraphImporter(this.getFileType());
        DirectedMultigraph directedMultigraph = new DirectedMultigraph(SupplierUtil.createStringSupplier(), SupplierUtil.DEFAULT_EDGE_SUPPLIER, true);
        graphImporter.importGraph((Graph)directedMultigraph, this.getFile(iScope));
        this.setBuffer(new GamaGraph(iScope, (AbstractBaseGraph<?, DefaultEdge>)directedMultigraph, this.nodeS, this.edgeS));
    }

    protected abstract String getFileType();

    @Override
    public IContainerType<?> getGamlType() {
        return Types.GRAPH;
    }
}

