/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.graph;

import gama.core.common.util.StringUtils;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.metamodel.topology.graph.GamaSpatialGraph;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.Collector;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMap;
import gama.core.util.GamaMapFactory;
import gama.core.util.GamaPair;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.core.util.file.json.Json;
import gama.core.util.file.json.JsonGamlObject;
import gama.core.util.file.json.JsonValue;
import gama.core.util.graph.GraphEvent;
import gama.core.util.graph.IGraph;
import gama.core.util.graph.IGraphEventListener;
import gama.core.util.graph.PathComputer;
import gama.core.util.graph._Edge;
import gama.core.util.graph._Vertex;
import gama.core.util.graph.loader.GamaGraphMLEdgeImporter;
import gama.core.util.graph.loader.GamaGraphMLNodeImporter;
import gama.core.util.matrix.GamaFloatMatrix;
import gama.core.util.matrix.IMatrix;
import gama.core.util.path.IPath;
import gama.core.util.path.PathFactory;
import gama.gaml.operators.Cast;
import gama.gaml.operators.Graphs;
import gama.gaml.operators.Strings;
import gama.gaml.operators.spatial.SpatialCreation;
import gama.gaml.species.ISpecies;
import gama.gaml.types.GamaListType;
import gama.gaml.types.GamaPairType;
import gama.gaml.types.IContainerType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import one.util.streamex.StreamEx;
import org.jgrapht.Graph;
import org.jgrapht.GraphType;
import org.jgrapht.Graphs;
import org.jgrapht.alg.connectivity.ConnectivityInspector;
import org.jgrapht.alg.cycle.CycleDetector;
import org.jgrapht.alg.spanning.KruskalMinimumSpanningTree;
import org.jgrapht.alg.tour.PalmerHamiltonianCycle;
import org.jgrapht.alg.util.Pair;
import org.jgrapht.graph.AbstractBaseGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.DefaultGraphType;
import org.jgrapht.graph.SimpleWeightedGraph;

public class GamaGraph<V, E>
implements IGraph<V, E> {
    public PathComputer pathComputer;
    protected final Map<V, _Vertex<V, E>> vertexMap;
    protected final Map<E, _Edge<V, E>> edgeMap;
    protected boolean directed;
    protected boolean agentEdge;
    protected final IScope graphScope;
    protected final IContainerType type;
    protected GamaSpatialGraph.VertexRelationship vertexRelation;
    protected static final double DEFAULT_NODE_WEIGHT = 0.0;
    protected ISpecies edgeSpecies;
    private final LinkedList<IGraphEventListener> listeners = new LinkedList();
    private final Set<IAgent> generatedEdges = new LinkedHashSet<IAgent>();
    protected ISpecies vertexSpecies;

    @Override
    public JsonValue serializeToJson(Json json) {
        JsonGamlObject jsonGamlObject = json.typedObject(this.getGamlType(), "directed", this.directed, "vertices", this.vertexMap, "edges", this.edgeMap, "agentEdge", this.agentEdge);
        if (this.edgeSpecies != null) {
            jsonGamlObject.add("edgeSpecies", this.edgeSpecies);
        }
        if (this.vertexSpecies != null) {
            jsonGamlObject.add("vertexSpecies", this.vertexSpecies);
        }
        return jsonGamlObject;
    }

    public GamaGraph(IScope iScope, boolean bl, IType iType, IType iType2) {
        this.directed = bl;
        this.vertexMap = GamaMapFactory.create();
        this.edgeMap = GamaMapFactory.create();
        this.vertexRelation = null;
        this.agentEdge = false;
        this.graphScope = iScope;
        this.type = Types.GRAPH.of(iType, iType2);
    }

    public GamaGraph(IScope iScope, IContainer iContainer, boolean bl, boolean bl2, boolean bl3, GamaSpatialGraph.VertexRelationship vertexRelationship, ISpecies iSpecies, IType iType, IType iType2) {
        this.vertexMap = GamaMapFactory.create();
        this.edgeMap = GamaMapFactory.create();
        this.graphScope = iScope;
        this.type = Types.GRAPH.of(iType, iType2);
        this.init(iScope, iContainer, bl, bl2, bl3, vertexRelationship, iSpecies);
    }

    public GamaGraph(IScope iScope, IType iType, IType iType2) {
        this.vertexMap = GamaMapFactory.create();
        this.edgeMap = GamaMapFactory.create();
        this.graphScope = iScope;
        this.type = Types.GRAPH.of(iType, iType2);
    }

    public GamaGraph(IScope iScope, AbstractBaseGraph<?, DefaultEdge> abstractBaseGraph, ISpecies iSpecies, ISpecies iSpecies2) {
        this(iScope, abstractBaseGraph, iSpecies, iSpecies2, null, null);
    }

    public GamaGraph(IScope iScope, AbstractBaseGraph<?, DefaultEdge> abstractBaseGraph, GamaMap<?, IShape> gamaMap) {
        this(iScope, gamaMap == null || gamaMap.isEmpty() ? Types.GEOMETRY : (gamaMap.getValues().get(0) instanceof IAgent ? Types.AGENT : Types.GEOMETRY), Types.GEOMETRY);
        if (gamaMap != null) {
            for (IShape iShape : gamaMap.getValues()) {
                this.addVertex(iShape);
            }
            for (IShape iShape : abstractBaseGraph.edgeSet()) {
                Object object = abstractBaseGraph.getEdgeSource((Object)iShape);
                Object object2 = abstractBaseGraph.getEdgeTarget((Object)iShape);
                IShape iShape2 = (IShape)gamaMap.get(object);
                IShape iShape3 = (IShape)gamaMap.get(object2);
                IList<IShape> iList = GamaListFactory.create();
                iList.add(iShape2.getLocation());
                iList.add(iShape3.getLocation());
                IShape iShape4 = SpatialCreation.line(iScope, iList);
                this.setEdgeWeight(iShape4, abstractBaseGraph.getEdgeWeight((Object)iShape));
                this.addEdge(iShape2, iShape3, iShape4);
            }
        }
    }

    public GamaGraph(IScope iScope, AbstractBaseGraph<?, DefaultEdge> abstractBaseGraph, ISpecies iSpecies, ISpecies iSpecies2, String string, String string2) {
        this(iScope, iSpecies == null ? Types.STRING : Types.AGENT, iSpecies2 == null ? Types.STRING : Types.AGENT);
        Object object;
        Object object2;
        Object object3;
        IMap iMap = GamaMapFactory.create();
        for (Object object4 : abstractBaseGraph.vertexSet()) {
            if (iSpecies == null) {
                this.addVertex(object4.toString());
                continue;
            }
            object3 = GamaListFactory.create();
            object2 = iSpecies.getPopulation(iScope).createAgents(iScope, 1, (List<Map<String, Object>>)object3, false, false, null);
            object = (IAgent)object2.get(0);
            if (object4 == null) continue;
            object.setName(object4.toString());
            if (object.hasAttribute(string) && object4 instanceof GamaGraphMLNodeImporter) {
                object.setAttribute(string, GamaMapFactory.create(iScope, Types.STRING, Types.STRING, ((GamaGraphMLNodeImporter)object4).getAttributes()));
            }
            this.addVertex(object);
            iMap.put(object4.toString(), object);
        }
        for (Object object4 : abstractBaseGraph.edgeSet()) {
            object3 = abstractBaseGraph.getEdgeSource(object4);
            object2 = abstractBaseGraph.getEdgeTarget(object4);
            if (iSpecies != null) {
                if (object3 instanceof String) {
                    object3 = iMap.get(object3);
                }
                if (object2 instanceof String) {
                    object2 = iMap.get(object2);
                }
            }
            if (iSpecies2 == null) {
                if (iSpecies == null) {
                    object = new Pair((Object)object3.toString(), (Object)object2.toString()).toString();
                    this.addEdge(object3.toString(), object2.toString(), object);
                    this.setEdgeWeight(object, abstractBaseGraph.getEdgeWeight(object4));
                    continue;
                }
                this.addEdge(object3, object2, object4);
                this.setEdgeWeight(object4, abstractBaseGraph.getEdgeWeight(object4));
                continue;
            }
            object = GamaListFactory.create();
            IList<? extends IAgent> iList = iSpecies2.getPopulation(iScope).createAgents(iScope, 1, (List<Map<String, Object>>)object, false, true, null);
            IAgent iAgent = (IAgent)iList.get(0);
            if (object4 != null) {
                iAgent.setName(iAgent.getSpeciesName() + iAgent.getIndex());
                if (iAgent.hasAttribute(string2) && object4 instanceof GamaGraphMLEdgeImporter) {
                    iAgent.setAttribute(string2, GamaMapFactory.create(iScope, Types.STRING, Types.STRING, ((GamaGraphMLEdgeImporter)((Object)object4)).getAttributes()));
                }
            }
            if (iSpecies != null) {
                IAgent iAgent2 = (IAgent)iMap.get(object3.toString());
                IAgent iAgent3 = (IAgent)iMap.get(object2.toString());
                this.addEdge(iAgent2, iAgent3, iAgent);
                iAgent.setGeometry(SpatialCreation.link(iScope, iAgent2, iAgent3));
            } else {
                this.addEdge(object3, object2, iAgent);
            }
            this.setEdgeWeight(iAgent, abstractBaseGraph.getEdgeWeight(object4));
        }
    }

    public GamaGraph(IScope iScope, AbstractBaseGraph<String, DefaultEdge> abstractBaseGraph, IList iList, ISpecies iSpecies) {
        this(iScope, Types.get(iList.get(0).getClass()), iSpecies == null ? Types.STRING : Types.AGENT);
        Object object;
        IMap iMap = GamaMapFactory.create();
        for (Object object2 : abstractBaseGraph.vertexSet()) {
            object = iList.get(Integer.parseInt(object2.toString()));
            this.addVertex(object);
            iMap.put(object2.toString(), object);
        }
        for (Object object2 : abstractBaseGraph.edgeSet()) {
            object = abstractBaseGraph.getEdgeSource(object2);
            Object object3 = abstractBaseGraph.getEdgeTarget(object2);
            if (iSpecies == null) {
                this.addEdge(object, object3, object2);
                this.setEdgeWeight(object2, abstractBaseGraph.getEdgeWeight(object2));
                continue;
            }
            IList iList2 = GamaListFactory.create();
            IList<? extends IAgent> iList3 = iSpecies.getPopulation(iScope).createAgents(iScope, 1, iList2, false, true, null);
            IAgent iAgent = (IAgent)iList3.get(0);
            if (object2 != null) {
                iAgent.setName(object2.toString());
            }
            Object v = iMap.get(object.toString());
            Object v2 = iMap.get(object3.toString());
            this.addEdge(v, v2, iAgent);
            if (v instanceof IShape) {
                iAgent.setGeometry(SpatialCreation.link(iScope, (IShape)v, (IShape)v2));
            }
            this.setEdgeWeight(iAgent, abstractBaseGraph.getEdgeWeight(object2));
        }
    }

    public IScope getScope() {
        return this.graphScope;
    }

    protected void init(IScope iScope, IContainer iContainer, boolean bl, boolean bl2, boolean bl3, GamaSpatialGraph.VertexRelationship vertexRelationship, ISpecies iSpecies) {
        this.directed = bl2;
        this.vertexRelation = vertexRelationship;
        this.edgeSpecies = iSpecies;
        boolean bl4 = this.agentEdge = iSpecies != null || bl && iContainer != null && iContainer.firstValue(iScope) instanceof IAgent;
        if (bl) {
            this.buildByEdge(iScope, iContainer);
        } else {
            this.buildByVertices(iScope, iContainer, bl3);
        }
    }

    protected void init(IScope iScope, IContainer iContainer, boolean bl, boolean bl2, boolean bl3, GamaSpatialGraph.VertexRelationship vertexRelationship, ISpecies iSpecies, Double d) {
        this.directed = bl2;
        this.vertexRelation = vertexRelationship;
        this.edgeSpecies = iSpecies;
        boolean bl4 = this.agentEdge = iSpecies != null || bl && iContainer != null && iContainer.firstValue(iScope) instanceof IAgent;
        if (bl) {
            this.buildByEdge(iScope, iContainer, d);
        } else {
            this.buildByVertices(iScope, iContainer, bl3);
        }
    }

    @Override
    public IContainerType getGamlType() {
        return this.type;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("graph { \nvertices (").append(this.vertexSet().size()).append("): ").append("[");
        for (Object object : this.vertexSet()) {
            stringBuilder.append(object).append(",");
        }
        stringBuilder.append("]").append(Strings.LN);
        stringBuilder.append("edges (").append(this.edgeSet().size()).append("): [").append(Strings.LN);
        for (Map.Entry entry : this.edgeMap.entrySet()) {
            Object k = entry.getKey();
            _Edge _Edge2 = (_Edge)entry.getValue();
            stringBuilder.append(k).append("\t").append("(").append(_Edge2).append("),").append(Strings.LN);
        }
        stringBuilder.append("]\n}");
        return stringBuilder.toString();
    }

    protected void buildByVertices(IScope iScope, IContainer<?, E> iContainer, boolean bl) {
        for (E e : iContainer.iterable(iScope)) {
            this.addVertex(e);
        }
    }

    protected void buildByEdge(IScope iScope, IContainer iContainer) {
        if (iContainer != null) {
            for (Object ValueType : iContainer.iterable(iScope)) {
                _Edge<V, E> _Edge2;
                Object ValueType2;
                this.addEdge(ValueType);
                Object object = ValueType2 = ValueType instanceof Graphs.GraphObjectToAdd ? ((Graphs.GraphObjectToAdd)ValueType).getObject() : ValueType;
                if (!(ValueType2 instanceof IShape) || (_Edge2 = this.getEdge(ValueType2)) == null) continue;
                _Edge2.setWeight(((IShape)ValueType2).getPerimeter());
            }
        }
    }

    protected void buildByEdge(IScope iScope, IContainer iContainer, Double d) {
        if (iContainer != null) {
            for (Object ValueType : iContainer.iterable(iScope)) {
                _Edge<V, E> _Edge2;
                Object ValueType2;
                this.addEdge(ValueType);
                Object object = ValueType2 = ValueType instanceof Graphs.GraphObjectToAdd ? ((Graphs.GraphObjectToAdd)ValueType).getObject() : ValueType;
                if (!(ValueType2 instanceof IShape) || (_Edge2 = this.getEdge(ValueType2)) == null) continue;
                _Edge2.setWeight(((IShape)ValueType2).getPerimeter());
            }
        }
    }

    protected void buildByEdge(IScope iScope, IContainer iContainer, IContainer iContainer2) {
    }

    public _Edge<V, E> getEdge(Object object) {
        return this.edgeMap.get(object);
    }

    public _Vertex<V, E> getVertex(Object object) {
        return this.vertexMap.get(object);
    }

    @Override
    public Object addEdge(Object object) {
        this.getPathComputer().incVersion();
        if (object instanceof GamaPair) {
            GamaPair gamaPair = (GamaPair)object;
            return this.addEdge(gamaPair.first(), gamaPair.last());
        }
        if (object instanceof Graphs.GraphObjectToAdd) {
            this.addValue(this.graphScope, (Graphs.GraphObjectToAdd)object);
            return ((Graphs.GraphObjectToAdd)object).getObject();
        }
        return this.addEdge(null, null, object) ? object : null;
    }

    @Override
    public void addValue(IScope iScope, Graphs.GraphObjectToAdd graphObjectToAdd) {
        if (graphObjectToAdd instanceof Graphs.EdgeToAdd) {
            Graphs.EdgeToAdd edgeToAdd = (Graphs.EdgeToAdd)graphObjectToAdd;
            if (edgeToAdd.object == null) {
                edgeToAdd.object = this.addEdge(edgeToAdd.source, edgeToAdd.target);
            }
            this.addEdge(edgeToAdd.source, edgeToAdd.target, edgeToAdd.object);
            if (edgeToAdd.weight != null) {
                this.setEdgeWeight(edgeToAdd.object, edgeToAdd.weight);
            }
        } else {
            Graphs.NodeToAdd nodeToAdd = (Graphs.NodeToAdd)graphObjectToAdd;
            this.addVertex(nodeToAdd.object);
            if (nodeToAdd.weight != null) {
                this.setVertexWeight(nodeToAdd.object, nodeToAdd.weight);
            }
        }
    }

    @Override
    public void addValueAtIndex(IScope iScope, Object object, Graphs.GraphObjectToAdd graphObjectToAdd) {
        GamaPair<V, V> gamaPair = this.buildIndex(iScope, object);
        Graphs.EdgeToAdd edgeToAdd = new Graphs.EdgeToAdd(gamaPair.key, gamaPair.value, (Object)null, null);
        if (graphObjectToAdd instanceof Graphs.EdgeToAdd) {
            edgeToAdd.object = ((Graphs.EdgeToAdd)graphObjectToAdd).object;
            edgeToAdd.weight = ((Graphs.EdgeToAdd)graphObjectToAdd).weight;
        } else {
            edgeToAdd.object = graphObjectToAdd;
        }
        this.addValue(iScope, edgeToAdd);
    }

    @Override
    public void setValueAtIndex(IScope iScope, Object object, Graphs.GraphObjectToAdd graphObjectToAdd) {
        this.addValueAtIndex(iScope, object, graphObjectToAdd);
    }

    @Override
    public void addValues(IScope iScope, Object object, IContainer iContainer) {
        if (iContainer instanceof GamaGraph) {
            for (Object e : ((GamaGraph)iContainer).edgeSet()) {
                this.addEdge(e);
            }
        } else {
            for (Object ValueType : iContainer.iterable(iScope)) {
                if (!(ValueType instanceof Graphs.GraphObjectToAdd)) continue;
                this.addValue(iScope, (Graphs.GraphObjectToAdd)ValueType);
            }
        }
    }

    @Override
    public void setAllValues(IScope iScope, Graphs.GraphObjectToAdd graphObjectToAdd) {
    }

    @Override
    public void removeValue(IScope iScope, Object object) {
        if (object instanceof Graphs.EdgeToAdd) {
            Graphs.EdgeToAdd edgeToAdd = (Graphs.EdgeToAdd)object;
            if (edgeToAdd.object != null) {
                this.removeEdge(edgeToAdd.object);
            } else if (edgeToAdd.source != null && edgeToAdd.target != null) {
                this.removeAllEdges(edgeToAdd.source, edgeToAdd.target);
            }
        } else if (object instanceof Graphs.NodeToAdd) {
            this.removeVertex(((Graphs.NodeToAdd)object).object);
        } else if (!this.removeVertex(object)) {
            this.removeEdge(object);
        }
    }

    @Override
    public void removeIndex(IScope iScope, Object object) {
        if (object instanceof GamaPair) {
            GamaPair gamaPair = (GamaPair)object;
            this.removeAllEdges(gamaPair.key, gamaPair.value);
        }
    }

    @Override
    public void removeIndexes(IScope iScope, IContainer<?, ?> iContainer) {
        for (Object obj : iContainer.iterable(iScope)) {
            this.removeIndex(iScope, obj);
        }
    }

    @Override
    public void removeValues(IScope iScope, IContainer<?, ?> iContainer) {
        if (iContainer instanceof IGraph) {
            this.removeAllEdges(((IGraph)iContainer).edgeSet());
        } else {
            for (Object obj : iContainer.iterable(iScope)) {
                this.removeValue(iScope, obj);
            }
        }
    }

    @Override
    public void removeAllOccurrencesOfValue(IScope iScope, Object object) {
        this.removeValue(iScope, object);
    }

    public Object addEdge(Object object, Object object2) {
        if (object instanceof GamaPair) {
            GamaPair gamaPair = (GamaPair)object;
            if (this.addEdge(gamaPair.first(), gamaPair.last(), object2)) {
                return object2;
            }
            return null;
        }
        Object object3 = this.createNewEdgeObjectFromVertices(object, object2);
        if (this.addEdge(object, object2, object3)) {
            return object3;
        }
        return null;
    }

    protected Object createNewEdgeObjectFromVertices(Object object, Object object2) {
        if (this.getEdgeSpecies() == null) {
            return this.generateEdgeObject(object, object2);
        }
        IMap iMap = GamaMapFactory.create();
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        iMap.put("source", object);
        iMap.put("target", object2);
        iMap.put("shape", SpatialCreation.link(this.graphScope, (IShape)object, (IShape)object2));
        arrayList.add(iMap);
        return this.generateEdgeAgent(arrayList);
    }

    protected Object generateEdgeObject(Object object, Object object2) {
        return new GamaPair<Object, Object>(object, object2, this.getGamlType().getKeyType(), this.getGamlType().getKeyType());
    }

    protected IAgent generateEdgeAgent(List<Map<String, Object>> list) {
        IAgent iAgent = this.graphScope.getAgent().getPopulationFor(this.getEdgeSpecies()).createAgents(this.graphScope, 1, list, false, true).firstValue(this.graphScope);
        if (iAgent != null) {
            this.generatedEdges.add(iAgent);
        }
        return iAgent;
    }

    public boolean addEdge(Object object, Object object2, Object object3) {
        _Edge<V, E> _Edge2;
        if (object3 == null) {
            return this.addEdge(object, object2) != null;
        }
        if (this.containsEdge(object3)) {
            return false;
        }
        this.addVertex(object);
        this.addVertex(object2);
        try {
            _Edge2 = this.newEdge(object3, object, object2);
        }
        catch (GamaRuntimeException gamaRuntimeException) {
            gamaRuntimeException.addContext("Impossible to create edge from " + StringUtils.toGaml(object3, false) + " in graph " + String.valueOf(this));
            throw gamaRuntimeException;
        }
        this.edgeMap.put(object3, _Edge2);
        this.dispatchEvent(this.graphScope, new GraphEvent(this.graphScope, this, object3, null, GraphEvent.GraphEventType.EDGE_ADDED));
        return true;
    }

    protected _Edge<V, E> newEdge(Object object, Object object2, Object object3) throws GamaRuntimeException {
        return new _Edge(this, object, object2, object3);
    }

    protected _Vertex<V, E> newVertex(Object object) throws GamaRuntimeException {
        return new _Vertex(this);
    }

    public boolean addVertex(Object object) {
        _Vertex<V, E> _Vertex2;
        if (object instanceof IAgent) {
            IAgent iAgent = (IAgent)object;
            this.vertexSpecies = !this.getVertices().isEmpty() && iAgent.getSpecies() != this.vertexSpecies ? null : iAgent.getSpecies();
        }
        if (object instanceof Graphs.GraphObjectToAdd) {
            this.addValue(this.graphScope, (Graphs.GraphObjectToAdd)object);
            return ((Graphs.GraphObjectToAdd)object).getObject() != null;
        }
        if (object == null || this.containsVertex(object)) {
            return false;
        }
        try {
            _Vertex2 = this.newVertex(object);
        }
        catch (GamaRuntimeException gamaRuntimeException) {
            gamaRuntimeException.addContext("Impossible to create vertex from " + StringUtils.toGaml(object, false) + " in graph " + String.valueOf(this));
            throw gamaRuntimeException;
        }
        this.vertexMap.put((_Vertex<V, E>)object, (_Vertex<_Vertex<V, E>, E>)_Vertex2);
        this.dispatchEvent(this.graphScope, new GraphEvent(this.graphScope, this, null, object, GraphEvent.GraphEventType.VERTEX_ADDED));
        return true;
    }

    public boolean containsEdge(Object object) {
        return this.edgeMap.containsKey(object);
    }

    public boolean containsEdge(Object object, Object object2) {
        return this.getEdge(object, object2) != null || !this.directed && this.getEdge(object2, object) != null;
    }

    public boolean containsVertex(Object object) {
        return this.vertexMap.containsKey(object);
    }

    public Set edgeSet() {
        return this.edgeMap.keySet();
    }

    @Override
    public Map<E, _Edge<V, E>> _internalEdgeMap() {
        return this.edgeMap;
    }

    @Override
    public Map<V, _Vertex<V, E>> _internalVertexMap() {
        return this.vertexMap;
    }

    public Set edgesOf(Object object) {
        _Vertex<V, E> _Vertex2 = this.getVertex(object);
        return _Vertex2 == null ? Collections.EMPTY_SET : _Vertex2.getEdges();
    }

    public Set getAllEdges(Object object, Object object2) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        if (!this.containsVertex(object) || !this.containsVertex(object2)) {
            return linkedHashSet;
        }
        linkedHashSet.addAll(this.getVertex(object).edgesTo(object2));
        if (!this.directed) {
            linkedHashSet.addAll(this.getVertex(object2).edgesTo(object));
        }
        return linkedHashSet;
    }

    public Object getEdge(Object object, Object object2) {
        if (!this.containsVertex(object) || !this.containsVertex(object2)) {
            return null;
        }
        Object object3 = this.getVertex(object).edgeTo(object2);
        return object3 == null && !this.directed ? this.getVertex(object2).edgeTo(object) : object3;
    }

    public Object getEdgeSource(Object object) {
        if (!this.containsEdge(object)) {
            return null;
        }
        return this.getEdge(object).getSource();
    }

    public Object getEdgeTarget(Object object) {
        if (!this.containsEdge(object)) {
            return null;
        }
        return this.getEdge(object).getTarget();
    }

    public double getEdgeWeight(Object object) {
        if (!this.containsEdge(object)) {
            return 1.0;
        }
        return this.getEdge(object).getWeight();
    }

    @Override
    public double getVertexWeight(Object object) {
        if (!this.containsVertex(object)) {
            return 0.0;
        }
        return this.getVertex(object).getWeight();
    }

    @Override
    public Double getWeightOf(Object object) {
        if (this.containsVertex(object)) {
            return this.getVertexWeight(object);
        }
        if (this.containsEdge(object)) {
            return this.getEdgeWeight(object);
        }
        return null;
    }

    public Set incomingEdgesOf(Object object) {
        _Vertex<V, E> _Vertex2 = this.getVertex(object);
        return _Vertex2 == null ? Collections.EMPTY_SET : (this.isDirected() ? _Vertex2.inEdges : _Vertex2.getEdges());
    }

    public int inDegreeOf(Object object) {
        return this.incomingEdgesOf(object).size();
    }

    public int outDegreeOf(Object object) {
        return this.outgoingEdgesOf(object).size();
    }

    public int degreeOf(Object object) {
        return this.isDirected() ? this.inDegreeOf(object) + this.outDegreeOf(object) : this.inDegreeOf(object);
    }

    public Set outgoingEdgesOf(Object object) {
        _Vertex<V, E> _Vertex2 = this.getVertex(object);
        return _Vertex2 == null ? Collections.EMPTY_SET : (this.isDirected() ? _Vertex2.outEdges : _Vertex2.getEdges());
    }

    public boolean removeAllEdges(Collection collection) {
        boolean bl = false;
        for (Object e : collection) {
            boolean bl2 = bl = bl || this.removeEdge(e);
        }
        return bl;
    }

    public Set removeAllEdges(Object object, Object object2) {
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
        Object object3 = this.removeEdge(object, object2);
        while (object3 != null) {
            linkedHashSet.add(object3);
            object3 = this.removeEdge(object, object2);
        }
        if (!this.directed) {
            object3 = this.removeEdge(object2, object);
            while (object3 != null) {
                linkedHashSet.add(object3);
                object3 = this.removeEdge(object2, object);
            }
        }
        return linkedHashSet;
    }

    public boolean removeAllVertices(Collection collection) {
        boolean bl = false;
        Object[] objectArray = collection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            bl = bl || this.removeVertex(object);
            ++n2;
        }
        return bl;
    }

    public boolean removeEdge(Object object) {
        if (object == null) {
            return false;
        }
        _Edge<V, E> _Edge2 = this.getEdge(object);
        if (_Edge2 == null && object instanceof GamaPair) {
            return this.removeEdge(((GamaPair)object).first(), ((GamaPair)object).last()) != null;
        }
        if (_Edge2 == null) {
            return false;
        }
        this.getPathComputer().incVersion();
        _Edge2.removeFromVerticesAs(object);
        this.edgeMap.remove(object);
        if (this.generatedEdges.contains(object)) {
            ((IAgent)object).dispose();
        }
        this.dispatchEvent(this.graphScope, new GraphEvent(this.graphScope, this, object, null, GraphEvent.GraphEventType.EDGE_REMOVED));
        return true;
    }

    public Object removeEdge(Object object, Object object2) {
        Object object3 = this.getEdge(object, object2);
        if (this.removeEdge(object3)) {
            this.getPathComputer().incVersion();
            return object3;
        }
        return null;
    }

    public boolean removeVertex(Object object) {
        if (!this.containsVertex(object)) {
            return false;
        }
        this.getPathComputer().incVersion();
        Set set = this.edgesOf(object);
        for (Object e : set) {
            this.removeEdge(e);
        }
        this.vertexMap.remove(object);
        this.dispatchEvent(this.graphScope, new GraphEvent(this.graphScope, this, null, object, GraphEvent.GraphEventType.VERTEX_REMOVED));
        return true;
    }

    public void setEdgeWeight(Object object, double d) {
        if (!this.containsEdge(object)) {
            return;
        }
        this.getPathComputer().incVersion();
        this.getEdge(object).setWeight(d);
    }

    @Override
    public void setVertexWeight(Object object, double d) {
        if (!this.containsVertex(object)) {
            return;
        }
        this.getPathComputer().incVersion();
        this.getVertex(object).setWeight(d);
    }

    public Set vertexSet() {
        this.getPathComputer().incVersion();
        return this.vertexMap.keySet();
    }

    protected IPath<V, E, IGraph<V, E>> pathFromEdges(IScope iScope, V v, V v2, IList<E> iList) {
        return PathFactory.newInstance(this, v, v2, iList);
    }

    @Override
    public IList<E> listValue(IScope iScope, IType iType, boolean bl) {
        return GamaListType.staticCast(iScope, this.edgeSet(), iType, false);
    }

    @Override
    public StreamEx<E> stream(IScope iScope) {
        return StreamEx.of((Collection)this.edgeSet());
    }

    @Override
    public String stringValue(IScope iScope) {
        return this.toString();
    }

    @Override
    public IMatrix matrixValue(IScope iScope, IType iType, boolean bl) {
        return this.toMatrix(iScope);
    }

    @Override
    public IMatrix matrixValue(IScope iScope, IType iType, GamaPoint gamaPoint, boolean bl) {
        return this.toMatrix(iScope);
    }

    @Override
    public String serializeToGaml(boolean bl) {
        return this.mapValue((IScope)null, Types.NO_TYPE, Types.NO_TYPE, false).serializeToGaml(bl) + " as graph";
    }

    @Override
    public IMap mapValue(IScope iScope, IType iType, IType iType2, boolean bl) {
        IMap iMap = GamaMapFactory.create(Types.PAIR.of(this.getGamlType().getKeyType(), this.getGamlType().getKeyType()), this.getGamlType().getContentType());
        for (Object e : this.edgeSet()) {
            iMap.put(new GamaPair<Object, Object>(this.getEdgeSource(e), this.getEdgeTarget(e), this.getGamlType().getKeyType(), this.getGamlType().getKeyType()), e);
        }
        return iMap;
    }

    @Override
    public List<E> get(IScope iScope, GamaPair<V, V> gamaPair) {
        return GamaListFactory.create(iScope, this.getGamlType().getContentType(), this.getAllEdges(gamaPair.key, gamaPair.value));
    }

    @Override
    public List<E> getFromIndicesList(IScope iScope, IList<GamaPair<V, V>> iList) throws GamaRuntimeException {
        if (iList == null || iList.isEmpty(iScope)) {
            return null;
        }
        return this.get(iScope, iList.firstValue(iScope));
    }

    @Override
    public E firstValue(IScope iScope) {
        return this.listValue(iScope, Types.NO_TYPE, false).firstValue(iScope);
    }

    @Override
    public E lastValue(IScope iScope) {
        return this.listValue(iScope, Types.NO_TYPE, false).lastValue(iScope);
    }

    @Override
    public int length(IScope iScope) {
        return this.listValue(iScope, Types.NO_TYPE, false).length(iScope);
    }

    @Override
    public boolean isEmpty(IScope iScope) {
        return this.edgeSet().isEmpty() && this.vertexSet().isEmpty();
    }

    @Override
    public IContainer reverse(IScope iScope) {
        GamaGraph<V, E> gamaGraph = new GamaGraph<V, E>(iScope, GamaListFactory.create(this.type.getKeyType()), false, this.directed, false, this.vertexRelation, this.edgeSpecies, this.type.getKeyType(), this.type.getContentType());
        Graphs.addGraphReversed(gamaGraph, (Graph)this);
        return gamaGraph;
    }

    @Override
    public IList getEdges() {
        return GamaListFactory.wrap(this.getGamlType().getContentType(), this.edgeSet());
    }

    @Override
    public IList getVertices() {
        return GamaListFactory.wrap(this.getGamlType().getKeyType(), this.vertexSet());
    }

    @Override
    public IList getSpanningTree(IScope iScope) {
        KruskalMinimumSpanningTree kruskalMinimumSpanningTree = new KruskalMinimumSpanningTree((Graph)this);
        return GamaListFactory.create(iScope, this.getGamlType().getContentType(), kruskalMinimumSpanningTree.getSpanningTree().getEdges());
    }

    @Override
    public IPath getCircuit(IScope iScope) {
        SimpleWeightedGraph simpleWeightedGraph = new SimpleWeightedGraph(null, null);
        Graphs.addAllEdges((Graph)simpleWeightedGraph, (Graph)this, (Collection)this.edgeSet());
        PalmerHamiltonianCycle palmerHamiltonianCycle = new PalmerHamiltonianCycle();
        List list = palmerHamiltonianCycle.getTour((Graph)this).getVertexList();
        int n = list.size();
        IList iList = GamaListFactory.create(this.getGamlType().getContentType());
        int n2 = 0;
        while (n2 < n - 1) {
            iList.add(this.getEdge(list.get(n2), list.get(n2 + 1)));
            ++n2;
        }
        return this.pathFromEdges(iScope, iList.get(0), iList.get(iList.size() - 1), iList);
    }

    @Override
    public Boolean getConnected() {
        ConnectivityInspector connectivityInspector = new ConnectivityInspector((Graph)this);
        return connectivityInspector.isConnected();
    }

    @Override
    public Boolean hasCycle() {
        if (!this.directed) {
            return true;
        }
        CycleDetector cycleDetector = new CycleDetector((Graph)this);
        return cycleDetector.detectCycles();
    }

    @Override
    public boolean isDirected() {
        return this.directed;
    }

    @Override
    public void setDirected(boolean bl) {
        this.directed = bl;
    }

    @Override
    public IGraph copy(IScope iScope) {
        GamaGraph<V, E> gamaGraph = new GamaGraph<V, E>(iScope, GamaListFactory.EMPTY_LIST, true, this.directed, false, this.vertexRelation, this.edgeSpecies, this.type.getKeyType(), this.type.getContentType());
        Graphs.addAllVertices(gamaGraph, (Collection)this.getVertices());
        Graphs.addAllEdges(gamaGraph, (Graph)this, (Collection)this.edgeSet());
        for (Object e : this.getVertices()) {
            gamaGraph.setVertexWeight(e, this.getWeightOf(e));
        }
        for (Object e : this.getEdges()) {
            gamaGraph.setEdgeWeight(e, this.getWeightOf(e));
        }
        return gamaGraph;
    }

    @Override
    public void setWeights(Map map) {
        Map map2 = map;
        for (Map.Entry entry : map2.entrySet()) {
            Object object = entry.getKey();
            if (object instanceof GamaPair) {
                object = this.getEdge(((GamaPair)object).first(), ((GamaPair)object).last());
                this.setEdgeWeight(object, Cast.asFloat(this.graphScope, entry.getValue()));
                continue;
            }
            if (this.containsEdge(object)) {
                this.setEdgeWeight(object, Cast.asFloat(this.graphScope, entry.getValue()));
                continue;
            }
            this.setVertexWeight(object, Cast.asFloat(this.graphScope, entry.getValue()));
        }
    }

    @Override
    public E anyValue(IScope iScope) {
        if (this.vertexMap.isEmpty()) {
            return null;
        }
        Object[] objectArray = this.vertexMap.keySet().toArray();
        int n = iScope.getRandom().between(0, objectArray.length - 1);
        return (E)objectArray[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(IGraphEventListener iGraphEventListener) {
        LinkedList<IGraphEventListener> linkedList = this.listeners;
        synchronized (linkedList) {
            if (!this.listeners.contains(iGraphEventListener)) {
                this.listeners.add(iGraphEventListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(IGraphEventListener iGraphEventListener) {
        LinkedList<IGraphEventListener> linkedList = this.listeners;
        synchronized (linkedList) {
            this.listeners.remove(iGraphEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatchEvent(IScope iScope, GraphEvent graphEvent) {
        LinkedList<IGraphEventListener> linkedList = this.listeners;
        synchronized (linkedList) {
            if (this.listeners.isEmpty()) {
                return;
            }
            for (IGraphEventListener iGraphEventListener : this.listeners) {
                iGraphEventListener.receiveEvent(iScope, graphEvent);
            }
        }
    }

    @Override
    public Iterable<E> iterable(IScope iScope) {
        return this.listValue(iScope, Types.NO_TYPE, false);
    }

    @Override
    public double computeWeight(IPath iPath) {
        double d = 0.0;
        IList iList = iPath.getEdgeList();
        for (Object e : iList) {
            d += this.getEdgeWeight(e);
        }
        return d;
    }

    @Override
    public double computeTotalWeight() {
        double d = 0.0;
        for (Object e : this.edgeSet()) {
            d += this.getEdgeWeight(e);
        }
        for (Object e : this.vertexSet()) {
            d += this.getVertexWeight(e);
        }
        return d;
    }

    public boolean isAgentEdge() {
        return this.agentEdge;
    }

    public IList getPath(int[] nArray, IList iList, int n, Object object, Object object2, int n2, int n3) {
        int n4;
        IList iList2 = GamaListFactory.create(this.getGamlType().getContentType());
        if (object == object2) {
            return iList2;
        }
        Object object3 = object2;
        int n5 = nArray[n3];
        if (n3 == n5 || n5 == -1) {
            return iList2;
        }
        do {
            Object e = iList.get(n5);
            Set set = this.getAllEdges(e, object3);
            Object e2 = null;
            for (Object e3 : set) {
                if (e2 != null && !(this.getEdgeWeight(e3) < this.getEdgeWeight(e2))) continue;
                e2 = e3;
            }
            if (e2 == null) break;
            iList2.add(0, e2);
            n4 = n5;
            n5 = nArray[n5];
            object3 = e;
        } while (n4 != n2);
        return iList2;
    }

    public Map<V, _Vertex<V, E>> getVertexMap() {
        return this.vertexMap;
    }

    @Override
    public Graphs.GraphObjectToAdd buildValue(IScope iScope, Object object) {
        if (object instanceof Graphs.NodeToAdd) {
            return new Graphs.NodeToAdd(this.type.getKeyType().cast(iScope, ((Graphs.NodeToAdd)object).object, null, false), ((Graphs.NodeToAdd)object).weight);
        }
        if (object instanceof Graphs.EdgeToAdd) {
            return new Graphs.EdgeToAdd(this.type.getKeyType().cast(iScope, ((Graphs.EdgeToAdd)object).source, null, false), this.type.getKeyType().cast(iScope, ((Graphs.EdgeToAdd)object).target, null, false), this.type.getContentType().cast(iScope, ((Graphs.EdgeToAdd)object).object, null, false), ((Graphs.EdgeToAdd)object).weight);
        }
        return new Graphs.EdgeToAdd(null, null, this.type.getContentType().cast(iScope, object, null, false), 0.0);
    }

    @Override
    public IContainer<?, Graphs.GraphObjectToAdd> buildValues(IScope iScope, IContainer iContainer) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Collector.AsList asList = Collector.getList();){
            if (!(iContainer instanceof Graphs.NodesToAdd)) {
                for (Object ValueType : iContainer.iterable(iScope)) {
                    asList.add(this.buildValue(iScope, ValueType));
                }
            } else {
                for (Object ValueType : iContainer.iterable(iScope)) {
                    asList.add(this.buildValue(iScope, new Graphs.NodeToAdd(ValueType)));
                }
            }
            return asList.items();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public GamaPair<V, V> buildIndex(IScope iScope, Object object) {
        return GamaPairType.staticCast(iScope, object, this.type.getKeyType(), this.type.getContentType(), false);
    }

    @Override
    public IContainer<?, GamaPair<V, V>> buildIndexes(IScope iScope, IContainer iContainer) {
        IList<GamaPair<V, V>> iList = GamaListFactory.create(Types.PAIR);
        for (Object ValueType : iContainer.iterable(iScope)) {
            iList.add(this.buildIndex(iScope, ValueType));
        }
        return iList;
    }

    public GamaFloatMatrix toMatrix(IScope iScope) {
        int n = this.getVertices().size();
        if (n == 0) {
            return null;
        }
        GamaFloatMatrix gamaFloatMatrix = new GamaFloatMatrix(n, n);
        gamaFloatMatrix.setAllValues(iScope, Double.POSITIVE_INFINITY);
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < n) {
                if (n2 == n3) {
                    gamaFloatMatrix.set(iScope, n2, n3, 0);
                } else {
                    Object object = this.getEdge(this.getVertices().get(n2), this.getVertices().get(n3));
                    if (object != null) {
                        gamaFloatMatrix.set(iScope, n2, n3, this.getWeightOf(object));
                    }
                }
                ++n3;
            }
            ++n2;
        }
        return gamaFloatMatrix;
    }

    @Override
    public ISpecies getVertexSpecies() {
        return this.vertexSpecies;
    }

    @Override
    public ISpecies getEdgeSpecies() {
        if (this.edgeSpecies == null) {
            IType<?> iType = this.getGamlType().getContentType();
            this.edgeSpecies = this.getScope().getModel().getSpecies(iType.getSpeciesName());
        }
        return this.edgeSpecies;
    }

    public void disposeVertex(IAgent iAgent) {
        Set set = this.edgesOf(iAgent);
        this.removeVertex(iAgent);
        for (Object e : set) {
            if (!(e instanceof IAgent)) continue;
            ((IAgent)e).dispose();
        }
    }

    public V addVertex() {
        return null;
    }

    public Supplier<E> getEdgeSupplier() {
        return null;
    }

    public GraphType getType() {
        if (this.isDirected()) {
            return DefaultGraphType.simple().asDirected().asWeighted();
        }
        return DefaultGraphType.simple().asUndirected().asWeighted();
    }

    public Supplier<V> getVertexSupplier() {
        return null;
    }

    @Override
    public PathComputer getPathComputer() {
        if (this.pathComputer == null) {
            this.pathComputer = new PathComputer(this);
        }
        return this.pathComputer;
    }
}

