/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.graph.layout;

import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.IScope;
import gama.core.util.GamaListFactory;
import gama.gaml.operators.Containers;
import gama.gaml.operators.Points;
import gama.gaml.operators.spatial.SpatialPunctal;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.IdentityHashMap;
import java.util.Map;
import org.jgrapht.Graph;

public class LayoutForceDirected {
    private final Graph<IShape, IShape> graph;
    private final boolean equi;
    private final double criterion;
    private final double coolingRate;
    private final int maxit;
    private final double coeffForce;
    IShape bounds;
    private int iteration = 0;
    private double area;
    private double k;
    private double t;
    private boolean equilibriumReached = false;
    private final Map<IShape, GamaPoint> disp;
    private final Map<IShape, GamaPoint> loc;

    public LayoutForceDirected(Graph<IShape, IShape> graph, IShape iShape, double d, double d2, int n, boolean bl, double d3) {
        this.graph = graph;
        this.bounds = iShape;
        this.equi = bl;
        this.criterion = d3;
        this.coolingRate = d2;
        this.maxit = n;
        this.coeffForce = d;
        this.disp = new IdentityHashMap<IShape, GamaPoint>();
        this.loc = new IdentityHashMap<IShape, GamaPoint>();
    }

    public int startSimulation(IScope iScope) {
        this.iteration = 0;
        this.equilibriumReached = false;
        this.area = Math.min(this.bounds.getWidth() * this.bounds.getWidth(), this.bounds.getHeight() * this.bounds.getHeight());
        this.k = this.coeffForce * Math.sqrt(this.area / (double)this.graph.vertexSet().size());
        this.t = this.bounds.getWidth() / 10.0;
        for (IShape iShape : this.graph.vertexSet()) {
            this.disp.put(iShape, new GamaPoint());
            this.loc.put(iShape, iShape.getCentroid().copy(iScope));
        }
        if (this.equi) {
            while (!this.equilibriumReached && this.iteration < this.maxit) {
                this.simulateStep(iScope);
            }
        } else {
            int n = 0;
            while (n < this.maxit) {
                this.simulateStep(iScope);
                ++n;
            }
        }
        for (IShape iShape : this.graph.vertexSet()) {
            iShape.setLocation(this.loc.get(iShape));
        }
        return this.iteration;
    }

    private void simulateStep(IScope iScope) {
        double d;
        Object object;
        IShape iShape4;
        IShape iShape22;
        double d2 = Math.sqrt(this.area) / 10.0;
        double d3 = Math.sqrt(this.area) / 3.0;
        for (IShape iShape22 : this.graph.vertexSet()) {
            iShape4 = this.disp.get(iShape22);
            ((GamaPoint)iShape4).setLocation(0.0, 0.0, 0.0);
            for (IShape iShape3 : this.graph.vertexSet()) {
                if (iShape22.equals(iShape3)) continue;
                GamaPoint gamaPoint = Points.subtract(this.loc.get(iShape22), this.loc.get(iShape3));
                double d4 = Points.norm(iScope, gamaPoint);
                if (d4 != 0.0) {
                    gamaPoint = Points.multiply(gamaPoint, this.forceRepulsive(d4, this.k) / d4);
                }
                ((GamaPoint)iShape4).add(gamaPoint);
            }
        }
        for (IShape iShape22 : this.graph.edgeSet()) {
            IShape iShape3;
            iShape4 = (IShape)this.graph.getEdgeSource((Object)iShape22);
            iShape3 = (IShape)this.graph.getEdgeTarget((Object)iShape22);
            object = Points.subtract(this.loc.get(iShape3), this.loc.get(iShape4));
            double d5 = Points.norm(iScope, (GamaPoint)object);
            if (d5 != 0.0) {
                object = Points.multiply((GamaPoint)object, this.forceAttractive(d5, this.k) / d5);
            }
            this.disp.get(iShape3).minus((GamaPoint)object);
            this.disp.get(iShape4).add((GamaPoint)object);
        }
        this.equilibriumReached = true;
        for (IShape iShape22 : this.graph.vertexSet()) {
            iShape4 = new GamaPoint(this.disp.get(iShape22));
            double d6 = Points.norm(iScope, (GamaPoint)iShape4);
            if (d6 > this.criterion) {
                this.equilibriumReached = false;
            }
            if (d6 != 0.0) {
                iShape4 = Points.multiply((GamaPoint)iShape4, Math.min(d6, this.t) / d6);
            }
            GamaPoint gamaPoint = this.loc.get(iShape22);
            gamaPoint.add((GamaPoint)iShape4);
            if (this.bounds.intersects(gamaPoint)) continue;
            this.loc.put(iShape22, SpatialPunctal._closest_point_to(gamaPoint, this.bounds));
        }
        iShape22 = (GamaPoint)Containers.opMean(iScope, GamaListFactory.wrap((IType)Types.POINT, this.loc.values()));
        if (iShape22.distance3D(this.bounds.getCentroid()) > d2) {
            GamaPoint gamaPoint = Points.subtract(this.bounds.getCentroid(), (GamaPoint)iShape22);
            gamaPoint.multiplyBy(0.5);
            for (IShape iShape4 : this.graph.vertexSet()) {
                object = this.loc.get(iShape4);
                ((GamaPoint)object).add(gamaPoint);
                if (this.bounds.intersects((IShape)object)) continue;
                this.loc.put(iShape4, SpatialPunctal._closest_point_to((GamaPoint)object, this.bounds));
            }
        }
        if ((d = this.graph.vertexSet().stream().mapToDouble(arg_0 -> LayoutForceDirected.lambda$0((GamaPoint)iShape22, arg_0)).max().getAsDouble()) < d3) {
            d = d3 - d;
            for (IShape iShape5 : this.graph.vertexSet()) {
                GamaPoint gamaPoint = this.loc.get(iShape5);
                GamaPoint gamaPoint2 = Points.subtract(gamaPoint, (GamaPoint)iShape22);
                double d7 = gamaPoint2.norm();
                if (d7 > 0.0) {
                    gamaPoint2.multiplyBy(d / gamaPoint2.norm());
                }
                gamaPoint.add(gamaPoint2);
                if (this.bounds.intersects(gamaPoint)) continue;
                this.loc.put(iShape5, SpatialPunctal._closest_point_to(gamaPoint, this.bounds));
            }
        }
        this.t = Math.max(this.t * (1.0 - this.coolingRate), 1.0);
        ++this.iteration;
    }

    private double forceAttractive(double d, double d2) {
        return d2 == 0.0 ? 1.0 : d * d / d2;
    }

    private double forceRepulsive(double d, double d2) {
        return d == 0.0 ? 1.0 : d2 * d2 / d;
    }

    private static /* synthetic */ double lambda$0(GamaPoint gamaPoint, IShape iShape) {
        return iShape.euclidianDistanceTo(gamaPoint);
    }
}

